/*
 * Decompiled with CFR 0.152.
 */
package com.smn.update;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.github.kevinsawicki.http.HttpRequest;
import com.google.gson.Gson;
import com.smn.update.UpdateConfig;
import com.smn.update.UpdateInfo;

public class UpdateModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    String url = null;
    UpdateConfig updateConfig;
    long downloadId;
    DownloadManager downloadManager;
    DownloadCompleteReceiver completeReceiver;

    public UpdateModule(ReactApplicationContext reactContext) {
        super(reactContext);
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public String getName() {
        return "RNUpdate";
    }

    @ReactMethod
    public void init(String url, Promise promise) {
        if (this.url != null && !this.url.equalsIgnoreCase(url)) {
            this.updateConfig = null;
            if (this.downloadId > 0L) {
                this.downloadManager.remove(new long[]{this.downloadId});
            }
        }
        this.url = url;
        promise.resolve((Object)url);
    }

    @ReactMethod
    public void getNewVersion(Promise promise) {
        boolean result = this.hasNewVersion();
        if (result) {
            promise.resolve((Object)this.getUpdateInfo().toMap());
        } else {
            promise.resolve(null);
        }
    }

    @ReactMethod
    public void update() {
        if (this.hasNewVersion()) {
            this.doUpdate();
        }
    }

    boolean hasNewVersion() {
        UpdateInfo updateInfo = this.getUpdateInfo();
        PackageInfo pinfo = null;
        try {
            pinfo = this.getReactApplicationContext().getPackageManager().getPackageInfo(this.getReactApplicationContext().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Update", (String)"getPackageInfo failure", (Throwable)e);
            return false;
        }
        return updateInfo.getVersionCode() > pinfo.versionCode;
    }

    private UpdateInfo getUpdateInfo() {
        if (this.updateConfig != null) {
            return this.updateConfig.getUpdateInfo();
        }
        try {
            HttpRequest request = HttpRequest.get((CharSequence)this.url);
            request.acceptJson();
            String body = request.body();
            if (request.ok()) {
                Gson gson = new Gson();
                this.updateConfig = (UpdateConfig)gson.fromJson(body, UpdateConfig.class);
                return this.updateConfig.getUpdateInfo();
            }
        }
        catch (Exception ex) {
            Log.e((String)"Update", (String)"getUpdateInfo failure", (Throwable)ex);
        }
        return null;
    }

    private void doUpdate() {
        Log.d((String)"Update", (String)("check update\uff1a" + this.url));
        try {
            UpdateInfo updateInfo = this.getUpdateInfo();
            if (this.completeReceiver == null) {
                this.completeReceiver = new DownloadCompleteReceiver();
            }
            this.getReactApplicationContext().registerReceiver((BroadcastReceiver)this.completeReceiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
            this.downloadManager = (DownloadManager)this.getReactApplicationContext().getSystemService("download");
            Log.d((String)"Update", (String)("downloadurl:" + updateInfo.getApkUrl()));
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)updateInfo.getApkUrl()));
            request.setAllowedNetworkTypes(2);
            request.setDestinationInExternalPublicDir("Download", updateInfo.getPackageName() + ".apk");
            request.setMimeType("application/vnd.android.package-archive");
            request.setTitle((CharSequence)updateInfo.getAppName());
            this.downloadId = this.downloadManager.enqueue(request);
        }
        catch (Exception ex) {
            Log.e((String)"Update", (String)"check update failure", (Throwable)ex);
            Log.e((String)"Update", (String)ex.getMessage());
            Log.e((String)"Update", (String)ex.toString());
        }
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        this.getReactApplicationContext().unregisterReceiver((BroadcastReceiver)this.completeReceiver);
    }

    private void promptInstall(Uri data) {
        Intent promptInstall = new Intent("android.intent.action.VIEW").setDataAndType(data, "application/vnd.android.package-archive");
        promptInstall.setFlags(0x10000000);
        this.getReactApplicationContext().startActivity(promptInstall);
    }

    class DownloadCompleteReceiver
    extends BroadcastReceiver {
        DownloadCompleteReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int columnIndex;
            long downloadCompletedId = intent.getLongExtra("extra_download_id", 0L);
            if (UpdateModule.this.downloadId != downloadCompletedId) {
                return;
            }
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{UpdateModule.this.downloadId});
            Cursor c = UpdateModule.this.downloadManager.query(query);
            if (c.moveToFirst() && 8 == c.getInt(columnIndex = c.getColumnIndex("status"))) {
                String uriString = c.getString(c.getColumnIndex("local_filename"));
                UpdateModule.this.promptInstall(Uri.parse((String)("file://" + uriString)));
            }
        }
    }
}

