/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import android.util.Pair;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.SharedReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.imageutils.JfifUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EncodedImage
implements Closeable {
    public static final int UNKNOWN_ROTATION_ANGLE = -1;
    public static final int UNKNOWN_WIDTH = -1;
    public static final int UNKNOWN_HEIGHT = -1;
    public static final int UNKNOWN_STREAM_SIZE = -1;
    public static final int DEFAULT_SAMPLE_SIZE = 1;
    @Nullable
    private final CloseableReference<PooledByteBuffer> mPooledByteBufferRef;
    @Nullable
    private final Supplier<FileInputStream> mInputStreamSupplier;
    private ImageFormat mImageFormat = ImageFormat.UNKNOWN;
    private int mRotationAngle = -1;
    private int mWidth = -1;
    private int mHeight = -1;
    private int mSampleSize = 1;
    private int mStreamSize = -1;

    public EncodedImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef) {
        Preconditions.checkArgument((boolean)CloseableReference.isValid(pooledByteBufferRef));
        this.mPooledByteBufferRef = pooledByteBufferRef.clone();
        this.mInputStreamSupplier = null;
    }

    public EncodedImage(Supplier<FileInputStream> inputStreamSupplier) {
        Preconditions.checkNotNull(inputStreamSupplier);
        this.mPooledByteBufferRef = null;
        this.mInputStreamSupplier = inputStreamSupplier;
    }

    public EncodedImage(Supplier<FileInputStream> inputStreamSupplier, int streamSize) {
        this(inputStreamSupplier);
        this.mStreamSize = streamSize;
    }

    public static EncodedImage cloneOrNull(EncodedImage encodedImage) {
        return encodedImage != null ? encodedImage.cloneOrNull() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedImage cloneOrNull() {
        EncodedImage encodedImage;
        if (this.mInputStreamSupplier != null) {
            encodedImage = new EncodedImage(this.mInputStreamSupplier, this.mStreamSize);
        } else {
            CloseableReference pooledByteBufferRef = CloseableReference.cloneOrNull(this.mPooledByteBufferRef);
            try {
                encodedImage = pooledByteBufferRef == null ? null : new EncodedImage((CloseableReference<PooledByteBuffer>)pooledByteBufferRef);
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)pooledByteBufferRef);
            }
        }
        if (encodedImage != null) {
            encodedImage.copyMetaDataFrom(this);
        }
        return encodedImage;
    }

    @Override
    public void close() {
        CloseableReference.closeSafely(this.mPooledByteBufferRef);
    }

    public synchronized boolean isValid() {
        return CloseableReference.isValid(this.mPooledByteBufferRef) || this.mInputStreamSupplier != null;
    }

    public CloseableReference<PooledByteBuffer> getByteBufferRef() {
        return CloseableReference.cloneOrNull(this.mPooledByteBufferRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        if (this.mInputStreamSupplier != null) {
            return (InputStream)this.mInputStreamSupplier.get();
        }
        CloseableReference pooledByteBufferRef = CloseableReference.cloneOrNull(this.mPooledByteBufferRef);
        if (pooledByteBufferRef != null) {
            try {
                PooledByteBufferInputStream pooledByteBufferInputStream = new PooledByteBufferInputStream((PooledByteBuffer)pooledByteBufferRef.get());
                return pooledByteBufferInputStream;
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)pooledByteBufferRef);
            }
        }
        return null;
    }

    public void setImageFormat(ImageFormat imageFormat) {
        this.mImageFormat = imageFormat;
    }

    public void setHeight(int height) {
        this.mHeight = height;
    }

    public void setWidth(int width) {
        this.mWidth = width;
    }

    public void setRotationAngle(int rotationAngle) {
        this.mRotationAngle = rotationAngle;
    }

    public void setSampleSize(int sampleSize) {
        this.mSampleSize = sampleSize;
    }

    public void setStreamSize(int streamSize) {
        this.mStreamSize = streamSize;
    }

    public ImageFormat getImageFormat() {
        return this.mImageFormat;
    }

    public int getRotationAngle() {
        return this.mRotationAngle;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getSampleSize() {
        return this.mSampleSize;
    }

    public boolean isCompleteAt(int length) {
        if (this.mImageFormat != ImageFormat.JPEG) {
            return true;
        }
        if (this.mInputStreamSupplier != null) {
            return true;
        }
        Preconditions.checkNotNull(this.mPooledByteBufferRef);
        PooledByteBuffer buf = (PooledByteBuffer)this.mPooledByteBufferRef.get();
        return buf.read(length - 2) == -1 && buf.read(length - 1) == -39;
    }

    public int getSize() {
        if (this.mPooledByteBufferRef != null && this.mPooledByteBufferRef.get() != null) {
            return ((PooledByteBuffer)this.mPooledByteBufferRef.get()).size();
        }
        return this.mStreamSize;
    }

    public void parseMetaData() {
        Pair<Integer, Integer> dimensions;
        ImageFormat imageFormat;
        this.mImageFormat = imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(this.getInputStream());
        if (!ImageFormat.isWebpFormat(imageFormat) && (dimensions = BitmapUtil.decodeDimensions(this.getInputStream())) != null) {
            this.mWidth = (Integer)dimensions.first;
            this.mHeight = (Integer)dimensions.second;
            if (imageFormat == ImageFormat.JPEG) {
                if (this.mRotationAngle == -1) {
                    this.mRotationAngle = JfifUtil.getAutoRotateAngleFromOrientation(JfifUtil.getOrientation(this.getInputStream()));
                }
            } else {
                this.mRotationAngle = 0;
            }
        }
    }

    public void copyMetaDataFrom(EncodedImage encodedImage) {
        this.mImageFormat = encodedImage.getImageFormat();
        this.mWidth = encodedImage.getWidth();
        this.mHeight = encodedImage.getHeight();
        this.mRotationAngle = encodedImage.getRotationAngle();
        this.mSampleSize = encodedImage.getSampleSize();
        this.mStreamSize = encodedImage.getSize();
    }

    public static boolean isMetaDataAvailable(EncodedImage encodedImage) {
        return encodedImage.mRotationAngle >= 0 && encodedImage.mWidth >= 0 && encodedImage.mHeight >= 0;
    }

    public static void closeSafely(@Nullable EncodedImage encodedImage) {
        if (encodedImage != null) {
            encodedImage.close();
        }
    }

    public static boolean isValid(@Nullable EncodedImage encodedImage) {
        return encodedImage != null && encodedImage.isValid();
    }

    @VisibleForTesting
    public synchronized SharedReference<PooledByteBuffer> getUnderlyingReferenceTestOnly() {
        return this.mPooledByteBufferRef != null ? this.mPooledByteBufferRef.getUnderlyingReferenceTestOnly() : null;
    }
}

