/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import java.io.File;

class StackTraceHelper {
    StackTraceHelper() {
    }

    public static StackFrame[] convertJsStackTrace(ReadableArray stack) {
        StackFrame[] result = new StackFrame[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            ReadableMap frame = stack.getMap(i);
            String methodName = frame.getString("methodName");
            String fileName = frame.getString("file");
            int lineNumber = frame.getInt("lineNumber");
            int columnNumber = -1;
            if (frame.hasKey("column") && !frame.isNull("column")) {
                columnNumber = frame.getInt("column");
            }
            result[i] = new StackFrame(fileName, methodName, lineNumber, columnNumber);
        }
        return result;
    }

    public static StackFrame[] convertJavaStackTrace(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new StackFrame(stackTrace[i].getClassName(), stackTrace[i].getFileName(), stackTrace[i].getMethodName(), stackTrace[i].getLineNumber(), 0);
        }
        return result;
    }

    public static class StackFrame {
        private final String mFile;
        private final String mMethod;
        private final int mLine;
        private final int mColumn;
        private final String mFileName;

        private StackFrame(String file, String method, int line, int column) {
            this.mFile = file;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
            this.mFileName = new File(file).getName();
        }

        private StackFrame(String file, String fileName, String method, int line, int column) {
            this.mFile = file;
            this.mFileName = fileName;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
        }

        public String getFile() {
            return this.mFile;
        }

        public String getMethod() {
            return this.mMethod;
        }

        public int getLine() {
            return this.mLine;
        }

        public int getColumn() {
            return this.mColumn;
        }

        public String getFileName() {
            return this.mFileName;
        }
    }
}

