/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.recyclerview;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

public class ContentSizeChangeEvent
extends Event<ContentSizeChangeEvent> {
    public static final String EVENT_NAME = "topContentSizeChange";
    private final int mWidth;
    private final int mHeight;

    public ContentSizeChangeEvent(int viewTag, long timestampMs, int width, int height) {
        super(viewTag, timestampMs);
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap data = Arguments.createMap();
        data.putDouble("width", PixelUtil.toDIPFromPixel(this.mWidth));
        data.putDouble("height", PixelUtil.toDIPFromPixel(this.mHeight));
        rctEventEmitter.receiveEvent(this.getViewTag(), EVENT_NAME, data);
    }
}

