/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.soloader;

import android.content.Context;
import com.facebook.soloader.DirectorySoSource;
import com.facebook.soloader.FileLocker;
import com.facebook.soloader.SysUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ExoSoSource
extends DirectorySoSource {
    private static final String TAG = "SoLoader";
    private static final boolean DEBUG = false;

    public ExoSoSource(Context context) throws IOException {
        super(SysUtil.createLibsDirectory(context), 1);
        File libsDir = this.soDirectory;
        Map<String, File> providedLibraries = ExoSoSource.findProvidedLibraries(context);
        try (FileLocker lock = SysUtil.lockLibsDirectory(context);){
            File[] extantFiles = libsDir.listFiles();
            for (int i = 0; i < extantFiles.length; ++i) {
                boolean upToDate;
                File extantFile = extantFiles[i];
                String name = extantFile.getName();
                File sourceFile = providedLibraries.get(name);
                boolean shouldDelete = sourceFile == null || sourceFile.length() != extantFile.length() || sourceFile.lastModified() != extantFile.lastModified();
                boolean bl = upToDate = sourceFile != null && !shouldDelete;
                if (shouldDelete) {
                    SysUtil.deleteOrThrow(extantFile);
                }
                if (!upToDate) continue;
                providedLibraries.remove(name);
            }
            for (String soName : providedLibraries.keySet()) {
                File sourceFile = providedLibraries.get(soName);
                try (FileInputStream is = new FileInputStream(sourceFile);){
                    SysUtil.reliablyCopyExecutable(is, new File(libsDir, soName), sourceFile.length(), sourceFile.lastModified());
                }
                SysUtil.freeCopyBuffer();
            }
        }
    }

    private static Map<String, File> findProvidedLibraries(Context context) throws IOException {
        File exoDir = new File("/data/local/tmp/exopackage/" + context.getPackageName() + "/native-libs/");
        HashMap<String, File> providedLibraries = new HashMap<String, File>();
        for (String abi : SysUtil.getSupportedAbis()) {
            File metadata;
            File abiDir = new File(exoDir, abi);
            if (!abiDir.isDirectory() || !(metadata = new File(abiDir, "metadata.txt")).isFile()) continue;
            try (FileReader fr = new FileReader(metadata);
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) continue;
                    int sep = line.indexOf(32);
                    if (sep == -1) {
                        throw new RuntimeException("illegal line in exopackage metadata: [" + line + "]");
                    }
                    String soName = line.substring(0, sep) + ".so";
                    String backingFile = line.substring(sep + 1);
                    if (providedLibraries.containsKey(soName)) continue;
                    providedLibraries.put(soName, new File(abiDir, backingFile));
                }
            }
        }
        return providedLibraries;
    }
}

