/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.reactnative;

import android.content.Context;
import android.util.Log;
import com.appsflyer.reactnative.ConnectorWrapper;
import com.appsflyer.reactnative.MappedValidationResultListener;
import com.appsflyer.reactnative.RNUtil;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PCAppsFlyerModule
extends ReactContextBaseJavaModule {
    private WeakReference<ReactApplicationContext> reactContext;
    private boolean isPurchaseConnectorModuleEnabled;
    private ConnectorWrapper connectorWrapper;
    private String TAG = "AppsFlyer_6.16.2";
    private Map<String, Object> subscriptionPurchaseParams;
    private Map<String, Object> inAppPurchaseParams;
    private int listenerCount = 0;
    private final MappedValidationResultListener arsListener = new MappedValidationResultListener(){

        @Override
        public void onFailure(String result, Throwable error) {
            PCAppsFlyerModule.this.handleError("subscriptionValidationFailure", result, error);
        }

        @Override
        public void onResponse(Map<String, Object> response) {
            if (response != null) {
                WritableMap writableMap = RNUtil.toWritableMap(response);
                PCAppsFlyerModule.this.handleSuccess("subscriptionValidationSuccess", writableMap);
            }
        }
    };
    private final MappedValidationResultListener viapListener = new MappedValidationResultListener(){

        @Override
        public void onFailure(String result, Throwable error) {
            PCAppsFlyerModule.this.handleError("inAppPurchaseValidationFailure", result, error);
        }

        @Override
        public void onResponse(Map<String, Object> response) {
            WritableMap writableMap = RNUtil.toWritableMap(response);
            PCAppsFlyerModule.this.handleSuccess("inAppPurchaseValidationSuccess", writableMap);
        }
    };

    public PCAppsFlyerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = new WeakReference<ReactApplicationContext>(reactContext);
        this.isPurchaseConnectorModuleEnabled = true;
        Log.d((String)"AppsFlyer_", (String)("PurchaseConnector inclusion status: " + this.isPurchaseConnectorModuleEnabled));
    }

    public String getName() {
        return "PCAppsFlyer";
    }

    @ReactMethod
    public void create(ReadableMap config) {
        if (!this.isPurchaseConnectorModuleEnabled) {
            Log.e((String)this.TAG, (String)"PurchaseConnector is not enabled. Please enable it in your build.gradle");
            return;
        }
        Log.d((String)this.TAG, (String)("Attempting to create connector with config: " + config.toString()));
        ReactApplicationContext context = (ReactApplicationContext)this.reactContext.get();
        if (context == null) {
            Log.e((String)this.TAG, (String)"React context is null");
            return;
        }
        if (this.connectorWrapper == null) {
            boolean logSubscriptions = config.getBoolean("logSubscriptions");
            boolean logInApps = config.getBoolean("logInApps");
            boolean sandbox = config.getBoolean("sandbox");
            if (config.hasKey("storeKitVersion")) {
                String storeKitVersion = config.getString("storeKitVersion");
                Log.d((String)this.TAG, (String)("storeKitVersion (" + storeKitVersion + ") is ignored on Android."));
            }
            MappedValidationResultListener arsListener = this.arsListener;
            MappedValidationResultListener viapListener = this.viapListener;
            this.connectorWrapper = new ConnectorWrapper((Context)context, logSubscriptions, logInApps, sandbox, arsListener, viapListener);
            if (this.subscriptionPurchaseParams != null) {
                this.connectorWrapper.setSubscriptionPurchaseEventDataSource(this.subscriptionPurchaseParams);
            }
            if (this.inAppPurchaseParams != null) {
                this.connectorWrapper.setInAppPurchaseEventDataSource(this.inAppPurchaseParams);
            }
            Log.d((String)this.TAG, (String)"The Purchase Connector initiated successfully.");
        } else {
            Log.e((String)this.TAG, (String)"The Purchase Connector is already configured and cannot be created again.");
        }
    }

    @ReactMethod
    public void startObservingTransactions() {
        if (!this.isPurchaseConnectorModuleEnabled || this.connectorWrapper == null) {
            Log.e((String)this.TAG, (String)"PurchaseConnector is not enabled or not initialized");
            return;
        }
        this.connectorWrapper.startObservingTransactions();
        Log.d((String)this.TAG, (String)"Start Observing Transactions...");
    }

    @ReactMethod
    public void stopObservingTransactions() {
        if (!this.isPurchaseConnectorModuleEnabled || this.connectorWrapper == null) {
            Log.e((String)this.TAG, (String)"PurchaseConnector is not enabled or not initialized");
            return;
        }
        this.connectorWrapper.stopObservingTransactions();
        Log.d((String)this.TAG, (String)"Stopped Observing Transactions...");
    }

    @ReactMethod
    public void setSubscriptionPurchaseEventDataSource(ReadableMap dataSource) {
        if (!this.isPurchaseConnectorModuleEnabled) {
            Log.e((String)this.TAG, (String)"PurchaseConnector is not enabled");
            return;
        }
        Log.d((String)this.TAG, (String)"Setting subscription purchase event data source");
        if (dataSource == null) {
            Log.e((String)this.TAG, (String)"dataSource is required");
            return;
        }
        if (this.connectorWrapper == null) {
            Log.e((String)this.TAG, (String)"Connector not initialized. Call create() first.");
            return;
        }
        this.subscriptionPurchaseParams = RNUtil.toMap(dataSource);
        this.connectorWrapper.setSubscriptionPurchaseEventDataSource(this.subscriptionPurchaseParams);
    }

    @ReactMethod
    public void setInAppPurchaseEventDataSource(ReadableMap dataSource) {
        if (!this.isPurchaseConnectorModuleEnabled) {
            Log.e((String)this.TAG, (String)"PurchaseConnector is not enabled");
            return;
        }
        Log.d((String)this.TAG, (String)"Setting in-app purchase event data source");
        if (dataSource == null) {
            Log.e((String)this.TAG, (String)"dataSource is required");
            return;
        }
        if (this.connectorWrapper == null) {
            Log.e((String)this.TAG, (String)"Connector not initialized. Call create() first.");
            return;
        }
        this.inAppPurchaseParams = RNUtil.toMap(dataSource);
        this.connectorWrapper.setInAppPurchaseEventDataSource(this.inAppPurchaseParams);
    }

    private void handleSuccess(String eventName, WritableMap response) {
        this.sendEvent(eventName, response);
    }

    private void handleError(String eventName, String result, Throwable error) {
        WritableMap resMap = Arguments.createMap();
        resMap.putString("result", result);
        resMap.putMap("error", error != null ? this.errorToMap(error) : null);
        this.sendEvent(eventName, resMap);
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }

    private void sendEvent(String eventName, Object params) {
        ReactApplicationContext context = (ReactApplicationContext)this.reactContext.get();
        if (context != null) {
            try {
                ((DeviceEventManagerModule.RCTDeviceEventEmitter)context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, params);
                Log.d((String)this.TAG, (String)("\u2705 Event emitted successfully: " + eventName));
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("\u274c Failed to emit event " + eventName + ": " + e.getMessage()));
            }
        } else {
            Log.d((String)this.TAG, (String)("\u23ed\ufe0f Skipping event '" + eventName + "' - context is null"));
        }
    }

    private WritableMap errorToMap(Throwable error) {
        JSONObject errorJson = new JSONObject(this.throwableToMap(error));
        WritableMap errorMap = RNUtil.jsonToWritableMap(errorJson);
        return errorMap;
    }

    private Map<String, Object> throwableToMap(Throwable throwable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", throwable.getClass().getSimpleName());
        map.put("message", throwable.getMessage());
        map.put("stacktrace", String.join((CharSequence)"\n", (CharSequence[])Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).toArray(String[]::new)));
        map.put("cause", throwable.getCause() != null ? this.throwableToMap(throwable.getCause()) : null);
        return map;
    }
}

