/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.reactnative;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appsflyer.AFAdRevenueData;
import com.appsflyer.AppsFlyerConsent;
import com.appsflyer.AppsFlyerConversionListener;
import com.appsflyer.AppsFlyerInAppPurchaseValidatorListener;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.CreateOneLinkHttpTask;
import com.appsflyer.MediationNetwork;
import com.appsflyer.attribution.AppsFlyerRequestListener;
import com.appsflyer.deeplink.DeepLinkListener;
import com.appsflyer.deeplink.DeepLinkResult;
import com.appsflyer.internal.platform_extension.Plugin;
import com.appsflyer.internal.platform_extension.PluginInfo;
import com.appsflyer.reactnative.RNUtil;
import com.appsflyer.share.CrossPromotionHelper;
import com.appsflyer.share.LinkGenerator;
import com.appsflyer.share.ShareInviteHelper;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RNAppsFlyerModule
extends ReactContextBaseJavaModule {
    private ReactApplicationContext reactContext;
    private Application application;
    private String personalDevKey;

    public RNAppsFlyerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        this.application = (Application)reactContext.getApplicationContext();
        this.personalDevKey = "";
    }

    public String getName() {
        return "RNAppsFlyer";
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("ACHIEVEMENT_UNLOCKED", "af_achievement_unlocked");
        constants.put("ADD_PAYMENT_INFO", "af_add_payment_info");
        constants.put("ADD_TO_CART", "af_add_to_cart");
        constants.put("ADD_TO_WISH_LIST", "af_add_to_wishlist");
        constants.put("COMPLETE_REGISTRATION", "af_complete_registration");
        constants.put("CONTENT_VIEW", "af_content_view");
        constants.put("INITIATED_CHECKOUT", "af_initiated_checkout");
        constants.put("INVITE", "af_invite");
        constants.put("LEVEL_ACHIEVED", "af_level_achieved");
        constants.put("LOCATION_CHANGED", "af_location_changed");
        constants.put("LOCATION_COORDINATES", "af_location_coordinates");
        constants.put("LOGIN", "af_login");
        constants.put("OPENED_FROM_PUSH_NOTIFICATION", "af_opened_from_push_notification");
        constants.put("ORDER_ID", "af_order_id");
        constants.put("PURCHASE", "af_purchase");
        constants.put("RATE", "af_rate");
        constants.put("RE_ENGAGE", "af_re_engage");
        constants.put("SEARCH", "af_search");
        constants.put("SHARE", "af_share");
        constants.put("SPENT_CREDIT", "af_spent_credits");
        constants.put("TRAVEL_BOOKING", "af_travel_booking");
        constants.put("TUTORIAL_COMPLETION", "af_tutorial_completion");
        constants.put("UPDATE", "af_update");
        return constants;
    }

    @ReactMethod
    public void initSdkWithCallBack(ReadableMap _options, Callback successCallback, Callback errorCallback) {
        try {
            String errorReason = this.callSdkInternal(_options);
            if (errorReason == null) {
                successCallback.invoke(new Object[]{"Success"});
            } else {
                errorCallback.invoke(new Object[]{new Exception(errorReason).getMessage()});
            }
        }
        catch (Exception e) {
            errorCallback.invoke(new Object[]{e.getMessage()});
        }
    }

    @ReactMethod
    public void initSdkWithPromise(ReadableMap _options, Promise promise) {
        try {
            String errorReason = this.callSdkInternal(_options);
            if (errorReason == null) {
                promise.resolve((Object)"Success");
            } else {
                promise.reject(errorReason, new Exception(errorReason).getMessage());
            }
        }
        catch (Exception e) {
            promise.reject("AF Unknown Error", (Throwable)e);
        }
    }

    private String callSdkInternal(ReadableMap _options) {
        AppsFlyerLib instance = AppsFlyerLib.getInstance();
        JSONObject options = RNUtil.readableMapToJson(_options);
        String devKey = options.optString("devKey", "");
        if (devKey.trim().equals("")) {
            return "No 'devKey' found or its empty";
        }
        this.personalDevKey = devKey;
        boolean isDebug = options.optBoolean("isDebug", false);
        instance.setDebugLog(isDebug);
        boolean isConversionData = options.optBoolean("onInstallConversionDataListener", true);
        if (isDebug) {
            Log.d((String)"AppsFlyer", (String)"Starting SDK");
        }
        boolean isDeepLinking = options.optBoolean("onDeepLinkListener", false);
        boolean isManualStartMode = options.optBoolean("manualStart", false);
        boolean isExpoApp = this.isExpoApp();
        PluginInfo pluginInfo = new PluginInfo(isExpoApp ? Plugin.EXPO : Plugin.REACT_NATIVE, "6.16.2");
        instance.setPluginInfo(pluginInfo);
        instance.init(devKey, isConversionData ? this.registerConversionListener() : null, this.application.getApplicationContext());
        if (isDeepLinking) {
            instance.subscribeForDeepLink(this.registerDeepLinkListener());
        }
        if (!isManualStartMode) {
            this.startSdk();
        }
        return null;
    }

    private boolean isExpoApp() {
        try {
            Class.forName("expo.modules.devmenu.react.DevMenuAwareReactActivity");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private DeepLinkListener registerDeepLinkListener() {
        return new DeepLinkListener(){

            public void onDeepLinking(@NonNull DeepLinkResult deepLinkResult) {
                JSONObject deepLinkObj = new JSONObject();
                DeepLinkResult.Error dlError = deepLinkResult.getError();
                try {
                    deepLinkObj.put("deepLinkStatus", (Object)deepLinkResult.getStatus());
                    deepLinkObj.put("status", (Object)"success");
                    deepLinkObj.put("type", (Object)"onDeepLinking");
                    if (dlError != null && deepLinkResult.getStatus() == DeepLinkResult.Status.ERROR) {
                        deepLinkObj.put("status", (Object)"failure");
                        deepLinkObj.put("data", (Object)dlError.toString());
                        deepLinkObj.put("isDeferred", false);
                    } else if (deepLinkResult.getStatus() == DeepLinkResult.Status.FOUND) {
                        deepLinkObj.put("data", (Object)deepLinkResult.getDeepLink().getClickEvent());
                        deepLinkObj.put("isDeferred", (Object)deepLinkResult.getDeepLink().isDeferred());
                    } else {
                        deepLinkObj.put("data", (Object)"deep link not found");
                        deepLinkObj.put("isDeferred", false);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                try {
                    RNAppsFlyerModule.this.sendEvent((ReactContext)RNAppsFlyerModule.this.reactContext, "onDeepLinking", deepLinkObj.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private AppsFlyerConversionListener registerConversionListener() {
        return new AppsFlyerConversionListener(){

            public void onAppOpenAttribution(Map<String, String> attributionData) {
                RNAppsFlyerModule.this.handleSuccess("onAppOpenAttribution", null, attributionData);
            }

            public void onAttributionFailure(String errorMessage) {
                RNAppsFlyerModule.this.handleError("onAttributionFailure", errorMessage);
            }

            public void onConversionDataSuccess(Map<String, Object> conversionData) {
                RNAppsFlyerModule.this.handleSuccess("onInstallConversionDataLoaded", conversionData, null);
            }

            public void onConversionDataFail(String errorMessage) {
                RNAppsFlyerModule.this.handleError("onInstallConversionFailure", errorMessage);
            }
        };
    }

    private void handleSuccess(String eventType, Map<String, Object> conversionData, Map<String, String> attributionData) {
        JSONObject obj = new JSONObject();
        try {
            JSONObject data = new JSONObject(conversionData == null ? attributionData : conversionData);
            obj.put("status", (Object)"success");
            obj.put("type", (Object)eventType);
            obj.put("data", (Object)data);
            if (eventType.equals("onInstallConversionDataLoaded")) {
                this.sendEvent((ReactContext)this.reactContext, "onInstallConversionDataLoaded", obj.toString());
            } else if (eventType.equals("onAppOpenAttribution")) {
                this.sendEvent((ReactContext)this.reactContext, "onAppOpenAttribution", obj.toString());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void handleError(String eventType, String errorMessage) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("status", (Object)"failure");
            obj.put("type", (Object)eventType);
            obj.put("data", (Object)errorMessage);
            this.sendEvent((ReactContext)this.reactContext, "onInstallConversionDataLoaded", obj.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void sendEvent(ReactContext reactContext, String eventName, Object params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, params);
    }

    @ReactMethod
    public void startSdk() {
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity != null) {
            AppsFlyerLib.getInstance().start((Context)currentActivity, this.personalDevKey);
        } else {
            AppsFlyerLib.getInstance().logEvent((Context)this.application, null, null);
            AppsFlyerLib.getInstance().start((Context)this.application, this.personalDevKey);
        }
    }

    @ReactMethod
    public void logEvent(String eventName, ReadableMap eventData, final Callback successCallback, final Callback errorCallback) {
        try {
            Activity currentActivity;
            if (eventName.trim().equals("")) {
                errorCallback.invoke(new Object[]{"No 'eventName' found or its empty"});
                return;
            }
            Map<String, Object> data = RNUtil.toMap(eventData);
            if (data == null) {
                data = new HashMap<String, Object>();
            }
            if ((currentActivity = this.getCurrentActivity()) != null) {
                AppsFlyerLib.getInstance().logEvent((Context)this.getCurrentActivity(), eventName, data, new AppsFlyerRequestListener(){

                    public void onSuccess() {
                        successCallback.invoke(new Object[]{"Success"});
                    }

                    public void onError(int i, @NonNull String s) {
                        errorCallback.invoke(new Object[]{s});
                    }
                });
            }
        }
        catch (Exception e) {
            errorCallback.invoke(new Object[]{e.getMessage()});
            return;
        }
    }

    @ReactMethod
    public void logEventWithPromise(String eventName, ReadableMap eventData, final Promise promise) {
        try {
            Activity currentActivity;
            if (eventName.trim().equals("")) {
                promise.reject("No 'eventName' found or its empty", new Exception("No 'eventName' found or its empty").getMessage());
                return;
            }
            Map<String, Object> data = RNUtil.toMap(eventData);
            if (data == null) {
                data = new HashMap<String, Object>();
            }
            if ((currentActivity = this.getCurrentActivity()) != null) {
                AppsFlyerLib.getInstance().logEvent((Context)this.getCurrentActivity(), eventName, data, new AppsFlyerRequestListener(){

                    public void onSuccess() {
                        promise.resolve((Object)"Success");
                    }

                    public void onError(int i, @NonNull String s) {
                        promise.reject(s);
                    }
                });
            }
        }
        catch (Exception e) {
            promise.reject("AF Unknown Error", (Throwable)e);
            return;
        }
    }

    @ReactMethod
    public void logAdRevenue(ReadableMap adRevenueDictionary) {
        String mediationNetworkValue;
        if (adRevenueDictionary == null || !adRevenueDictionary.keySetIterator().hasNextKey()) {
            Log.d((String)"AppsFlyer", (String)"adRevenueData is missing, the data is mandatory to use this API.");
            return;
        }
        String monetizationNetwork = adRevenueDictionary.getString("monetizationNetwork");
        if (monetizationNetwork == null) {
            Log.d((String)"AppsFlyer", (String)"monetizationNetwork is missing");
            return;
        }
        String currencyIso4217Code = adRevenueDictionary.getString("currencyIso4217Code");
        if (currencyIso4217Code == null) {
            Log.d((String)"AppsFlyer", (String)"currencyIso4217Code is missing");
            return;
        }
        if (!adRevenueDictionary.hasKey("revenue") || adRevenueDictionary.getType("revenue") != ReadableType.Number) {
            Log.d((String)"AppsFlyer", (String)"revenue is missing or not a number");
            return;
        }
        double revenue = adRevenueDictionary.getDouble("revenue");
        ReadableMap additionalParameters = null;
        if (adRevenueDictionary.hasKey("additionalParameters") && adRevenueDictionary.getType("additionalParameters") == ReadableType.Map) {
            additionalParameters = adRevenueDictionary.getMap("additionalParameters");
        }
        if ((mediationNetworkValue = adRevenueDictionary.getString("mediationNetwork")) == null || mediationNetworkValue.isEmpty()) {
            Log.d((String)"AppsFlyer", (String)"mediationNetwork is missing");
            return;
        }
        MediationNetwork mediationNetwork = MediationNetwork.valueOf((String)mediationNetworkValue.toUpperCase());
        if (mediationNetwork == null) {
            Log.d((String)"AppsFlyer", (String)"Invalid mediation network");
            return;
        }
        AFAdRevenueData adRevenueData = new AFAdRevenueData(monetizationNetwork, mediationNetwork, currencyIso4217Code, revenue);
        AppsFlyerLib.getInstance().logAdRevenue(adRevenueData, RNUtil.toMap(additionalParameters));
    }

    @ReactMethod
    public void getAppsFlyerUID(Callback callback) {
        String appId = AppsFlyerLib.getInstance().getAppsFlyerUID((Context)this.getReactApplicationContext());
        callback.invoke(new Object[]{null, appId});
    }

    @ReactMethod
    public void updateServerUninstallToken(String token, Callback callback) {
        AppsFlyerLib.getInstance().updateServerUninstallToken((Context)this.getReactApplicationContext(), token);
        if (callback != null) {
            callback.invoke(new Object[]{"Success"});
        }
    }

    @ReactMethod
    public void setCustomerUserId(String userId, Callback callback) {
        AppsFlyerLib.getInstance().setCustomerUserId(userId);
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setCollectIMEI(boolean isCollect, Callback callback) {
        AppsFlyerLib.getInstance().setCollectIMEI(isCollect);
        if (callback != null) {
            callback.invoke(new Object[]{"Success"});
        }
    }

    @ReactMethod
    public void setCollectAndroidID(boolean isCollect, Callback callback) {
        AppsFlyerLib.getInstance().setCollectAndroidID(isCollect);
        if (callback != null) {
            callback.invoke(new Object[]{"Success"});
        }
    }

    @ReactMethod
    public void stop(boolean isStopped, Callback callback) {
        AppsFlyerLib.getInstance().stop(isStopped, (Context)this.getReactApplicationContext());
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setAdditionalData(ReadableMap additionalData, Callback callback) {
        Map<String, Object> data = null;
        try {
            data = RNUtil.toMap(additionalData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        HashMap<String, Object> copyData = new HashMap<String, Object>(data);
        AppsFlyerLib.getInstance().setAdditionalData(copyData);
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setUserEmails(ReadableMap _options, Callback successCallback, Callback errorCallback) {
        JSONObject options = RNUtil.readableMapToJson(_options);
        int emailsCryptType = options.optInt("emailsCryptType", 0);
        JSONArray emailsJSON = options.optJSONArray("emails");
        if (emailsJSON.length() == 0) {
            errorCallback.invoke(new Object[]{new Exception("No arguments found or list is corrupted").getMessage()});
            return;
        }
        AppsFlyerProperties.EmailsCryptType type = AppsFlyerProperties.EmailsCryptType.NONE;
        for (AppsFlyerProperties.EmailsCryptType _type : AppsFlyerProperties.EmailsCryptType.values()) {
            if (_type.getValue() != emailsCryptType) continue;
            type = _type;
            break;
        }
        String[] emailsList = new String[emailsJSON.length()];
        try {
            for (int i = 0; i < emailsJSON.length(); ++i) {
                emailsList[i] = emailsJSON.getString(i);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{new Exception("No arguments found or list is corrupted").getMessage()});
            return;
        }
        AppsFlyerLib.getInstance().setUserEmails(type, emailsList);
        successCallback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setAppInviteOneLinkID(String oneLinkID, Callback callback) {
        AppsFlyerLib.getInstance().setAppInviteOneLink(oneLinkID);
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setCurrencyCode(String currencyCode, Callback callback) {
        AppsFlyerLib.getInstance().setCurrencyCode(currencyCode);
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void generateInviteLink(ReadableMap args, final Callback successCallback, final Callback errorCallback) {
        String channel = null;
        String campaign = null;
        String referrerName = null;
        String referrerImageUrl = null;
        String customerID = null;
        String baseDeepLink = null;
        String brandDomain = null;
        LinkGenerator linkGenerator = ShareInviteHelper.generateInviteUrl((Context)this.getReactApplicationContext());
        try {
            JSONObject options = RNUtil.readableMapToJson(args);
            channel = options.optString("channel", "");
            campaign = options.optString("campaign", "");
            referrerName = options.optString("referrerName", "");
            referrerImageUrl = options.optString("referreImageURL", "");
            customerID = options.optString("customerID", "");
            baseDeepLink = options.optString("baseDeepLink", "");
            brandDomain = options.optString("brandDomain", "");
            if (channel != null && channel != "") {
                linkGenerator.setChannel(channel);
            }
            if (campaign != null && campaign != "") {
                linkGenerator.setCampaign(campaign);
            }
            if (referrerName != null && referrerName != "") {
                linkGenerator.setReferrerName(referrerName);
            }
            if (referrerImageUrl != null && referrerImageUrl != "") {
                linkGenerator.setReferrerImageURL(referrerImageUrl);
            }
            if (customerID != null && customerID != "") {
                linkGenerator.setReferrerCustomerId(customerID);
            }
            if (baseDeepLink != null && baseDeepLink != "") {
                linkGenerator.setBaseDeeplink(baseDeepLink);
            }
            if (brandDomain != null && brandDomain != "") {
                linkGenerator.setBrandDomain(brandDomain);
            }
            if (options.length() > 1 && !options.get("userParams").equals("")) {
                JSONObject jsonCustomValues = options.getJSONObject("userParams");
                Iterator keys = jsonCustomValues.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object keyvalue = jsonCustomValues.get(key);
                    linkGenerator.addParameter(key, keyvalue.toString());
                }
            }
        }
        catch (JSONException options) {
            // empty catch block
        }
        CreateOneLinkHttpTask.ResponseListener listener = new CreateOneLinkHttpTask.ResponseListener(){

            public void onResponse(String oneLinkUrl) {
                successCallback.invoke(new Object[]{oneLinkUrl});
            }

            public void onResponseError(String error) {
                errorCallback.invoke(new Object[]{error});
            }
        };
        linkGenerator.generateLink((Context)this.getReactApplicationContext(), listener);
    }

    @ReactMethod
    public void logCrossPromotionImpression(String appId, String campaign, ReadableMap params) {
        try {
            Map<String, Object> temp = RNUtil.toMap(params);
            Map<String, Object> data = null;
            data = temp;
            CrossPromotionHelper.logCrossPromoteImpression((Context)this.getReactApplicationContext(), (String)appId, (String)campaign, data);
        }
        catch (Exception e) {
            CrossPromotionHelper.logCrossPromoteImpression((Context)this.getReactApplicationContext(), (String)appId, (String)campaign);
        }
    }

    @ReactMethod
    public void logCrossPromotionAndOpenStore(String appId, String campaign, ReadableMap params) {
        Map<String, Object> data = null;
        try {
            Map<String, Object> temp;
            data = temp = RNUtil.toMap(params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrossPromotionHelper.logAndOpenStore((Context)this.getReactApplicationContext(), (String)appId, (String)campaign, data);
    }

    @ReactMethod
    public void anonymizeUser(boolean b, Callback callback) {
        AppsFlyerLib.getInstance().anonymizeUser(b);
        callback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void setOneLinkCustomDomains(ReadableArray domainsArray, Callback successCallback, Callback errorCallback) {
        if (domainsArray.size() <= 0) {
            errorCallback.invoke(new Object[]{"No arguments found or list is corrupted"});
            return;
        }
        List<Object> domainsList = RNUtil.toList(domainsArray);
        try {
            String[] domains = domainsList.toArray(new String[domainsList.size()]);
            AppsFlyerLib.getInstance().setOneLinkCustomDomain(domains);
            successCallback.invoke(new Object[]{"Success"});
        }
        catch (Exception e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{"No arguments found or list is corrupted"});
        }
    }

    @ReactMethod
    public void setResolveDeepLinkURLs(ReadableArray urlsArray, Callback successCallback, Callback errorCallback) {
        if (urlsArray.size() <= 0) {
            errorCallback.invoke(new Object[]{"No arguments found or list is corrupted"});
            return;
        }
        List<Object> urlsList = RNUtil.toList(urlsArray);
        try {
            String[] urls = urlsList.toArray(new String[urlsList.size()]);
            AppsFlyerLib.getInstance().setResolveDeepLinkURLs(urls);
            successCallback.invoke(new Object[]{"Success"});
        }
        catch (Exception e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{"No arguments found or list is corrupted"});
        }
    }

    @ReactMethod
    public void performOnAppAttribution(String urlString, Callback successCallback, Callback errorCallback) {
        try {
            URI uri = URI.create(urlString);
            Context c = this.application.getApplicationContext();
            AppsFlyerLib.getInstance().performOnAppAttribution(c, uri);
            successCallback.invoke(new Object[]{"Success"});
        }
        catch (Exception e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{"Passed string is not a valid URI"});
        }
    }

    @ReactMethod
    public void setSharingFilterForPartners(ReadableArray partnersArray) {
        List<Object> partnersList = RNUtil.toList(partnersArray);
        if (partnersList == null) {
            AppsFlyerLib.getInstance().setSharingFilterForPartners((String[])null);
        } else {
            try {
                String[] partners = partnersList.toArray(new String[partnersList.size()]);
                AppsFlyerLib.getInstance().setSharingFilterForPartners(partners);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @ReactMethod
    public void logLocation(double longitude, double latitude, Callback successCallback) {
        AppsFlyerLib.getInstance().logLocation((Context)this.getReactApplicationContext(), latitude, longitude);
        successCallback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void validateAndLogInAppPurchase(ReadableMap purchaseInfo, Callback successCallback, Callback errorCallback) {
        String publicKey = "";
        String signature = "";
        String purchaseData = "";
        String price = "";
        String currency = "";
        Map<String, String> additionalParameters = null;
        try {
            purchaseInfo.hasKey("additionalParameters");
            JSONObject purchaseJson = RNUtil.readableMapToJson(purchaseInfo);
            publicKey = purchaseJson.optString("publicKey", "");
            signature = purchaseJson.optString("signature", "");
            purchaseData = purchaseJson.optString("purchaseData", "");
            price = purchaseJson.optString("price", "");
            currency = purchaseJson.optString("currency", "");
            if (purchaseInfo.hasKey("additionalParameters")) {
                JSONObject additionalParametersJson = purchaseJson.optJSONObject("additionalParameters");
                additionalParameters = RNUtil.jsonObjectToMap(additionalParametersJson);
            }
            if (publicKey == "" || signature == "" || purchaseData == "" || price == "" || currency == "") {
                errorCallback.invoke(new Object[]{"Please provide purchase parameters"});
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{e});
            return;
        }
        this.initInAppPurchaseValidatorListener(successCallback, errorCallback);
        AppsFlyerLib.getInstance().validateAndLogInAppPurchase((Context)this.reactContext, publicKey, signature, purchaseData, price, currency, additionalParameters);
    }

    @ReactMethod
    public void initInAppPurchaseValidatorListener(final Callback successCallback, final Callback errorCallback) {
        AppsFlyerLib.getInstance().registerValidatorListener((Context)this.reactContext, new AppsFlyerInAppPurchaseValidatorListener(){

            public void onValidateInApp() {
                successCallback.invoke(new Object[]{"In-App Purchase Validation success"});
            }

            public void onValidateInAppFailure(String error) {
                errorCallback.invoke(new Object[]{"In-App Purchase Validation failed with error: " + error});
            }
        });
    }

    @ReactMethod
    public void sendPushNotificationData(ReadableMap pushPayload, Callback errorCallback) {
        JSONObject payload = RNUtil.readableMapToJson(pushPayload);
        if (payload == null) {
            String errorMsg = "PushNotification payload is null";
            this.handleErrorMessage(errorMsg, errorCallback);
            return;
        }
        Bundle bundle = null;
        try {
            bundle = RNUtil.jsonToBundle(payload);
        }
        catch (JSONException e) {
            e.printStackTrace();
            String errorMsg = "Can't parse pushPayload to bundle";
            this.handleErrorMessage(errorMsg, errorCallback);
            return;
        }
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            Intent intent = activity.getIntent();
            if (intent != null) {
                intent.putExtras(bundle);
                activity.setIntent(intent);
                AppsFlyerLib.getInstance().sendPushNotificationData(activity);
            } else {
                String errorMsg = "The intent is null. Push payload has not been sent!";
                this.handleErrorMessage(errorMsg, errorCallback);
            }
        } else {
            String errorMsg = "The activity is null. Push payload has not been sent!";
            this.handleErrorMessage(errorMsg, errorCallback);
        }
    }

    private void handleErrorMessage(String errorMessage, Callback errorCB) {
        Log.d((String)"AppsFlyer", (String)errorMessage);
        if (errorCB != null) {
            errorCB.invoke(new Object[]{errorMessage});
        }
    }

    @ReactMethod
    public void setHost(String hostPrefix, String hostName, Callback successCallback) {
        AppsFlyerLib.getInstance().setHost(hostPrefix, hostName);
        successCallback.invoke(new Object[]{"Success"});
    }

    @ReactMethod
    public void addPushNotificationDeepLinkPath(ReadableArray path, Callback successCallback, Callback errorCallback) {
        if (path.size() <= 0) {
            errorCallback.invoke(new Object[]{"No arguments found or list is corrupted"});
            return;
        }
        List<Object> pathList = RNUtil.toList(path);
        try {
            String[] params = pathList.toArray(new String[pathList.size()]);
            AppsFlyerLib.getInstance().addPushNotificationDeepLinkPath(params);
            successCallback.invoke(new Object[]{"Success"});
        }
        catch (Exception e) {
            e.printStackTrace();
            errorCallback.invoke(new Object[]{e});
        }
    }

    @ReactMethod
    public void disableAdvertisingIdentifier(Boolean isDisabled) {
        AppsFlyerLib.getInstance().setDisableAdvertisingIdentifiers(isDisabled.booleanValue());
    }

    @ReactMethod
    public void setPartnerData(String partnerId, ReadableMap partnerData) {
        Map<String, Object> partnerDataAsMap = RNUtil.toMap(partnerData);
        AppsFlyerLib.getInstance().setPartnerData(partnerId, partnerDataAsMap);
    }

    @ReactMethod
    public void appendParametersToDeepLinkingURL(String contains, ReadableMap parameters) {
        Map<String, Object> parametersAsMap = RNUtil.toMap(parameters);
        AppsFlyerLib.getInstance().appendParametersToDeepLinkingURL(contains, parametersAsMap);
    }

    @ReactMethod
    public void setDisableNetworkData(Boolean disabled) {
        AppsFlyerLib.getInstance().setDisableNetworkData(disabled.booleanValue());
    }

    @ReactMethod
    public void performOnDeepLinking() {
        Activity activity = this.getCurrentActivity();
        if (activity != null) {
            Intent intent = activity.getIntent();
            if (intent != null) {
                AppsFlyerLib.getInstance().performOnDeepLinking(intent, (Context)this.application);
            } else {
                Log.d((String)"AppsFlyer", (String)"performOnDeepLinking: intent is null!");
            }
        } else {
            Log.d((String)"AppsFlyer", (String)"performOnDeepLinking: activity is null!");
        }
    }

    @ReactMethod
    public void enableTCFDataCollection(Boolean enabled) {
        AppsFlyerLib.getInstance().enableTCFDataCollection(enabled.booleanValue());
    }

    @ReactMethod
    public void setConsentData(@Nullable ReadableMap consentData) {
        if (consentData == null) {
            Log.e((String)"AppsFlyer", (String)"consentData is null");
            return;
        }
        JSONObject JSONConsentData = RNUtil.readableMapToJson(consentData);
        if (JSONConsentData == null) {
            Log.e((String)"AppsFlyer", (String)"Failed to convert consentData to JSON");
            return;
        }
        Boolean isUserSubjectToGDPR = JSONConsentData.has("isUserSubjectToGDPR") && !JSONConsentData.isNull("isUserSubjectToGDPR") ? Boolean.valueOf(JSONConsentData.optBoolean("isUserSubjectToGDPR")) : null;
        Boolean hasConsentForDataUsage = JSONConsentData.has("hasConsentForDataUsage") && !JSONConsentData.isNull("hasConsentForDataUsage") ? Boolean.valueOf(JSONConsentData.optBoolean("hasConsentForDataUsage")) : null;
        Boolean hasConsentForAdsPersonalization = JSONConsentData.has("hasConsentForAdsPersonalization") && !JSONConsentData.isNull("hasConsentForAdsPersonalization") ? Boolean.valueOf(JSONConsentData.optBoolean("hasConsentForAdsPersonalization")) : null;
        Boolean hasConsentForAdStorage = JSONConsentData.has("hasConsentForAdStorage") && !JSONConsentData.isNull("hasConsentForAdStorage") ? Boolean.valueOf(JSONConsentData.optBoolean("hasConsentForAdStorage")) : null;
        AppsFlyerConsent consentObject = new AppsFlyerConsent(isUserSubjectToGDPR, hasConsentForDataUsage, hasConsentForAdsPersonalization, hasConsentForAdStorage);
        AppsFlyerLib.getInstance().setConsentData(consentObject);
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }
}

