/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.reactnative;

import android.os.Bundle;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RNUtil {
    private RNUtil() {
    }

    public static WritableMap toWritableMap(Map<String, Object> map) {
        WritableMap writableMap = Arguments.createMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                writableMap.putNull(key);
                continue;
            }
            if (value instanceof Boolean) {
                writableMap.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                writableMap.putDouble(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                writableMap.putInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                writableMap.putString(key, (String)value);
                continue;
            }
            if (value instanceof Map) {
                writableMap.putMap(key, (ReadableMap)RNUtil.toWritableMap((Map)value));
                continue;
            }
            if (!(value instanceof List)) continue;
            writableMap.putArray(key, (ReadableArray)RNUtil.toWritableArray((List)value));
        }
        return writableMap;
    }

    public static WritableArray toWritableArray(List<Object> list) {
        WritableArray writableArray = Arguments.createArray();
        for (Object value : list) {
            if (value == null) {
                writableArray.pushNull();
                continue;
            }
            if (value instanceof Boolean) {
                writableArray.pushBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                writableArray.pushDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                writableArray.pushInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                writableArray.pushString((String)value);
                continue;
            }
            if (value instanceof Map) {
                writableArray.pushMap((ReadableMap)RNUtil.toWritableMap((Map)value));
                continue;
            }
            if (!(value instanceof List)) continue;
            writableArray.pushArray((ReadableArray)RNUtil.toWritableArray((List)value));
        }
        return writableArray;
    }

    public static Map<String, Object> toMap(@Nullable ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        if (!iterator.hasNextKey()) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            result.put(key, RNUtil.toObject(readableMap, key));
        }
        return result;
    }

    public static Object toObject(@Nullable ReadableMap readableMap, String key) {
        if (readableMap == null) {
            return null;
        }
        ReadableType readableType = readableMap.getType(key);
        return switch (readableType) {
            case ReadableType.Null -> null;
            case ReadableType.Boolean -> readableMap.getBoolean(key);
            case ReadableType.Number -> {
                double tmp = readableMap.getDouble(key);
                if (tmp == (double)((int)tmp)) {
                    yield (int)tmp;
                }
                yield tmp;
            }
            case ReadableType.String -> readableMap.getString(key);
            case ReadableType.Map -> RNUtil.toMap(readableMap.getMap(key));
            case ReadableType.Array -> RNUtil.toList(readableMap.getArray(key));
            default -> throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        };
    }

    public static List<Object> toList(@Nullable ReadableArray readableArray) {
        if (readableArray == null) {
            return null;
        }
        List<Object> result = new ArrayList<Object>(readableArray.size());
        block8: for (int index = 0; index < readableArray.size(); ++index) {
            ReadableType readableType = readableArray.getType(index);
            switch (readableType) {
                case Null: {
                    result.add(null);
                    continue block8;
                }
                case Boolean: {
                    result.add(readableArray.getBoolean(index));
                    continue block8;
                }
                case Number: {
                    double tmp = readableArray.getDouble(index);
                    if (tmp == (double)((int)tmp)) {
                        result.add((int)tmp);
                        continue block8;
                    }
                    result.add(tmp);
                    continue block8;
                }
                case String: {
                    result.add(readableArray.getString(index));
                    continue block8;
                }
                case Map: {
                    result.add(RNUtil.toMap(readableArray.getMap(index)));
                    continue block8;
                }
                case Array: {
                    result = RNUtil.toList(readableArray.getArray(index));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert object with index: " + index + ".");
                }
            }
        }
        return result;
    }

    @Nullable
    public static JSONObject readableMapToJson(ReadableMap readableMap) {
        JSONObject jsonObject = new JSONObject();
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        if (!iterator.hasNextKey()) {
            return null;
        }
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType readableType = readableMap.getType(key);
            try {
                switch (readableType) {
                    case Null: {
                        jsonObject.put(key, null);
                        break;
                    }
                    case Boolean: {
                        jsonObject.put(key, readableMap.getBoolean(key));
                        break;
                    }
                    case Number: {
                        jsonObject.put(key, readableMap.getInt(key));
                        break;
                    }
                    case String: {
                        jsonObject.put(key, (Object)readableMap.getString(key));
                        break;
                    }
                    case Map: {
                        jsonObject.put(key, (Object)RNUtil.readableMapToJson(readableMap.getMap(key)));
                        break;
                    }
                    case Array: {
                        jsonObject.put(key, (Object)RNUtil.convertArrayToJson(readableMap.getArray(key)));
                    }
                }
            }
            catch (JSONException jSONException) {}
        }
        return jsonObject;
    }

    private static JSONArray convertArrayToJson(ReadableArray readableArray) throws JSONException {
        JSONArray array = new JSONArray();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block8;
                }
                case Boolean: {
                    array.put(readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    array.put(readableArray.getDouble(i));
                    continue block8;
                }
                case String: {
                    array.put((Object)readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    array.put((Object)RNUtil.readableMapToJson(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    array.put((Object)RNUtil.convertArrayToJson(readableArray.getArray(i)));
                }
            }
        }
        return array;
    }

    @Nullable
    public static WritableMap jsonToWritableMap(JSONObject jsonObject) {
        WritableNativeMap writableMap = new WritableNativeMap();
        if (jsonObject == null) {
            return null;
        }
        Iterator iterator = jsonObject.keys();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                Object value = jsonObject.get(key);
                if (value == null) {
                    writableMap.putNull(key);
                    continue;
                }
                if (value instanceof Boolean) {
                    writableMap.putBoolean(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    writableMap.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    writableMap.putDouble(key, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof String) {
                    writableMap.putString(key, (String)value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    writableMap.putMap(key, (ReadableMap)RNUtil.jsonToWritableMap((JSONObject)value));
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                writableMap.putArray(key, (ReadableArray)RNUtil.jsonArrayToWritableArray((JSONArray)value));
            }
            catch (JSONException jSONException) {}
        }
        return writableMap;
    }

    @Nullable
    public static WritableArray jsonArrayToWritableArray(JSONArray jsonArray) {
        WritableNativeArray writableArray = new WritableNativeArray();
        if (jsonArray == null) {
            return null;
        }
        if (jsonArray.length() <= 0) {
            return null;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                Object value = jsonArray.get(i);
                if (value == null) {
                    writableArray.pushNull();
                    continue;
                }
                if (value instanceof Boolean) {
                    writableArray.pushBoolean(((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    writableArray.pushInt(((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    writableArray.pushDouble(((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof String) {
                    writableArray.pushString((String)value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    writableArray.pushMap((ReadableMap)RNUtil.jsonToWritableMap((JSONObject)value));
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                writableArray.pushArray((ReadableArray)RNUtil.jsonArrayToWritableArray((JSONArray)value));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return writableArray;
    }

    @Nullable
    public static Map<String, String> jsonObjectToMap(JSONObject object) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            String value = (String)object.get(key);
            map.put(key, value);
        }
        return map;
    }

    public static Bundle jsonToBundle(JSONObject jsonObject) throws JSONException {
        Bundle bundle = new Bundle();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = jsonObject.getString(key);
            bundle.putString(key, value);
        }
        return bundle;
    }
}

