/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.rnbackgroundfetch;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactInstanceEventListener;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.jstasks.HeadlessJsTaskConfig;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.jstasks.HeadlessJsTaskEventListener;
import com.transistorsoft.tsbackgroundfetch.BGTask;

public class HeadlessTask
implements HeadlessJsTaskEventListener {
    private static String HEADLESS_TASK_NAME = "BackgroundFetch";
    private static Handler mHandler = new Handler();
    private ReactNativeHost mReactNativeHost;
    private HeadlessJsTaskContext mActiveTaskContext;

    public HeadlessTask(Context context, BGTask task) {
        try {
            ReactApplication reactApplication = (ReactApplication)context.getApplicationContext();
            this.mReactNativeHost = reactApplication.getReactNativeHost();
        }
        catch (AssertionError | ClassCastException e) {
            Log.e((String)"TSBackgroundFetch", (String)"Failed to fetch ReactApplication.  Task ignored.");
            return;
        }
        WritableNativeMap clientEvent = new WritableNativeMap();
        clientEvent.putString("taskId", task.getTaskId());
        clientEvent.putBoolean("timeout", task.getTimedOut());
        HeadlessJsTaskConfig config = new HeadlessJsTaskConfig(HEADLESS_TASK_NAME, (WritableMap)clientEvent, 30000L);
        this.startTask(config);
    }

    public void finish() {
        if (this.mActiveTaskContext != null) {
            this.mActiveTaskContext.removeTaskEventListener((HeadlessJsTaskEventListener)this);
        }
    }

    public void onHeadlessJsTaskStart(int taskId) {
        Log.d((String)"TSBackgroundFetch", (String)("onHeadlessJsTaskStart: " + taskId));
    }

    public void onHeadlessJsTaskFinish(int taskId) {
        Log.d((String)"TSBackgroundFetch", (String)("onHeadlessJsTaskFinish: " + taskId));
        this.mActiveTaskContext.removeTaskEventListener((HeadlessJsTaskEventListener)this);
    }

    protected void startTask(final HeadlessJsTaskConfig taskConfig) {
        UiThreadUtil.assertOnUiThread();
        final ReactInstanceManager reactInstanceManager = this.mReactNativeHost.getReactInstanceManager();
        ReactContext reactContext = reactInstanceManager.getCurrentReactContext();
        if (reactContext == null) {
            reactInstanceManager.addReactInstanceEventListener((ReactInstanceEventListener)new ReactInstanceManager.ReactInstanceEventListener(){

                public void onReactContextInitialized(final ReactContext reactContext) {
                    mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            HeadlessTask.this.invokeStartTask(reactContext, taskConfig);
                        }
                    }, 500L);
                    reactInstanceManager.removeReactInstanceEventListener((ReactInstanceEventListener)this);
                }
            });
            if (!reactInstanceManager.hasStartedCreatingInitialContext()) {
                reactInstanceManager.createReactContextInBackground();
            }
        } else {
            this.invokeStartTask(reactContext, taskConfig);
        }
    }

    private void invokeStartTask(ReactContext reactContext, final HeadlessJsTaskConfig taskConfig) {
        if (reactContext.getLifecycleState() == LifecycleState.RESUMED) {
            return;
        }
        final HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance((ReactContext)reactContext);
        headlessJsTaskContext.addTaskEventListener((HeadlessJsTaskEventListener)this);
        this.mActiveTaskContext = headlessJsTaskContext;
        try {
            UiThreadUtil.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int n = headlessJsTaskContext.startTask(taskConfig);
                    }
                    catch (IllegalStateException exception) {
                        Log.e((String)"TSBackgroundFetch", (String)"Headless task attempted to run in the foreground.  Task ignored.");
                        return;
                    }
                }
            });
        }
        catch (IllegalStateException exception) {
            Log.e((String)"TSBackgroundFetch", (String)"Headless task attempted to run in the foreground.  Task ignored.");
            return;
        }
    }
}

