/*
 * Decompiled with CFR 0.152.
 */
package com.transistorsoft.rnbackgroundfetch;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.transistorsoft.rnbackgroundfetch.HeadlessTask;
import com.transistorsoft.tsbackgroundfetch.BackgroundFetch;
import com.transistorsoft.tsbackgroundfetch.BackgroundFetchConfig;

public class RNBackgroundFetchModule
extends ReactContextBaseJavaModule
implements ActivityEventListener,
LifecycleEventListener {
    public static final String TAG = "BackgroundFetch";
    private static final String EVENT_FETCH = "fetch";
    private static final String JOB_SERVICE_CLASS = HeadlessTask.class.getName();
    private static final String FETCH_TASK_ID = "react-native-background-fetch";
    private boolean isForceReload = false;
    private boolean initialized = false;

    public RNBackgroundFetchModule(ReactApplicationContext reactContext) {
        super(reactContext);
        Log.d((String)TAG, (String)"[RNBackgroundFetchModule load]");
        BackgroundFetch.getInstance((Context)reactContext.getApplicationContext());
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public String getName() {
        return TAG;
    }

    @ReactMethod
    public void configure(ReadableMap options, Callback success, Callback failure) {
        Log.d((String)TAG, (String)"[RNBackgroundFetchModule configure]");
        BackgroundFetch adapter = this.getAdapter();
        BackgroundFetch.Callback callback = new BackgroundFetch.Callback(){

            public void onFetch(String taskId) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("taskId", taskId);
                params.putBoolean("timeout", false);
                ((RCTNativeAppEventEmitter)RNBackgroundFetchModule.this.getReactApplicationContext().getJSModule(RCTNativeAppEventEmitter.class)).emit(RNBackgroundFetchModule.EVENT_FETCH, (Object)params);
            }

            public void onTimeout(String taskId) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("taskId", taskId);
                params.putBoolean("timeout", true);
                ((RCTNativeAppEventEmitter)RNBackgroundFetchModule.this.getReactApplicationContext().getJSModule(RCTNativeAppEventEmitter.class)).emit(RNBackgroundFetchModule.EVENT_FETCH, (Object)params);
            }
        };
        adapter.configure(this.buildConfig(options).setTaskId(FETCH_TASK_ID).setIsFetchTask(true).build(), callback);
        success.invoke(new Object[]{2});
    }

    @ReactMethod
    public void scheduleTask(ReadableMap options, Callback success, Callback failure) {
        BackgroundFetch adapter = this.getAdapter();
        adapter.scheduleTask(this.buildConfig(options).build());
        success.invoke(new Object[]{true});
    }

    @ReactMethod
    public void start(Callback success, Callback failure) {
        BackgroundFetch adapter = this.getAdapter();
        adapter.start(FETCH_TASK_ID);
        success.invoke(new Object[]{adapter.status()});
    }

    @ReactMethod
    public void stop(String taskId, Callback success, Callback failure) {
        if (taskId == null) {
            taskId = FETCH_TASK_ID;
        }
        BackgroundFetch adapter = this.getAdapter();
        adapter.stop(taskId);
        success.invoke(new Object[]{true});
    }

    @ReactMethod
    public void status(Callback success) {
        BackgroundFetch adapter = this.getAdapter();
        success.invoke(new Object[]{adapter.status()});
    }

    @ReactMethod
    public void finish(String taskId) {
        BackgroundFetch adapter = this.getAdapter();
        adapter.finish(taskId);
    }

    @ReactMethod
    public void addListener(String event) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }

    public void onHostResume() {
        if (!this.initialized) {
            this.initializeBackgroundFetch();
        }
    }

    public void onHostPause() {
    }

    public void onNewIntent(Intent intent) {
    }

    public void onHostDestroy() {
        this.initialized = false;
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    private BackgroundFetchConfig.Builder buildConfig(ReadableMap options) {
        BackgroundFetchConfig.Builder config = new BackgroundFetchConfig.Builder();
        if (options.hasKey("minimumFetchInterval")) {
            config.setMinimumFetchInterval(options.getInt("minimumFetchInterval"));
        }
        if (options.hasKey("taskId")) {
            config.setTaskId(options.getString("taskId"));
        }
        if (options.hasKey("delay")) {
            Integer delay = options.getInt("delay");
            config.setDelay(delay.longValue());
        }
        if (options.hasKey("stopOnTerminate")) {
            config.setStopOnTerminate(options.getBoolean("stopOnTerminate"));
        }
        if (options.hasKey("forceAlarmManager")) {
            config.setForceAlarmManager(options.getBoolean("forceAlarmManager"));
        }
        if (options.hasKey("startOnBoot")) {
            config.setStartOnBoot(options.getBoolean("startOnBoot"));
        }
        if (options.hasKey("enableHeadless") && options.getBoolean("enableHeadless")) {
            config.setJobService(JOB_SERVICE_CLASS);
        }
        if (options.hasKey("requiredNetworkType")) {
            config.setRequiredNetworkType(options.getInt("requiredNetworkType"));
        }
        if (options.hasKey("requiresBatteryNotLow")) {
            config.setRequiresBatteryNotLow(options.getBoolean("requiresBatteryNotLow"));
        }
        if (options.hasKey("requiresCharging")) {
            config.setRequiresCharging(options.getBoolean("requiresCharging"));
        }
        if (options.hasKey("requiresDeviceIdle")) {
            config.setRequiresDeviceIdle(options.getBoolean("requiresDeviceIdle"));
        }
        if (options.hasKey("requiresStorageNotLow")) {
            config.setRequiresStorageNotLow(options.getBoolean("requiresStorageNotLow"));
        }
        if (options.hasKey("periodic")) {
            config.setPeriodic(options.getBoolean("periodic"));
        }
        return config;
    }

    private void initializeBackgroundFetch() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            return;
        }
        this.initialized = true;
    }

    private BackgroundFetch getAdapter() {
        return BackgroundFetch.getInstance((Context)this.getReactApplicationContext());
    }
}

