/*
 * Decompiled with CFR 0.152.
 */
package com.zyu;

import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.zyu.ReactWheelCurvedPicker;
import java.util.ArrayList;
import java.util.Map;

public class ReactWheelCurvedPickerManager
extends SimpleViewManager<ReactWheelCurvedPicker> {
    private static final String REACT_CLASS = "WheelCurvedPicker";
    private static final int DEFAULT_TEXT_SIZE = 50;
    private static final int DEFAULT_ITEM_SPACE = 28;

    protected ReactWheelCurvedPicker createViewInstance(ThemedReactContext reactContext) {
        ReactWheelCurvedPicker picker = new ReactWheelCurvedPicker((ReactContext)reactContext);
        picker.setTextColor(-3355444);
        picker.setCurrentTextColor(-1);
        picker.setTextSize(50);
        picker.setItemSpace(28);
        return picker;
    }

    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of((Object)"wheelCurvedPickerPageSelected", (Object)MapBuilder.of((Object)"registrationName", (Object)"onValueChange"));
    }

    @ReactProp(name="data")
    public void setData(ReactWheelCurvedPicker picker, ReadableArray items) {
        if (picker != null) {
            ArrayList<Object> valueData = new ArrayList<Object>();
            ArrayList<String> labelData = new ArrayList<String>();
            for (int i = 0; i < items.size(); ++i) {
                ReadableMap itemMap = items.getMap(i);
                if (itemMap.getType("value") == ReadableType.String) {
                    valueData.add(itemMap.getString("value"));
                } else if (itemMap.getType("value") == ReadableType.Number) {
                    valueData.add(itemMap.getInt("value"));
                }
                labelData.add(itemMap.getString("label"));
            }
            picker.setValueData(valueData);
            picker.setData(labelData);
        }
    }

    @ReactProp(name="selectedIndex")
    public void setSelectedIndex(ReactWheelCurvedPicker picker, int index) {
        if (picker != null && picker.getState() == 0) {
            picker.setItemIndex(index);
            picker.invalidate();
        }
    }

    @ReactProp(name="textColor", customType="Color")
    public void setTextColor(ReactWheelCurvedPicker picker, Integer color) {
        if (picker != null) {
            picker.setCurrentTextColor(color);
            picker.setTextColor(color);
        }
    }

    @ReactProp(name="textSize")
    public void setTextSize(ReactWheelCurvedPicker picker, int size) {
        if (picker != null) {
            picker.setTextSize((int)PixelUtil.toPixelFromDIP((float)size));
        }
    }

    @ReactProp(name="itemSpace")
    public void setItemSpace(ReactWheelCurvedPicker picker, int space) {
        if (picker != null) {
            picker.setItemSpace((int)PixelUtil.toPixelFromDIP((float)space));
        }
    }

    public String getName() {
        return REACT_CLASS;
    }
}

