/*
 * Decompiled with CFR 0.152.
 */
package com.rusel.RCTBluetoothSerial;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Base64;
import android.util.Log;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.rusel.RCTBluetoothSerial.RCTBluetoothSerialService;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.Nullable;

public class RCTBluetoothSerialModule
extends ReactContextBaseJavaModule
implements ActivityEventListener,
LifecycleEventListener {
    private static final boolean D = false;
    private static final String BT_ENABLED = "bluetoothEnabled";
    private static final String BT_DISABLED = "bluetoothDisabled";
    private static final String CONN_SUCCESS = "connectionSuccess";
    private static final String CONN_FAILED = "connectionFailed";
    private static final String CONN_LOST = "connectionLost";
    private static final String DEVICE_READ = "read";
    private static final String ERROR = "error";
    private static final int REQUEST_ENABLE_BLUETOOTH = 1;
    private BluetoothAdapter mBluetoothAdapter;
    private RCTBluetoothSerialService mBluetoothService;
    private ReactApplicationContext mReactContext;
    private StringBuffer mBuffer = new StringBuffer();
    private Promise mEnabledPromise;
    private Promise mConnectedPromise;
    private Promise mDeviceDiscoveryPromise;
    private Promise mPairDevicePromise;

    public RCTBluetoothSerialModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mReactContext = reactContext;
        if (this.mBluetoothAdapter == null) {
            this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.mBluetoothService == null) {
            this.mBluetoothService = new RCTBluetoothSerialService(this);
        }
        if (this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled()) {
            this.sendEvent(BT_ENABLED, null);
        } else {
            this.sendEvent(BT_DISABLED, null);
        }
        this.mReactContext.addLifecycleEventListener((LifecycleEventListener)this);
        this.registerBluetoothStateReceiver();
    }

    public String getName() {
        return "RCTBluetoothSerial";
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1) {
            if (resultCode == -1) {
                if (this.mEnabledPromise != null) {
                    this.mEnabledPromise.resolve((Object)true);
                }
            } else if (this.mEnabledPromise != null) {
                this.mEnabledPromise.reject((Throwable)new Exception("User did not enable Bluetooth"));
            }
            this.mEnabledPromise = null;
        }
    }

    public void onHostResume() {
    }

    public void onHostPause() {
    }

    public void onHostDestroy() {
        this.mBluetoothService.stop();
    }

    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mBluetoothService.stop();
    }

    @ReactMethod
    public void requestEnable(Promise promise) {
        if (this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled()) {
            promise.resolve((Object)true);
        } else {
            Activity activity = this.getCurrentActivity();
            this.mEnabledPromise = promise;
            Intent intent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
            if (activity != null) {
                activity.startActivityForResult(intent, 1);
            } else {
                Exception e = new Exception("Cannot start activity");
                Log.e((String)"BluetoothSerial", (String)"Cannot start activity", (Throwable)e);
                this.mEnabledPromise.reject((Throwable)e);
                this.mEnabledPromise = null;
                this.onError(e);
            }
        }
    }

    @ReactMethod
    public void enable(Promise promise) {
        if (this.mBluetoothAdapter != null && !this.mBluetoothAdapter.isEnabled()) {
            this.mBluetoothAdapter.enable();
        }
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void disable(Promise promise) {
        if (this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled()) {
            this.mBluetoothAdapter.disable();
        }
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void isEnabled(Promise promise) {
        if (this.mBluetoothAdapter != null) {
            promise.resolve((Object)this.mBluetoothAdapter.isEnabled());
        } else {
            promise.resolve((Object)false);
        }
    }

    @ReactMethod
    public void list(Promise promise) {
        WritableArray deviceList = Arguments.createArray();
        if (this.mBluetoothAdapter != null) {
            Set bondedDevices = this.mBluetoothAdapter.getBondedDevices();
            for (BluetoothDevice rawDevice : bondedDevices) {
                WritableMap device = this.deviceToWritableMap(rawDevice);
                deviceList.pushMap(device);
            }
        }
        promise.resolve((Object)deviceList);
    }

    @ReactMethod
    public void discoverUnpairedDevices(Promise promise) {
        this.mDeviceDiscoveryPromise = promise;
        this.registerBluetoothDeviceDiscoveryReceiver();
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.startDiscovery();
        } else {
            promise.resolve((Object)Arguments.createArray());
        }
    }

    public void pairDevice(String id, Promise promise) {
        this.mPairDevicePromise = promise;
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.startDiscovery();
        } else {
            promise.resolve((Object)false);
        }
    }

    @ReactMethod
    public void connect(String id, Promise promise) {
        this.mConnectedPromise = promise;
        if (this.mBluetoothAdapter != null) {
            BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(id);
            if (device != null) {
                this.mBluetoothService.connect(device);
            } else {
                promise.reject((Throwable)new Exception("Could not connect to " + id));
            }
        } else {
            promise.resolve((Object)true);
        }
    }

    @ReactMethod
    public void disconnect(Promise promise) {
        this.mBluetoothService.stop();
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void isConnected(Promise promise) {
        promise.resolve((Object)this.mBluetoothService.isConnected());
    }

    @ReactMethod
    public void writeToDevice(String message, Promise promise) {
        byte[] data = Base64.decode((String)message, (int)0);
        this.mBluetoothService.write(data);
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void readFromDevice(Promise promise) {
        int length = this.mBuffer.length();
        String data = this.mBuffer.substring(0, length);
        this.mBuffer.delete(0, length);
        promise.resolve((Object)data);
    }

    @ReactMethod
    public void readUntilDelimiter(String delimiter, Promise promise) {
        String data = "";
        int index = this.mBuffer.indexOf(delimiter, 0);
        if (index > -1) {
            data = this.mBuffer.substring(0, index + delimiter.length());
            this.mBuffer.delete(0, index + delimiter.length());
        }
        promise.resolve((Object)data);
    }

    @ReactMethod
    public void clear(Promise promise) {
        this.mBuffer.setLength(0);
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void available(Promise promise) {
        promise.resolve((Object)this.mBuffer.length());
    }

    @ReactMethod
    public void setAdapterName(String newName, Promise promise) {
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.setName(newName);
        }
        promise.resolve((Object)true);
    }

    void onConnectionSuccess(String msg) {
        WritableMap params = Arguments.createMap();
        params.putString("message", msg);
        this.sendEvent(CONN_SUCCESS, null);
        if (this.mConnectedPromise != null) {
            this.mConnectedPromise.resolve((Object)params);
        }
        this.mConnectedPromise = null;
    }

    void onConnectionFailed(String msg) {
        WritableMap params = Arguments.createMap();
        params.putString("message", msg);
        this.sendEvent(CONN_FAILED, null);
        if (this.mConnectedPromise != null) {
            this.mConnectedPromise.reject((Throwable)new Exception(msg));
        }
        this.mConnectedPromise = null;
    }

    void onConnectionLost(String msg) {
        WritableMap params = Arguments.createMap();
        params.putString("message", msg);
        this.sendEvent(CONN_LOST, params);
    }

    void onError(Exception e) {
        WritableMap params = Arguments.createMap();
        params.putString("message", e.getMessage());
        this.sendEvent(ERROR, params);
    }

    void onData(String data) {
        WritableMap params = Arguments.createMap();
        params.putString("data", data);
        this.sendEvent(DEVICE_READ, params);
    }

    private void pairDevice(BluetoothDevice device) {
        block3: {
            try {
                Method m = device.getClass().getMethod("createBond", null);
                m.invoke((Object)device, (Object[])null);
                if (this.mPairDevicePromise != null) {
                    this.mPairDevicePromise.resolve((Object)true);
                }
            }
            catch (Exception e) {
                Log.e((String)"pairDevice()", (String)e.getMessage());
                if (this.mPairDevicePromise == null) break block3;
                this.mPairDevicePromise.reject((Throwable)e);
            }
        }
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        if (this.mReactContext.hasActiveCatalystInstance()) {
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
        }
    }

    private WritableMap deviceToWritableMap(BluetoothDevice device) {
        WritableMap params = Arguments.createMap();
        params.putString("name", device.getName());
        params.putString("address", device.getAddress());
        params.putString("id", device.getAddress());
        if (device.getBluetoothClass() != null) {
            params.putInt("class", device.getBluetoothClass().getDeviceClass());
        }
        return params;
    }

    private void registerBluetoothStateReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        BroadcastReceiver bluetoothStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(action)) {
                    int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    switch (state) {
                        case 10: {
                            RCTBluetoothSerialModule.this.sendEvent(RCTBluetoothSerialModule.BT_DISABLED, null);
                            break;
                        }
                        case 12: {
                            RCTBluetoothSerialModule.this.sendEvent(RCTBluetoothSerialModule.BT_ENABLED, null);
                        }
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(bluetoothStateReceiver, intentFilter);
    }

    private void registerBluetoothDeviceDiscoveryReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.device.action.FOUND");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        BroadcastReceiver deviceDiscoveryReceiver = new BroadcastReceiver(){
            private WritableArray unpairedDevices = Arguments.createArray();

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.bluetooth.device.action.FOUND".equals(action)) {
                    BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    WritableMap d = RCTBluetoothSerialModule.this.deviceToWritableMap(device);
                    this.unpairedDevices.pushMap(d);
                } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                    if (RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise != null) {
                        RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise.resolve((Object)this.unpairedDevices);
                    }
                    RCTBluetoothSerialModule.this.mDeviceDiscoveryPromise = null;
                    try {
                        RCTBluetoothSerialModule.this.mReactContext.unregisterReceiver((BroadcastReceiver)this);
                    }
                    catch (Exception e) {
                        Log.e((String)"BluetoothSerial", (String)"Unable to unregister receiver", (Throwable)e);
                        RCTBluetoothSerialModule.this.onError(e);
                    }
                }
            }
        };
        this.mReactContext.registerReceiver(deviceDiscoveryReceiver, intentFilter);
    }
}

