/*
 * Decompiled with CFR 0.152.
 */
package com.rusel.RCTBluetoothSerial;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import com.rusel.RCTBluetoothSerial.RCTBluetoothSerialModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

class RCTBluetoothSerialService {
    private static final boolean D = false;
    private static final UUID UUID_SPP = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;
    private RCTBluetoothSerialModule mModule;
    private String mState = "none";
    private static final String STATE_NONE = "none";
    private static final String STATE_CONNECTING = "connecting";
    private static final String STATE_CONNECTED = "connected";

    RCTBluetoothSerialService(RCTBluetoothSerialModule module) {
        this.mModule = module;
    }

    synchronized void connect(BluetoothDevice device) {
        if (this.mState.equals(STATE_CONNECTING)) {
            this.cancelConnectThread();
        }
        this.cancelConnectedThread();
        this.mConnectThread = new ConnectThread(device);
        this.mConnectThread.start();
        this.setState(STATE_CONNECTING);
    }

    boolean isConnected() {
        return this.getState().equals(STATE_CONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] out) {
        ConnectedThread r;
        RCTBluetoothSerialService rCTBluetoothSerialService = this;
        synchronized (rCTBluetoothSerialService) {
            if (this.isConnected()) {
                return;
            }
            r = this.mConnectedThread;
        }
        r.write(out);
    }

    synchronized void stop() {
        this.cancelConnectThread();
        this.cancelConnectedThread();
        this.setState(STATE_NONE);
    }

    private synchronized String getState() {
        return this.mState;
    }

    private synchronized void setState(String state) {
        this.mState = state;
    }

    private synchronized void connectionSuccess(BluetoothSocket socket, BluetoothDevice device) {
        this.cancelConnectThread();
        this.cancelConnectedThread();
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.mModule.onConnectionSuccess("Connected to " + device.getName());
        this.setState(STATE_CONNECTED);
    }

    private void connectionFailed() {
        this.mModule.onConnectionFailed("Unable to connect to device");
        this.stop();
    }

    private void connectionLost() {
        this.mModule.onConnectionLost("Device connection was lost");
        this.stop();
    }

    private void cancelConnectThread() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
    }

    private void cancelConnectedThread() {
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        ConnectedThread(BluetoothSocket socket) {
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"temp sockets not created", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            Log.i((String)"BluetoothSerial", (String)"BEGIN mConnectedThread");
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int bytes = this.mmInStream.read(buffer);
                    String data = new String(buffer, 0, bytes, "ISO-8859-1");
                    RCTBluetoothSerialService.this.mModule.onData(data);
                }
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"disconnected", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
                RCTBluetoothSerialService.this.connectionLost();
                RCTBluetoothSerialService.this.stop();
                return;
            }
        }

        void write(byte[] buffer) {
            try {
                String str = new String(buffer, "UTF-8");
                this.mmOutStream.write(buffer);
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"Exception during write", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
        }

        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"close() of connect socket failed", (Throwable)e);
            }
        }
    }

    private class ConnectThread
    extends Thread {
        private BluetoothSocket mmSocket;
        private final BluetoothDevice mmDevice;

        ConnectThread(BluetoothDevice device) {
            this.mmDevice = device;
            BluetoothSocket tmp = null;
            try {
                tmp = device.createRfcommSocketToServiceRecord(UUID_SPP);
            }
            catch (Exception e) {
                RCTBluetoothSerialService.this.mModule.onError(e);
                Log.e((String)"BluetoothSerial", (String)"Socket create() failed", (Throwable)e);
            }
            this.mmSocket = tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setName("ConnectThread");
            RCTBluetoothSerialService.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)e.toString());
                RCTBluetoothSerialService.this.mModule.onError(e);
                try {
                    Log.i((String)"BluetoothSerial", (String)"Trying fallback...");
                    this.mmSocket = (BluetoothSocket)this.mmDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE).invoke((Object)this.mmDevice, 1);
                    this.mmSocket.connect();
                    Log.i((String)"BluetoothSerial", (String)"Connected");
                }
                catch (Exception e2) {
                    Log.e((String)"BluetoothSerial", (String)"Couldn't establish a Bluetooth connection.");
                    RCTBluetoothSerialService.this.mModule.onError(e2);
                    try {
                        this.mmSocket.close();
                    }
                    catch (Exception e3) {
                        Log.e((String)"BluetoothSerial", (String)"unable to close() socket during connection failure", (Throwable)e3);
                        RCTBluetoothSerialService.this.mModule.onError(e3);
                    }
                    RCTBluetoothSerialService.this.connectionFailed();
                    return;
                }
            }
            RCTBluetoothSerialService rCTBluetoothSerialService = RCTBluetoothSerialService.this;
            synchronized (rCTBluetoothSerialService) {
                RCTBluetoothSerialService.this.mConnectThread = null;
            }
            RCTBluetoothSerialService.this.connectionSuccess(this.mmSocket, this.mmDevice);
        }

        void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (Exception e) {
                Log.e((String)"BluetoothSerial", (String)"close() of connect socket failed", (Throwable)e);
                RCTBluetoothSerialService.this.mModule.onError(e);
            }
        }
    }
}

