/*
 * Decompiled with CFR 0.152.
 */
package com.reactnativebugbattlesdk;

import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.util.Base64;
import bugbattle.io.bugbattle.APPLICATIONTYPE;
import bugbattle.io.bugbattle.BugBattle;
import bugbattle.io.bugbattle.BugBattleActivationMethod;
import bugbattle.io.bugbattle.BugBattleNotInitialisedException;
import bugbattle.io.bugbattle.BugSentCallback;
import bugbattle.io.bugbattle.BugWillBeSentCallback;
import bugbattle.io.bugbattle.CustomActionCallback;
import bugbattle.io.bugbattle.RequestType;
import com.facebook.react.ReactApplication;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BugbattleSdkModule
extends ReactContextBaseJavaModule {
    private boolean isSilentBugReport = false;
    private BugBattle instance = null;

    public BugbattleSdkModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "BugbattleSdk";
    }

    @ReactMethod
    public void initializeMany(String sdkKey, ReadableArray activationMethods) {
        if (this.instance == null) {
            BugBattle.getInstance().registerCustomAction(new CustomActionCallback(){

                public void invoke(String message) {
                    JSONObject obj = new JSONObject();
                    try {
                        obj.put("name", (Object)message);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    ((DeviceEventManagerModule.RCTDeviceEventEmitter)BugbattleSdkModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("customActionTriggered", (Object)obj.toString());
                }
            });
            BugBattle.getInstance().setBugWillBeSentCallback(new BugWillBeSentCallback(){

                public void flowInvoced() {
                    ((DeviceEventManagerModule.RCTDeviceEventEmitter)BugbattleSdkModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("bugWillBeSent", null);
                }
            });
            try {
                BugBattle.getInstance().setApplicationType(APPLICATIONTYPE.REACTNATIVE);
                LinkedList<BugBattleActivationMethod> activationMethodsList = new LinkedList<BugBattleActivationMethod>();
                for (Object activationMethod : activationMethods.toArrayList()) {
                    if (activationMethod.equals("SHAKE")) {
                        activationMethodsList.add(BugBattleActivationMethod.SHAKE);
                        BugBattle.getInstance().setBugSentCallback(new BugSentCallback(){

                            public void close() {
                                new Timer().schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        if (!BugbattleSdkModule.this.isSilentBugReport) {
                                            BugbattleSdkModule.this.showDevMenu();
                                        }
                                        BugbattleSdkModule.this.isSilentBugReport = false;
                                    }
                                }, 500L);
                            }
                        });
                        continue;
                    }
                    if (!activationMethod.equals("SCREENSHOT")) continue;
                    activationMethodsList.add(BugBattleActivationMethod.SCREENSHOT);
                }
                Activity activity = this.getReactApplicationContext().getCurrentActivity();
                if (activity != null) {
                    BugBattleActivationMethod[] bugBattleActivationMethods = activationMethodsList.toArray(new BugBattleActivationMethod[activationMethodsList.size()]);
                    this.instance = BugBattle.initWithToken((String)sdkKey, (BugBattleActivationMethod[])bugBattleActivationMethods, (Application)activity.getApplication(), (Activity)activity);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ReactMethod
    public void initialize(String sdkKey, String activationMethod) {
        if (this.instance == null) {
            try {
                Activity activity = this.getReactApplicationContext().getCurrentActivity();
                if (activity != null) {
                    BugBattle.getInstance().setApplicationType(APPLICATIONTYPE.REACTNATIVE);
                    BugBattle.getInstance().setBugWillBeSentCallback(new BugWillBeSentCallback(){

                        public void flowInvoced() {
                            ((DeviceEventManagerModule.RCTDeviceEventEmitter)BugbattleSdkModule.this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("bugWillBeSent", null);
                        }
                    });
                    if (activationMethod.equals("SHAKE")) {
                        this.instance = BugBattle.initWithToken((String)sdkKey, (BugBattleActivationMethod)BugBattleActivationMethod.SHAKE, (Application)activity.getApplication());
                        BugBattle.getInstance().setBugSentCallback(new BugSentCallback(){

                            public void close() {
                                new Timer().schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        BugbattleSdkModule.this.showDevMenu();
                                    }
                                }, 500L);
                            }
                        });
                    } else {
                        this.instance = activationMethod.equals("SCREENSHOT") ? BugBattle.initWithToken((String)sdkKey, (BugBattleActivationMethod)BugBattleActivationMethod.SCREENSHOT, (Application)activity.getApplication()) : BugBattle.initWithToken((String)sdkKey, (BugBattleActivationMethod)BugBattleActivationMethod.NONE, (Application)activity.getApplication());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void showDevMenu() {
        final ReactApplication application = (ReactApplication)this.getReactApplicationContext().getCurrentActivity().getApplication();
        Handler mainHandler = new Handler(this.getReactApplicationContext().getMainLooper());
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    application.getReactNativeHost().getReactInstanceManager().getDevSupportManager().showDevOptionsDialog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        mainHandler.post(myRunnable);
    }

    @ReactMethod
    public void startBugReporting() {
        try {
            BugBattle.getInstance().startBugReporting();
            BugBattle.getInstance().setBugSentCallback(new BugSentCallback(){

                public void close() {
                    new Timer().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            BugbattleSdkModule.this.showDevMenu();
                        }
                    }, 500L);
                }
            });
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @ReactMethod
    public void startBugReportingWithImage(String base64) {
        byte[] decodedString = Base64.decode((String)base64, (int)0);
        Bitmap decodedByte = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
        try {
            BugBattle.getInstance().startBugReporting(decodedByte);
        }
        catch (BugBattleNotInitialisedException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    public void sendSilentBugReport(String senderEmail, String description, String priority) {
        this.isSilentBugReport = true;
        BugBattle.SEVERITY severity = BugBattle.SEVERITY.LOW;
        if (priority == "MEDIUM") {
            severity = BugBattle.SEVERITY.MIDDLE;
        }
        if (priority == "HIGH") {
            severity = BugBattle.SEVERITY.HIGH;
        }
        BugBattle.getInstance().sendSilentBugReport(senderEmail, description, severity);
    }

    @ReactMethod
    public void setApiUrl(String apiUrl) {
        try {
            BugBattle.getInstance().setApiUrl(apiUrl);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @ReactMethod
    public void setCustomerEmail(String email) {
        BugBattle.getInstance().setCustomerEmail(email);
    }

    @ReactMethod
    public void setLanguage(String language) {
        BugBattle.getInstance().setLanguage(language);
    }

    @ReactMethod
    public void enableReplays(boolean enable) {
        if (enable) {
            try {
                Thread.sleep(1000L);
                BugBattle.getInstance().enableReplays(enable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ReactMethod
    public void appendCustomData(ReadableMap customData) {
        try {
            JSONObject jsonObject = BugbattleSdkModule.convertMapToJson(customData);
            BugBattle.getInstance().appendCustomData(jsonObject);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @ReactMethod
    public void setCustomData(String key, String value) {
        BugBattle.getInstance().setCustomData(key, value);
    }

    @ReactMethod
    public void attachData(ReadableMap data) {
        try {
            JSONObject object = BugbattleSdkModule.convertMapToJson(data);
            BugBattle.getInstance().attachData(object);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @ReactMethod
    public void removeCustomData(String key) {
        BugBattle.getInstance().removeCustomDataForKey(key);
    }

    @ReactMethod
    public void clearCustomData() {
        BugBattle.getInstance().clearCustomData();
    }

    @ReactMethod
    public void attachNetworkLog(String networkLog) {
        try {
            JSONArray object = new JSONArray(networkLog);
            for (int i = 0; i < object.length(); ++i) {
                JSONObject currentRequest = (JSONObject)object.get(i);
                JSONObject response = (JSONObject)currentRequest.get("response");
                JSONObject request = new JSONObject();
                if (currentRequest.has("request")) {
                    request = (JSONObject)currentRequest.get("request");
                }
                BugBattle.getInstance().logNetwork(currentRequest.getString("url"), RequestType.valueOf((String)currentRequest.getString("type")), response.getInt("status"), currentRequest.getInt("duration"), request, response);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    @ReactMethod
    public void enablePrivacyPolicy(boolean enable) {
        BugBattle.getInstance().enablePrivacyPolicy(enable);
    }

    @ReactMethod
    public void setPrivacyPolicyUrl(String privacyUrl) {
        BugBattle.getInstance().setPrivacyPolicyUrl(privacyUrl);
    }

    @ReactMethod
    public void enablePoweredByBugbattle(boolean enable) {
        BugBattle.getInstance().enablePoweredByBugbattle(enable);
    }

    @ReactMethod
    public void setLogoUrl(String logoUrl) {
        BugBattle.getInstance().setLogoUrl(logoUrl);
    }

    @ReactMethod
    void logEvent(String name) {
        BugBattle.getInstance().logEvent(name);
    }

    @ReactMethod
    void logEvent(String name, ReadableMap data) {
        JSONObject jsonObject = null;
        try {
            jsonObject = BugbattleSdkModule.convertMapToJson(data);
            BugBattle.getInstance().logEvent(name, jsonObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @ReactMethod
    void setCustomerName(String name) {
        BugBattle.getInstance().setCustomerName(name);
    }

    @ReactMethod
    void setColor(String color) {
        BugBattle.getInstance().setColor(color);
    }

    private static JSONObject convertMapToJson(ReadableMap readableMap) throws JSONException {
        JSONObject object = new JSONObject();
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            switch (readableMap.getType(key)) {
                case Null: {
                    object.put(key, JSONObject.NULL);
                    break;
                }
                case Boolean: {
                    object.put(key, readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    object.put(key, readableMap.getDouble(key));
                    break;
                }
                case String: {
                    object.put(key, (Object)readableMap.getString(key));
                    break;
                }
                case Map: {
                    object.put(key, (Object)BugbattleSdkModule.convertMapToJson(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    object.put(key, (Object)BugbattleSdkModule.convertArrayToJson(readableMap.getArray(key)));
                }
            }
        }
        return object;
    }

    private static JSONArray convertArrayToJson(ReadableArray readableArray) throws JSONException {
        JSONArray array = new JSONArray();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    continue block8;
                }
                case Boolean: {
                    array.put(readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    array.put(readableArray.getDouble(i));
                    continue block8;
                }
                case String: {
                    array.put((Object)readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    array.put((Object)BugbattleSdkModule.convertMapToJson(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    array.put((Object)BugbattleSdkModule.convertArrayToJson(readableArray.getArray(i)));
                }
            }
        }
        return array;
    }
}

