/*
 * Decompiled with CFR 0.152.
 */
package com.contoriel.cafebazaar;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.contoriel.cafebazaar.util.IabHelper;
import com.contoriel.cafebazaar.util.IabResult;
import com.contoriel.cafebazaar.util.Inventory;
import com.contoriel.cafebazaar.util.Purchase;
import com.facebook.react.bridge.ActivityEventListener;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.google.gson.Gson;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class CafeBazaar
extends ReactContextBaseJavaModule
implements ActivityEventListener {
    private final ReactApplicationContext _reactContext;
    private String LICENSE_KEY = null;
    private IabHelper mHelper;
    private final Gson gson = new Gson();
    private static final String E_SETUP_ERROR = "E_SETUP_ERROR";
    private static final String E_SETUP_DISCONNECT = "E_SETUP_DISCONNECT";
    private static final String E_LOAD_ITEMS_FAILURE = "E_LOAD_ITEMS_FAILURE";
    private static final String E_LAYOUT_ERROR = "E_LAYOUT_ERROR";
    private static final String E_PURCHASE_DISCONNECT = "E_PURCHASE_DISCONNECT";
    private static final String E_PURCHASE_FAILURE = "E_PURCHASE_FAILURE";
    private static final String E_PURCHASE_PAYLOAD_VERIFY = "E_PURCHASE_PAYLOAD_VERIFY";
    private static final String E_PURCHASE_ERROR = "E_PURCHASE_ERROR";
    private static final String E_CONSUME_FAILURE = "E_CONSUME_FAILURE";
    private static final String E_CONSUME_ERROR = "E_CONSUME_ERROR";
    private static final String E_CONSUME_INITIAL = "E_CONSUME_INITIAL";
    static final String TAG = "CafeBazaar";
    private Inventory userInvo;

    public CafeBazaar(ReactApplicationContext reactContext, String licenseKey) {
        super(reactContext);
        this._reactContext = reactContext;
        this.LICENSE_KEY = licenseKey;
        reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    public CafeBazaar(ReactApplicationContext reactContext) {
        super(reactContext);
        this._reactContext = reactContext;
        int keyResourceId = this._reactContext.getResources().getIdentifier("CAFE_BAZAAR_PUBLIC_KEY", "string", this._reactContext.getPackageName());
        this.LICENSE_KEY = this._reactContext.getString(keyResourceId);
        reactContext.addActivityEventListener((ActivityEventListener)this);
    }

    public String getName() {
        return TAG;
    }

    @ReactMethod
    public void open(final Promise promise) {
        this.mHelper = new IabHelper((Context)this._reactContext, this.LICENSE_KEY);
        this.mHelper.enableDebugLogging(false);
        this.mHelper.startSetup(new IabHelper.OnIabSetupFinishedListener(){

            @Override
            public void onIabSetupFinished(IabResult result) {
                if (result.isSuccess()) {
                    promise.resolve((Object)CafeBazaar.this.gson.toJson((Object)result));
                } else if (CafeBazaar.this.mHelper == null) {
                    promise.reject(CafeBazaar.E_SETUP_DISCONNECT, "there no connection to cafe bazaar!");
                } else {
                    promise.reject(CafeBazaar.E_SETUP_ERROR, "There is a problem in cafe bazaar setup");
                }
            }
        });
    }

    @ReactMethod
    public void loadInventory(ReadableArray skuList, final Promise promise) {
        ArrayList<String> skus = new ArrayList<String>();
        for (int i = 0; i < skuList.size(); ++i) {
            skus.add(skuList.getString(i));
        }
        this.mHelper.queryInventoryAsync(true, skus, new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inventory) {
                if (CafeBazaar.this.mHelper == null) {
                    promise.reject(CafeBazaar.E_SETUP_DISCONNECT, "there no connection to cafe bazaar!");
                }
                if (result.isFailure()) {
                    promise.reject(CafeBazaar.E_LAYOUT_ERROR, "Failed to query inventory: " + result.getMessage());
                }
                promise.resolve((Object)CafeBazaar.this.gson.toJson((Object)inventory));
            }
        });
    }

    @ReactMethod
    public void loadOwnedItems(final Promise promise) {
        this.mHelper.queryInventoryAsync(new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inventory) {
                WritableMap params = Arguments.createMap();
                if (CafeBazaar.this.mHelper == null) {
                    promise.reject(CafeBazaar.E_SETUP_DISCONNECT, "there no connection to cafe bazaar!");
                }
                if (result.isFailure()) {
                    promise.reject(CafeBazaar.E_LOAD_ITEMS_FAILURE, result.getMessage());
                }
                CafeBazaar.this.userInvo = inventory;
                promise.resolve((Object)CafeBazaar.this.gson.toJson(inventory.getAllOwnedSkus()));
            }
        });
    }

    public void loadOwnedItemsWithEvent() {
        this.mHelper.queryInventoryAsync(new IabHelper.QueryInventoryFinishedListener(){

            @Override
            public void onQueryInventoryFinished(IabResult result, Inventory inventory) {
                WritableMap params = Arguments.createMap();
                if (CafeBazaar.this.mHelper == null) {
                    params.putString("LoadOwnedItem", "Disposed!");
                    CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                }
                if (result.isFailure()) {
                    params.putString("LoadOwnedItem", result.getMessage());
                    CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                }
                CafeBazaar.this.userInvo = inventory;
                params.putString("LoadOwnedItem", CafeBazaar.this.gson.toJson(inventory.getAllOwnedSkus()));
                CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
            }
        });
    }

    @ReactMethod
    public void purchaseWithEvent(String sku, String payload, int rcRequest) {
        try {
            this.mHelper.launchPurchaseFlow(this.getCurrentActivity(), sku, rcRequest, new IabHelper.OnIabPurchaseFinishedListener(){

                @Override
                public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
                    WritableMap params = Arguments.createMap();
                    if (CafeBazaar.this.mHelper == null) {
                        params.putString("PurchaseResult", "Connection Error!");
                        CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                    } else if (result.isFailure()) {
                        params.putString("Error", result.getMessage());
                        CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                    } else if (!CafeBazaar.this.verifyDeveloperPayload(purchase)) {
                        params.putString("Error", "could not verify developer payload");
                        CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                    } else {
                        params.putString("Details", CafeBazaar.this.gson.toJson((Object)purchase));
                        CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                    }
                }
            }, payload);
        }
        catch (Exception ex) {
            WritableMap params = Arguments.createMap();
            params.putString("Error", ex.getMessage());
            this.sendEvent(TAG, params);
        }
    }

    @ReactMethod
    public void purchase(String sku, String payload, int rcRequest, final Promise promise) {
        try {
            this.mHelper.launchPurchaseFlow(this.getCurrentActivity(), sku, rcRequest, new IabHelper.OnIabPurchaseFinishedListener(){

                @Override
                public void onIabPurchaseFinished(IabResult result, Purchase purchase) {
                    WritableMap params = Arguments.createMap();
                    if (CafeBazaar.this.mHelper == null) {
                        promise.reject(CafeBazaar.E_PURCHASE_DISCONNECT, "Connection Error!");
                    } else if (result.isFailure()) {
                        promise.reject(CafeBazaar.E_PURCHASE_FAILURE, result.getMessage());
                    } else if (!CafeBazaar.this.verifyDeveloperPayload(purchase)) {
                        promise.reject(CafeBazaar.E_PURCHASE_PAYLOAD_VERIFY, "could not verify developer payload");
                    } else {
                        promise.resolve((Object)CafeBazaar.this.gson.toJson((Object)purchase));
                    }
                }
            }, payload);
        }
        catch (Exception ex) {
            promise.reject(E_PURCHASE_ERROR, ex.getMessage());
        }
    }

    boolean verifyDeveloperPayload(Purchase p) {
        String payload = p.getDeveloperPayload();
        return true;
    }

    private void sendEvent(String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this._reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    @ReactMethod
    public void consume(String sku, final Promise promise) {
        if (this.userInvo != null) {
            if (this.userInvo.hasPurchase(sku)) {
                this.mHelper.consumeAsync(this.userInvo.getPurchase(sku), new IabHelper.OnConsumeFinishedListener(){

                    @Override
                    public void onConsumeFinished(Purchase purchase, IabResult result) {
                        WritableMap params = Arguments.createMap();
                        if (result.isSuccess()) {
                            promise.resolve((Object)CafeBazaar.this.gson.toJson((Object)purchase));
                        } else {
                            promise.reject(CafeBazaar.E_CONSUME_FAILURE, result.getMessage());
                        }
                    }
                });
            } else {
                promise.reject(E_CONSUME_ERROR, "user did not purchase item");
            }
        } else {
            promise.reject(E_CONSUME_INITIAL, "inventory not loaded!");
        }
    }

    @ReactMethod
    public void consumeWithEvent(String sku) {
        if (this.userInvo != null) {
            if (this.userInvo.hasPurchase(sku)) {
                this.mHelper.consumeAsync(this.userInvo.getPurchase(sku), new IabHelper.OnConsumeFinishedListener(){

                    @Override
                    public void onConsumeFinished(Purchase purchase, IabResult result) {
                        WritableMap params = Arguments.createMap();
                        if (result.isSuccess()) {
                            params.putString("SuccessfulConsume", CafeBazaar.this.gson.toJson((Object)purchase));
                            CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                        } else {
                            params.putString("Error", result.getMessage());
                            CafeBazaar.this.sendEvent(CafeBazaar.TAG, params);
                        }
                    }
                });
            } else {
                WritableMap params = Arguments.createMap();
                params.putString("Error", "user did not purchase item");
                this.sendEvent(TAG, params);
            }
        } else {
            WritableMap params = Arguments.createMap();
            params.putString("Error", "inventory not loaded!");
            this.sendEvent(TAG, params);
        }
    }

    @Deprecated
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (this.mHelper == null) {
            return;
        }
        if (!this.mHelper.handleActivityResult(requestCode, resultCode, intent)) {
            WritableMap params = Arguments.createMap();
            params.putString("Warning", "you need to use your activity to perfom billing");
            this.sendEvent(TAG, params);
        }
    }

    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent intent) {
        if (this.mHelper == null) {
            return;
        }
        if (!this.mHelper.handleActivityResult(requestCode, resultCode, intent)) {
            WritableMap params = Arguments.createMap();
            params.putString("Warning", "you need to use your activity to perfom billing");
            this.sendEvent(TAG, params);
        }
    }

    public void onNewIntent(Intent intent) {
    }

    @ReactMethod
    public void close(Promise promise) {
        if (this.mHelper != null) {
            this.mHelper.dispose();
            this.mHelper = null;
        }
        promise.resolve((Object)true);
    }
}

