/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.Systrace;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.core.HeadlessJsTaskSupportModule;
import com.facebook.react.modules.core.JSTimersExecution;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.facebook.react.modules.core.Timing;
import com.facebook.react.modules.debug.AnimationsDebugModule;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import com.facebook.react.uimanager.UIImplementationProvider;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;

class CoreModulesPackage
extends LazyReactPackage
implements ReactPackageLogger {
    private final ReactInstanceManager mReactInstanceManager;
    private final DefaultHardwareBackBtnHandler mHardwareBackBtnHandler;
    private final UIImplementationProvider mUIImplementationProvider;
    private final boolean mLazyViewManagersEnabled;

    CoreModulesPackage(ReactInstanceManager reactInstanceManager, DefaultHardwareBackBtnHandler hardwareBackBtnHandler, UIImplementationProvider uiImplementationProvider, boolean lazyViewManagersEnabled) {
        this.mReactInstanceManager = reactInstanceManager;
        this.mHardwareBackBtnHandler = hardwareBackBtnHandler;
        this.mUIImplementationProvider = uiImplementationProvider;
        this.mLazyViewManagersEnabled = lazyViewManagersEnabled;
    }

    @Override
    public List<ModuleSpec> getNativeModules(final ReactApplicationContext reactContext) {
        ArrayList<ModuleSpec> moduleSpecList = new ArrayList<ModuleSpec>();
        moduleSpecList.add(new ModuleSpec(AndroidInfoModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new AndroidInfoModule();
            }
        }));
        moduleSpecList.add(new ModuleSpec(AnimationsDebugModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new AnimationsDebugModule(reactContext, CoreModulesPackage.this.mReactInstanceManager.getDevSupportManager().getDevSettings());
            }
        }));
        moduleSpecList.add(new ModuleSpec(DeviceEventManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new DeviceEventManagerModule(reactContext, CoreModulesPackage.this.mHardwareBackBtnHandler);
            }
        }));
        moduleSpecList.add(new ModuleSpec(ExceptionsManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new ExceptionsManagerModule(CoreModulesPackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }));
        moduleSpecList.add(new ModuleSpec(HeadlessJsTaskSupportModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new HeadlessJsTaskSupportModule(reactContext);
            }
        }));
        moduleSpecList.add(new ModuleSpec(SourceCodeModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new SourceCodeModule(reactContext);
            }
        }));
        moduleSpecList.add(new ModuleSpec(Timing.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return new Timing(reactContext, CoreModulesPackage.this.mReactInstanceManager.getDevSupportManager());
            }
        }));
        moduleSpecList.add(new ModuleSpec(UIManagerModule.class, (Provider<? extends NativeModule>)new Provider<NativeModule>(){

            public NativeModule get() {
                return CoreModulesPackage.this.createUIManager(reactContext);
            }
        }));
        return moduleSpecList;
    }

    @Override
    public List<Class<? extends JavaScriptModule>> createJSModules() {
        ArrayList<Class<? extends JavaScriptModule>> jsModules = new ArrayList<Class<? extends JavaScriptModule>>(Arrays.asList(DeviceEventManagerModule.RCTDeviceEventEmitter.class, JSTimersExecution.class, RCTEventEmitter.class, RCTNativeAppEventEmitter.class, AppRegistry.class, Systrace.class, HMRClient.class));
        return jsModules;
    }

    @Override
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        ReactMarker.logMarker("CORE_REACT_PACKAGE_GET_REACT_MODULE_INFO_PROVIDER_START");
        ReactModuleInfoProvider reactModuleInfoProvider = LazyReactPackage.getReactModuleInfoProviderViaReflection(this);
        ReactMarker.logMarker("CORE_REACT_PACKAGE_GET_REACT_MODULE_INFO_PROVIDER_END");
        return reactModuleInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker("CREATE_UI_MANAGER_MODULE_START");
        com.facebook.systrace.Systrace.beginSection(0L, "createUIManagerModule");
        try {
            List<ViewManager> viewManagersList = this.mReactInstanceManager.createAllViewManagers(reactContext);
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, viewManagersList, this.mUIImplementationProvider, this.mLazyViewManagersEnabled);
            return uIManagerModule;
        }
        finally {
            com.facebook.systrace.Systrace.endSection(0L);
            ReactMarker.logMarker("CREATE_UI_MANAGER_MODULE_END");
        }
    }

    @Override
    public void startProcessPackage() {
        ReactMarker.logMarker("PROCESS_CORE_REACT_PACKAGE_START");
    }

    @Override
    public void endProcessPackage() {
        ReactMarker.logMarker("PROCESS_CORE_REACT_PACKAGE_END");
    }
}

