/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.common.logging.FLog;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.cxxbridge.ModuleHolder;
import com.facebook.react.cxxbridge.NativeModuleRegistry;
import com.facebook.react.module.model.ReactModuleInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeModuleRegistryBuilder {
    private final ReactApplicationContext mReactApplicationContext;
    private final boolean mLazyNativeModulesEnabled;
    private final Map<Class<? extends NativeModule>, ModuleHolder> mModules = new HashMap<Class<? extends NativeModule>, ModuleHolder>();
    private final Map<String, Class<? extends NativeModule>> namesToType = new HashMap<String, Class<? extends NativeModule>>();

    public NativeModuleRegistryBuilder(ReactApplicationContext reactApplicationContext, boolean lazyNativeModulesEnabled) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mLazyNativeModulesEnabled = lazyNativeModulesEnabled;
    }

    public void processPackage(ReactPackage reactPackage) {
        if (this.mLazyNativeModulesEnabled) {
            if (!(reactPackage instanceof LazyReactPackage)) {
                throw new IllegalStateException("Lazy native modules requires all ReactPackage to inherit from LazyReactPackage");
            }
            LazyReactPackage lazyReactPackage = (LazyReactPackage)reactPackage;
            List<ModuleSpec> moduleSpecs = lazyReactPackage.getNativeModules(this.mReactApplicationContext);
            Map<Class, ReactModuleInfo> reactModuleInfoMap = lazyReactPackage.getReactModuleInfoProvider().getReactModuleInfos();
            for (ModuleSpec moduleSpec : moduleSpecs) {
                ModuleHolder moduleHolder;
                Class<? extends NativeModule> type = moduleSpec.getType();
                ReactModuleInfo reactModuleInfo = reactModuleInfoMap.get(type);
                if (reactModuleInfo == null) {
                    if (BaseJavaModule.class.isAssignableFrom(type)) {
                        throw new IllegalStateException("Native Java module " + type.getSimpleName() + " should be annotated with @ReactModule and added to a @ReactModuleList.");
                    }
                    ReactMarker.logMarker("CREATE_MODULE_START", moduleSpec.getType().getSimpleName());
                    NativeModule module = (NativeModule)moduleSpec.getProvider().get();
                    ReactMarker.logMarker("CREATE_MODULE_END");
                    moduleHolder = new ModuleHolder(module);
                } else {
                    moduleHolder = new ModuleHolder(reactModuleInfo.name(), reactModuleInfo.canOverrideExistingModule(), reactModuleInfo.supportsWebWorkers(), reactModuleInfo.needsEagerInit(), moduleSpec.getProvider());
                }
                String name = moduleHolder.getName();
                if (this.namesToType.containsKey(name)) {
                    Class<? extends NativeModule> existingNativeModule = this.namesToType.get(name);
                    if (!moduleHolder.getCanOverrideExistingModule()) {
                        throw new IllegalStateException("Native module " + type.getSimpleName() + " tried to override " + existingNativeModule.getSimpleName() + " for module name " + name + ". If this was your intention, set canOverrideExistingModule=true");
                    }
                    this.mModules.remove(existingNativeModule);
                }
                this.namesToType.put(name, type);
                this.mModules.put(type, moduleHolder);
            }
        } else {
            FLog.d((String)"React", (String)(reactPackage.getClass().getSimpleName() + " is not a LazyReactPackage, falling back to old version."));
            for (NativeModule nativeModule : reactPackage.createNativeModules(this.mReactApplicationContext)) {
                this.addNativeModule(nativeModule);
            }
        }
    }

    public void addNativeModule(NativeModule nativeModule) {
        String name = nativeModule.getName();
        Class<?> type = nativeModule.getClass();
        if (this.namesToType.containsKey(name)) {
            Class<? extends NativeModule> existingModule = this.namesToType.get(name);
            if (!nativeModule.canOverrideExistingModule()) {
                throw new IllegalStateException("Native module " + type.getSimpleName() + " tried to override " + existingModule.getSimpleName() + " for module name " + name + ". If this was your intention, set canOverrideExistingModule=true");
            }
            this.mModules.remove(existingModule);
        }
        this.namesToType.put(name, type);
        ModuleHolder moduleHolder = new ModuleHolder(nativeModule);
        this.mModules.put(type, moduleHolder);
    }

    public NativeModuleRegistry build() {
        ArrayList<ModuleHolder> batchCompleteListenerModules = new ArrayList<ModuleHolder>();
        for (Map.Entry<Class<? extends NativeModule>, ModuleHolder> entry : this.mModules.entrySet()) {
            if (!OnBatchCompleteListener.class.isAssignableFrom(entry.getKey())) continue;
            batchCompleteListenerModules.add(entry.getValue());
        }
        return new NativeModuleRegistry(this.mModules, batchCompleteListenerModules);
    }
}

