/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleLogger;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.cxxbridge.Arguments;
import com.facebook.react.cxxbridge.ModuleHolder;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class JavaModuleWrapper {
    private final CatalystInstance mCatalystInstance;
    private final ModuleHolder mModuleHolder;
    private final ArrayList<NativeModule.NativeMethod> mMethods;

    public JavaModuleWrapper(CatalystInstance catalystinstance, ModuleHolder moduleHolder) {
        this.mCatalystInstance = catalystinstance;
        this.mModuleHolder = moduleHolder;
        this.mMethods = new ArrayList();
    }

    @DoNotStrip
    public BaseJavaModule getModule() {
        return (BaseJavaModule)this.mModuleHolder.getModule();
    }

    @DoNotStrip
    public String getName() {
        return this.mModuleHolder.getName();
    }

    @DoNotStrip
    public List<MethodDescriptor> getMethodDescriptors() {
        ArrayList<MethodDescriptor> descs = new ArrayList<MethodDescriptor>();
        for (Map.Entry<String, NativeModule.NativeMethod> entry : this.getModule().getMethods().entrySet()) {
            MethodDescriptor md = new MethodDescriptor();
            md.name = entry.getKey();
            md.type = entry.getValue().getType();
            BaseJavaModule.JavaMethod method = (BaseJavaModule.JavaMethod)entry.getValue();
            if (md.type == "sync") {
                md.signature = method.getSignature();
                md.method = method.getMethod();
            }
            this.mMethods.add(method);
            descs.add(md);
        }
        return descs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public NativeArray getConstants() {
        WritableNativeMap writableNativeMap;
        BaseJavaModule baseJavaModule = this.getModule();
        ReactMarker.logMarker("GET_CONSTANTS_START", this.getName());
        SystraceMessage.beginSection(0L, "Map constants").arg("moduleName", this.getName()).flush();
        Map<String, Object> map = baseJavaModule.getConstants();
        Systrace.endSection(0L);
        SystraceMessage.beginSection(0L, "WritableNativeMap constants").arg("moduleName", this.getName()).flush();
        if (baseJavaModule instanceof NativeModuleLogger) {
            ((NativeModuleLogger)((Object)baseJavaModule)).startConstantsMapConversion();
        }
        try {
            writableNativeMap = Arguments.makeNativeMap(map);
        }
        finally {
            Systrace.endSection(0L);
        }
        WritableNativeArray array = new WritableNativeArray();
        array.pushMap(writableNativeMap);
        if (baseJavaModule instanceof NativeModuleLogger) {
            ((NativeModuleLogger)((Object)baseJavaModule)).endConstantsMapConversion();
        }
        ReactMarker.logMarker("GET_CONSTANTS_END");
        return array;
    }

    @DoNotStrip
    public boolean supportsWebWorkers() {
        return this.getModule().supportsWebWorkers();
    }

    @DoNotStrip
    public void invoke(ExecutorToken token, int methodId, ReadableNativeArray parameters) {
        if (this.mMethods == null || methodId >= this.mMethods.size()) {
            return;
        }
        this.mMethods.get(methodId).invoke(this.mCatalystInstance, token, parameters);
    }

    @DoNotStrip
    public class MethodDescriptor {
        @DoNotStrip
        Method method;
        @DoNotStrip
        String signature;
        @DoNotStrip
        String name;
        @DoNotStrip
        String type;
    }
}

