/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.util.Log;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.packagerconnection.JSPackagerClient;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class JSCHeapUpload {
    public static JSCHeapCapture.CaptureCallback captureCallback(final String uploadUrl, final @Nullable JSPackagerClient.Responder responder) {
        return new JSCHeapCapture.CaptureCallback(){

            @Override
            public void onSuccess(File capture) {
                OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
                httpClientBuilder.connectTimeout(1L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES);
                OkHttpClient httpClient = httpClientBuilder.build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (File)capture);
                Request request = new Request.Builder().url(uploadUrl).method("POST", body).build();
                Call call = httpClient.newCall(request);
                call.enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        String message = "Upload of heap capture failed: " + e.toString();
                        Log.e((String)"JSCHeapCapture", (String)message);
                        responder.error(message);
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (!response.isSuccessful()) {
                            String message = "Upload of heap capture failed with code " + Integer.toString(response.code()) + ": " + response.body().string();
                            Log.e((String)"JSCHeapCapture", (String)message);
                            responder.error(message);
                        }
                        responder.respond(response.body().string());
                    }
                });
            }

            @Override
            public void onFailure(JSCHeapCapture.CaptureException e) {
                String message = "Heap capture failed: " + e.toString();
                Log.e((String)"JSCHeapCapture", (String)message);
                responder.error(message);
            }
        };
    }
}

