/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ResourceDrawableIdHelper {
    private Map<String, Integer> mResourceDrawableIdMap = new HashMap<String, Integer>();
    private static final String LOCAL_RESOURCE_SCHEME = "res";
    private static ResourceDrawableIdHelper sResourceDrawableIdHelper;

    private ResourceDrawableIdHelper() {
    }

    public static ResourceDrawableIdHelper getInstance() {
        if (sResourceDrawableIdHelper == null) {
            sResourceDrawableIdHelper = new ResourceDrawableIdHelper();
        }
        return sResourceDrawableIdHelper;
    }

    public void clear() {
        this.mResourceDrawableIdMap.clear();
    }

    public int getResourceDrawableId(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return 0;
        }
        if (this.mResourceDrawableIdMap.containsKey(name = name.toLowerCase().replace("-", "_"))) {
            return this.mResourceDrawableIdMap.get(name);
        }
        int id2 = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        this.mResourceDrawableIdMap.put(name, id2);
        return id2;
    }

    @Nullable
    public Drawable getResourceDrawable(Context context, @Nullable String name) {
        int resId = this.getResourceDrawableId(context, name);
        return resId > 0 ? context.getResources().getDrawable(resId) : null;
    }

    public Uri getResourceDrawableUri(Context context, @Nullable String name) {
        int resId = this.getResourceDrawableId(context, name);
        return resId > 0 ? new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resId)).build() : Uri.EMPTY;
    }
}

