/*
 * Decompiled with CFR 0.152.
 */
package com.pritesh.calldetection;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.pritesh.calldetection.CallDetectionPhoneStateListener;
import com.pritesh.calldetection.CallStateUpdateActionModule;
import java.util.HashMap;
import java.util.Map;

public class CallDetectionManagerModule
extends ReactContextBaseJavaModule
implements Application.ActivityLifecycleCallbacks,
CallDetectionPhoneStateListener.PhoneCallStateUpdate {
    private boolean wasAppInOffHook = false;
    private ReactApplicationContext reactContext;
    private TelephonyManager telephonyManager;
    private CallStateUpdateActionModule jsModule = null;
    private CallDetectionPhoneStateListener callDetectionPhoneStateListener;

    public CallDetectionManagerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "CallDetectionManagerAndroid";
    }

    @ReactMethod
    public void startListener() {
        this.telephonyManager = (TelephonyManager)this.reactContext.getSystemService("phone");
        this.callDetectionPhoneStateListener = new CallDetectionPhoneStateListener(this);
        this.telephonyManager.listen((PhoneStateListener)this.callDetectionPhoneStateListener, 32);
    }

    @ReactMethod
    public void stopListener() {
        this.telephonyManager.listen((PhoneStateListener)this.callDetectionPhoneStateListener, 0);
        this.telephonyManager = null;
        this.callDetectionPhoneStateListener = null;
    }

    @Nullable
    public Map<String, Object> getConstants() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Incoming", "Incoming");
        map.put("Offhook", "Offhook");
        map.put("Disconnected", "Disconnected");
        return map;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceType) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        if (this.wasAppInOffHook && this.jsModule != null) {
            this.wasAppInOffHook = false;
            this.jsModule.callStateUpdated("Disconnected", null);
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    @Override
    public void phoneCallStateUpdated(int state, String phoneNumber) {
        this.jsModule = (CallStateUpdateActionModule)this.reactContext.getJSModule(CallStateUpdateActionModule.class);
        switch (state) {
            case 0: {
                break;
            }
            case 2: {
                this.wasAppInOffHook = true;
                this.jsModule.callStateUpdated("Offhook", null);
                break;
            }
            case 1: {
                this.jsModule.callStateUpdated("Incoming", phoneNumber);
            }
        }
    }
}

