/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animation;

import android.view.View;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animation.AnimationListener;
import com.facebook.react.animation.AnimationPropertyUpdater;
import javax.annotation.Nullable;

public abstract class Animation {
    private final int mAnimationID;
    private final AnimationPropertyUpdater mPropertyUpdater;
    private volatile boolean mCancelled = false;
    private volatile boolean mIsFinished = false;
    @Nullable
    private AnimationListener mAnimationListener;
    @Nullable
    private View mAnimatedView;

    public Animation(int animationID, AnimationPropertyUpdater propertyUpdater) {
        this.mAnimationID = animationID;
        this.mPropertyUpdater = propertyUpdater;
    }

    public void setAnimationListener(AnimationListener animationListener) {
        this.mAnimationListener = animationListener;
    }

    public final void start(View view) {
        this.mAnimatedView = view;
        this.mPropertyUpdater.prepare(view);
        this.run();
    }

    public abstract void run();

    protected final boolean onUpdate(float value) {
        Assertions.assertCondition((!this.mIsFinished ? 1 : 0) != 0, (String)"Animation must not already be finished!");
        if (!this.mCancelled) {
            this.mPropertyUpdater.onUpdate((View)Assertions.assertNotNull((Object)this.mAnimatedView), value);
        }
        return !this.mCancelled;
    }

    protected final void finish() {
        Assertions.assertCondition((!this.mIsFinished ? 1 : 0) != 0, (String)"Animation must not already be finished!");
        this.mIsFinished = true;
        if (!this.mCancelled) {
            if (this.mAnimatedView != null) {
                this.mPropertyUpdater.onFinish(this.mAnimatedView);
            }
            if (this.mAnimationListener != null) {
                this.mAnimationListener.onFinished();
            }
        }
    }

    public final void cancel() {
        if (this.mIsFinished || this.mCancelled) {
            return;
        }
        this.mCancelled = true;
        if (this.mAnimationListener != null) {
            this.mAnimationListener.onCancel();
        }
    }

    public int getAnimationID() {
        return this.mAnimationID;
    }
}

