/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;
import javax.inject.Provider;

public class ModuleSpec {
    private static final Class[] EMPTY_SIGNATURE = new Class[0];
    private static final Class[] CONTEXT_SIGNATURE = new Class[]{ReactApplicationContext.class};
    private final Class<? extends NativeModule> mType;
    private final Provider<? extends NativeModule> mProvider;

    public static ModuleSpec simple(final Class<? extends NativeModule> type) {
        return new ModuleSpec(type, new ConstructorProvider(type, EMPTY_SIGNATURE){

            public NativeModule get() {
                try {
                    return this.getConstructor(type, EMPTY_SIGNATURE).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("ModuleSpec with class: " + type.getName(), e);
                }
            }
        });
    }

    public static ModuleSpec simple(final Class<? extends NativeModule> type, final ReactApplicationContext context) {
        return new ModuleSpec(type, new ConstructorProvider(type, CONTEXT_SIGNATURE){

            public NativeModule get() {
                try {
                    return this.getConstructor(type, CONTEXT_SIGNATURE).newInstance(new Object[]{context});
                }
                catch (Exception e) {
                    throw new RuntimeException("ModuleSpec with class: " + type.getName(), e);
                }
            }
        });
    }

    public ModuleSpec(Class<? extends NativeModule> type, Provider<? extends NativeModule> provider) {
        this.mType = type;
        this.mProvider = provider;
    }

    public Class<? extends NativeModule> getType() {
        return this.mType;
    }

    public Provider<? extends NativeModule> getProvider() {
        return this.mProvider;
    }

    private static abstract class ConstructorProvider
    implements Provider<NativeModule> {
        @Nullable
        protected Constructor<? extends NativeModule> mConstructor;

        public ConstructorProvider(Class<? extends NativeModule> type, Class[] signature) {
        }

        protected Constructor<? extends NativeModule> getConstructor(Class<? extends NativeModule> mType, Class[] signature) throws NoSuchMethodException {
            if (this.mConstructor != null) {
                return this.mConstructor;
            }
            return mType.getConstructor(signature);
        }
    }
}

