/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Sink;

public class MultipartStreamReader {
    private static final String CRLF = "\r\n";
    private final BufferedSource mSource;
    private final String mBoundary;

    public MultipartStreamReader(BufferedSource source, String boundary) {
        this.mSource = source;
        this.mBoundary = boundary;
    }

    private Map<String, String> parseHeaders(Buffer data) {
        String[] lines;
        HashMap<String, String> headers = new HashMap<String, String>();
        String text = data.readUtf8();
        for (String line : lines = text.split(CRLF)) {
            int indexOfSeparator = line.indexOf(":");
            if (indexOfSeparator == -1) continue;
            String key = line.substring(0, indexOfSeparator).trim();
            String value = line.substring(indexOfSeparator + 1).trim();
            headers.put(key, value);
        }
        return headers;
    }

    private void emitChunk(Buffer chunk, boolean done, ChunkCallback callback) throws IOException {
        ByteString marker = ByteString.encodeUtf8((String)"\r\n\r\n");
        long indexOfMarker = chunk.indexOf(marker);
        if (indexOfMarker == -1L) {
            callback.execute(null, chunk, done);
        } else {
            Buffer headers = new Buffer();
            Buffer body = new Buffer();
            chunk.read(headers, indexOfMarker);
            chunk.skip((long)marker.size());
            chunk.readAll((Sink)body);
            callback.execute(this.parseHeaders(headers), body, done);
        }
    }

    public boolean readAllParts(ChunkCallback callback) throws IOException {
        ByteString delimiter = ByteString.encodeUtf8((String)("\r\n--" + this.mBoundary + CRLF));
        ByteString closeDelimiter = ByteString.encodeUtf8((String)("\r\n--" + this.mBoundary + "--" + CRLF));
        int bufferLen = 4096;
        long chunkStart = 0L;
        long bytesSeen = 0L;
        Buffer content = new Buffer();
        while (true) {
            boolean isCloseDelimiter = false;
            long searchStart = Math.max(bytesSeen - (long)closeDelimiter.size(), chunkStart);
            long indexOfDelimiter = content.indexOf(delimiter, searchStart);
            if (indexOfDelimiter == -1L) {
                isCloseDelimiter = true;
                indexOfDelimiter = content.indexOf(closeDelimiter, searchStart);
            }
            if (indexOfDelimiter == -1L) {
                bytesSeen = content.size();
                long bytesRead = this.mSource.read(content, (long)bufferLen);
                if (bytesRead > 0L) continue;
                return false;
            }
            long chunkEnd = indexOfDelimiter;
            long length = chunkEnd - chunkStart;
            if (chunkStart > 0L) {
                Buffer chunk = new Buffer();
                content.skip(chunkStart);
                content.read(chunk, length);
                this.emitChunk(chunk, isCloseDelimiter, callback);
            } else {
                content.skip(chunkEnd);
            }
            if (isCloseDelimiter) {
                return true;
            }
            bytesSeen = chunkStart = (long)delimiter.size();
        }
    }

    public static interface ChunkCallback {
        public void execute(Map<String, String> var1, Buffer var2, boolean var3) throws IOException;
    }
}

