/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.flat;

import android.util.SparseIntArray;
import com.facebook.react.flat.ClippingDrawCommandManager;
import com.facebook.react.flat.DrawCommand;
import com.facebook.react.flat.DrawView;
import com.facebook.react.flat.FlatViewGroup;
import com.facebook.react.flat.NodeRegion;
import java.util.Arrays;

final class HorizontalDrawCommandManager
extends ClippingDrawCommandManager {
    HorizontalDrawCommandManager(FlatViewGroup flatViewGroup, DrawCommand[] drawCommands) {
        super(flatViewGroup, drawCommands);
    }

    @Override
    int commandStartIndex() {
        int start = Arrays.binarySearch(this.mCommandMaxBottom, (float)this.mClippingRect.left);
        return start < 0 ? ~start : start;
    }

    @Override
    int commandStopIndex(int start) {
        int stop = Arrays.binarySearch(this.mCommandMinTop, start, this.mCommandMinTop.length, (float)this.mClippingRect.right);
        return stop < 0 ? ~stop : stop;
    }

    @Override
    int regionStopIndex(float touchX, float touchY) {
        int stop = Arrays.binarySearch(this.mRegionMinTop, touchX + 1.0E-4f);
        return stop < 0 ? ~stop : stop;
    }

    @Override
    boolean regionAboveTouch(int index, float touchX, float touchY) {
        return this.mRegionMaxBottom[index] < touchX;
    }

    public static void fillMaxMinArrays(NodeRegion[] regions, float[] maxRight, float[] minLeft) {
        int i;
        float last = 0.0f;
        for (i = 0; i < regions.length; ++i) {
            maxRight[i] = last = Math.max(last, regions[i].getTouchableRight());
        }
        for (i = regions.length - 1; i >= 0; --i) {
            minLeft[i] = last = Math.min(last, regions[i].getTouchableLeft());
        }
    }

    public static void fillMaxMinArrays(DrawCommand[] commands, float[] maxRight, float[] minLeft, SparseIntArray drawViewIndexMap) {
        int i;
        float last = 0.0f;
        for (i = 0; i < commands.length; ++i) {
            if (commands[i] instanceof DrawView) {
                DrawView drawView = (DrawView)commands[i];
                drawViewIndexMap.append(drawView.reactTag, i);
                last = Math.max(last, drawView.mLogicalRight);
            } else {
                last = Math.max(last, commands[i].getRight());
            }
            maxRight[i] = last;
        }
        for (i = commands.length - 1; i >= 0; --i) {
            last = commands[i] instanceof DrawView ? Math.min(last, ((DrawView)commands[i]).mLogicalLeft) : Math.min(last, commands[i].getLeft());
            minLeft[i] = last;
        }
    }
}

