/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.os.Build;
import android.view.View;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.AccessibilityHelper;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.MatrixMathHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.TransformHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.annotations.ReactProp;

public abstract class BaseViewManager<T extends View, C extends LayoutShadowNode>
extends ViewManager<T, C> {
    private static final String PROP_BACKGROUND_COLOR = "backgroundColor";
    private static final String PROP_TRANSFORM = "transform";
    private static final String PROP_OPACITY = "opacity";
    private static final String PROP_ELEVATION = "elevation";
    private static final String PROP_Z_INDEX = "zIndex";
    private static final String PROP_RENDER_TO_HARDWARE_TEXTURE = "renderToHardwareTextureAndroid";
    private static final String PROP_ACCESSIBILITY_LABEL = "accessibilityLabel";
    private static final String PROP_ACCESSIBILITY_COMPONENT_TYPE = "accessibilityComponentType";
    private static final String PROP_ACCESSIBILITY_LIVE_REGION = "accessibilityLiveRegion";
    private static final String PROP_IMPORTANT_FOR_ACCESSIBILITY = "importantForAccessibility";
    private static final String PROP_ROTATION = "rotation";
    private static final String PROP_SCALE_X = "scaleX";
    private static final String PROP_SCALE_Y = "scaleY";
    private static final String PROP_TRANSLATE_X = "translateX";
    private static final String PROP_TRANSLATE_Y = "translateY";
    private static final int PERSPECTIVE_ARRAY_INVERTED_CAMERA_DISTANCE_INDEX = 2;
    private static final float CAMERA_DISTANCE_NORMALIZATION_MULTIPLIER = 5.0f;
    public static final String PROP_TEST_ID = "testID";
    private static MatrixMathHelper.MatrixDecompositionContext sMatrixDecompositionContext = new MatrixMathHelper.MatrixDecompositionContext();
    private static double[] sTransformDecompositionArray = new double[16];

    @ReactProp(name="backgroundColor", defaultInt=0, customType="Color")
    public void setBackgroundColor(T view, int backgroundColor) {
        view.setBackgroundColor(backgroundColor);
    }

    @ReactProp(name="transform")
    public void setTransform(T view, ReadableArray matrix) {
        if (matrix == null) {
            BaseViewManager.resetTransformProperty(view);
        } else {
            BaseViewManager.setTransformProperty(view, matrix);
        }
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(T view, float opacity) {
        view.setAlpha(opacity);
    }

    @ReactProp(name="elevation")
    public void setElevation(T view, float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            view.setElevation(PixelUtil.toPixelFromDIP(elevation));
        }
    }

    @ReactProp(name="zIndex")
    public void setZIndex(T view, float zIndex) {
        int integerZIndex = Math.round(zIndex);
        ViewGroupManager.setViewZIndex(view, integerZIndex);
    }

    @ReactProp(name="renderToHardwareTextureAndroid")
    public void setRenderToHardwareTexture(T view, boolean useHWTexture) {
        view.setLayerType(useHWTexture ? 2 : 0, null);
    }

    @ReactProp(name="testID")
    public void setTestId(T view, String testId) {
        view.setTag((Object)testId);
    }

    @ReactProp(name="accessibilityLabel")
    public void setAccessibilityLabel(T view, String accessibilityLabel) {
        view.setContentDescription((CharSequence)accessibilityLabel);
    }

    @ReactProp(name="accessibilityComponentType")
    public void setAccessibilityComponentType(T view, String accessibilityComponentType) {
        AccessibilityHelper.updateAccessibilityComponentType(view, accessibilityComponentType);
    }

    @ReactProp(name="importantForAccessibility")
    public void setImportantForAccessibility(T view, String importantForAccessibility) {
        if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
            view.setImportantForAccessibility(0);
        } else if (importantForAccessibility.equals("yes")) {
            view.setImportantForAccessibility(1);
        } else if (importantForAccessibility.equals("no")) {
            view.setImportantForAccessibility(2);
        } else if (importantForAccessibility.equals("no-hide-descendants")) {
            view.setImportantForAccessibility(4);
        }
    }

    @Deprecated
    @ReactProp(name="rotation")
    public void setRotation(T view, float rotation) {
        view.setRotation(rotation);
    }

    @Deprecated
    @ReactProp(name="scaleX", defaultFloat=1.0f)
    public void setScaleX(T view, float scaleX) {
        view.setScaleX(scaleX);
    }

    @Deprecated
    @ReactProp(name="scaleY", defaultFloat=1.0f)
    public void setScaleY(T view, float scaleY) {
        view.setScaleY(scaleY);
    }

    @Deprecated
    @ReactProp(name="translateX", defaultFloat=0.0f)
    public void setTranslateX(T view, float translateX) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(translateX));
    }

    @Deprecated
    @ReactProp(name="translateY", defaultFloat=0.0f)
    public void setTranslateY(T view, float translateY) {
        view.setTranslationY(PixelUtil.toPixelFromDIP(translateY));
    }

    @ReactProp(name="accessibilityLiveRegion")
    public void setAccessibilityLiveRegion(T view, String liveRegion) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (liveRegion == null || liveRegion.equals("none")) {
                view.setAccessibilityLiveRegion(0);
            } else if (liveRegion.equals("polite")) {
                view.setAccessibilityLiveRegion(1);
            } else if (liveRegion.equals("assertive")) {
                view.setAccessibilityLiveRegion(2);
            }
        }
    }

    private static void setTransformProperty(View view, ReadableArray transforms) {
        float invertedCameraDistance;
        TransformHelper.processTransform(transforms, sTransformDecompositionArray);
        MatrixMathHelper.decomposeMatrix(sTransformDecompositionArray, sMatrixDecompositionContext);
        view.setTranslationX(PixelUtil.toPixelFromDIP((float)BaseViewManager.sMatrixDecompositionContext.translation[0]));
        view.setTranslationY(PixelUtil.toPixelFromDIP((float)BaseViewManager.sMatrixDecompositionContext.translation[1]));
        view.setRotation((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[2]);
        view.setRotationX((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[0]);
        view.setRotationY((float)BaseViewManager.sMatrixDecompositionContext.rotationDegrees[1]);
        view.setScaleX((float)BaseViewManager.sMatrixDecompositionContext.scale[0]);
        view.setScaleY((float)BaseViewManager.sMatrixDecompositionContext.scale[1]);
        double[] perspectiveArray = BaseViewManager.sMatrixDecompositionContext.perspective;
        if (perspectiveArray.length > 2 && (invertedCameraDistance = (float)perspectiveArray[2]) < 0.0f) {
            float cameraDistance = -1.0f / invertedCameraDistance;
            float scale = DisplayMetricsHolder.getScreenDisplayMetrics().density;
            float normalizedCameraDistance = scale * cameraDistance * 5.0f;
            view.setCameraDistance(normalizedCameraDistance);
        }
    }

    private static void resetTransformProperty(View view) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
        view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
        view.setRotation(0.0f);
        view.setRotationX(0.0f);
        view.setRotationY(0.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
        view.setCameraDistance(0.0f);
    }
}

