/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.cashchanger;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.cashchanger.CashChangerStatusInfo;
import com.epson.epos2.cashchanger.CashCountListener;
import com.epson.epos2.cashchanger.CollectListener;
import com.epson.epos2.cashchanger.CommandReplyListener;
import com.epson.epos2.cashchanger.ConfigChangeListener;
import com.epson.epos2.cashchanger.DepositListener;
import com.epson.epos2.cashchanger.DirectIOCommandReplyListener;
import com.epson.epos2.cashchanger.DirectIOListener;
import com.epson.epos2.cashchanger.DispenseListener;
import com.epson.epos2.cashchanger.StatusChangeListener;
import com.epson.epos2.cashchanger.StatusUpdateListener;
import com.epson.epos2.storage.ConnectionInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CashChanger {
    public static final int COUNT_MODE_MANUAL_INPUT = 0;
    public static final int COUNT_MODE_AUTO_COUNT = 1;
    public static final int DEPOSIT_CHANGE = 0;
    public static final int DEPOSIT_NOCHANGE = 1;
    public static final int DEPOSIT_REPAY = 2;
    public static final int COLLECT_ALL_CASH = 0;
    public static final int COLLECT_PART_OF_CASH = 1;
    public static final int STATUS_BUSY = 0;
    public static final int STATUS_PAUSE = 1;
    public static final int STATUS_END = 2;
    public static final int STATUS_ERR = 3;
    public static final int SUE_POWER_ONLINE = 2001;
    public static final int SUE_POWER_OFF = 2002;
    public static final int SUE_POWER_OFFLINE = 2003;
    public static final int SUE_POWER_OFF_OFFLINE = 2004;
    public static final int SUE_STATUS_EMPTY = 11;
    public static final int SUE_STATUS_NEAREMPTY = 12;
    public static final int SUE_STATUS_EMPTYOK = 13;
    public static final int SUE_STATUS_FULL = 21;
    public static final int SUE_STATUS_NEARFULL = 22;
    public static final int SUE_STATUS_FULLOK = 23;
    public static final int SUE_STATUS_JAM = 31;
    public static final int SUE_STATUS_JAMOK = 32;
    public static final int ST_EMPTY = 0;
    public static final int ST_NEAR_EMPTY = 1;
    public static final int ST_OK = 2;
    public static final int ST_NEAR_FULL = 3;
    public static final int ST_FULL = 4;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    private long mCashChangerHandle = 0L;
    private Context mContext = null;
    public static final int PARAM_DEFAULT = -2;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    private CashCountListener mCashCountListener = null;
    private DepositListener mDepositListener = null;
    private DispenseListener mDispenseListener = null;
    private DirectIOCommandReplyListener mDirectIOCommandReplyListener = null;
    private DirectIOListener mDirectIOListener = null;
    private StatusUpdateListener mStatusUpdateListener = null;
    private ConfigChangeListener mConfigChangeListener = null;
    private CollectListener mCollectListener = null;
    private CommandReplyListener mCommandReplyListener = null;
    private StatusChangeListener mStatusChangeListener = null;
    private ConnectionListener mConnectionListener = null;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static int connection;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native CashChangerStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2GetOposErrorCode(long var1);

    protected native int nativeEpos2ReadCashCount(long var1);

    protected native int nativeEpos2BeginDeposit(long var1);

    protected native int nativeEpos2PauseDeposit(long var1);

    protected native int nativeEpos2RestartDeposit(long var1);

    protected native int nativeEpos2EndDeposit(long var1, int var3);

    protected native int nativeEpos2DispenseChange(long var1, long var3);

    protected native int nativeEpos2DispenseCash(long var1, String[] var3, long[] var4, int var5);

    protected native int nativeEpos2SendDirectIOCommand(long var1, long var3, long var5, String var7);

    protected native int nativeEpos2SetConfigCountMode(long var1, int var3);

    protected native int nativeEpos2SetConfigLeftCash(long var1, long var3, long var5);

    protected native int nativeEpos2CollectCash(long var1, int var3);

    protected native int nativeEpos2OpenDrawer(long var1);

    protected native int nativeEpos2SendCommand(long var1, byte[] var3);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public CashChanger(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("CashChanger", context);
        ConnectionInfo.setStoragePath(context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("CashChanger", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeCashChangerInstance();
        this.outputLogEvent("CashChanger", context);
    }

    protected void initializeCashChangerInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mCashChangerHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mCashCountListener = null;
        this.mDepositListener = null;
        this.mDispenseListener = null;
        this.mDirectIOCommandReplyListener = null;
        this.mDirectIOListener = null;
        this.mStatusUpdateListener = null;
        this.mConfigChangeListener = null;
        this.mCollectListener = null;
        this.mCommandReplyListener = null;
        this.mStatusChangeListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mCashChangerHandle != 0L) {
                this.nativeEpos2Disconnect(this.mCashChangerHandle);
                this.nativeEpos2DestroyHandle(this.mCashChangerHandle);
                this.mCashChangerHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mCashChangerHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mCashChangerHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public CashChangerStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        CashChangerStatusInfo status = this.nativeEpos2GetStatus(this.mCashChangerHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public int getOposErrorCode() {
        this.outputLogCallFunction("getOposErrorCode", new Object[0]);
        if (this.mCashChangerHandle == 0L) {
            return 0;
        }
        int errStatus = this.nativeEpos2GetOposErrorCode(this.mCashChangerHandle);
        this.outputLogReturnFunction("getOposErrorCode", errStatus, new Object[0]);
        return errStatus;
    }

    public void readCashCount() throws Epos2Exception {
        this.outputLogCallFunction("readCashCount", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ReadCashCount(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("readCashCount", ex);
            this.outputLogReturnFunction("readCashCount", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("readCashCount", 0, new Object[0]);
    }

    public void beginDeposit() throws Epos2Exception {
        this.outputLogCallFunction("beginDeposit", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2BeginDeposit(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("beginDeposit", ex);
            this.outputLogReturnFunction("beginDeposit", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("beginDeposit", 0, new Object[0]);
    }

    public void pauseDeposit() throws Epos2Exception {
        this.outputLogCallFunction("pauseDeposit", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2PauseDeposit(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("pauseDeposit", ex);
            this.outputLogReturnFunction("pauseDeposit", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("pauseDeposit", 0, new Object[0]);
    }

    public void restartDeposit() throws Epos2Exception {
        this.outputLogCallFunction("restartDeposit", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2RestartDeposit(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("restartDeposit", ex);
            this.outputLogReturnFunction("restartDeposit", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("restartDeposit", 0, new Object[0]);
    }

    public void endDeposit(int config) throws Epos2Exception {
        this.outputLogCallFunction("endDeposit", config);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2EndDeposit(this.mCashChangerHandle, config);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("endDeposit", ex);
            this.outputLogReturnFunction("endDeposit", ex.getErrorStatus(), config);
            throw ex;
        }
        this.outputLogReturnFunction("endDeposit", 0, config);
    }

    public void dispenseChange(int cash) throws Epos2Exception {
        this.outputLogCallFunction("dispenseChange", cash);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2DispenseChange(this.mCashChangerHandle, cash);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("dispenseChange", ex);
            this.outputLogReturnFunction("dispenseChange", ex.getErrorStatus(), cash);
            throw ex;
        }
        this.outputLogReturnFunction("dispenseChange", 0, cash);
    }

    public void dispenseCash(Map<String, Integer> data) throws Epos2Exception {
        this.outputLogCallFunction("dispenseCash", data);
        try {
            this.checkHandle();
            if (data == null) {
                throw new Epos2Exception(1);
            }
            int dataSize = data.size();
            if (dataSize == 0) {
                throw new Epos2Exception(1);
            }
            String[] cashDataKey = new String[dataSize];
            long[] cashDataValue = new long[dataSize];
            int count = 0;
            for (Map.Entry<String, Integer> entry : data.entrySet()) {
                cashDataKey[count] = entry.getKey();
                cashDataValue[count] = entry.getValue().intValue();
                ++count;
            }
            int errStatus = this.nativeEpos2DispenseCash(this.mCashChangerHandle, cashDataKey, cashDataValue, dataSize);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("dispenseCash", ex);
            this.outputLogReturnFunction("dispenseCash", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("dispenseCash", 0, data);
    }

    public void sendDirectIOCommand(int command, int data, String string) throws Epos2Exception {
        this.outputLogCallFunction("sendDirectIOCommand", command, data, string);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendDirectIOCommand(this.mCashChangerHandle, command, data, string);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendDirectIOCommand", ex);
            this.outputLogReturnFunction("sendDirectIOCommand", ex.getErrorStatus(), command, data, string);
            throw ex;
        }
        this.outputLogReturnFunction("sendDirectIOCommand", 0, command, data, string);
    }

    public void setConfigCountMode(int countMode) throws Epos2Exception {
        this.outputLogCallFunction("setConfigCountMode", countMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SetConfigCountMode(this.mCashChangerHandle, countMode);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("setConfigCountMode", ex);
            this.outputLogReturnFunction("setConfigCountMode", ex.getErrorStatus(), countMode);
            throw ex;
        }
        this.outputLogReturnFunction("setConfigCountMode", 0, countMode);
    }

    public void setConfigLeftCash(int coins, int bills) throws Epos2Exception {
        this.outputLogCallFunction("setConfigLeftCash", coins, bills);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SetConfigLeftCash(this.mCashChangerHandle, coins, bills);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("setConfigLeftCash", ex);
            this.outputLogReturnFunction("setConfigLeftCash", ex.getErrorStatus(), coins, bills);
            throw ex;
        }
        this.outputLogReturnFunction("setConfigLeftCash", 0, coins, bills);
    }

    public void collectCash(int type) throws Epos2Exception {
        this.outputLogCallFunction("collectCash", type);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2CollectCash(this.mCashChangerHandle, type);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("collectCash", ex);
            this.outputLogReturnFunction("collectCash", ex.getErrorStatus(), type);
            throw ex;
        }
        this.outputLogReturnFunction("collectCash", 0, type);
    }

    public void openDrawer() throws Epos2Exception {
        this.outputLogCallFunction("openDrawer", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2OpenDrawer(this.mCashChangerHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("openDrawer", ex);
            this.outputLogReturnFunction("openDrawer", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("openDrawer", 0, new Object[0]);
    }

    public void sendCommand(byte[] data) throws Epos2Exception {
        this.outputLogCallFunction("sendCommand", new Object[]{data});
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendCommand(this.mCashChangerHandle, data);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendCommand", ex);
            this.outputLogReturnFunction("sendCommand", ex.getErrorStatus(), new Object[]{data});
            throw ex;
        }
        this.outputLogReturnFunction("sendCommand", 0, new Object[]{data});
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mCashChangerHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mCashChangerHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mCashChangerHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mCashChangerHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void setCashCountEventListener(CashCountListener listener) {
        this.outputLogCallFunction("setCashCountEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mCashCountListener = listener != null ? listener : null;
        }
    }

    public void setDepositEventListener(DepositListener listener) {
        this.outputLogCallFunction("setDepositEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mDepositListener = listener != null ? listener : null;
        }
    }

    public void setDispenseEventListener(DispenseListener listener) {
        this.outputLogCallFunction("setDispenseEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mDispenseListener = listener != null ? listener : null;
        }
    }

    public void setDirectIOCommandReplyEventListener(DirectIOCommandReplyListener listener) {
        this.outputLogCallFunction("setDirectIOCommandReplyEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mDirectIOCommandReplyListener = listener != null ? listener : null;
        }
    }

    public void setDirectIOEventListener(DirectIOListener listener) {
        this.outputLogCallFunction("setDirectIOEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mDirectIOListener = listener != null ? listener : null;
        }
    }

    public void setStatusUpdateEventListener(StatusUpdateListener listener) {
        this.outputLogCallFunction("setStatusUpdateEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mStatusUpdateListener = listener != null ? listener : null;
        }
    }

    public void setConfigChangeEventListener(ConfigChangeListener listener) {
        this.outputLogCallFunction("setConfigChangeEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mConfigChangeListener = listener != null ? listener : null;
        }
    }

    public void setCollectEventListener(CollectListener listener) {
        this.outputLogCallFunction("setCollectEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mCollectListener = listener != null ? listener : null;
        }
    }

    public void setCommandReplyEventListener(CommandReplyListener listener) {
        this.outputLogCallFunction("setCommandReplyEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mCommandReplyListener = listener != null ? listener : null;
        }
    }

    public void setStatusChangeEventListener(StatusChangeListener listener) {
        this.outputLogCallFunction("setStatusChangeEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mStatusChangeListener = listener != null ? listener : null;
        }
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mCashChangerHandle == 0L) {
            return;
        }
        if (this.mCashChangerHandle != 0L) {
            this.mConnectionListener = listener != null ? listener : null;
        }
    }

    private void onCChangerCashCount(int code, String[] key, int[] value, int dataSize) {
        this.outputLogCallFunction("onCChangerCashCount", code, key, value, dataSize, this);
        try {
            HashMap<String, Integer> data;
            if (dataSize == 0) {
                data = null;
            } else {
                data = new HashMap<String, Integer>();
                for (int i = 0; i < dataSize; ++i) {
                    data.put(key[i], value[i]);
                }
            }
            if (null != this.mCashCountListener) {
                this.mCashCountListener.onCChangerCashCount(this, code, data);
                this.outputLogEvent("onCChangerCashCount", "code->", code, "key->", key, "value->", value, "dataSize->", dataSize, this);
            }
            this.outputLogReturnFunction("onCChangerCashCount", 0, code, data, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCChangerDeposit(int code, int status, int amount, String[] key, int[] value, int dataSize) {
        this.outputLogCallFunction("onCChangerDeposit", code, status, amount, key, value, this);
        try {
            HashMap<String, Integer> data;
            if (dataSize == 0) {
                data = null;
            } else {
                data = new HashMap<String, Integer>();
                for (int i = 0; i < dataSize; ++i) {
                    data.put(key[i], value[i]);
                }
            }
            if (null != this.mDepositListener) {
                this.mDepositListener.onCChangerDeposit(this, code, status, amount, data);
                this.outputLogEvent("onCChangerDeposit", "code->", code, "status->", status, "amount->", amount, "key->", key, "value->", value, this);
            }
            this.outputLogReturnFunction("onCChangerDeposit", 0, code, status, amount, data, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCChangerDispense(int code) {
        this.outputLogCallFunction("onCChangerDispense", code, this);
        if (null != this.mDispenseListener) {
            this.mDispenseListener.onCChangerDispense(this, code);
            this.outputLogEvent("onCChangerDispense", "code->", code, this);
        }
        this.outputLogReturnFunction("onCChangerDispense", 0, code, this);
    }

    private void onCChangerDirectIOCommandReply(int code, int command, int data, String string) {
        this.outputLogCallFunction("onCChangerDirectIOCommandReply", code, command, data, string, this);
        if (null != this.mDirectIOCommandReplyListener) {
            this.mDirectIOCommandReplyListener.onCChangerDirectIOCommandReply(this, code, command, data, string);
            this.outputLogEvent("onCChangerDirectIOCommandReply", "code->", code, "command->", command, "data->", data, "string->", string, this);
        }
        this.outputLogReturnFunction("onCChangerDirectIOCommandReply", 0, code, command, data, string, this);
    }

    private void onCChangerDirectIO(int eventNumber, int data, String string) {
        this.outputLogCallFunction("onCChangerDirectIO", eventNumber, data, string, this);
        if (null != this.mDirectIOListener) {
            this.mDirectIOListener.onCChangerDirectIO(this, eventNumber, data, string);
            this.outputLogEvent("onCChangerDirectIO", "eventNumber->", eventNumber, "data->", data, "string->", string, this);
        }
        this.outputLogReturnFunction("onCChangerDirectIO", 0, eventNumber, data, string, this);
    }

    private void onCChangerStatusUpdate(int status) {
        this.outputLogCallFunction("onCChangerStatusUpdate", status, this);
        if (null != this.mStatusUpdateListener) {
            this.mStatusUpdateListener.onCChangerStatusUpdate(this, status);
            this.outputLogEvent("onCChangerStatusUpdate", "status->", status, this);
        }
        this.outputLogReturnFunction("onCChangerStatusUpdate", 0, status, this);
    }

    private void onCChangerConfigChange(int code) {
        this.outputLogCallFunction("onCChangerConfigChange", code, this);
        if (null != this.mConfigChangeListener) {
            this.mConfigChangeListener.onCChangerConfigChange(this, code);
            this.outputLogEvent("onCChangerConfigChange", "code->", code, this);
        }
        this.outputLogReturnFunction("onCChangerConfigChange", 0, code, this);
    }

    private void onCChangerCollect(int code) {
        this.outputLogCallFunction("onCChangerCollect", code, this);
        if (null != this.mCollectListener) {
            this.mCollectListener.onCChangerCollect(this, code);
            this.outputLogEvent("onCChangerCollect", "code->", code, this);
        }
        this.outputLogReturnFunction("onCChangerCollect", 0, code, this);
    }

    private void onCChangerCommandReply(int code, byte[] data) {
        this.outputLogCallFunction("onCChangerCommandReply", code, data, this);
        if (null != this.mCommandReplyListener) {
            this.mCommandReplyListener.onCChangerCommandReply(this, code, data);
            this.outputLogEvent("onCChangerCommandReply", "code->", code, "data->", data, this);
        }
        this.outputLogReturnFunction("onCChangerCommandReply", 0, code, data, this);
    }

    private void onCChangerStatusChange(int code, String[] key, int[] status, int statusSize) {
        this.outputLogCallFunction("onCChangerStatusChange", code, key, status, statusSize, this);
        try {
            HashMap<String, Integer> data;
            if (statusSize == 0) {
                data = null;
            } else {
                data = new HashMap<String, Integer>();
                for (int i = 0; i < statusSize; ++i) {
                    data.put(key[i], status[i]);
                }
            }
            if (null != this.mStatusChangeListener) {
                this.mStatusChangeListener.onCChangerStatusChange(this, code, data);
                this.outputLogEvent("onCChangerStatusChange", "code->", code, "key->", key, "status->", status, "statusSize->", statusSize, this);
            }
            this.outputLogReturnFunction("onCChangerStatusChange", 0, code, key, status, statusSize, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCashChangerHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCashChangerHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mCashChangerHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mCashChangerHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

