/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.cat;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.cat.AccessDailyLogListener;
import com.epson.epos2.cat.AuthorizeCompletionListener;
import com.epson.epos2.cat.AuthorizeRefundListener;
import com.epson.epos2.cat.AuthorizeResult;
import com.epson.epos2.cat.AuthorizeSalesListener;
import com.epson.epos2.cat.AuthorizeVoidListener;
import com.epson.epos2.cat.CashDepositListener;
import com.epson.epos2.cat.CashDepositResult;
import com.epson.epos2.cat.CatStatusInfo;
import com.epson.epos2.cat.CheckConnectionListener;
import com.epson.epos2.cat.ClearOutputListener;
import com.epson.epos2.cat.DailyLog;
import com.epson.epos2.cat.DirectIOCommandReplyListener;
import com.epson.epos2.cat.DirectIOListener;
import com.epson.epos2.cat.DirectIOResult;
import com.epson.epos2.cat.ScanCodeListener;
import com.epson.epos2.cat.ScanDataListener;
import com.epson.epos2.cat.StatusUpdateListener;
import com.epson.epos2.storage.ConnectionInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Cat {
    public static final int SERVICE_CREDIT = 0;
    public static final int SERVICE_DEBIT = 1;
    public static final int SERVICE_UNIONPAY = 2;
    public static final int SERVICE_EDY = 3;
    public static final int SERVICE_ID = 4;
    public static final int SERVICE_NANACO = 5;
    public static final int SERVICE_QUICPAY = 6;
    public static final int SERVICE_SUICA = 7;
    public static final int SERVICE_WAON = 8;
    public static final int SERVICE_POINT = 9;
    public static final int SERVICE_COMMON = 10;
    public static final int SERVICE_NFCPAYMENT = 11;
    public static final int SERVICE_PITAPA = 12;
    public static final int SERVICE_FISC = 13;
    public static final int SERVICE_QR = 14;
    public static final int SERVICE_CREDIT_DEBIT = 15;
    public static final int SERVICE_MULTI = 16;
    public static final int PAYMENT_CONDITION_LUMP_SUM = 0;
    public static final int PAYMENT_CONDITION_BONUS_1 = 1;
    public static final int PAYMENT_CONDITION_BONUS_2 = 2;
    public static final int PAYMENT_CONDITION_BONUS_3 = 3;
    public static final int PAYMENT_CONDITION_INSTALLMENT_1 = 4;
    public static final int PAYMENT_CONDITION_INSTALLMENT_2 = 5;
    public static final int PAYMENT_CONDITION_REVOLVING = 6;
    public static final int PAYMENT_CONDITION_COMBINATION_1 = 7;
    public static final int PAYMENT_CONDITION_COMBINATION_2 = 8;
    public static final int PAYMENT_CONDITION_DEBIT = 9;
    public static final int PAYMENT_CONDITION_ELECTRONIC_MONEY = 10;
    public static final int PAYMENT_CONDITION_OTHER = 11;
    public static final int PAYMENT_CONDITION_BONUS_4 = 12;
    public static final int PAYMENT_CONDITION_BONUS_5 = 13;
    public static final int PAYMENT_CONDITION_INSTALLMENT_3 = 14;
    public static final int PAYMENT_CONDITION_COMBINATION_3 = 15;
    public static final int PAYMENT_CONDITION_COMBINATION_4 = 16;
    public static final int SUE_POWER_ONLINE = 2001;
    public static final int SUE_POWER_OFF_OFFLINE = 2004;
    public static final int SUE_LOGSTATUS_OK = 0;
    public static final int SUE_LOGSTATUS_NEARFULL = 1;
    public static final int SUE_LOGSTATUS_FULL = 2;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_DEFAULT = -2;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    private long mCatHandle = 0L;
    private Context mContext = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    private AuthorizeSalesListener mAuthorizeSalesListener = null;
    private AuthorizeVoidListener mAuthorizeVoidListener = null;
    private AuthorizeRefundListener mAuthorizeRefundLitener = null;
    private AuthorizeCompletionListener mAuthorizeCompletionListener = null;
    private AccessDailyLogListener mAccessDailyLogListener = null;
    private DirectIOCommandReplyListener mDirectIOCommandReplyListener = null;
    private CheckConnectionListener mCheckConnectionListener = null;
    private ClearOutputListener mClearOutputListener = null;
    private ScanCodeListener mScanCodeListener = null;
    private ScanDataListener mScanDataListener = null;
    private CashDepositListener mCashDepositListener = null;
    private DirectIOListener mDirectIOListener = null;
    private StatusUpdateListener mStatusUpdateListener = null;
    private ConnectionListener mConnectionListener = null;
    private static int connection;
    private static final int TIMEOUT_DEFAULT = -1;
    private static final int TIMEOUT_DEFAULT_CHECKCONNECTION = 0;
    private static final int TIMEOUT_DEFAULT_SCANCODE = 60000;
    private static final int TIMEOUT_DEFAULT_SCANDATA = 150000;
    private int mTimeout = -1;
    private static final int PARAM_UNUSE = -4;
    private int mTrainingMode = 0;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native CatStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2GetOposErrorCode(long var1);

    protected native int nativeEpos2AuthorizeSale(long var1, int var3, long var4, long var6, long var8, long var10, long var12, int var14, String var15);

    protected native int nativeEpos2AuthorizeVoid(long var1, int var3, long var4, long var6, long var8, long var10, long var12, int var14, String var15);

    protected native int nativeEpos2AuthorizeRefund(long var1, int var3, long var4, long var6, long var8, long var10, long var12, int var14, String var15);

    protected native int nativeEpos2AuthorizeCompletion(long var1, int var3, long var4, long var6, long var8, long var10, long var12, int var14, String var15);

    protected native int nativeEpos2AccessDailyLog(long var1, int var3, long var4, long var6, int var8, String var9, String var10);

    protected native int nativeEpos2SendDirectIOCommand(long var1, long var3, long var5, String var7, int var8, int var9, String var10);

    protected native int nativeEpos2CheckConnection(long var1, long var3, String var5);

    protected native int nativeEpos2ClearOutput(long var1);

    protected native int nativeEpos2ScanCode(long var1, long var3, int var5);

    protected native int nativeEpos2ScanData(long var1, long var3, int var5, long var6, String var8);

    protected native int nativeEpos2CashDeposit(long var1, int var3, long var4, long var6, long var8, int var10);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    protected void initializeCatInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mCatHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mAuthorizeSalesListener = null;
        this.mAuthorizeVoidListener = null;
        this.mAuthorizeRefundLitener = null;
        this.mAuthorizeCompletionListener = null;
        this.mAccessDailyLogListener = null;
        this.mDirectIOCommandReplyListener = null;
        this.mCheckConnectionListener = null;
        this.mClearOutputListener = null;
        this.mDirectIOListener = null;
        this.mStatusUpdateListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mCatHandle != 0L) {
                this.nativeEpos2Disconnect(this.mCatHandle);
                this.nativeEpos2DestroyHandle(this.mCatHandle);
                this.mCatHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mCatHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public Cat(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("Cat", context);
        ConnectionInfo.setStoragePath(context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("Cat", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeCatInstance();
        this.outputLogEvent("Cat", context);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mCatHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mCatHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public CatStatusInfo getStauts() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        CatStatusInfo status = this.nativeEpos2GetStatus(this.mCatHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public int getOposErrorCode() {
        this.outputLogCallFunction("getOposErrorCode", new Object[0]);
        if (this.mCatHandle == 0L) {
            return 0;
        }
        int errStatus = this.nativeEpos2GetOposErrorCode(this.mCatHandle);
        this.outputLogReturnFunction("getOposErrorCode", errStatus, new Object[0]);
        return errStatus;
    }

    public void authorizeSales(int service, int totalAmount, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("authorizeSales", service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            this.authorizeSales(service, totalAmount, -4, -4, sequence, "");
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeSales", ex);
            this.outputLogReturnFunction("authorizeSales", ex.getErrorStatus(), service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeSales", 0, service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeSales(int service, int totalAmount, int amount, int tax, int sequence, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("authorizeSales", service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AuthorizeSale(this.mCatHandle, service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeSales", ex);
            this.outputLogReturnFunction("authorizeSales", ex.getErrorStatus(), service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeSales", 0, service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeVoid(int service, int totalAmount, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("authorizeVoid", service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            this.authorizeVoid(service, totalAmount, -4, -4, sequence, "");
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeVoid", ex);
            this.outputLogReturnFunction("authorizeVoid", ex.getErrorStatus(), service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeVoid", 0, service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeVoid(int service, int totalAmount, int amount, int tax, int sequence, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("authorizeVoid", service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AuthorizeVoid(this.mCatHandle, service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeVoid", ex);
            this.outputLogReturnFunction("authorizeVoid", ex.getErrorStatus(), service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeVoid", 0, service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeRefund(int service, int totalAmount, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("authorizeRefund", service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            this.authorizeRefund(service, totalAmount, -4, -4, sequence, "");
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeRefund", ex);
            this.outputLogReturnFunction("authorizeRefund", ex.getErrorStatus(), service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeRefund", 0, service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeRefund(int service, int totalAmount, int amount, int tax, int sequence, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("authorizeRefund", service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AuthorizeRefund(this.mCatHandle, service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeRefund", ex);
            this.outputLogReturnFunction("authorizeRefund", ex.getErrorStatus(), service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeRefund", 0, service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
    }

    public void authorizeCompletion(int service, int totalAmount, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("authorizeCompletion", service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            this.authorizeCompletion(service, totalAmount, -4, -4, sequence, "");
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeCompletion", ex);
            this.outputLogReturnFunction("authorizeCompletion", ex.getErrorStatus(), service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeCompletion", 0, service, totalAmount, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void authorizeCompletion(int service, int totalAmount, int amount, int tax, int sequence, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("authorizeCompletion", service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AuthorizeCompletion(this.mCatHandle, service, totalAmount, amount, tax, sequence, this.mTimeout, this.mTrainingMode, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("authorizeCompletion", ex);
            this.outputLogReturnFunction("authorizeCompletion", ex.getErrorStatus(), service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("authorizeCompletion", 0, service, totalAmount, amount, tax, sequence, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
    }

    public void accessDailyLog(int service, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("accessDailyLog", service, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            this.accessDailyLog(service, sequence, "", "");
        }
        catch (Epos2Exception ex) {
            this.outputException("accessDailyLog", ex);
            this.outputLogReturnFunction("accessDailyLog", ex.getErrorStatus(), service, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("accessDailyLog", 0, service, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void accessDailyLog(int service, int sequence, String dailyLogType, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("accessDailyLog", service, sequence, dailyLogType, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AccessDailyLog(this.mCatHandle, service, sequence, this.mTimeout, this.mTrainingMode, dailyLogType, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("accessDailyLog", ex);
            this.outputLogReturnFunction("accessDailyLog", ex.getErrorStatus(), service, sequence, dailyLogType, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("accessDailyLog", 0, service, sequence, dailyLogType, additionalSecurityInformation, this.mTimeout, this.mTrainingMode);
    }

    public void sendDirectIOCommand(int command, int data, String string, int service) throws Epos2Exception {
        this.outputLogCallFunction("sendDirectIOCommand", command, data, string, service, this.mTrainingMode);
        try {
            this.checkHandle();
            this.sendDirectIOCommand(command, data, string, service, "");
        }
        catch (Epos2Exception ex) {
            this.outputException("sendDirectIOCommand", ex);
            this.outputLogReturnFunction("sendDirectIOCommand", ex.getErrorStatus(), command, data, string, service, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("sendDirectIOCommand", 0, command, data, string, service, this.mTrainingMode);
    }

    public void sendDirectIOCommand(int command, int data, String string, int service, String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("sendDirectIOCommand", command, data, string, service, additionalSecurityInformation, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendDirectIOCommand(this.mCatHandle, command, data, string, service, this.mTrainingMode, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendDirectIOCommand", ex);
            this.outputLogReturnFunction("sendDirectIOCommand", ex.getErrorStatus(), command, data, string, service, additionalSecurityInformation, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("sendDirectIOCommand", 0, command, data, string, service, additionalSecurityInformation, this.mTrainingMode);
    }

    public void checkConnection(String additionalSecurityInformation) throws Epos2Exception {
        this.outputLogCallFunction("checkConnection", additionalSecurityInformation, this.mTimeout);
        try {
            this.checkHandle();
            long timeout = 0L;
            timeout = this.mTimeout == -1 ? 0L : (long)this.mTimeout;
            int errStatus = this.nativeEpos2CheckConnection(this.mCatHandle, timeout, additionalSecurityInformation);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("checkConnection", ex);
            this.outputLogReturnFunction("checkConnection", ex.getErrorStatus(), additionalSecurityInformation, this.mTimeout);
            throw ex;
        }
        this.outputLogReturnFunction("checkConnection", 0, additionalSecurityInformation, this.mTimeout);
    }

    public void clearOutput() throws Epos2Exception {
        this.outputLogCallFunction("clearOutput", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ClearOutput(this.mCatHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("clearOutput", ex);
            this.outputLogReturnFunction("clearOutput", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("clearOutput", 0, new Object[0]);
    }

    public void scanCode() throws Epos2Exception {
        this.outputLogCallFunction("scanCode", new Object[0]);
        try {
            this.checkHandle();
            long timeout = 0L;
            timeout = this.mTimeout == -1 ? 60000L : (long)this.mTimeout;
            int errStatus = this.nativeEpos2ScanCode(this.mCatHandle, timeout, this.mTrainingMode);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("scanCode", ex);
            this.outputLogReturnFunction("scanCode", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("scanCode", 0, new Object[0]);
    }

    public void scanData(int command, String string) throws Epos2Exception {
        this.outputLogCallFunction("scanData", new Object[0]);
        try {
            this.checkHandle();
            long timeout = 0L;
            timeout = this.mTimeout == -1 ? 150000L : (long)this.mTimeout;
            int errStatus = this.nativeEpos2ScanData(this.mCatHandle, timeout, this.mTrainingMode, command, string);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("scanData", ex);
            this.outputLogReturnFunction("scanData", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("scanData", 0, new Object[0]);
    }

    public void cashDeposit(int service, int amount, int sequence) throws Epos2Exception {
        this.outputLogCallFunction("cashDeposit", service, amount, sequence, this.mTimeout, this.mTrainingMode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2CashDeposit(this.mCatHandle, service, amount, sequence, this.mTimeout, this.mTrainingMode);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("cashDeposit", ex);
            this.outputLogReturnFunction("cashDeposit", ex.getErrorStatus(), service, amount, sequence, this.mTimeout, this.mTrainingMode);
            throw ex;
        }
        this.outputLogReturnFunction("cashDeposit", 0, service, amount, sequence, this.mTimeout, this.mTrainingMode);
    }

    public void setTimeout(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("setTimeout", timeout);
        try {
            this.checkHandle();
            if (timeout < -1 || timeout > 999000) {
                throw new Epos2Exception(1);
            }
            this.mTimeout = timeout;
        }
        catch (Epos2Exception ex) {
            this.outputException("setTimeout", ex);
            this.outputLogReturnFunction("setTimeout", ex.getErrorStatus(), timeout);
            throw ex;
        }
        this.outputLogReturnFunction("setTimeout", 0, timeout);
    }

    public int getTimeout() {
        this.outputLogCallFunction("getTimeout", this.mTimeout);
        return this.mTimeout;
    }

    public void setTrainingMode(int mode) throws Epos2Exception {
        this.outputLogCallFunction("setTrainingMode", mode);
        try {
            this.checkHandle();
            if (mode != 1 && mode != 0) {
                throw new Epos2Exception(1);
            }
            this.mTrainingMode = mode;
        }
        catch (Epos2Exception ex) {
            this.outputException("setTrainingMode", ex);
            this.outputLogReturnFunction("setTrainingMode", ex.getErrorStatus(), mode);
            throw ex;
        }
        this.outputLogReturnFunction("setTrainingMode", 0, mode);
    }

    public int getTrainingMode() {
        this.outputLogCallFunction("getTrainingMode", this.mTrainingMode);
        return this.mTrainingMode;
    }

    public void setAuthorizeSalesEventListener(AuthorizeSalesListener listener) {
        this.outputLogCallFunction("setAuthorizeSalesEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mAuthorizeSalesListener = listener != null ? listener : null;
        }
    }

    public void setAuthorizeVoidEventListener(AuthorizeVoidListener listener) {
        this.outputLogCallFunction("setAuthorizeVoidEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mAuthorizeVoidListener = listener != null ? listener : null;
        }
    }

    public void setAuthorizeRefundEventListener(AuthorizeRefundListener listener) {
        this.outputLogCallFunction("setAuthorizeRefundEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mAuthorizeRefundLitener = listener != null ? listener : null;
        }
    }

    public void setAuthorizeCompletionEventListener(AuthorizeCompletionListener listener) {
        this.outputLogCallFunction("setAuthorizeCompletionEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mAuthorizeCompletionListener = listener != null ? listener : null;
        }
    }

    public void setAccessDailyLogEventListener(AccessDailyLogListener listener) {
        this.outputLogCallFunction("setAccessDailyLogEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mAccessDailyLogListener = listener != null ? listener : null;
        }
    }

    public void setDirectIOCommandReplyEventListener(DirectIOCommandReplyListener listener) {
        this.outputLogCallFunction("setDirectIOCommandReplyEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mDirectIOCommandReplyListener = listener != null ? listener : null;
        }
    }

    public void setCheckConnectionEventListener(CheckConnectionListener listener) {
        this.outputLogCallFunction("setCheckConnectionEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mCheckConnectionListener = listener != null ? listener : null;
        }
    }

    public void setClearOutputEventListener(ClearOutputListener listener) {
        this.outputLogCallFunction("setClearOutputEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mClearOutputListener = listener != null ? listener : null;
        }
    }

    public void setScanCodeEventListener(ScanCodeListener listener) {
        this.outputLogCallFunction("setScanCodeEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mScanCodeListener = listener != null ? listener : null;
        }
    }

    public void setScanDataEventListener(ScanDataListener listener) {
        this.outputLogCallFunction("setScanDataEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mScanDataListener = listener != null ? listener : null;
        }
    }

    public void setCashDepositEventListener(CashDepositListener listener) {
        this.outputLogCallFunction("setCashDepositEventListener", listener);
        if (this.mCatHandle != 0L) {
            this.mCashDepositListener = listener != null ? listener : null;
        }
    }

    public void setDirectIOEventListener(DirectIOListener listener) {
        this.outputLogCallFunction("setDirectIOEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mDirectIOListener = listener != null ? listener : null;
        }
    }

    public void setStatusUpdateEventListener(StatusUpdateListener listener) {
        this.outputLogCallFunction("setStatusUpdateEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mStatusUpdateListener = listener != null ? listener : null;
        }
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mCatHandle == 0L) {
            return;
        }
        if (this.mCatHandle != 0L) {
            this.mConnectionListener = listener != null ? listener : null;
        }
    }

    private void onCatAuthorizeSales(int code, int sequence, int service, AuthorizeResult result) {
        this.outputLogCallFunction("onCatAuthorizeSales", code, sequence, service, result, this);
        try {
            if (null != this.mAuthorizeSalesListener) {
                this.mAuthorizeSalesListener.onCatAuthorizeSales(this, code, sequence, service, result);
                this.outputLogEvent("onCatAuthorizeSales", "code->", code, "sequence->", sequence, "service->", service, "result->", result, this);
            }
            this.outputLogReturnFunction("onCatAuthorizeSales", 0, code, sequence, service, result, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatAuthorizeVoid(int code, int sequence, int service, AuthorizeResult result) {
        this.outputLogCallFunction("onCatAuthorizeVoid", code, sequence, service, result, this);
        try {
            if (null != this.mAuthorizeVoidListener) {
                this.mAuthorizeVoidListener.onCatAuthorizeVoid(this, code, sequence, service, result);
                this.outputLogEvent("onCatAuthorizeVoid", "code->", code, "sequence->", sequence, "service->", service, "result->", result, this);
            }
            this.outputLogReturnFunction("onCatAuthorizeVoid", 0, code, sequence, service, result, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatAuthorizeRefund(int code, int sequence, int service, AuthorizeResult result) {
        this.outputLogCallFunction("onCatAuthorizeRefund", code, sequence, service, result, this);
        try {
            if (null != this.mAuthorizeRefundLitener) {
                this.mAuthorizeRefundLitener.onCatAuthorizeRefund(this, code, sequence, service, result);
                this.outputLogEvent("onCatAuthorizeRefund", "code->", code, "sequence->", sequence, "service->", service, "result->", result, this);
            }
            this.outputLogReturnFunction("onCatAuthorizeRefund", 0, code, sequence, service, result, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatAuthorizeCompletion(int code, int sequence, int service, AuthorizeResult result) {
        this.outputLogCallFunction("onCatAuthorizeCompletion", code, sequence, service, result, this);
        try {
            if (null != this.mAuthorizeCompletionListener) {
                this.mAuthorizeCompletionListener.onCatAuthorizeCompletion(this, code, sequence, service, result);
                this.outputLogEvent("onCatAuthorizeCompletion", "code->", code, "sequence->", sequence, "service->", service, "result->", result, this);
            }
            this.outputLogReturnFunction("onCatAuthorizeCompletion", 0, code, sequence, service, result, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatAccessDailyLog(int code, int sequence, int service, DailyLog[] dailyLogArray, int logCount) {
        this.outputLogCallFunction("onCatAccessDailyLog", code, sequence, service, dailyLogArray, logCount, this);
        try {
            ArrayList<DailyLog> dailyLogArrayList = new ArrayList<DailyLog>(logCount);
            int i = 0;
            for (i = 0; i < logCount; ++i) {
                dailyLogArrayList.add(dailyLogArray[i]);
            }
            if (null != this.mAccessDailyLogListener) {
                this.mAccessDailyLogListener.onCatAccessDailyLog(this, code, sequence, service, dailyLogArrayList);
                this.outputLogEvent("onCatAccessDailyLog", "code->", code, "sequence->", sequence, "service->", service, "dailyLogArrayList->", dailyLogArrayList, this);
            }
            this.outputLogReturnFunction("onCatAccessDailyLog", 0, code, sequence, service, dailyLogArray, logCount, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatDirectIOCommandReply(int code, int command, int data, String string, int sequence, int service, DirectIOResult result) {
        this.outputLogCallFunction("onCatDirectIOCommandReply", code, command, data, string, sequence, service, result, this);
        if (null != this.mDirectIOCommandReplyListener) {
            this.mDirectIOCommandReplyListener.onCatDirectIOCommandReply(this, code, command, data, string, sequence, service, result);
            this.outputLogEvent("onCatDirectIOCommandReply", "code->", code, "command->", command, "data->", data, "string->", string, "sequence->", sequence, "service->", service, "result->", result, this);
        }
        this.outputLogReturnFunction("onCatDirectIOCommandReply", 0, code, command, data, string, sequence, service, result, this);
    }

    private void onCatCheckConnection(int code, String additionalSecurityInformation) {
        this.outputLogCallFunction("onCatCheckConnection", code, additionalSecurityInformation, this);
        if (null != this.mCheckConnectionListener) {
            this.mCheckConnectionListener.onCatCheckConnection(this, code, additionalSecurityInformation);
            this.outputLogEvent("onCatCheckConnection", "code->", code, "additionalSecurityInformation->", additionalSecurityInformation, this);
        }
        this.outputLogReturnFunction("onCatCheckConnection", 0, code, additionalSecurityInformation, this);
    }

    private void onCatClearOutput(int code, int abortCode) {
        this.outputLogCallFunction("onCatClearOutput", code, abortCode, this);
        if (null != this.mClearOutputListener) {
            this.mClearOutputListener.onCatClearOutput(this, code, abortCode);
            this.outputLogEvent("onCatClearOutput", "code->", code, "abortCode->", abortCode, this);
        }
        this.outputLogReturnFunction("onCatClearOutput", 0, code, abortCode, this);
    }

    private void onCatScanCode(int code, String additionalSecurityInformation) {
        this.outputLogCallFunction("onCatScanCode", code, additionalSecurityInformation, this);
        if (null != this.mScanCodeListener) {
            this.mScanCodeListener.onCatScanCode(this, code, additionalSecurityInformation);
            this.outputLogEvent("onCatScanCode", "code->", code, "additionalSecurityInformation->", additionalSecurityInformation, this);
        }
        this.outputLogReturnFunction("onCatScanCode", 0, code, additionalSecurityInformation, this);
    }

    private void onCatScanData(int code, String additionalSecurityInformation) {
        this.outputLogCallFunction("onCatScanData", code, additionalSecurityInformation, this);
        if (null != this.mScanDataListener) {
            this.mScanDataListener.onCatScanData(this, code, additionalSecurityInformation);
            this.outputLogEvent("onCatScanData", "code->", code, "additionalSecurityInformation->", additionalSecurityInformation, this);
        }
        this.outputLogReturnFunction("onCatScanData", 0, code, additionalSecurityInformation, this);
    }

    public void onCatCashDeposit(int code, int sequence, int service, CashDepositResult result) {
        this.outputLogCallFunction("onCatCashDeposit", this, code, sequence, service, result);
        try {
            if (null != this.mCashDepositListener) {
                this.mCashDepositListener.onCatCashDeposit(this, code, sequence, service, result);
                this.outputLogEvent("onCatCashDeposit", "code->", code, "sequence->", sequence, "service->", service, "result->", result, this);
            }
            this.outputLogReturnFunction("onCatCashDeposit", 0, code, sequence, service, result, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onCatDirectIO(int eventNumber, int data, String string) {
        this.outputLogCallFunction("onCatDirectIO", eventNumber, data, string, this);
        if (null != this.mDirectIOListener) {
            this.mDirectIOListener.onCatDirectIO(this, eventNumber, data, string);
            this.outputLogEvent("onCatDirectIO", "eventNumber->", eventNumber, "data->", data, "string->", string, this);
        }
        this.outputLogReturnFunction("onCatDirectIO", 0, eventNumber, data, string, this);
    }

    private void onCatStatusUpdate(int status) {
        this.outputLogCallFunction("onCatStatusUpdate", status, this);
        if (null != this.mStatusUpdateListener) {
            this.mStatusUpdateListener.onCatStatusUpdate(this, status);
            this.outputLogEvent("onCatStatusUpdate", "status->", status, this);
        }
        this.outputLogReturnFunction("onCatStatusUpdate", 0, status, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mCatHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mCatHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mCatHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mCatHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCatHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCatHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mCatHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mCatHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

