/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.commbox;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.commbox.CommBoxStatusInfo;
import com.epson.epos2.commbox.GetCommHistoryCallback;
import com.epson.epos2.commbox.ReceiveListener;
import com.epson.epos2.commbox.SendMessageCallback;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class CommBox {
    private long mCommBoxHandle = 0L;
    private Context mContext = null;
    private ReceiveListener mReceiveListener = null;
    private ConnectionListener mConnectionListener = null;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_DEFAULT = -2;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    private static int connection;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, String var6, Object var7);

    private native int nativeEpos2Disconnect(long var1);

    protected native int nativeEpos2GetCommHistory(long var1, CommBoxHistoryCallbackAdapter var3);

    protected native int nativeEpos2SendMessage(long var1, String var3, String var4, CommBoxSendMessageCallbackAdapter var5);

    protected native CommBoxStatusInfo nativeEpos2GetStatus(long var1);

    public CommBox(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("CommBox", context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("CommBox", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeCommBoxInstance();
        this.outputLogReturnFunction("CommBox", 0, context);
    }

    protected void initializeCommBoxInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mCommBoxHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mCommBoxHandle != 0L) {
                this.nativeEpos2Disconnect(this.mCommBoxHandle);
                this.nativeEpos2DestroyHandle(this.mCommBoxHandle);
                this.mCommBoxHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    public void connect(String target, int timeout, String myId) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout, myId);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            String paramMyId = myId != null ? myId : "";
            int errStatus = this.nativeEpos2Connect(this.mCommBoxHandle, target, timeout, paramMyId, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout, myId);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout, myId);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mCommBoxHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mCommBoxHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void getCommHistory(GetCommHistoryCallback target) throws Epos2Exception {
        this.outputLogCallFunction("getCommHistory", target);
        try {
            if (this.mCommBoxHandle == 0L) {
                throw new Epos2Exception(5);
            }
            if (target == null) {
                throw new Epos2Exception(1);
            }
            int errState = this.nativeEpos2GetCommHistory(this.mCommBoxHandle, new CommBoxHistoryCallbackAdapter(this.mCommBoxHandle, target, this));
            if (errState != 0) {
                throw new Epos2Exception(errState);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getCommHistory", ex);
            this.outputLogReturnFunction("getCommHistory", ex.getErrorStatus(), target);
            throw ex;
        }
        this.outputLogReturnFunction("getCommHistory", 0, target);
    }

    public void sendMessage(String message, String targetId, SendMessageCallback target) throws Epos2Exception {
        this.outputLogCallFunction("sendMessage", message, targetId, target);
        try {
            if (this.mCommBoxHandle == 0L) {
                throw new Epos2Exception(5);
            }
            if (message == null || target == null) {
                throw new Epos2Exception(1);
            }
            String paramTargetId = null;
            paramTargetId = targetId != null ? targetId : "";
            int errState = this.nativeEpos2SendMessage(this.mCommBoxHandle, message, paramTargetId, new CommBoxSendMessageCallbackAdapter(this.mCommBoxHandle, target, this));
            if (errState != 0) {
                throw new Epos2Exception(errState);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendMessage", ex);
            this.outputLogReturnFunction("sendMessage", ex.getErrorStatus(), message, targetId, target);
            throw ex;
        }
        this.outputLogReturnFunction("sendMessage", 0, message, targetId, target);
    }

    public void setReceiveEventListener(ReceiveListener target) {
        this.outputLogCallFunction("setReceiveEventListener", target);
        if (this.mCommBoxHandle == 0L) {
            return;
        }
        this.mReceiveListener = target != null ? target : null;
    }

    protected void onCommBoxReceive(long commBoxHandle, String senderId, String receiverId, String message) {
        this.outputLogCallFunction("onCommBoxReceive", senderId, receiverId, message, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onCommBoxReceive(this, senderId, receiverId, message);
            this.outputLogEvent("onCommBoxReceive", "senderId->", senderId, "receiverId->", receiverId, "message->", message);
        }
        this.outputLogReturnFunction("onCommBoxReceive", 0, senderId, receiverId, message, this);
    }

    public CommBoxStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        CommBoxStatusInfo status = this.nativeEpos2GetStatus(this.mCommBoxHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public String getAdmin() {
        this.outputLogCallFunction("getAdmin", new Object[0]);
        String admin = "";
        this.outputLogReturnFunction("getAdmin", 0, new Object[0]);
        return admin;
    }

    public String getLocation() {
        this.outputLogCallFunction("getLocation", new Object[0]);
        String location = "";
        this.outputLogReturnFunction("getLocation", 0, new Object[0]);
        return location;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mCommBoxHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCommBoxHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mCommBoxHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mCommBoxHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mCommBoxHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }

    protected class CommBoxHistoryCallbackAdapter {
        private long mAdapterCommBoxHandle = 0L;
        private GetCommHistoryCallback mCallback = null;
        private CommBox mCommBoxObj = null;
        private ArrayList<HashMap<String, String>> mHistoryList = new ArrayList();

        public long getAdapterCommBoxHandle() {
            return this.mAdapterCommBoxHandle;
        }

        public CommBoxHistoryCallbackAdapter(long handle, GetCommHistoryCallback target, CommBox commboxObj) {
            this.mAdapterCommBoxHandle = handle;
            this.mCallback = target;
            this.mCommBoxObj = commboxObj;
        }

        public void onCommBoxHistory(long commBoxHandle, int code) {
            CommBox.this.outputLogCallFunction("onCommBoxHistory", new Object[]{code, this.mHistoryList, this.mHistoryList.size(), "-", this.mCommBoxObj});
            if (this.mCallback != null) {
                CommBox.this.outputLogEvent("onCommBoxHistory", new Object[]{"code->", code, "historyList->", this.mHistoryList, "count->", this.mHistoryList.size()});
                if (code == 0) {
                    this.mCallback.onGetCommHistory(this.mCommBoxObj, code, this.mHistoryList);
                } else {
                    this.mCallback.onGetCommHistory(this.mCommBoxObj, code, null);
                }
            }
            CommBox.this.outputLogReturnFunction("onCommBoxHistory", 0, new Object[]{code, this.mHistoryList, this.mHistoryList.size(), "-", this.mCommBoxObj});
        }

        public void addHistory(String senderId, String receiverId, String message) {
            HashMap<String, String> history = new HashMap<String, String>();
            history.put("senderId", senderId);
            history.put("receiverId", receiverId);
            history.put("message", message);
            this.mHistoryList.add(history);
        }
    }

    protected class CommBoxSendMessageCallbackAdapter {
        private long mAdapterCommBoxHandle = 0L;
        private SendMessageCallback mListener = null;
        private CommBox mCommBoxObj = null;

        public CommBoxSendMessageCallbackAdapter(long handle, SendMessageCallback target, CommBox commboxObj) {
            this.mAdapterCommBoxHandle = handle;
            this.mListener = target;
            this.mCommBoxObj = commboxObj;
        }

        public long getAdapterCommBoxHandle() {
            return this.mAdapterCommBoxHandle;
        }

        public void onCommBoxSendMessage(long commBoxHandle, int code, long count) {
            CommBox.this.outputLogCallFunction("onCommBoxSendMessage", new Object[]{code, count, "-", this.mCommBoxObj});
            if (this.mListener != null) {
                CommBox.this.outputLogEvent("onCommBoxSendMessage", new Object[]{"code->", code, "count->", count});
                this.mListener.onCommBoxSendMessage(this.mCommBoxObj, code, (int)count);
            }
            CommBox.this.outputLogReturnFunction("onCommBoxSendMessage", 0, new Object[]{code, count, "-", this.mCommBoxObj});
        }
    }
}

