/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.keyboard;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.keyboard.KeyPressListener;
import com.epson.epos2.keyboard.KeyboardStatusInfo;
import com.epson.epos2.keyboard.ReadStringListener;
import com.epson.epos2.storage.ConnectionInfo;
import java.lang.reflect.Method;

public class Keyboard {
    private long mKeyboardHandle = 0L;
    private Context mContext = null;
    public static final int VK_BACK = 8;
    public static final int VK_TAB = 9;
    public static final int VK_RETURN = 13;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_MENU = 18;
    public static final int VK_CAPITAL = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_CONVERT = 28;
    public static final int VK_NONCONVERT = 29;
    public static final int VK_SPACE = 32;
    public static final int VK_PRIOR = 33;
    public static final int VK_NEXT = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_INSERT = 45;
    public static final int VK_DELETE = 46;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_OEM_1 = 186;
    public static final int VK_OEM_PLUS = 187;
    public static final int VK_OEM_COMMA = 188;
    public static final int VK_OEM_MINUS = 189;
    public static final int VK_OEM_PERIOD = 190;
    public static final int VK_OEM_2 = 191;
    public static final int VK_OEM_3 = 192;
    public static final int VK_OEM_4 = 219;
    public static final int VK_OEM_5 = 220;
    public static final int VK_OEM_6 = 221;
    public static final int VK_OEM_7 = 222;
    public static final int VK_OEM_ATTN = 240;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_DEFAULT = -2;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    private KeyPressListener mKeyPressListener = null;
    private ReadStringListener mStringListener = null;
    private ConnectionListener mConnectionListener = null;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private static int connection;

    private native int nativeEpos2CreateHandle(long[] var1);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native int nativeEpos2SetPrefix(long var1, int[] var3);

    protected native int[] nativeEpos2GetPrefix(long var1);

    protected native KeyboardStatusInfo nativeEpos2GetStatus(long var1);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public Keyboard(Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("Keyboard", context);
        ConnectionInfo.setStoragePath(context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("Keyboard", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeKeyboardInstance();
        this.outputLogEvent("Keyboard", context);
    }

    protected void initializeKeyboardInstance() throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mKeyboardHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mKeyPressListener = null;
        this.mStringListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mKeyboardHandle != 0L) {
                this.nativeEpos2Disconnect(this.mKeyboardHandle);
                this.nativeEpos2DestroyHandle(this.mKeyboardHandle);
                this.mKeyboardHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mKeyboardHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mKeyboardHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mKeyboardHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void setPrefix(int[] prefixes) throws Epos2Exception {
        this.outputLogCallFunction("setPrefix", new Object[]{prefixes});
        try {
            this.checkHandle();
            int result = this.nativeEpos2SetPrefix(this.mKeyboardHandle, prefixes);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("setPrefix", ex);
            this.outputLogReturnFunction("setPrefix", ex.getErrorStatus(), new Object[]{prefixes});
            throw ex;
        }
        this.outputLogReturnFunction("setPrefix", 0, new Object[]{prefixes});
    }

    public int[] getPrefix() {
        this.outputLogCallFunction("getPrefix", new Object[0]);
        if (this.mKeyboardHandle == 0L) {
            this.outputLogReturnFunction("getPrefix", 257, new Object[0]);
            return null;
        }
        this.outputLogReturnFunction("getPrefix", 0, new Object[0]);
        return this.nativeEpos2GetPrefix(this.mKeyboardHandle);
    }

    public void setKeyPressEventListener(KeyPressListener target) {
        this.outputLogCallFunction("setKeyPressEventListener", target);
        if (this.mKeyboardHandle != 0L) {
            this.mKeyPressListener = target != null ? target : null;
        }
    }

    public void setReadStringEventListener(ReadStringListener target) {
        this.outputLogCallFunction("setReadStringEventListener", target);
        if (this.mKeyboardHandle != 0L) {
            this.mStringListener = target != null ? target : null;
        }
    }

    protected void onKbdKeyPress(int keyCode, String ascii) {
        this.outputLogCallFunction("onKbdKeyPress", keyCode, ascii, this);
        if (null != this.mKeyPressListener) {
            this.mKeyPressListener.onKbdKeyPress(this, keyCode, ascii);
            this.outputLogEvent("onKbdKeyPress", "keyCode->", keyCode, "ascii->", ascii);
        }
        this.outputLogReturnFunction("onKbdKeyPress", 0, keyCode, ascii, this);
    }

    protected void onKbdReadString(String input, int prefix) {
        this.outputLogCallFunction("onKbdReadString", input, prefix, this);
        if (null != this.mStringListener) {
            this.mStringListener.onKbdReadString(this, input, prefix);
            this.outputLogEvent("onKbdReadString", "readString->", input, "prefix->", prefix);
        }
        this.outputLogReturnFunction("onKbdReadString", 0, input, prefix, this);
    }

    public KeyboardStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        KeyboardStatusInfo status = this.nativeEpos2GetStatus(this.mKeyboardHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mKeyboardHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mKeyboardHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mKeyboardHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mKeyboardHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mKeyboardHandle != 0L) {
            this.mConnectionListener = listener != null ? listener : null;
        }
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mKeyboardHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mKeyboardHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mKeyboardHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mKeyboardHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

