/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.linedisplay;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.linedisplay.DisplayStatusInfo;
import com.epson.epos2.linedisplay.ReceiveListener;
import com.epson.epos2.storage.ConnectionInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;

public class LineDisplay {
    private long mDisplayHandle = 0L;
    private Context mContext = null;
    private ReceiveListener mReceiveListener;
    private ConnectionListener mConnectionListener;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mReadLogSettingsMethod = null;
    private Method mOutputLogInfoMethod = null;
    private static final int NO_EXCEPTION = 0;
    private static final int RETURN_NULL_CHARACTER = 256;
    private static final int RETURN_NULL = 257;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    public static final int PARAM_DEFAULT = -2;
    public static final int PARAM_UNUSE = -4;
    public static final int DM_D110 = 0;
    public static final int DM_D210 = 1;
    public static final int DM_D30 = 2;
    public static final int DM_D70 = 3;
    public static final int SCROLL_OVERWRITE = 0;
    public static final int SCROLL_VERTICAL = 1;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int MOVE_TOP_LEFT = 0;
    public static final int MOVE_TOP_RIGHT = 1;
    public static final int MOVE_BOTTOM_LEFT = 2;
    public static final int MOVE_BOTTOM_RIGHT = 3;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_UNDERLINE = 1;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int LANG_MULTI = 7;
    public static final int MARQUEE_WALK = 0;
    public static final int MARQUEE_PLACE = 1;
    public static final int BRIGHTNESS_20 = 0;
    public static final int BRIGHTNESS_40 = 1;
    public static final int BRIGHTNESS_60 = 2;
    public static final int BRIGHTNESS_100 = 3;
    public static final int LAYOUT_MODE_1 = 0;
    public static final int LAYOUT_MODE_2 = 1;
    public static final int LAYOUT_MODE_3 = 2;
    public static final int LAYOUT_MODE_4 = 3;
    public static final int LAYOUT_MODE_5 = 4;
    public static final int LAYOUT_MODE_6 = 5;
    public static final int LAYOUT_MODE_7 = 6;
    public static final int LAYOUT_MODE_8 = 7;
    public static final int LAYOUT_MODE_9 = 8;
    public static final int LAYOUT_MODE_10 = 9;
    public static final int LAYOUT_MODE_11 = 10;
    public static final int LAYOUT_MODE_12 = 11;
    public static final int LAYOUT_MODE_13 = 12;
    public static final int LAYOUT_MODE_14 = 13;
    public static final int LAYOUT_MODE_15 = 14;
    public static final int LANDSCAPE_LAYOUT_MODE_1 = 15;
    public static final int LANDSCAPE_LAYOUT_MODE_2 = 16;
    public static final int LANDSCAPE_LAYOUT_MODE_3 = 17;
    public static final int LANDSCAPE_LAYOUT_MODE_4 = 18;
    public static final int LANDSCAPE_LAYOUT_MODE_5 = 19;
    public static final int PORTRAIT_LAYOUT_MODE_1 = 20;
    public static final int PORTRAIT_LAYOUT_MODE_2 = 21;
    public static final int PORTRAIT_LAYOUT_MODE_3 = 22;
    public static final int PORTRAIT_LAYOUT_MODE_4 = 23;
    public static final int PORTRAIT_LAYOUT_MODE_5 = 24;
    public static final int PORTRAIT_LAYOUT_MODE_6 = 25;
    public static final int PORTRAIT_LAYOUT_MODE_7 = 26;
    public static final int EVEN_ROWS = -10;
    public static final int ODD_ROWS = -11;
    public static final int ALL_ROWS = -12;
    public static final int SYMBOL_QRCODE_MODEL_1 = 2;
    public static final int SYMBOL_QRCODE_MODEL_2 = 3;
    public static final int LEVEL_L = 9;
    public static final int LEVEL_M = 10;
    public static final int LEVEL_Q = 11;
    public static final int LEVEL_H = 12;
    private static final int BINARY_TYPE_UNKNOWN = 0;
    private static final int BINARY_TYPE_JPEG = 1;
    private static final int BINARY_TYPE_PNG = 2;
    private static final int LANDSCAPE_WIDTH_MAX = 800;
    private static final int LANDSCAPE_HEIGHT_MAX = 480;
    private static final int PORTRAIT_WIDTH_MAX = 480;
    private static final int PORTRAIT_HEIGHT_MAX = 800;
    private static byte[] imageData;
    private static int connection;

    private native int nativeEpos2CreateHandle(int var1, long[] var2);

    private native int nativeEpos2DestroyHandle(long var1);

    private native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    private native int nativeEpos2Disconnect(long var1);

    protected native DisplayStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2SendData(long var1);

    protected native int nativeEpos2ClearCommandBuffer(long var1);

    protected native int nativeEpos2AddInitialize(long var1);

    protected native int nativeEpos2AddCreateWindow(long var1, long var3, long var5, long var7, long var9, long var11, int var13);

    protected native int nativeEpos2AddDestroyWindow(long var1, long var3);

    protected native int nativeEpos2AddSetCurrentWindow(long var1, long var3);

    protected native int nativeEpos2AddClearCurrentWindow(long var1);

    protected native int nativeEpos2AddSetCursorPosition(long var1, long var3, long var5);

    protected native int nativeEpos2AddMoveCursorPosition(long var1, int var3);

    protected native int nativeEpos2AddSetCursorType(long var1, int var3);

    protected native int nativeEpos2DspAddText(long var1, String var3, long var4, long var6, int var8, long var9, long var11, long var13);

    protected native int nativeEpos2AddReverseText(long var1, String var3);

    protected native int nativeEpos2AddReverseTextLang(long var1, String var3, int var4);

    protected native int nativeEpos2AddReverseTextPosition(long var1, String var3, long var4, long var6);

    protected native int nativeEpos2AddReverseTextPositionLang(long var1, String var3, long var4, long var6, int var8);

    protected native int nativeEpos2AddMarqueeText(long var1, String var3, int var4, long var5, long var7, long var9, int var11);

    protected native int nativeEpos2AddSetBlink(long var1, long var3);

    protected native int nativeEpos2AddSetBrightness(long var1, int var3);

    protected native int nativeEpos2AddShowClock(long var1);

    protected native int nativeEpos2AddCommand(long var1, byte[] var3);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    protected native int nativeEpos2AddCreateScreen(long var1, int var3);

    protected native int nativeEpos2AddCreateScreenCustom(long var1, int var3, long var4, long var6);

    protected native int nativeEpos2AddBackgroundColor(long var1, long var3, long var5, long var7, long var9);

    protected native int nativeEpos2AddStartSlideShow(long var1, long var3);

    protected native int nativeEpos2AddStopSlideShow(long var1);

    protected native int nativeEpos2AddDspSymbol(long var1, String var3, int var4, int var5, long var6, long var8, long var10, long var12, int var14);

    protected native int nativeEpos2AddDspDownloadImage(long var1, long var3, long var5, long var7, long var9, long var11, long var13);

    protected native int nativeEpos2AddDspRegisterDownloadImage(long var1, byte[] var3, long var4, long var6);

    protected native int nativeEpos2AddDspNVImage(long var1, long var3, long var5, long var7, long var9, long var11, long var13);

    protected native int nativeEpos2AddDspClearImage(long var1);

    protected native int nativeEpos2AddDspClearSymbol(long var1);

    protected native int nativeEpos2AddCreateTextArea(long var1, long var3, long var5, long var7, long var9, long var11, int var13);

    protected native int nativeEpos2AddDestroyTextArea(long var1, long var3);

    protected native int nativeEpos2AddSetCurrentTextArea(long var1, long var3);

    protected native int nativeEpos2AddClearCurrentTextArea(long var1);

    private int checkBinaryType(byte[] data, int length) {
        if (data == null || length <= 0) {
            return 0;
        }
        int type = 0;
        if (length > 4) {
            if (data[0] == -1 && data[1] == -40) {
                type = 1;
            }
            if (data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71) {
                type = 2;
            }
        }
        return type;
    }

    private void convertBinaryData(int binaryType, byte[] src) throws Exception {
        if (binaryType == 0 || src == null) {
            this.outputLogInfo("createBinaryData ERR_PARAM");
            throw new Exception();
        }
        try {
            Bitmap image = BitmapFactory.decodeByteArray((byte[])src, (int)0, (int)src.length);
            int height = image.getHeight();
            int width = image.getWidth();
            int trimHeight = height;
            int trimWidth = width;
            if (height <= width) {
                if (height > 480) {
                    trimHeight = 480;
                }
                if (width > 800) {
                    trimWidth = 800;
                }
            } else if (height > width) {
                if (height > 800) {
                    trimHeight = 800;
                }
                if (width > 480) {
                    trimWidth = 480;
                }
            }
            boolean convertPNGBinary = false;
            if (binaryType == 1) {
                if (trimWidth >= 1) {
                    if (trimWidth == 1) {
                        convertPNGBinary = true;
                    } else if (trimWidth % 2 != 0) {
                        --trimWidth;
                    }
                } else {
                    this.outputLogInfo("createBinaryData ERR_PARAM");
                    throw new Exception();
                }
            }
            int trimStartX = 0;
            int trimStartY = 0;
            Bitmap trimmedImage = Bitmap.createBitmap((Bitmap)image, (int)trimStartX, (int)trimStartY, (int)trimWidth, (int)trimHeight);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            switch (binaryType) {
                case 1: {
                    if (convertPNGBinary) {
                        trimmedImage.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
                        imageData = stream.toByteArray();
                        break;
                    }
                    trimmedImage.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)stream);
                    imageData = stream.toByteArray();
                    break;
                }
                case 2: {
                    trimmedImage.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
                    imageData = stream.toByteArray();
                    break;
                }
                default: {
                    this.outputLogInfo("createBinaryData ERR_PARAM");
                    throw new Exception();
                }
            }
        }
        catch (Exception e) {
            this.outputLogInfo("createBinaryData(Exception)", e);
            throw new Exception(e);
        }
    }

    private StringBuffer createBinaryString(int binaryType, byte[] data) {
        if (data == null) {
            this.outputLogInfo("createBinaryString ERR_PARAM");
            return new StringBuffer("");
        }
        StringBuffer str = new StringBuffer();
        try {
            int i;
            int length = data.length;
            int outputLength = 0;
            if (binaryType == 1) {
                for (i = 0; i < length; ++i) {
                    if (data[i] != -1 || i + 1 >= length || data[i + 1] != -64) continue;
                    outputLength = i + 20;
                    if (outputLength > length) {
                        outputLength = 0;
                    }
                    break;
                }
            } else if (binaryType == 2 && length > 32) {
                outputLength = 32;
            }
            for (i = 0; i < outputLength; ++i) {
                str.append(String.format("%02X ", data[i]));
            }
        }
        catch (Exception e) {
            this.outputLogInfo("createBinaryString(Exception)", e);
        }
        return str;
    }

    public LineDisplay(int displaySeries, Context context) throws Epos2Exception {
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("LineDisplay", displaySeries, context);
        ConnectionInfo.setStoragePath(context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("LineDisplay", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeDisplayInstance(displaySeries);
        this.outputLogReturnFunction("LineDisplay", 0, displaySeries, context);
    }

    protected void initializeDisplayInstance(int displaySeries) throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(displaySeries, bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mDisplayHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mDisplayHandle != 0L) {
                this.nativeEpos2Disconnect(this.mDisplayHandle);
                this.nativeEpos2DestroyHandle(this.mDisplayHandle);
                this.mDisplayHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mDisplayHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    protected void checkHandle() throws Epos2Exception {
        if (this.mDisplayHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    public void sendData() throws Epos2Exception {
        this.outputLogCallFunction("sendData", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendData(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendData", ex);
            this.outputLogReturnFunction("sendData", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", 0, new Object[0]);
    }

    public DisplayStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        DisplayStatusInfo status = this.nativeEpos2GetStatus(this.mDisplayHandle);
        if (status != null) {
            connection = status.getConnection();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return status;
    }

    public void clearCommandBuffer() {
        this.outputLogCallFunction("clearCommandBuffer", new Object[0]);
        if (this.mDisplayHandle != 0L) {
            this.nativeEpos2ClearCommandBuffer(this.mDisplayHandle);
        }
        this.outputLogReturnFunction("clearCommandBuffer", 0, new Object[0]);
    }

    public void addInitialize() throws Epos2Exception {
        this.outputLogCallFunction("addInitialize", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = 0;
            errStatus = this.nativeEpos2AddInitialize(this.mDisplayHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addInitialize", ex);
            this.outputLogReturnFunction("addInitialize", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addInitialize", 0, new Object[0]);
    }

    public void addCreateWindow(int number, int x, int y, int width, int height, int scrollMode) throws Epos2Exception {
        this.outputLogCallFunction("addCreateWindow", number, x, y, width, height, scrollMode);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCreateWindow(this.mDisplayHandle, number, x, y, width, height, scrollMode);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCreateWindow", ex);
            this.outputLogReturnFunction("addCreateWindow", ex.getErrorStatus(), number, x, y, width, height, scrollMode);
            throw ex;
        }
        this.outputLogReturnFunction("addCreateWindow", 0, number, x, y, width, height, scrollMode);
    }

    public void addDestroyWindow(int number) throws Epos2Exception {
        this.outputLogCallFunction("addDestroyWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDestroyWindow(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addDestroyWindow", ex);
            this.outputLogReturnFunction("addDestroyWindow", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addDestroyWindow", 0, number);
    }

    public void addSetCurrentWindow(int number) throws Epos2Exception {
        this.outputLogCallFunction("addSetCurrentWindow", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCurrentWindow(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCurrentWindow", ex);
            this.outputLogReturnFunction("addSetCurrentWindow", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCurrentWindow", 0, number);
    }

    public void addClearCurrentWindow() throws Epos2Exception {
        this.outputLogCallFunction("addClearCurrentWindow", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddClearCurrentWindow(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addClearCurrentWindow", ex);
            this.outputLogReturnFunction("addClearCurrentWindow", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addClearCurrentWindow", 0, new Object[0]);
    }

    public void addSetCursorPosition(int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addSetCursorPosition", x, y);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCursorPosition(this.mDisplayHandle, x, y);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCursorPosition", ex);
            this.outputLogReturnFunction("addSetCursorPosition", ex.getErrorStatus(), x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCursorPosition", 0, x, y);
    }

    public void addMoveCursorPosition(int position) throws Epos2Exception {
        this.outputLogCallFunction("addMoveCursorPosition", position);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddMoveCursorPosition(this.mDisplayHandle, position);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addMoveCursorPosition", ex);
            this.outputLogReturnFunction("addMoveCursorPosition", ex.getErrorStatus(), position);
            throw ex;
        }
        this.outputLogReturnFunction("addMoveCursorPosition", 0, position);
    }

    public void addSetCursorType(int type) throws Epos2Exception {
        this.outputLogCallFunction("addSetCursorType", type);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCursorType(this.mDisplayHandle, type);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCursorType", ex);
            this.outputLogReturnFunction("addSetCursorType", ex.getErrorStatus(), type);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCursorType", 0, type);
    }

    public void addText(String data) throws Epos2Exception {
        this.outputLogCallFunction("addText", data);
        try {
            this.checkHandle();
            this.addText(data, -4, -4, -4, -4, -4, -4);
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data);
    }

    public void addText(String data, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, lang);
        try {
            this.checkHandle();
            this.addText(data, -4, -4, lang, -4, -4, -4);
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, lang);
    }

    public void addText(String data, int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, x, y);
        try {
            this.checkHandle();
            this.addText(data, x, y, -4, -4, -4, -4);
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, x, y);
    }

    public void addText(String data, int x, int y, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, x, y, lang);
        try {
            this.checkHandle();
            this.addText(data, x, y, lang, -4, -4, -4);
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, x, y, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, x, y, lang);
    }

    public void addText(String data, int x, int y, int lang, int r, int g, int b) throws Epos2Exception {
        this.outputLogCallFunction("addText", data, x, y, lang, r, g, b);
        try {
            this.checkHandle();
            int result = this.nativeEpos2DspAddText(this.mDisplayHandle, data, x, y, lang, r, g, b);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data, x, y, lang, r, g, b);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data, x, y, lang, r, g, b);
    }

    public void addReverseText(String data) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseText(this.mDisplayHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data);
    }

    public void addReverseText(String data, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextLang(this.mDisplayHandle, data, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, lang);
    }

    public void addReverseText(String data, int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, x, y);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextPosition(this.mDisplayHandle, data, x, y);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, x, y);
    }

    public void addReverseText(String data, int x, int y, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addReverseText", data, x, y, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddReverseTextPositionLang(this.mDisplayHandle, data, x, y, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addReverseText", ex);
            this.outputLogReturnFunction("addReverseText", ex.getErrorStatus(), data, x, y, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addReverseText", 0, data, x, y, lang);
    }

    public void addMarqueeText(String data, int format, int unitWait, int repeatWait, int repeatCount, int lang) throws Epos2Exception {
        this.outputLogCallFunction("addMarqueeText", data, format, unitWait, repeatWait, repeatCount, lang);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddMarqueeText(this.mDisplayHandle, data, format, unitWait, repeatWait, repeatCount, lang);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addMarqueeText", ex);
            this.outputLogReturnFunction("addMarqueeText", ex.getErrorStatus(), data, format, unitWait, repeatWait, repeatCount, lang);
            throw ex;
        }
        this.outputLogReturnFunction("addMarqueeText", 0, data, format, unitWait, repeatWait, repeatCount, lang);
    }

    public void addSetBlink(int interval) throws Epos2Exception {
        this.outputLogCallFunction("addSetBlink", interval);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetBlink(this.mDisplayHandle, interval);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetBlink", ex);
            this.outputLogReturnFunction("addSetBlink", ex.getErrorStatus(), interval);
            throw ex;
        }
        this.outputLogReturnFunction("addSetBlink", 0, interval);
    }

    public void addSetBrightness(int brightness) throws Epos2Exception {
        this.outputLogCallFunction("addSetBrightness", brightness);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetBrightness(this.mDisplayHandle, brightness);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetBrightness", ex);
            this.outputLogReturnFunction("addSetBrightness", ex.getErrorStatus(), brightness);
            throw ex;
        }
        this.outputLogReturnFunction("addSetBrightness", 0, brightness);
    }

    public void addShowClock() throws Epos2Exception {
        this.outputLogCallFunction("addShowClock", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddShowClock(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addShowClock", ex);
            this.outputLogReturnFunction("addShowClock", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addShowClock", 0, new Object[0]);
    }

    public void addCommand(byte[] data) throws Epos2Exception {
        this.outputLogCallFunction("addCommand", new Object[]{data});
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCommand(this.mDisplayHandle, data);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCommand", ex);
            this.outputLogReturnFunction("addCommand", ex.getErrorStatus(), new Object[]{data});
            throw ex;
        }
        this.outputLogReturnFunction("addCommand", 0, new Object[]{data});
    }

    public void setReceiveEventListener(ReceiveListener target) {
        this.outputLogCallFunction("setReceiveEventListener", target);
        if (this.mDisplayHandle != 0L) {
            this.mReceiveListener = target != null ? target : null;
        }
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mDisplayHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mDisplayHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mDisplayHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mDisplayHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    public void addCreateScreen(int mode) throws Epos2Exception {
        this.outputLogCallFunction("addCreateScreen", mode);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCreateScreen(this.mDisplayHandle, mode);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCreateScreen", ex);
            this.outputLogReturnFunction("addCreateScreen", ex.getErrorStatus(), mode);
            throw ex;
        }
        this.outputLogReturnFunction("addCreateScreen", 0, mode);
    }

    public void addCreateScreenCustom(int mode, int column, int row) throws Epos2Exception {
        this.outputLogCallFunction("addCreateScreenCustom", mode, column, row);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCreateScreenCustom(this.mDisplayHandle, mode, column, row);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCreateScreenCustom", ex);
            this.outputLogReturnFunction("addCreateScreenCustom", ex.getErrorStatus(), mode, column, row);
            throw ex;
        }
        this.outputLogReturnFunction("addCreateScreenCustom", 0, mode, column, row);
    }

    public void addBackgroundColor(int row, int r, int g, int b) throws Epos2Exception {
        this.outputLogCallFunction("addBackgroundColor", row, r, g, b);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddBackgroundColor(this.mDisplayHandle, row, r, g, b);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addBackgroundColor", ex);
            this.outputLogReturnFunction("addBackgroundColor", ex.getErrorStatus(), row, r, g, b);
            throw ex;
        }
        this.outputLogReturnFunction("addBackgroundColor", 0, row, r, g, b);
    }

    public void addStartSlideShow(int interval) throws Epos2Exception {
        this.outputLogCallFunction("addStartSlideShow", interval);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddStartSlideShow(this.mDisplayHandle, interval);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addStartSlideShow", ex);
            this.outputLogReturnFunction("addStartSlideShow", ex.getErrorStatus(), interval);
            throw ex;
        }
        this.outputLogReturnFunction("addStartSlideShow", 0, interval);
    }

    public void addStopSlideShow() throws Epos2Exception {
        this.outputLogCallFunction("addStopSlideShow", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddStopSlideShow(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addStopSlideShow", ex);
            this.outputLogReturnFunction("addStopSlideShow", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addStopSlideShow", 0, new Object[0]);
    }

    public void addSymbol(String data, int type, int level, int width, int height, int dotX, int dotY, int quietZone) throws Epos2Exception {
        this.outputLogCallFunction("addSymbol", data, type, level, width, height, dotX, dotY, quietZone);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDspSymbol(this.mDisplayHandle, data, type, level, width, height, dotX, dotY, quietZone);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSymbol", ex);
            this.outputLogReturnFunction("addSymbol", ex.getErrorStatus(), data, type, level, width, height, dotX, dotY, quietZone);
            throw ex;
        }
        this.outputLogReturnFunction("addSymbol", 0, data, type, level, width, height, dotX, dotY, quietZone);
    }

    public void addDownloadImage(int key1, int key2, int dotX, int dotY, int width, int height) throws Epos2Exception {
        this.outputLogCallFunction("addDownloadImage", key1, key2, dotX, dotY, width, height);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDspDownloadImage(this.mDisplayHandle, key1, key2, dotX, dotY, width, height);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addDownloadImage", ex);
            this.outputLogReturnFunction("addDownloadImage", ex.getErrorStatus(), key1, key2, dotX, dotY, width, height);
            throw ex;
        }
        this.outputLogReturnFunction("addDownloadImage", 0, key1, key2, dotX, dotY, width, height);
    }

    public void addRegisterDownloadImage(byte[] data, int key1, int key2) throws Epos2Exception {
        try {
            int binaryType;
            this.outputLogCallFunction("addRegisterDownloadImage", data, key1, key2);
            this.checkHandle();
            imageData = data;
            int length = 0;
            if (data != null) {
                length = data.length;
            }
            if ((binaryType = this.checkBinaryType(data, length)) == 0) {
                this.outputLogInfo("Binary Type UNKNOWN");
                throw new Epos2Exception(1);
            }
            this.convertBinaryData(binaryType, data);
            StringBuffer logString = this.createBinaryString(binaryType, imageData);
            this.outputLogInfo("Convert Binary Size(input) : ", length);
            this.outputLogInfo("Convert Binary Size(output) : ", imageData.length);
            this.outputLogInfo("Convert Binary Data : ", logString);
            int result = this.nativeEpos2AddDspRegisterDownloadImage(this.mDisplayHandle, imageData, key1, key2);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addRegisterDownloadImage", ex);
            this.outputLogReturnFunction("addRegisterDownloadImage", ex.getErrorStatus(), data, key1, key2);
            throw ex;
        }
        catch (Exception e) {
            this.outputLogReturnFunction("addRegisterDownloadImage(Exception) : " + e, 255, data, key1, key2);
            throw new Epos2Exception(255);
        }
        this.outputLogReturnFunction("addRegisterDownloadImage", 0, data, key1, key2);
    }

    public void addNVImage(int key1, int key2, int dotX, int dotY, int width, int height) throws Epos2Exception {
        this.outputLogCallFunction("addNVImage", key1, key2, dotX, dotY, width, height);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDspNVImage(this.mDisplayHandle, key1, key2, dotX, dotY, width, height);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addNVImage", ex);
            this.outputLogReturnFunction("addNVImage", ex.getErrorStatus(), key1, key2, dotX, dotY, width, height);
            throw ex;
        }
        this.outputLogReturnFunction("addNVImage", 0, key1, key2, dotX, dotY, width, height);
    }

    public void addClearImage() throws Epos2Exception {
        this.outputLogCallFunction("addClearImage", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDspClearImage(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addClearImage", ex);
            this.outputLogReturnFunction("addClearImage", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addClearImage", 0, new Object[0]);
    }

    public void addClearSymbol() throws Epos2Exception {
        this.outputLogCallFunction("addClearSymbol", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDspClearSymbol(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addClearSymbol", ex);
            this.outputLogReturnFunction("addClearSymbol", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addClearSymbol", 0, new Object[0]);
    }

    public void addCreateTextArea(int number, int x, int y, int width, int height, int scrollMode) throws Epos2Exception {
        this.outputLogCallFunction("addCreateTextArea", number, x, y, width, height, scrollMode);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddCreateTextArea(this.mDisplayHandle, number, x, y, width, height, scrollMode);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCreateTextArea", ex);
            this.outputLogReturnFunction("addCreateTextArea", ex.getErrorStatus(), number, x, y, width, height, scrollMode);
            throw ex;
        }
        this.outputLogReturnFunction("addCreateTextArea", 0, number, x, y, width, height, scrollMode);
    }

    public void addDestroyTextArea(int number) throws Epos2Exception {
        this.outputLogCallFunction("addDestroyTextArea", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddDestroyTextArea(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addDestroyTextArea", ex);
            this.outputLogReturnFunction("addDestroyTextArea", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addDestroyTextArea", 0, number);
    }

    public void addSetCurrentTextArea(int number) throws Epos2Exception {
        this.outputLogCallFunction("addSetCurrentTextArea", number);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddSetCurrentTextArea(this.mDisplayHandle, number);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSetCurrentTextArea", ex);
            this.outputLogReturnFunction("addSetCurrentTextArea", ex.getErrorStatus(), number);
            throw ex;
        }
        this.outputLogReturnFunction("addSetCurrentTextArea", 0, number);
    }

    public void addClearCurrentTextArea() throws Epos2Exception {
        this.outputLogCallFunction("addClearCurrentTextArea", new Object[0]);
        try {
            this.checkHandle();
            int result = this.nativeEpos2AddClearCurrentTextArea(this.mDisplayHandle);
            if (result != 0) {
                throw new Epos2Exception(result);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addClearCurrentTextArea", ex);
            this.outputLogReturnFunction("addClearCurrentTextArea", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addClearCurrentTextArea", 0, new Object[0]);
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mDisplayHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void onDispReceive(int code) {
        this.outputLogCallFunction("onDispReceive", code, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onDispReceive(this, code);
            this.outputLogEvent("onDispReceive", "code->", code);
        }
        this.outputLogReturnFunction("onDispReceive", 0, code, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    private void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mReadLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            this.mReadLogSettingsMethod.setAccessible(true);
            this.mOutputLogInfoMethod = this.mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            this.mOutputLogInfoMethod.setAccessible(true);
            this.mReadLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mDisplayHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outputLogInfo(Object ... param) {
        try {
            this.mOutputLogInfoMethod.invoke(this.mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        connection = 0;
    }
}

