/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.content.Context;
import android.graphics.Bitmap;
import com.epson.epos2.Epos2Exception;
import java.lang.reflect.Method;
import java.util.ArrayList;

abstract class CommonPrinter {
    Class<?> APMClass;
    Object APMInstance;
    boolean APMPresent;
    long mPrinterHandle = 0L;
    Context mContext = null;
    ArrayList<Byte> commandBuffer;
    String mConnectedTarget = null;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_UNSPECIFIED = -1;
    public static final int PARAM_DEFAULT = -2;
    public static final int UNKNOWN = -3;
    public static final int MODEL_ANK = 0;
    public static final int MODEL_JAPANESE = 1;
    public static final int MODEL_CHINESE = 2;
    public static final int MODEL_TAIWAN = 3;
    public static final int MODEL_KOREAN = 4;
    public static final int MODEL_THAI = 5;
    public static final int MODEL_SOUTHASIA = 6;
    private static final int GET_COMMAND_BODY = 0;
    private static final int GET_COMMAND_HEADER = 1;
    private static final int GET_COMMAND_FOOTER = 2;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int LANG_ZH_CN = 2;
    public static final int LANG_ZH_TW = 3;
    public static final int LANG_KO = 4;
    public static final int LANG_TH = 5;
    public static final int LANG_VI = 6;
    public static final int LANG_MULTI = 7;
    public static final int FONT_A = 0;
    public static final int FONT_B = 1;
    public static final int FONT_C = 2;
    public static final int FONT_D = 3;
    public static final int FONT_E = 4;
    public static final int COLOR_NONE = 0;
    public static final int COLOR_1 = 1;
    public static final int COLOR_2 = 2;
    public static final int COLOR_3 = 3;
    public static final int COLOR_4 = 4;
    public static final int MODE_MONO = 0;
    public static final int MODE_GRAY16 = 1;
    public static final int MODE_MONO_HIGH_DENSITY = 2;
    public static final int HALFTONE_DITHER = 0;
    public static final int HALFTONE_ERROR_DIFFUSION = 1;
    public static final int HALFTONE_THRESHOLD = 2;
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_DEFLATE = 1;
    public static final int COMPRESS_AUTO = 2;
    public static final int BARCODE_UPC_A = 0;
    public static final int BARCODE_UPC_E = 1;
    public static final int BARCODE_EAN13 = 2;
    public static final int BARCODE_JAN13 = 3;
    public static final int BARCODE_EAN8 = 4;
    public static final int BARCODE_JAN8 = 5;
    public static final int BARCODE_CODE39 = 6;
    public static final int BARCODE_ITF = 7;
    public static final int BARCODE_CODABAR = 8;
    public static final int BARCODE_CODE93 = 9;
    public static final int BARCODE_CODE128 = 10;
    public static final int BARCODE_GS1_128 = 11;
    public static final int BARCODE_GS1_DATABAR_OMNIDIRECTIONAL = 12;
    public static final int BARCODE_GS1_DATABAR_TRUNCATED = 13;
    public static final int BARCODE_GS1_DATABAR_LIMITED = 14;
    public static final int BARCODE_GS1_DATABAR_EXPANDED = 15;
    public static final int BARCODE_CODE128_AUTO = 16;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int SYMBOL_PDF417_STANDARD = 0;
    public static final int SYMBOL_PDF417_TRUNCATED = 1;
    public static final int SYMBOL_QRCODE_MODEL_1 = 2;
    public static final int SYMBOL_QRCODE_MODEL_2 = 3;
    public static final int SYMBOL_QRCODE_MICRO = 4;
    public static final int SYMBOL_MAXICODE_MODE_2 = 5;
    public static final int SYMBOL_MAXICODE_MODE_3 = 6;
    public static final int SYMBOL_MAXICODE_MODE_4 = 7;
    public static final int SYMBOL_MAXICODE_MODE_5 = 8;
    public static final int SYMBOL_MAXICODE_MODE_6 = 9;
    public static final int SYMBOL_GS1_DATABAR_STACKED = 10;
    public static final int SYMBOL_GS1_DATABAR_STACKED_OMNIDIRECTIONAL = 11;
    public static final int SYMBOL_GS1_DATABAR_EXPANDED_STACKED = 12;
    public static final int SYMBOL_AZTECCODE_FULLRANGE = 13;
    public static final int SYMBOL_AZTECCODE_COMPACT = 14;
    public static final int SYMBOL_DATAMATRIX_SQUARE = 15;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_8 = 16;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_12 = 17;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_16 = 18;
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    public static final int LEVEL_4 = 4;
    public static final int LEVEL_5 = 5;
    public static final int LEVEL_6 = 6;
    public static final int LEVEL_7 = 7;
    public static final int LEVEL_8 = 8;
    public static final int LEVEL_L = 9;
    public static final int LEVEL_M = 10;
    public static final int LEVEL_Q = 11;
    public static final int LEVEL_H = 12;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_BOTTOM_TO_TOP = 1;
    public static final int DIRECTION_RIGHT_TO_LEFT = 2;
    public static final int DIRECTION_TOP_TO_BOTTOM = 3;
    public static final int LINE_THIN = 0;
    public static final int LINE_MEDIUM = 1;
    public static final int LINE_THICK = 2;
    public static final int LINE_THIN_DOUBLE = 3;
    public static final int LINE_MEDIUM_DOUBLE = 4;
    public static final int LINE_THICK_DOUBLE = 5;
    public static final int CUT_NO_FEED = 0;
    public static final int CUT_FEED = 1;
    public static final int CUT_RESERVE = 2;
    public static final int FULL_CUT_FEED = 3;
    public static final int FULL_CUT_NO_FEED = 4;
    public static final int FULL_CUT_RESERVE = 5;
    public static final int DRAWER_2PIN = 0;
    public static final int DRAWER_5PIN = 1;
    public static final int PULSE_100 = 0;
    public static final int PULSE_200 = 1;
    public static final int PULSE_300 = 2;
    public static final int PULSE_400 = 3;
    public static final int PULSE_500 = 4;
    public static final int PATTERN_NONE = 0;
    public static final int PATTERN_A = 1;
    public static final int PATTERN_B = 2;
    public static final int PATTERN_C = 3;
    public static final int PATTERN_D = 4;
    public static final int PATTERN_E = 5;
    public static final int PATTERN_ERROR = 6;
    public static final int PATTERN_PAPER_EMPTY = 7;
    public static final int PATTERN_1 = 8;
    public static final int PATTERN_2 = 9;
    public static final int PATTERN_3 = 10;
    public static final int PATTERN_4 = 11;
    public static final int PATTERN_5 = 12;
    public static final int PATTERN_6 = 13;
    public static final int PATTERN_7 = 14;
    public static final int PATTERN_8 = 15;
    public static final int PATTERN_9 = 16;
    public static final int PATTERN_10 = 17;
    public static final int FEED_PEELING = 0;
    public static final int FEED_CUTTING = 1;
    public static final int FEED_CURRENT_TOF = 2;
    public static final int FEED_NEXT_TOF = 3;
    public static final int PAPER_OK = 0;
    public static final int PAPER_NEAR_END = 1;
    public static final int PAPER_EMPTY = 2;
    public static final int SWITCH_OFF = 0;
    public static final int SWITCH_ON = 1;
    public static final int DRAWER_HIGH = 0;
    public static final int DRAWER_LOW = 1;
    public static final int NO_ERR = 0;
    public static final int MECHANICAL_ERR = 1;
    public static final int AUTOCUTTER_ERR = 2;
    public static final int UNRECOVER_ERR = 3;
    public static final int AUTORECOVER_ERR = 4;
    public static final int HEAD_OVERHEAT = 0;
    public static final int MOTOR_OVERHEAT = 1;
    public static final int BATTERY_OVERHEAT = 2;
    public static final int WRONG_PAPER = 3;
    public static final int COVER_OPEN = 4;
    public static final int REMOVAL_WAIT_PAPER = 0;
    public static final int REMOVAL_WAIT_NONE = 1;
    public static final int EVENT_ONLINE = 0;
    public static final int EVENT_OFFLINE = 1;
    public static final int EVENT_POWER_OFF = 2;
    public static final int EVENT_COVER_CLOSE = 3;
    public static final int EVENT_COVER_OPEN = 4;
    public static final int EVENT_PAPER_OK = 5;
    public static final int EVENT_PAPER_NEAR_END = 6;
    public static final int EVENT_PAPER_EMPTY = 7;
    public static final int EVENT_DRAWER_HIGH = 8;
    public static final int EVENT_DRAWER_LOW = 9;
    public static final int EVENT_RECONNECTING = 0;
    public static final int EVENT_RECONNECT = 1;
    public static final int EVENT_DISCONNECT = 2;
    static final int NO_EXCEPTION = 0;
    static final int RETURN_NULL_CHARACTER = 256;
    static final int RETURN_NULL = 257;
    int mInterval = 3000;
    private static final int INTERVAL_DEFAULT = 3000;
    private static final int MIN_IMAGE_WIDTH = 1;
    private static final int MIN_IMAGE_HEIGHT = 1;
    private Class<?> mClassOutputLog = null;
    private Method mOutputLogCallFunctionMethod = null;
    private Method mOutputLogReturnFunctionMethod = null;
    private Method mOutputExceptionMethod = null;
    private Method mOutputLogEventMethod = null;
    private Method mOutputLogInfoMethod = null;

    CommonPrinter() {
    }

    protected native int nativeEpos2ClearCommandBuffer(long var1);

    protected native int nativeEpos2StartMonitor(long var1);

    protected native int nativeEpos2StopMonitor(long var1);

    protected native int nativeEpos2BeginTransaction(long var1);

    protected native int nativeEpos2EndTransaction(long var1);

    protected native int nativeEpos2GetCommandBuffer(long var1, int var3);

    protected native int nativeEpos2AddTextAlign(long var1, int var3);

    protected native int nativeEpos2AddLineSpace(long var1, long var3);

    protected native int nativeEpos2AddTextRotate(long var1, int var3);

    protected native int nativeEpos2AddText(long var1, String var3);

    protected native int nativeEpos2AddTextLang(long var1, int var3);

    protected native int nativeEpos2AddTextFont(long var1, int var3);

    protected native int nativeEpos2AddTextSmooth(long var1, int var3);

    protected native int nativeEpos2AddTextSize(long var1, long var3, long var5);

    protected native int nativeEpos2AddTextStyle(long var1, int var3, int var4, int var5, int var6);

    protected native int nativeEpos2AddHPosition(long var1, long var3);

    protected native int nativeEpos2AddFeedUnit(long var1, long var3);

    protected native int nativeEpos2AddFeedLine(long var1, long var3);

    protected native int nativeEpos2AddImage(long var1, byte[] var3, long var4, long var6, long var8, long var10, long var12, long var14, int var16, int var17, int var18, double var19, int var21);

    protected native int nativeEpos2AddLogo(long var1, long var3, long var5);

    protected native int nativeEpos2AddBarcode(long var1, String var3, int var4, int var5, int var6, long var7, long var9);

    protected native int nativeEpos2AddSymbol(long var1, String var3, int var4, int var5, long var6, long var8, long var10);

    protected native int nativeEpos2AddPageBegin(long var1);

    protected native int nativeEpos2AddPageEnd(long var1);

    protected native int nativeEpos2AddPageArea(long var1, long var3, long var5, long var7, long var9);

    protected native int nativeEpos2AddPageDirection(long var1, int var3);

    protected native int nativeEpos2AddPagePosition(long var1, long var3, long var5);

    protected native int nativeEpos2AddPageLine(long var1, long var3, long var5, long var7, long var9, int var11);

    protected native int nativeEpos2AddPageRectangle(long var1, long var3, long var5, long var7, long var9, int var11);

    protected native int nativeEpos2AddCut(long var1, int var3);

    protected native int nativeEpos2AddPulse(long var1, int var3, int var4);

    protected native int nativeEpos2AddSound(long var1, int var3, long var4, long var6);

    protected native int nativeEpos2AddFeedPosition(long var1, int var3);

    protected native int nativeEpos2AddRotateBegin(long var1);

    protected native int nativeEpos2AddRotateEnd(long var1);

    protected native int nativeEpos2AddCommand(long var1, byte[] var3);

    protected native int nativeEpos2ForceRecover(long var1, int var3);

    protected native int nativeEpos2ForcePulse(long var1, int var3, int var4, int var5);

    protected native int nativeEpos2ForceReset(long var1, int var3);

    protected native int nativeEpos2SetInterval(long var1, long var3);

    protected void checkHandle() throws Epos2Exception {
        if (this.mPrinterHandle == 0L) {
            throw new Epos2Exception(255);
        }
    }

    private long getEdcHandle() {
        return this.mPrinterHandle;
    }

    public void clearCommandBuffer() {
        this.outputLogCallFunction("clearCommandBuffer", new Object[0]);
        if (this.getEdcHandle() != 0L) {
            this.nativeEpos2ClearCommandBuffer(this.getEdcHandle());
        }
        this.outputLogReturnFunction("clearCommandBuffer", 0, new Object[0]);
    }

    public void startMonitor() throws Epos2Exception {
        this.outputLogCallFunction("startMonitor", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2StartMonitor(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("startMonitor", ex);
            this.outputLogReturnFunction("startMonitor", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("startMonitor", 0, new Object[0]);
    }

    public void stopMonitor() throws Epos2Exception {
        this.outputLogCallFunction("stopMonitor", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2StopMonitor(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("stopMonitor", ex);
            this.outputLogReturnFunction("stopMonitor", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("stopMonitor", 0, new Object[0]);
    }

    public void beginTransaction() throws Epos2Exception {
        this.outputLogCallFunction("beginTransaction", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2BeginTransaction(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("beginTransaction", ex);
            this.outputLogReturnFunction("beginTransaction", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("beginTransaction", 0, new Object[0]);
    }

    public void endTransaction() throws Epos2Exception {
        this.outputLogCallFunction("endTransaction", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2EndTransaction(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("endTransaction", ex);
            this.outputLogReturnFunction("endTransaction", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("endTransaction", 0, new Object[0]);
    }

    private void addCommandBuffer(int command) {
        if (this.commandBuffer != null) {
            this.commandBuffer.add((byte)command);
        }
    }

    private void getCommandBuffer(ArrayList<Byte> commandData, int flag) throws Epos2Exception {
        this.outputLogCallFunction("getCommandBuffer", flag);
        try {
            this.checkHandle();
            if (commandData == null) {
                throw new Epos2Exception(1);
            }
            this.commandBuffer = commandData;
            int errStatus = this.nativeEpos2GetCommandBuffer(this.getEdcHandle(), flag);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getCommandBuffer", ex);
            this.outputLogReturnFunction("getCommandBuffer", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        finally {
            this.commandBuffer = null;
        }
        this.outputLogReturnFunction("getCommandBuffer", 0, flag);
    }

    public void addTextAlign(int align) throws Epos2Exception {
        this.outputLogCallFunction("addTextAlign", align);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextAlign(this.getEdcHandle(), align);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextAlign", ex);
            this.outputLogReturnFunction("addTextAlign", ex.getErrorStatus(), align);
            throw ex;
        }
        this.outputLogReturnFunction("addTextAlign", 0, align);
    }

    public void addLineSpace(int linespc) throws Epos2Exception {
        this.outputLogCallFunction("addLineSpace", linespc);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddLineSpace(this.getEdcHandle(), linespc);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addLineSpace", ex);
            this.outputLogReturnFunction("addLineSpace", ex.getErrorStatus(), linespc);
            throw ex;
        }
        this.outputLogReturnFunction("addLineSpace", 0, linespc);
    }

    public void addTextRotate(int rotate) throws Epos2Exception {
        this.outputLogCallFunction("addTextRotate", rotate);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextRotate(this.getEdcHandle(), rotate);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextRotate", ex);
            this.outputLogReturnFunction("addTextRotate", ex.getErrorStatus(), rotate);
            throw ex;
        }
        this.outputLogReturnFunction("addTextRotate", 0, rotate);
    }

    public void addText(String data) throws Epos2Exception {
        this.outputLogCallFunction("addText", data);
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            try {
                this.APMClass = Class.forName("eu.epson.rdc.apm.APMInterface");
                if (this.APMInstance == null) {
                    this.APMInstance = this.APMClass.newInstance();
                    Method APMInitMethod = this.APMClass.getMethod("APMInitialize", Context.class);
                    Object initReturn = APMInitMethod.invoke(this.APMInstance, this.mContext);
                    this.APMPresent = (Boolean)initReturn;
                }
                if (this.APMClass != null && this.APMInstance != null && this.APMPresent) {
                    String returnText;
                    Method APMProcessMethod = this.APMClass.getMethod("APMProcessChars", String.class);
                    Object returnObj = APMProcessMethod.invoke(this.APMInstance, data);
                    data = returnText = (String)returnObj;
                }
            }
            catch (ClassNotFoundException APMProcessMethod) {
            }
            catch (IllegalArgumentException e) {
                this.outputLogCallFunction("APM IllegalArgumentException: ", e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.outputLogCallFunction("APM IllegalAccessException: ", e.getMessage());
            }
            catch (Exception e) {
                this.outputLogCallFunction("APM Exception: ", e.getMessage());
            }
            int errStatus = this.nativeEpos2AddText(this.getEdcHandle(), data);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addText", ex);
            this.outputLogReturnFunction("addText", ex.getErrorStatus(), data);
            throw ex;
        }
        this.outputLogReturnFunction("addText", 0, data);
    }

    public void addTextLang(int lang) throws Epos2Exception {
        this.outputLogCallFunction("addTextLang", lang);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextLang(this.getEdcHandle(), lang);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextLang", ex);
            this.outputLogReturnFunction("addTextLang", ex.getErrorStatus(), lang);
            throw ex;
        }
        this.outputLogReturnFunction("addTextLang", 0, lang);
    }

    public void addTextFont(int font) throws Epos2Exception {
        this.outputLogCallFunction("addTextFont", font);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextFont(this.getEdcHandle(), font);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextFont", ex);
            this.outputLogReturnFunction("addTextFont", ex.getErrorStatus(), font);
            throw ex;
        }
        this.outputLogReturnFunction("addTextFont", 0, font);
    }

    public void addTextSmooth(int smooth) throws Epos2Exception {
        this.outputLogCallFunction("addTextSmooth", smooth);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextSmooth(this.getEdcHandle(), smooth);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextSmooth", ex);
            this.outputLogReturnFunction("addTextSmooth", ex.getErrorStatus(), smooth);
            throw ex;
        }
        this.outputLogReturnFunction("addTextSmooth", 0, smooth);
    }

    public void addTextSize(int width, int height) throws Epos2Exception {
        this.outputLogCallFunction("addTextSize", width, height);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextSize(this.getEdcHandle(), width, height);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextSize", ex);
            this.outputLogReturnFunction("addTextSize", ex.getErrorStatus(), width, height);
            throw ex;
        }
        this.outputLogReturnFunction("addTextSize", 0, width, height);
    }

    public void addTextStyle(int reverse, int ul, int em, int color2) throws Epos2Exception {
        this.outputLogCallFunction("addTextStyle", reverse, ul, em, color2);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddTextStyle(this.getEdcHandle(), reverse, ul, em, color2);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextStyle", ex);
            this.outputLogReturnFunction("addTextStyle", ex.getErrorStatus(), reverse, ul, em, color2);
            throw ex;
        }
        this.outputLogReturnFunction("addTextStyle", 0, reverse, ul, em, color2);
    }

    public void addHPosition(int x) throws Epos2Exception {
        this.outputLogCallFunction("addTextPosition", x);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddHPosition(this.getEdcHandle(), x);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addTextPosition", ex);
            this.outputLogReturnFunction("addTextPosition", ex.getErrorStatus(), x);
            throw ex;
        }
        this.outputLogReturnFunction("addTextPosition", 0, x);
    }

    public void addFeedUnit(int unit) throws Epos2Exception {
        this.outputLogCallFunction("addFeedUnit", unit);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddFeedUnit(this.getEdcHandle(), unit);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addFeedUnit", ex);
            this.outputLogReturnFunction("addFeedUnit", ex.getErrorStatus(), unit);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedUnit", 0, unit);
    }

    public void addFeedLine(int line) throws Epos2Exception {
        this.outputLogCallFunction("addFeedLine", line);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddFeedLine(this.getEdcHandle(), line);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addFeedLine", ex);
            this.outputLogReturnFunction("addFeedLine", ex.getErrorStatus(), line);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedLine", 0, line);
    }

    public void addImage(Bitmap data, int x, int y, int width, int height, int color2, int mode, int halftone, double brightness, int compress) throws Epos2Exception {
        this.outputLogCallFunction("addImage", data, x, y, width, height, color2, mode);
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            int bgrBytePerPixel = 3;
            int maxByteValue = 255;
            int srcWidth = data.getWidth();
            int srcHeight = data.getHeight();
            int byteMask = 255;
            int shiftBitForAlpha = 24;
            int shiftBitForRed = 16;
            int shiftBitForGreen = 8;
            int srcPos = 0;
            int dstPos = 0;
            int alpha = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int line = 0;
            int row = 0;
            int[] lineBuf = new int[srcWidth];
            int divTableSize = 256;
            double[] divTable = new double[256];
            if (1 > srcWidth || 1 > srcHeight) {
                throw new Epos2Exception(1);
            }
            Bitmap image = null;
            if (data.getConfig() == Bitmap.Config.ARGB_8888) {
                image = data;
            } else {
                image = data.copy(Bitmap.Config.ARGB_8888, false);
                if (image == null) {
                    throw new Epos2Exception(4);
                }
            }
            for (int i = 0; i < 256; ++i) {
                divTable[i] = 1.0 - (double)i / 255.0;
            }
            byte[] imageBGR = new byte[3 * srcWidth * srcHeight];
            for (line = 0; line < srcHeight; ++line) {
                image.getPixels(lineBuf, 0, srcWidth, 0, line, srcWidth, 1);
                srcPos = 0;
                for (row = 0; row < srcWidth; ++row) {
                    alpha = lineBuf[srcPos] >> 24 & 0xFF;
                    r = lineBuf[srcPos] >> 16 & 0xFF;
                    g = lineBuf[srcPos] >> 8 & 0xFF;
                    b = lineBuf[srcPos] & 0xFF;
                    if (255 == alpha) {
                        imageBGR[dstPos] = (byte)b;
                        imageBGR[dstPos + 1] = (byte)g;
                        imageBGR[dstPos + 2] = (byte)r;
                    } else if (0 == alpha) {
                        imageBGR[dstPos] = -1;
                        imageBGR[dstPos + 1] = -1;
                        imageBGR[dstPos + 2] = -1;
                    } else {
                        imageBGR[dstPos] = (byte)(255.0 - (double)alpha * divTable[b]);
                        imageBGR[dstPos + 1] = (byte)(255.0 - (double)alpha * divTable[g]);
                        imageBGR[dstPos + 2] = (byte)(255.0 - (double)alpha * divTable[r]);
                    }
                    dstPos += 3;
                    ++srcPos;
                }
            }
            int errStatus = this.nativeEpos2AddImage(this.getEdcHandle(), imageBGR, srcWidth, srcHeight, x, y, width, height, color2, mode, halftone, brightness, compress);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addImage", ex);
            this.outputLogReturnFunction("addImage", ex.getErrorStatus(), data, x, y, width, height, color2, mode);
            throw ex;
        }
        catch (OutOfMemoryError ex) {
            Epos2Exception eposEx = new Epos2Exception(4);
            this.outputException("addImage", eposEx);
            throw eposEx;
        }
        this.outputLogReturnFunction("addImage", 0, data, x, y, width, height, color2, mode);
    }

    public void addLogo(int key1, int key2) throws Epos2Exception {
        this.outputLogCallFunction("addLogo", key1, key2);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddLogo(this.getEdcHandle(), key1, key2);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addLogo", ex);
            this.outputLogReturnFunction("addLogo", ex.getErrorStatus(), key1, key2);
            throw ex;
        }
        this.outputLogReturnFunction("addLogo", 0, key1, key2);
    }

    public void addBarcode(String data, int type, int hri, int font, int width, int height) throws Epos2Exception {
        this.outputLogCallFunction("addBarcode", data, type, hri, font, width);
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            int errStatus = this.nativeEpos2AddBarcode(this.getEdcHandle(), data, type, hri, font, width, height);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addBarcode", ex);
            this.outputLogReturnFunction("addBarcode", ex.getErrorStatus(), data, type, hri, font, width);
            throw ex;
        }
        this.outputLogReturnFunction("addBarcode", 0, data, type, hri, font, width);
    }

    public void addSymbol(String data, int type, int level, int width, int height, int size) throws Epos2Exception {
        this.outputLogCallFunction("addSymbol", data, type, level, width, height, size);
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            int errStatus = this.nativeEpos2AddSymbol(this.getEdcHandle(), data, type, level, width, height, size);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSymbol", ex);
            this.outputLogReturnFunction("addSymbol", ex.getErrorStatus(), data, type, level, width, height, size);
            throw ex;
        }
        this.outputLogReturnFunction("addSymbol", 0, data, type, level, width, height, size);
    }

    public void addPageBegin() throws Epos2Exception {
        this.outputLogCallFunction("addPageBegin", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageBegin(this.getEdcHandle());
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageBegin", ex);
            this.outputLogReturnFunction("addPageBegin", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addPageBegin", 0, new Object[0]);
    }

    public void addPageEnd() throws Epos2Exception {
        this.outputLogCallFunction("addPageEnd", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageEnd(this.getEdcHandle());
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageEnd", ex);
            this.outputLogReturnFunction("addPageEnd", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addPageEnd", 0, new Object[0]);
    }

    public void addPageArea(int x, int y, int width, int height) throws Epos2Exception {
        this.outputLogCallFunction("addPageArea", x, y, width, height);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageArea(this.getEdcHandle(), x, y, width, height);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageArea", ex);
            this.outputLogReturnFunction("addPageArea", ex.getErrorStatus(), x, y, width, height);
            throw ex;
        }
        this.outputLogReturnFunction("addPageArea", 0, x, y, width, height);
    }

    public void addPageDirection(int direction) throws Epos2Exception {
        this.outputLogCallFunction("addPageDirection", direction);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageDirection(this.getEdcHandle(), direction);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageDirection", ex);
            this.outputLogReturnFunction("addPageDirection", ex.getErrorStatus(), direction);
            throw ex;
        }
        this.outputLogReturnFunction("addPageDirection", 0, direction);
    }

    public void addPagePosition(int x, int y) throws Epos2Exception {
        this.outputLogCallFunction("addPagePosition", x, y);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPagePosition(this.getEdcHandle(), x, y);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPagePosition", ex);
            this.outputLogReturnFunction("addPagePosition", ex.getErrorStatus(), x, y);
            throw ex;
        }
        this.outputLogReturnFunction("addPagePosition", 0, x, y);
    }

    public void addPageLine(int x1, int y1, int x2, int y2, int style) throws Epos2Exception {
        this.outputLogCallFunction("addPageLine", x1, y1, x2, y2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageLine(this.getEdcHandle(), x1, y1, x2, y2, style);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageLine", ex);
            this.outputLogReturnFunction("addPageLine", ex.getErrorStatus(), x1, y1, x2, y2, style);
            throw ex;
        }
        this.outputLogReturnFunction("addPageLine", 0, x1, y1, x2, y2, style);
    }

    public void addPageRectangle(int x1, int y1, int x2, int y2, int style) throws Epos2Exception {
        this.outputLogCallFunction("addPageRectangle", x1, y1, x2, y2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPageRectangle(this.getEdcHandle(), x1, y1, x2, y2, style);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPageRectangle", ex);
            this.outputLogReturnFunction("addPageRectangle", ex.getErrorStatus(), x1, y1, x2, y2, style);
            throw ex;
        }
        this.outputLogReturnFunction("addPageRectangle", 0, x1, y1, x2, y2, style);
    }

    public void addCut(int type) throws Epos2Exception {
        this.outputLogCallFunction("addCut", type);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddCut(this.getEdcHandle(), type);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCut", ex);
            this.outputLogReturnFunction("addCut", ex.getErrorStatus(), type);
            throw ex;
        }
        this.outputLogReturnFunction("addCut", 0, type);
    }

    public void addPulse(int drawer, int time) throws Epos2Exception {
        this.outputLogCallFunction("addPulse", drawer, time);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddPulse(this.getEdcHandle(), drawer, time);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addPulse", ex);
            this.outputLogReturnFunction("addPulse", ex.getErrorStatus(), drawer, time);
            throw ex;
        }
        this.outputLogReturnFunction("addPulse", 0, drawer, time);
    }

    public void addSound(int pattern, int repeat, int cycle) throws Epos2Exception {
        this.outputLogCallFunction("addSound", pattern, repeat, cycle);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddSound(this.mPrinterHandle, pattern, repeat, cycle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addSound", ex);
            this.outputLogReturnFunction("addSound", ex.getErrorStatus(), pattern, repeat, cycle);
            throw ex;
        }
        this.outputLogReturnFunction("addSound", 0, pattern, repeat, cycle);
    }

    public void addFeedPosition(int position) throws Epos2Exception {
        this.outputLogCallFunction("addFeedPosition", position);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddFeedPosition(this.mPrinterHandle, position);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addFeedPosition", ex);
            this.outputLogReturnFunction("addFeedPosition", ex.getErrorStatus(), position);
            throw ex;
        }
        this.outputLogReturnFunction("addFeedPosition", 0, position);
    }

    public void addRotateBegin() throws Epos2Exception {
        this.outputLogCallFunction("addRotateBegin", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddRotateBegin(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addRotateBegin", ex);
            this.outputLogReturnFunction("addRotateBegin", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addRotateBegin", 0, new Object[0]);
    }

    public void addRotateEnd() throws Epos2Exception {
        this.outputLogCallFunction("addRotateEnd", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddRotateEnd(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addRotateEnd", ex);
            this.outputLogReturnFunction("addRotateEnd", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("addRotateEnd", 0, new Object[0]);
    }

    public void addCommand(byte[] data) throws Epos2Exception {
        this.outputLogCallFunction("addCommand", new Object[]{data});
        try {
            this.checkHandle();
            if (null == data) {
                throw new Epos2Exception(1);
            }
            int errStatus = this.nativeEpos2AddCommand(this.getEdcHandle(), data);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addCommand", ex);
            this.outputLogReturnFunction("addCommand", ex.getErrorStatus(), new Object[]{data});
            throw ex;
        }
        this.outputLogReturnFunction("addCommand", 0, new Object[]{data});
    }

    public void forceRecover(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forceRecover", timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForceRecover(this.mPrinterHandle, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forceRecover", ex);
            this.outputLogReturnFunction("forceRecover", ex.getErrorStatus(), timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forceRecover", 0, timeout);
    }

    public void forcePulse(int drawer, int pulseTime, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forcePulse", drawer, pulseTime, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForcePulse(this.mPrinterHandle, drawer, pulseTime, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forcePulse", ex);
            this.outputLogReturnFunction("forcePulse", ex.getErrorStatus(), drawer, pulseTime, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forcePulse", 0, drawer, pulseTime, timeout);
    }

    public void forceReset(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forceReset", timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForceReset(this.mPrinterHandle, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forceReset", ex);
            this.outputLogReturnFunction("forceReset", ex.getErrorStatus(), timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forceReset", 0, timeout);
    }

    public void setInterval(int interval) throws Epos2Exception {
        this.outputLogCallFunction("setInterval", interval);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SetInterval(this.mPrinterHandle, interval);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mInterval = interval;
        }
        catch (Epos2Exception ex) {
            this.outputException("setInterval", ex);
            this.outputLogReturnFunction("setInterval", ex.getErrorStatus(), interval);
            throw ex;
        }
        this.outputLogReturnFunction("setInterval", 0, interval);
    }

    public int getInterval() {
        return this.mInterval;
    }

    void initializeOuputLogFunctions(Context context) throws Epos2Exception {
        try {
            this.mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            this.mOutputLogCallFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogCallFunction", String.class, Long.TYPE, Object[].class);
            this.mOutputLogCallFunctionMethod.setAccessible(true);
            this.mOutputLogReturnFunctionMethod = this.mClassOutputLog.getDeclaredMethod("outputLogReturnFunction", String.class, Long.TYPE, Integer.TYPE, Object[].class);
            this.mOutputLogReturnFunctionMethod.setAccessible(true);
            this.mOutputExceptionMethod = this.mClassOutputLog.getDeclaredMethod("outputException", String.class, Long.TYPE, Exception.class);
            this.mOutputExceptionMethod.setAccessible(true);
            this.mOutputLogEventMethod = this.mClassOutputLog.getDeclaredMethod("outputLogEvent", String.class, Long.TYPE, Object[].class);
            this.mOutputLogEventMethod.setAccessible(true);
            this.mOutputLogInfoMethod = this.mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            this.mOutputLogInfoMethod.setAccessible(true);
            Method readLogSettingsMethod = this.mClassOutputLog.getDeclaredMethod("readLogSettings", Context.class);
            readLogSettingsMethod.setAccessible(true);
            readLogSettingsMethod.invoke(this.mClassOutputLog, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void outputLogCallFunction(String methodName, Object ... param) {
        try {
            this.mOutputLogCallFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mPrinterHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void outputLogReturnFunction(String methodName, int result, Object ... param) {
        try {
            this.mOutputLogReturnFunctionMethod.invoke(this.mClassOutputLog, methodName, this.mPrinterHandle, result, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void outputException(String methodName, Exception exception) {
        try {
            this.mOutputExceptionMethod.invoke(this.mClassOutputLog, methodName, this.mPrinterHandle, exception);
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    void outputLogEvent(String methodName, Object ... param) {
        try {
            this.mOutputLogEventMethod.invoke(this.mClassOutputLog, methodName, this.mPrinterHandle, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void outputLogInfo(Object ... param) {
        try {
            this.mOutputLogInfoMethod.invoke(this.mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

