/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class EfxExtractor {
    private static final byte[] DSC_PDATA = new byte[]{68, 0, 83, 0, 67, 0, 95, 0, 80, 0, 68, 0, 65, 0, 84, 0, 65, 0};
    private static final int LocalFile_filesizeOffset = 18;
    private static final int LocalFile_filesizeLength = 4;
    private static final int LocalFile_filenameLengthOffset = 26;
    private static final int LocalFile_filenameLengthLength = 2;
    private static final int LocalFile_expandedFieldLengthLength = 2;
    private static final int CentralDir_filenameLengthOffset = 28;
    private static final int CentralDir_filenameLengthLength = 2;
    private static final int CentralDir_expandedFieldLengthLength = 2;
    private static final int CentralDir_filecommentLengthOffset = 32;
    private static final int CentralDir_filecommentLengthLength = 2;
    private static final int CentralDir_filenameOffset = 46;
    private static final int EndOfCentralDir_filecommentLengthOffset = 20;
    private static final int EndOfCentralDir_filecommentLengthLength = 2;
    private static final int BUFFER_SIZE = 0x100000;
    private static final long MAX_FILE_SIZE = 0xC800000L;

    private EfxExtractor() {
    }

    private static boolean findZipStart(InputStream inputStream) {
        int readByte = 0;
        int dsc_pdata_index = 0;
        try {
            while ((readByte = inputStream.read()) != -1) {
                if ((byte)(0xFF & readByte) == DSC_PDATA[dsc_pdata_index]) {
                    if (++dsc_pdata_index < DSC_PDATA.length) continue;
                    break;
                }
                dsc_pdata_index = 0;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static byte[] getLocalFileHeaderWithCopying(InputStream inputStream, OutputStream outputStream) {
        int readByte = 0;
        ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < 26; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    headerStream.close();
                    return new byte[0];
                }
                headerStream.write(readByte);
            }
            long filenameLength = 0L;
            for (int i = 0; i < 2; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    headerStream.close();
                    return new byte[0];
                }
                headerStream.write(readByte);
                filenameLength += (long)((readByte & 0xFF) << i * 8);
            }
            long expandedFieldLength = 0L;
            for (int i = 0; i < 2; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    headerStream.close();
                    return new byte[0];
                }
                headerStream.write(readByte);
                expandedFieldLength += (long)((readByte & 0xFF) << i * 8);
            }
            for (long i = 0L; i < filenameLength + expandedFieldLength; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    headerStream.close();
                    return new byte[0];
                }
                headerStream.write(readByte);
            }
            byte[] header = headerStream.toByteArray();
            headerStream.close();
            outputStream.write(header);
            return header;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                headerStream.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return new byte[0];
        }
    }

    private static boolean copyCentralDirectoryFileHeader(InputStream inputStream, OutputStream outputStream) {
        int readByte = 0;
        try {
            long i;
            for (int i2 = 0; i2 < 28; ++i2) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
            }
            long filenameLength = 0L;
            for (int i3 = 0; i3 < 2; ++i3) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
                filenameLength += (long)((readByte & 0xFF) << i3 * 8);
            }
            long expandedFieldLength = 0L;
            for (int i4 = 0; i4 < 2; ++i4) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
                expandedFieldLength += (long)((readByte & 0xFF) << i4 * 8);
            }
            long filecommentLength = 0L;
            for (int i5 = 0; i5 < 2; ++i5) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
                filecommentLength += (long)((readByte & 0xFF) << i5 * 8);
            }
            for (i = 34L; i < 46L; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
            }
            for (i = 0L; i < filenameLength + expandedFieldLength + filecommentLength; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyEndOfCentralDirectory(InputStream inputStream, OutputStream outputStream) {
        int readByte = 0;
        try {
            for (int i = 0; i < 20; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
            }
            long filecommentLength = 0L;
            for (int i = 0; i < 2; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
                filecommentLength += (long)((readByte & 0xFF) << i * 8);
            }
            for (long i = 0L; i < filecommentLength; ++i) {
                readByte = inputStream.read();
                if (readByte == -1) {
                    return false;
                }
                outputStream.write(readByte);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean efxToZip(InputStream inputStream, OutputStream outputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            int readTotalSize;
            if (!EfxExtractor.findZipStart(bufferedInputStream)) {
                boolean bl = false;
                return bl;
            }
            byte[] header = EfxExtractor.getLocalFileHeaderWithCopying(bufferedInputStream, bufferedOutputStream);
            if (header.length == 0) {
                boolean e = false;
                return e;
            }
            long filesize = 0L;
            if (header.length < 22) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < 4; filesize += (long)((header[18 + i] & 0xFF) << i * 8), ++i) {
            }
            try {
                byte[] buffer = new byte[0x100000];
                readTotalSize = 0;
                int readSize = 0;
                while ((long)readTotalSize < filesize) {
                    readSize = bufferedInputStream.read(buffer, 0, Math.min(0x100000, (int)(filesize - (long)readTotalSize)));
                    if (readSize == -1) {
                        boolean bl = false;
                        return bl;
                    }
                    bufferedOutputStream.write(buffer, 0, readSize);
                    readTotalSize += readSize;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                readTotalSize = 0;
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                try {
                    bufferedOutputStream.close();
                    return readTotalSize != 0;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return readTotalSize != 0;
            }
            if (!EfxExtractor.copyCentralDirectoryFileHeader(bufferedInputStream, bufferedOutputStream)) {
                boolean bl = false;
                return bl;
            }
            if (EfxExtractor.copyEndOfCentralDirectory(bufferedInputStream, bufferedOutputStream)) return true;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bufferedOutputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUnzippedFilename(InputStream inputStream) {
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        String zipName = "";
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            zipName = zipEntry.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
            zipName = "";
        }
        catch (NullPointerException e) {
            zipName = "";
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                zipName = "";
            }
        }
        return zipName;
    }

    private static String validateFilename(String filename, String intendedDir) throws IOException {
        File f = new File(filename);
        String canonicalPath = f.getCanonicalPath();
        File iD = new File(intendedDir);
        String canonicalID = iD.getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID)) {
            return canonicalPath;
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipToCtyptedRcx(InputStream inputStream, OutputStream outputStream) {
        boolean result;
        block27: {
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            result = false;
            try {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                EfxExtractor.validateFilename(zipEntry.getName(), ".");
                try {
                    byte[] buffer = new byte[0x100000];
                    int readSize = 0;
                    long totalFileSize = 0L;
                    while ((readSize = zipInputStream.read(buffer)) != -1) {
                        bufferedOutputStream.write(buffer, 0, readSize);
                        if ((totalFileSize += (long)readSize) <= 0xC800000L) continue;
                    }
                    if (totalFileSize > 0xC800000L) {
                        result = false;
                        break block27;
                    }
                    result = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    zipInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private static String caesar(String string) {
        char[] caesarString = string.toCharArray();
        for (int i = 0; i < caesarString.length; ++i) {
            int n = i;
            caesarString[n] = (char)(caesarString[n] - '\u0001');
            if (caesarString[i] > '\u0019') continue;
            caesarString[i] = (char)(126 - (25 - caesarString[i]));
        }
        return String.valueOf(caesarString);
    }

    private static String createPassword(String filename) {
        String caesarFirmwareUpdate = "GjsnxbsfVqebuf";
        String caesarFilename = EfxExtractor.caesar(filename);
        String password = "";
        int passwordLength = Math.min(caesarFirmwareUpdate.length(), filename.length());
        for (int i = 0; i < passwordLength; ++i) {
            password = password + caesarFirmwareUpdate.charAt(i);
            password = password + caesarFilename.charAt(i);
        }
        return password;
    }

    private static byte[] getSalt(InputStream inputStream) {
        int SALT_HEADER_LENGTH = 8;
        int SALT_LENGTH = 8;
        byte[] salt_header = new byte[8];
        byte[] salt = new byte[8];
        try {
            if (inputStream.read(salt_header, 0, salt_header.length) != salt_header.length) {
                return new byte[0];
            }
            if (inputStream.read(salt, 0, salt.length) != salt.length) {
                return new byte[0];
            }
            return salt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private static byte[] createKey(String password, byte[] salt) {
        try {
            byte[] passwordByteArray = password.getBytes("US-ASCII");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] pass_salt = new byte[passwordByteArray.length + salt.length];
            System.arraycopy(passwordByteArray, 0, pass_salt, 0, passwordByteArray.length);
            System.arraycopy(salt, 0, pass_salt, passwordByteArray.length, salt.length);
            byte[] hash1 = messageDigest.digest(pass_salt);
            byte[] hash1_pass_salt = new byte[hash1.length + passwordByteArray.length + salt.length];
            System.arraycopy(hash1, 0, hash1_pass_salt, 0, hash1.length);
            System.arraycopy(passwordByteArray, 0, hash1_pass_salt, hash1.length, passwordByteArray.length);
            System.arraycopy(salt, 0, hash1_pass_salt, hash1.length + passwordByteArray.length, salt.length);
            byte[] hash2 = messageDigest.digest(hash1_pass_salt);
            byte[] hash1_hash2 = new byte[hash1.length + hash2.length];
            System.arraycopy(hash1, 0, hash1_hash2, 0, hash1.length);
            System.arraycopy(hash2, 0, hash1_hash2, hash1.length, hash2.length);
            return hash1_hash2;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private static byte[] createIv(String password, byte[] salt) {
        try {
            byte[] passwordByteArray = password.getBytes("US-ASCII");
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] pass_salt = new byte[passwordByteArray.length + salt.length];
            System.arraycopy(passwordByteArray, 0, pass_salt, 0, passwordByteArray.length);
            System.arraycopy(salt, 0, pass_salt, passwordByteArray.length, salt.length);
            byte[] hash1 = messageDigest.digest(pass_salt);
            byte[] hash1_pass_salt = new byte[hash1.length + passwordByteArray.length + salt.length];
            System.arraycopy(hash1, 0, hash1_pass_salt, 0, hash1.length);
            System.arraycopy(passwordByteArray, 0, hash1_pass_salt, hash1.length, passwordByteArray.length);
            System.arraycopy(salt, 0, hash1_pass_salt, hash1.length + passwordByteArray.length, salt.length);
            byte[] hash2 = messageDigest.digest(hash1_pass_salt);
            byte[] hash2_password_salt = new byte[hash2.length + passwordByteArray.length + salt.length];
            System.arraycopy(hash2, 0, hash2_password_salt, 0, hash2.length);
            System.arraycopy(passwordByteArray, 0, hash2_password_salt, hash2.length, passwordByteArray.length);
            System.arraycopy(salt, 0, hash2_password_salt, hash2.length + passwordByteArray.length, salt.length);
            return messageDigest.digest(hash2_password_salt);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cryptedRcxToRcx(InputStream inputStream, OutputStream outputStream, String filename) {
        try {
            String password = EfxExtractor.createPassword(filename);
            byte[] salt = EfxExtractor.getSalt(inputStream);
            boolean result = false;
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(EfxExtractor.createKey(password, salt), "AES"), new IvParameterSpec(EfxExtractor.createIv(password, salt), 0, cipher.getBlockSize()));
            CipherInputStream cipherInputStream = new CipherInputStream(new BufferedInputStream(inputStream), cipher);
            byte[] buffer = new byte[0x100000];
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            int readSize = 0;
            try {
                while ((readSize = cipherInputStream.read(buffer)) != -1) {
                    bufferedOutputStream.write(buffer, 0, readSize);
                }
                result = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                result = false;
            }
            finally {
                try {
                    cipherInputStream.close();
                    bufferedOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    result = false;
                }
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            return false;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return false;
        }
    }
}

