/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import java.lang.reflect.Method;
import org.json.JSONObject;

public class EposSdkJson {
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogInfoMethod = null;

    public static String jsonToSdkJson(String jsonString) {
        if (jsonString == null) {
            EposSdkJson.outputLogInfo(new Object[0]);
            return "";
        }
        String[][] keyList = new String[][]{{"PrinterSpec", "Product", "SerialNo"}, {"PrinterSpec", "Spec", "Language"}, {"PrinterSpec", "Spec", "PaperWidth"}, {"PrinterSpec", "Spec", "HeadDpi"}, {"Setting", "AutoCut", "CutAfterPaperset"}, {"Setting", "Buzzer", "Select"}, {"Setting", "Command", "AutoCR"}, {"Setting", "Interface", "USB", "NetworkTethering"}, {"Setting", "Interface", "USB2LAN", "Active"}, {"Setting", "Print", "Density"}, {"Setting", "Print", "Speed"}, {"Setting", "Print", "ColumnEmulation"}, {"Setting", "Print", "RollPaperWidth"}, {"Setting", "Print", "PaperWidthWithGuide"}, {"Setting", "Print", "NearEndSetting"}, {"Setting", "WifiCfg", "Ssid"}, {"Setting", "WifiCfg", "EncType_Select"}, {"Setting", "WifiCfg", "WpaPsk", "Key"}, {"Setting", "WifiCfg", "WlanChip", "ChipMode_Select"}, {"Setting", "TcpIpCfg", "IpV4", "Acquiring_Select"}, {"Setting", "TcpIpCfg", "IpV4", "Ip"}, {"Setting", "TcpIpCfg", "IpV4", "Sm"}, {"Setting", "TcpIpCfg", "IpV4", "Gw"}, {"Setting", "TcpIpCfg", "IpV4", "IpAddlessPrint_Select"}, {"Maintenance", "ThermalHead", "NumberOfWarningDot"}, {"Maintenance", "ThermalHead", "PositionOfWarningDot"}, {"Maintenance", "ThermalHead", "NumberOfBrokenDot"}, {"Maintenance", "ThermalHead", "PositionOfBrokenDot"}, {"Maintenance", "Counter", "RollPaper_FeedLines"}, {"Maintenance", "Counter", "RollPaper_CutterDrives"}, {"FormatName"}, {"Rev"}};
        return EposSdkJson.createSdkJson(keyList, jsonString);
    }

    public static String jsonToSdkJsonDeprecated(String jsonString) {
        if (jsonString == null) {
            EposSdkJson.outputLogInfo(new Object[0]);
            return "";
        }
        String[][] keyListDeprecated = new String[][]{{"Setting", "AutoCut", "CutAfterPaperset"}, {"Setting", "Buzzer", "Select"}, {"Setting", "Command", "AutoCR"}, {"Setting", "Print", "Density"}, {"Setting", "Print", "Speed"}, {"Setting", "Print", "ColumnEmulation"}, {"Setting", "Print", "RollPaperWidth"}, {"Setting", "Print", "PaperWidthWithGuide"}, {"Setting", "Print", "NearEndSetting"}, {"FormatName"}, {"Rev"}};
        return EposSdkJson.createSdkJson(keyListDeprecated, jsonString);
    }

    public static String createSdkJson(String[][] keyList, String jsonString) {
        JSONObject sdkJson;
        if (keyList == null || jsonString == null) {
            EposSdkJson.outputLogInfo(new Object[0]);
            return "";
        }
        int nRowKeyList = keyList.length;
        if (keyList.length == 0) {
            EposSdkJson.outputLogInfo(new Object[0]);
            return "";
        }
        String[] valueList = new String[nRowKeyList];
        block8: for (int i = 0; i < nRowKeyList; ++i) {
            JSONObject printerJson;
            try {
                printerJson = new JSONObject(jsonString);
            }
            catch (Exception e) {
                EposSdkJson.outputLogInfo(e);
                return "";
            }
            for (int j = 0; j < keyList[i].length; ++j) {
                if (j == keyList[i].length - 1) {
                    String value;
                    try {
                        value = printerJson.getString(keyList[i][j]);
                    }
                    catch (Exception e) {
                        valueList[i] = null;
                        continue block8;
                    }
                    valueList[i] = value;
                    continue;
                }
                try {
                    printerJson = printerJson.getJSONObject(keyList[i][j]);
                    continue;
                }
                catch (Exception e) {
                    valueList[i] = null;
                    continue block8;
                }
            }
        }
        try {
            sdkJson = new JSONObject();
        }
        catch (Exception e) {
            EposSdkJson.outputLogInfo(e);
            return "";
        }
        for (int i = 0; i < valueList.length; ++i) {
            if (valueList[i] == null) continue;
            EposSdkJson.appendSdkJson(sdkJson, keyList[i], valueList[i]);
        }
        return sdkJson.toString();
    }

    public static void appendSdkJson(JSONObject target, String[] keys, String value) {
        if (target == null || keys == null || value == null) {
            return;
        }
        JSONObject current = target;
        try {
            if (1 != keys.length) {
                for (int i = 0; i < keys.length - 1; ++i) {
                    if (!current.has(keys[i])) {
                        JSONObject objNode = new JSONObject();
                        current.put(keys[i], (Object)objNode);
                    }
                    current = current.getJSONObject(keys[i]);
                }
            }
            current.put(keys[keys.length - 1], (Object)value);
        }
        catch (Exception e) {
            EposSdkJson.outputLogInfo(e);
            return;
        }
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            EposSdkJson.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

