/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import com.epson.epos2.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;

class FirmwareDownloader {
    private static final String DOWNLOAD_URL = "https://www.epson-biz.com/api/firm/";
    private static final String JSON_KEY_FORMAT_NAME = "FormatName";
    private static final String JSON_KEY_COMM_SERVER = "CommServer";
    private static final String JSON_KEY_COMMAND = "Command";
    private static final String JSON_KEY_TOOL_ID = "ToolID";
    private static final String JSON_KEY_VERSION = "Version";
    private static final String JSON_KEY_PRINTER_SPEC = "PrinterSpec";
    private static final String JSON_KEY_PRODUCT = "Product";
    private static final String JSON_KEY_PRODUCT_NAME = "ProductName";
    private static final String JSON_KEY_PRINTER_FIRM_VER = "PrinterFirmVersion";
    private static final String JSON_KEY_SERIAL_NUMBER = "SerialNo";
    private static final String JSON_KEY_DERIVATIVE = "Derivative";
    private static final String JSON_KEY_LANGUAGE = "Language";
    private static final String JSON_FIXED_FORMAT_NAME = "TMFirm-Form";
    private static final String JSON_FIXED_REV = "2";
    private static final String JSON_FIXED_TOOL_ID = "ePOS SDK Android";
    private static final String JSON_COMMAND_GET_FILELIST = "GetFileList";
    private static final String JSON_COMMAND_GET_FILE = "GetFile";
    private static final String JSON_COMMAND_GET_HISTORY = "GetHistory";
    private static final String JSON_RESULT_KEY_VERSION = "Version";
    private static final String JSON_RESULT_KEY_USER_CHECK = "UserCheck";
    private static final String JSON_RESULT_KEY_HISTORY = "History";
    private static final String JSON_RESULT_KEY_ACCESS = "Access";
    private static final String JSON_RESULT_NONE = "NONE";
    private static final String JSON_ERROR_WRONG_ID_PASSWORD = "ERROR_WRONG_ID_PASSWORD";
    private static final String JSON_ERROR_EXPIRED_PASSWORD = "ERROR_EXPIRED_PASSWORD";
    private static final String JSON_ERROR_SERVER_CONGESTION = "ERROR_SERVER_CONGESTION";
    public static final String LANGUAGE_EN = "en";
    public static final String LANGUAGE_JA = "ja";
    public static final String LANGUAGE_FR = "fr";
    public static final String LANGUAGE_IT = "it";
    public static final String LANGUAGE_DE = "de";
    public static final String LANGUAGE_ES = "es";
    public static final String LANGUAGE_PT = "pt";
    public static final String LANGUAGE_NL = "nl";
    public static final String LANGUAGE_RU = "ru";
    public static final String LANGUAGE_KO = "ko";
    public static final String UTF8 = "UTF-8";
    private static final int BUFFER_SIZE = 0x100000;
    private static final int TIMEOUT_CONNECT = 60000;
    private static final int TIMEOUT_READ = 60000;
    public static final String DEFAULT_DERIVATIVE = "ESC/POS";
    public static final String INTENT_KEY_DEVICE_NAME = "DEVICE_NAME";
    public static final String INTENT_KEY_FIRMWARE_VERESION = "FIRMWARE_VERSION";
    public static final String INTENT_KEY_TO_BE_UPDATED_VERESION = "TO_BE_UPDATED_VERSION";
    public static final String INTENT_KEY_TYPE_NAME = "TYPE_NAME";
    public static final String INTENT_KEY_SELECT_FIRMEWARE_INDEX = "SELECT_FIRMEWARE_INDEX";
    private String m_productName = "";
    private String m_requestName = "";
    private String m_serialNumber = "";
    private String m_derivative = "";
    private String m_printerFirmwareVersion = "";
    private Locale m_locale = Locale.getDefault();
    private JSONObject m_nextCommand = null;
    private BufferedOutputStream m_outputStream = null;
    private OnProgressListener m_onProgressListener = null;
    private OnResultListener m_onResultListener = null;
    private boolean m_stopDownload = false;
    private Semaphore m_httpSemaphore = new Semaphore(1);
    private URLConnection m_urlConnection = null;
    private Thread m_httpThread = null;
    private Runnable getFileListRunnable = new Runnable(){

        @Override
        public void run() {
            if (FirmwareDownloader.this.m_nextCommand == null) {
                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                return;
            }
            if (!FirmwareDownloader.this.openHttpConnection()) {
                FirmwareDownloader.this.closeHttpConnection();
                FirmwareDownloader.this.safeOnError(Error.UNREACHABLE);
                return;
            }
            boolean isSuccessSent = FirmwareDownloader.this.sendRequestToServer(FirmwareDownloader.this.m_nextCommand);
            if (!isSuccessSent) {
                FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                FirmwareDownloader.this.closeHttpConnection();
                return;
            }
            try {
                InputStream inputStream = FirmwareDownloader.this.m_urlConnection.getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[0x100000];
                int readSize = 0;
                while ((readSize = inputStream.read(buffer, 0, 0x100000)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, readSize);
                }
                inputStream.close();
                FirmwareDownloader.this.closeHttpConnection();
                JSONObject result = new JSONObject(byteArrayOutputStream.toString(FirmwareDownloader.UTF8));
                byteArrayOutputStream.close();
                try {
                    String resultValue = result.getString("Version");
                    if (resultValue.equals(FirmwareDownloader.JSON_RESULT_NONE)) {
                        FirmwareDownloader.this.safeOnError(Error.FILE_NONE);
                    } else {
                        FirmwareDownloader.this.safeOnFileListGet(resultValue.split(","));
                    }
                    return;
                }
                catch (JSONException resultValue) {
                    try {
                        String resultValue2 = result.getString(FirmwareDownloader.JSON_RESULT_KEY_ACCESS);
                        if (resultValue2.equals(FirmwareDownloader.JSON_ERROR_SERVER_CONGESTION)) {
                            FirmwareDownloader.this.safeOnError(Error.CONGESTION);
                        } else {
                            FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                        }
                        return;
                    }
                    catch (JSONException jSONException) {
                        FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                FirmwareDownloader.this.closeHttpConnection();
                return;
            }
            catch (JSONException e) {
                e.printStackTrace();
                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                return;
            }
        }
    };
    private Runnable getHistoryRunnable = new Runnable(){

        @Override
        public void run() {
            if (FirmwareDownloader.this.m_nextCommand == null) {
                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                return;
            }
            if (!FirmwareDownloader.this.openHttpConnection()) {
                FirmwareDownloader.this.closeHttpConnection();
                FirmwareDownloader.this.safeOnError(Error.UNREACHABLE);
                return;
            }
            boolean isSuccessSent = FirmwareDownloader.this.sendRequestToServer(FirmwareDownloader.this.m_nextCommand);
            if (!isSuccessSent) {
                FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                FirmwareDownloader.this.closeHttpConnection();
                return;
            }
            try {
                InputStream inputStream = FirmwareDownloader.this.m_urlConnection.getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[0x100000];
                int readSize = 0;
                while ((readSize = inputStream.read(buffer, 0, 0x100000)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, readSize);
                }
                inputStream.close();
                FirmwareDownloader.this.closeHttpConnection();
                JSONObject result = new JSONObject(byteArrayOutputStream.toString(FirmwareDownloader.UTF8));
                byteArrayOutputStream.close();
                try {
                    String resultValue = result.getString(FirmwareDownloader.JSON_RESULT_KEY_HISTORY);
                    if (resultValue.equals(FirmwareDownloader.JSON_RESULT_NONE)) {
                        FirmwareDownloader.this.safeOnError(Error.FILE_NONE);
                    } else {
                        FirmwareDownloader.this.safeOnHistoryGet(resultValue);
                    }
                    return;
                }
                catch (JSONException resultValue) {
                    try {
                        String resultValue2 = result.getString(FirmwareDownloader.JSON_RESULT_KEY_ACCESS);
                        if (resultValue2.equals(FirmwareDownloader.JSON_ERROR_SERVER_CONGESTION)) {
                            FirmwareDownloader.this.safeOnError(Error.CONGESTION);
                        } else {
                            FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                        }
                        return;
                    }
                    catch (JSONException jSONException) {
                        FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                FirmwareDownloader.this.closeHttpConnection();
                return;
            }
            catch (JSONException e) {
                e.printStackTrace();
                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                return;
            }
        }
    };
    private Runnable getFileRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            if (FirmwareDownloader.this.m_nextCommand == null) {
                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                return;
            }
            if (!FirmwareDownloader.this.openHttpConnection()) {
                FirmwareDownloader.this.closeHttpConnection();
                FirmwareDownloader.this.safeOnError(Error.UNREACHABLE);
                return;
            }
            boolean isSuccessSent = FirmwareDownloader.this.sendRequestToServer(FirmwareDownloader.this.m_nextCommand);
            if (!isSuccessSent) {
                FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                FirmwareDownloader.this.closeHttpConnection();
                return;
            }
            InputStream inputStream = null;
            try {
                inputStream = FirmwareDownloader.this.m_urlConnection.getInputStream();
                if (FirmwareDownloader.this.m_urlConnection.getContentType().equals("application/force-download")) {
                    boolean isSuccessGetFile = FirmwareDownloader.this.getFirmwareFile(inputStream);
                    if (isSuccessGetFile) {
                        FirmwareDownloader.this.safeOnSuccess();
                    } else {
                        FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                    }
                    return;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[0x100000];
                int readSize = 0;
                while ((readSize = inputStream.read(buffer, 0, 0x100000)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, readSize);
                }
                JSONObject result = new JSONObject(byteArrayOutputStream.toString(FirmwareDownloader.UTF8));
                byteArrayOutputStream.close();
                try {
                    String resultValue = result.getString(FirmwareDownloader.JSON_RESULT_KEY_USER_CHECK);
                    if (resultValue.equals(FirmwareDownloader.JSON_ERROR_WRONG_ID_PASSWORD)) {
                        FirmwareDownloader.this.safeOnError(Error.WRONG_ID_PASSWORD);
                    } else if (resultValue.equals(FirmwareDownloader.JSON_ERROR_EXPIRED_PASSWORD)) {
                        FirmwareDownloader.this.safeOnError(Error.EXPIRED_PASSWORD);
                    } else {
                        FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                    }
                    return;
                }
                catch (JSONException resultValue) {
                    block50: {
                        String resultValue2 = result.getString(FirmwareDownloader.JSON_RESULT_KEY_ACCESS);
                        if (resultValue2.equals(FirmwareDownloader.JSON_ERROR_SERVER_CONGESTION)) {
                            FirmwareDownloader.this.safeOnError(Error.CONGESTION);
                            break block50;
                        }
                        FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FirmwareDownloader.this.closeHttpConnection();
                    return;
                    {
                        catch (JSONException resultValue2) {
                            block51: {
                                String resultValue3 = result.getString("Version");
                                if (resultValue3.equals(FirmwareDownloader.JSON_RESULT_NONE)) {
                                    FirmwareDownloader.this.safeOnError(Error.FILE_NONE);
                                    break block51;
                                }
                                FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                            }
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            FirmwareDownloader.this.closeHttpConnection();
                            return;
                            {
                                catch (JSONException jSONException) {
                                    FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    FirmwareDownloader.this.closeHttpConnection();
                                    return;
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        FirmwareDownloader.this.safeOnError(Error.DISCONNECT);
                                        return;
                                    }
                                    catch (JSONException e) {
                                        e.printStackTrace();
                                        FirmwareDownloader.this.safeOnError(Error.UNKNOWN);
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
                FirmwareDownloader.this.closeHttpConnection();
            }
        }
    };

    public FirmwareDownloader(String productName, String requestName, String printerFirmwareVersion) {
        this.m_productName = productName;
        this.m_requestName = requestName;
        this.m_printerFirmwareVersion = printerFirmwareVersion;
        String[] elements = printerFirmwareVersion.split(" ");
        if (elements.length == 2) {
            this.m_derivative = elements[1];
        }
        if (this.m_derivative.equals(DEFAULT_DERIVATIVE)) {
            this.m_derivative = "";
        }
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public synchronized void setOnProgressListener(OnProgressListener listener) {
        this.m_onProgressListener = listener;
    }

    public synchronized void setOnResultListener(OnResultListener listener) {
        this.m_onResultListener = listener;
    }

    public synchronized void clearListeners() {
        this.m_onProgressListener = null;
        this.m_onResultListener = null;
    }

    public void stopDownload() {
        this.m_stopDownload = true;
    }

    private boolean openHttpConnection() {
        try {
            URL url = new URL(DOWNLOAD_URL);
            this.m_urlConnection = url.openConnection();
            this.m_urlConnection.setDoOutput(true);
            this.m_urlConnection.setConnectTimeout(60000);
            this.m_urlConnection.setReadTimeout(60000);
            this.m_urlConnection.setRequestProperty("Content-type", "application/json");
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void closeHttpConnection() {
        this.m_urlConnection = null;
        this.m_httpSemaphore.release();
    }

    private synchronized void safeOnSuccess() {
        if (this.m_onResultListener != null) {
            this.m_onResultListener.OnSuccess();
        }
    }

    private synchronized void safeOnFileListGet(String[] fileList) {
        if (this.m_onResultListener != null) {
            this.m_onResultListener.OnFileListGet(this.m_productName, this.m_requestName, fileList);
        }
    }

    private synchronized void safeOnHistoryGet(String history) {
        if (this.m_onResultListener != null) {
            this.m_onResultListener.OnHistoryGet(history);
        }
    }

    private synchronized void safeOnError(Error error) {
        if (this.m_onResultListener != null) {
            this.m_onResultListener.OnError(error);
        }
    }

    private synchronized void safeOnProgress(int receivedByte, int totalByte) {
        if (this.m_onProgressListener != null) {
            this.m_onProgressListener.OnDownloadFirmwareProgress(receivedByte, totalByte);
        }
    }

    private String getPortType(String connectedTarget) {
        String resultPortType = null;
        try {
            int index = connectedTarget.indexOf(":");
            if (index == -1) {
                return null;
            }
            resultPortType = connectedTarget.substring(0, index);
        }
        catch (Exception e) {
            return null;
        }
        return resultPortType;
    }

    private JSONObject createGetFileListJSONObject(String connectedTarget) {
        JSONObject root = new JSONObject();
        JSONObject commServer = new JSONObject();
        JSONObject printerSpec = new JSONObject();
        JSONObject product = new JSONObject();
        try {
            String sdkVersion = Log.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = "";
            }
            String toolId = null;
            String portType = this.getPortType(connectedTarget);
            toolId = portType != null ? "ePOS SDK Android " + sdkVersion + " [" + portType + "]" : "ePOS SDK Android " + sdkVersion;
            root.put(JSON_KEY_FORMAT_NAME, (Object)JSON_FIXED_FORMAT_NAME);
            commServer.put(JSON_KEY_COMMAND, (Object)JSON_COMMAND_GET_FILELIST);
            commServer.put(JSON_KEY_TOOL_ID, (Object)toolId);
            root.put(JSON_KEY_COMM_SERVER, (Object)commServer);
            product.put(JSON_KEY_PRODUCT_NAME, (Object)this.m_requestName);
            product.put(JSON_KEY_SERIAL_NUMBER, (Object)this.m_serialNumber);
            product.put(JSON_KEY_LANGUAGE, (Object)FirmwareDownloader.langStringOf(this.m_locale));
            product.put(JSON_KEY_DERIVATIVE, (Object)this.m_derivative);
            printerSpec.put(JSON_KEY_PRODUCT, (Object)product);
            root.put(JSON_KEY_PRINTER_SPEC, (Object)printerSpec);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return root;
    }

    public void getFileList(String connectedTarget) {
        try {
            this.m_httpSemaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        this.m_nextCommand = this.createGetFileListJSONObject(connectedTarget);
        this.m_httpThread = new Thread(this.getFileListRunnable);
        this.m_httpThread.start();
    }

    public static String langStringOf(Locale locale) {
        String localeString = locale.toString();
        if (localeString.length() < 2) {
            return LANGUAGE_EN;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_JA)) {
            return LANGUAGE_JA;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_FR)) {
            return LANGUAGE_FR;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_IT)) {
            return LANGUAGE_IT;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_DE)) {
            return LANGUAGE_DE;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_ES)) {
            return LANGUAGE_ES;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_PT)) {
            return LANGUAGE_PT;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_NL)) {
            return LANGUAGE_NL;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_RU)) {
            return LANGUAGE_RU;
        }
        if (localeString.substring(0, 2).equals(LANGUAGE_KO)) {
            return LANGUAGE_KO;
        }
        return LANGUAGE_EN;
    }

    private JSONObject createGetHistoryJSONObject() {
        JSONObject root = new JSONObject();
        JSONObject commServer = new JSONObject();
        JSONObject printerSpec = new JSONObject();
        JSONObject product = new JSONObject();
        try {
            String sdkVersion = Log.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = "";
            }
            String toolId = "ePOS SDK Android " + sdkVersion;
            root.put(JSON_KEY_FORMAT_NAME, (Object)JSON_FIXED_FORMAT_NAME);
            commServer.put(JSON_KEY_COMMAND, (Object)JSON_COMMAND_GET_HISTORY);
            commServer.put(JSON_KEY_TOOL_ID, (Object)toolId);
            product.put(JSON_KEY_PRODUCT_NAME, (Object)this.useProductName());
            product.put(JSON_KEY_LANGUAGE, (Object)FirmwareDownloader.langStringOf(this.m_locale));
            product.put(JSON_KEY_DERIVATIVE, (Object)this.m_derivative);
            printerSpec.put(JSON_KEY_PRODUCT, (Object)product);
            root.put(JSON_KEY_COMM_SERVER, (Object)commServer);
            root.put(JSON_KEY_PRINTER_SPEC, (Object)printerSpec);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return root;
    }

    public void getHistory() {
        try {
            this.m_httpSemaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        this.m_nextCommand = this.createGetHistoryJSONObject();
        this.m_httpThread = new Thread(this.getHistoryRunnable);
        this.m_httpThread.start();
    }

    private JSONObject createGetFileJSONObject(String version) {
        JSONObject root = new JSONObject();
        JSONObject commServer = new JSONObject();
        JSONObject printerSpec = new JSONObject();
        JSONObject product = new JSONObject();
        try {
            String sdkVersion = Log.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = "";
            }
            String toolId = "ePOS SDK Android " + sdkVersion;
            root.put(JSON_KEY_FORMAT_NAME, (Object)JSON_FIXED_FORMAT_NAME);
            commServer.put(JSON_KEY_COMMAND, (Object)JSON_COMMAND_GET_FILE);
            commServer.put(JSON_KEY_TOOL_ID, (Object)toolId);
            commServer.put("Version", (Object)version);
            product.put(JSON_KEY_PRODUCT_NAME, (Object)this.m_requestName);
            product.put(JSON_KEY_SERIAL_NUMBER, (Object)this.m_serialNumber);
            product.put(JSON_KEY_LANGUAGE, (Object)FirmwareDownloader.langStringOf(this.m_locale));
            product.put(JSON_KEY_DERIVATIVE, (Object)this.m_derivative);
            product.put(JSON_KEY_PRINTER_FIRM_VER, (Object)this.m_printerFirmwareVersion);
            printerSpec.put(JSON_KEY_PRODUCT, (Object)product);
            root.put(JSON_KEY_COMM_SERVER, (Object)commServer);
            root.put(JSON_KEY_PRINTER_SPEC, (Object)printerSpec);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return root;
    }

    public void getFile(String version, OutputStream outputStream) {
        try {
            this.m_httpSemaphore.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        this.m_nextCommand = this.createGetFileJSONObject(version);
        this.m_outputStream = new BufferedOutputStream(outputStream);
        this.m_stopDownload = false;
        this.m_httpThread = new Thread(this.getFileRunnable);
        this.m_httpThread.start();
    }

    public String createOrderedJSONString(JSONObject jsonObject) {
        try {
            String command = jsonObject.getJSONObject(JSON_KEY_COMM_SERVER).getString(JSON_KEY_COMMAND);
            String sdkVersion = Log.getSdkVersion();
            if (sdkVersion == null) {
                sdkVersion = "";
            }
            String toolId = "ePOS SDK Android " + sdkVersion;
            if (command.equals(JSON_COMMAND_GET_FILELIST)) {
                String productName = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_PRODUCT_NAME);
                String serialNumber = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_SERIAL_NUMBER);
                String language = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_LANGUAGE);
                String derivative = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_DERIVATIVE);
                return "{\"FormatName\":\"TMFirm-Form\",\"Rev\":\"2\",\"CommServer\":{\"Command\":\"GetFileList\",\"ToolID\":\"" + toolId + " \"},\"PrinterSpec\":{\"Product\":{\"ProductName\":\"" + productName + "\",\"SerialNo\":\"" + serialNumber + "\",\"Language\":\"" + language + "\",\"Derivative\":\"" + derivative + "\"}}}";
            }
            if (command.equals(JSON_COMMAND_GET_FILE)) {
                String version = jsonObject.getJSONObject(JSON_KEY_COMM_SERVER).getString("Version");
                String productName = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_PRODUCT_NAME);
                String printerFirmwareVersion = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_PRINTER_FIRM_VER);
                String serialNumber = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_SERIAL_NUMBER);
                String language = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_LANGUAGE);
                String derivative = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_DERIVATIVE);
                return "{\"FormatName\":\"TMFirm-Form\",\"Rev\":\"2\",\"CommServer\":{\"Command\":\"GetFile\",\"ToolID\":\"" + toolId + " \",\"Version\":\"" + version + "\"},\"PrinterSpec\":{\"Product\":{\"ProductName\":\"" + productName + "\",\"PrinterFirmVersion\":\"" + printerFirmwareVersion + "\",\"SerialNo\":\"" + serialNumber + "\",\"Language\":\"" + language + "\",\"Derivative\":\"" + derivative + "\"}}}";
            }
            if (command.equals(JSON_COMMAND_GET_HISTORY)) {
                String productName = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_PRODUCT_NAME);
                String language = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_LANGUAGE);
                String derivative = jsonObject.getJSONObject(JSON_KEY_PRINTER_SPEC).getJSONObject(JSON_KEY_PRODUCT).getString(JSON_KEY_DERIVATIVE);
                return "{\"FormatName\":\"TMFirm-Form\",\"Rev\":\"2\",\"CommServer\":{\"Command\":\"GetHistory\",\"ToolID\":\"" + toolId + " \"},\"PrinterSpec\":{\"Product\":{\"ProductName\":\"" + productName + "\",\"Language\":\"" + language + "\",\"Derivative\":\"" + derivative + "\"}}}";
            }
            return "";
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean sendRequestToServer(JSONObject nextCommand) {
        boolean isSendSuccess;
        block26: {
            String sentJsonString = this.createOrderedJSONString(nextCommand);
            if (sentJsonString.isEmpty()) {
                return false;
            }
            OutputStream outputStream = null;
            isSendSuccess = false;
            try {
                outputStream = this.m_urlConnection.getOutputStream();
                OutputStreamWriter outputStreamWriter = null;
                outputStreamWriter = new OutputStreamWriter(outputStream, UTF8);
                outputStreamWriter.write(sentJsonString);
                isSendSuccess = true;
                try {
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    break block26;
                }
                catch (Exception e2) {
                    isSendSuccess = false;
                }
                break block26;
                catch (Exception e2) {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                        break block26;
                    }
                    catch (Exception e22) {
                        isSendSuccess = false;
                    }
                    break block26;
                    catch (Throwable throwable) {
                        try {
                            if (outputStreamWriter != null) {
                                outputStreamWriter.close();
                            }
                        }
                        catch (Exception e23) {
                            isSendSuccess = false;
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException e) {
                    isSendSuccess = false;
                }
            }
        }
        return isSendSuccess;
    }

    boolean getFirmwareFile(InputStream inputStream) {
        int dataSize = this.m_urlConnection.getContentLength();
        if (this.m_outputStream == null || dataSize == -1) {
            return false;
        }
        try {
            byte[] buffer = new byte[0x100000];
            int totalSize = 0;
            int readSize = 0;
            while ((readSize = inputStream.read(buffer, 0, 0x100000)) != -1) {
                if (this.m_stopDownload) {
                    return false;
                }
                this.m_outputStream.write(buffer, 0, readSize);
                totalSize += readSize;
                if (dataSize == -1) continue;
                this.safeOnProgress(totalSize, dataSize);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String useProductName() {
        if ("TM-T88VI".equals(this.m_productName)) {
            return "TM-T88VI-iUIB";
        }
        return this.m_productName;
    }

    public static interface OnResultListener {
        public void OnSuccess();

        public void OnFileListGet(String var1, String var2, String[] var3);

        public void OnHistoryGet(String var1);

        public void OnError(Error var1);
    }

    public static interface OnProgressListener {
        public void OnDownloadFirmwareProgress(int var1, int var2);
    }

    public static enum Error {
        UNREACHABLE,
        DISCONNECT,
        CONGESTION,
        WRONG_ID_PASSWORD,
        EXPIRED_PASSWORD,
        FILE_NONE,
        OUTPUT_STREAM,
        UNKNOWN;

    }
}

