/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import com.epson.epos2.Epos2Exception;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class FirmwareInfo {
    private String version;
    private String model;
    private String requestModel;
    private JSONObject json;

    protected FirmwareInfo(String model, String version, String requestModel) {
        this.model = model;
        this.version = version;
        this.requestModel = requestModel;
    }

    protected FirmwareInfo(String json) throws Epos2Exception {
        try {
            this.json = new JSONObject(json);
            this.version = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("PrinterFirmVersion");
            this.model = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("ProductName");
            if (this.json.getJSONObject("PrinterSpec").getJSONObject("Product").has("TypeName")) {
                this.model = this.json.getJSONObject("PrinterSpec").getJSONObject("Product").getString("TypeName");
            }
            this.requestModel = "";
        }
        catch (Exception err) {
            throw new Epos2Exception(4);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getModel() {
        return this.model;
    }

    public String getRequestModel() {
        return this.requestModel;
    }

    protected JSONObject getJson() {
        return this.json;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    public static ArrayList<Map> makePrinterUnits(JSONObject printerJson) {
        ArrayList<Map> printerUnits = new ArrayList<Map>();
        if (printerJson == null) {
            return null;
        }
        try {
            JSONObject updateInfo = printerJson.getJSONObject("UpdateInfo");
            JSONObject tagE = updateInfo.getJSONObject("E");
            String matchString = "6.\\d+.1";
            Iterator keys = tagE.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!key.matches(matchString)) continue;
                HashMap<String, String> printerUnit = new HashMap<String, String>();
                int size = key.length();
                String unitId = key.substring(2, size - 2);
                printerUnit.put("UnitIndex", unitId);
                printerUnit.put("UnitKind", tagE.getString("6." + unitId));
                printerUnit.put("UnitID", tagE.getString("6." + unitId + ".1"));
                printerUnit.put("UnitVersion", tagE.getString("6." + unitId + ".2"));
                printerUnit.put("UnitSpec", tagE.getString("6." + unitId + ".4"));
                printerUnits.add(printerUnit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return printerUnits;
    }
}

