/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.util.Pair;
import com.epson.epos2.printer.FirmwareUpdate;
import com.epson.epos2.printer.RccStream;
import com.epson.epos2.printer.RcxHeaderAnalyzer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class FirmwareUpdater {
    private OnProgressListener m_progressListener = null;
    private boolean m_stopUpdate = false;
    private static int invalidSize = -1;

    FirmwareUpdater() {
    }

    public void setProgressListener(OnProgressListener progressListener) {
        this.m_progressListener = progressListener;
    }

    public void clearProgressListener() {
        this.m_progressListener = null;
    }

    public static int isValidRcxHeaderWithRcxInfo(RcxHeaderAnalyzer rcxHeaderAnalyzer) {
        if (rcxHeaderAnalyzer == null) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("A", "1").equals("1")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("A", "2").equals("7")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("B", "1").equals("TRUE")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("B", "2").equals("TRUE")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("C", "1").equals("1")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("C", "2").equals("0")) {
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("E", "1").equals("2")) {
            return 43;
        }
        if (!(rcxHeaderAnalyzer.get("E", "2").equals("1000") || rcxHeaderAnalyzer.get("E", "2").equals("1010") || rcxHeaderAnalyzer.get("E", "2").equals("1100"))) {
            return 43;
        }
        return 0;
    }

    public static int checkFirmwareInfo(RcxHeaderAnalyzer rcxHeaderAnalyzer, JSONObject information, String toBeUpdatedVersion, boolean[] forceUpdate) {
        int rcxHeaderResult = FirmwareUpdater.isValidRcxHeaderWithRcxInfo(rcxHeaderAnalyzer);
        if (rcxHeaderResult != 0) {
            return rcxHeaderResult;
        }
        String productName = "";
        String boardId = "";
        String entireDerivative = "";
        String printerGenreNumber = "";
        try {
            JSONObject printerSpec = information.getJSONObject("PrinterSpec");
            JSONObject product = printerSpec.getJSONObject("Product");
            productName = product.getString("ProductName");
            if (product.has("TypeName")) {
                productName = product.getString("TypeName");
            }
            JSONObject updateInfo = information.getJSONObject("UpdateInfo");
            JSONObject tagA = updateInfo.getJSONObject("A");
            entireDerivative = tagA.getString("5");
            JSONObject tagE = updateInfo.getJSONObject("E");
            boardId = tagE.getString("8");
            printerGenreNumber = tagE.getString("2");
            String printerFirmVersion = product.getString("PrinterFirmVersion");
            if (forceUpdate.length > 0) {
                forceUpdate[0] = printerFirmVersion.equals(toBeUpdatedVersion);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 43;
        }
        if (!rcxHeaderAnalyzer.get("E", "8").equals(boardId)) {
            return 41;
        }
        if (!rcxHeaderAnalyzer.get("E", "2").equals(printerGenreNumber)) {
            return 41;
        }
        return 0;
    }

    public static List<Pair<Integer, UpdateRequiredType>> enumUpdateAreas(RcxHeaderAnalyzer rcxHeaderAnalyzer, JSONObject information) {
        int[] areaKeys = rcxHeaderAnalyzer.getChildrenKeys("E", "6");
        ArrayList<Pair<Integer, UpdateRequiredType>> updateAreas = new ArrayList<Pair<Integer, UpdateRequiredType>>();
        try {
            JSONObject updateInfo = information.getJSONObject("UpdateInfo");
            JSONObject tagE = updateInfo.getJSONObject("E");
            for (int i = 0; i < areaKeys.length; ++i) {
                try {
                    String idOfPrinter = "";
                    try {
                        idOfPrinter = tagE.getString("6." + areaKeys[i] + ".1");
                    }
                    catch (JSONException e) {
                        updateAreas.add((Pair<Integer, UpdateRequiredType>)new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.AREA_NOT_MATCHED));
                        continue;
                    }
                    if (idOfPrinter.isEmpty()) {
                        updateAreas.add((Pair<Integer, UpdateRequiredType>)new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.AREA_NOT_MATCHED));
                        continue;
                    }
                    String idOfRcx = rcxHeaderAnalyzer.get("E", new int[]{6, areaKeys[i], 1});
                    if (!idOfPrinter.equals(idOfRcx)) continue;
                    String derivativeOfRcx = rcxHeaderAnalyzer.get("E", new int[]{6, areaKeys[i], 4});
                    String derivativeOfPrinter = tagE.getString("6." + areaKeys[i] + ".4");
                    String versionOfRcx = rcxHeaderAnalyzer.get("E", new int[]{6, areaKeys[i], 2});
                    String versionOfPrinter = tagE.getString("6." + areaKeys[i] + ".2");
                    if (!derivativeOfRcx.equals(derivativeOfPrinter) || !versionOfRcx.equals(versionOfPrinter)) {
                        String repeatFlag = rcxHeaderAnalyzer.get("E", new int[]{6, areaKeys[i], 5});
                        if (repeatFlag.equals("REPEAT")) {
                            updateAreas.add((Pair<Integer, UpdateRequiredType>)new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.UPDATE_REQUIRED_WITH_REPEAT));
                            continue;
                        }
                        updateAreas.add((Pair<Integer, UpdateRequiredType>)new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.UPDATE_REQUIRED));
                        continue;
                    }
                    updateAreas.add((Pair<Integer, UpdateRequiredType>)new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.UPDATE_NOT_REQUIRED));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return new ArrayList<Pair<Integer, UpdateRequiredType>>();
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ArrayList<Pair<Integer, UpdateRequiredType>>();
        }
        return updateAreas;
    }

    public static int calcRebootTime(RcxHeaderAnalyzer rcxHeaderAnalyzer) {
        int time = 0;
        try {
            String timeString = rcxHeaderAnalyzer.get("B", "3");
            time = Integer.parseInt(timeString);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
        return time;
    }

    public static int calcUpdateAllTime(RcxHeaderAnalyzer rcxHeaderAnalyzer, List<Pair<Integer, UpdateRequiredType>> updateAreas) {
        int time = 0;
        for (Pair<Integer, UpdateRequiredType> area : updateAreas) {
            if (area.second == UpdateRequiredType.AREA_NOT_MATCHED) continue;
            try {
                String areaTimeString = rcxHeaderAnalyzer.get("E", new int[]{6, (Integer)area.first, 3});
                time += Integer.parseInt(areaTimeString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return invalidSize;
            }
        }
        return time;
    }

    public static int calcUpdateTime(RcxHeaderAnalyzer rcxHeaderAnalyzer, List<Pair<Integer, UpdateRequiredType>> updateAreas) {
        int time = 0;
        for (Pair<Integer, UpdateRequiredType> area : updateAreas) {
            try {
                if (area.second != UpdateRequiredType.UPDATE_REQUIRED) continue;
                String areaTimeString = rcxHeaderAnalyzer.get("E", new int[]{6, (Integer)area.first, 3});
                time += Integer.parseInt(areaTimeString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return invalidSize;
            }
        }
        return time;
    }

    private static int calcRccSize(byte[] header) {
        if (header.length < 37) {
            return -1;
        }
        String size = "";
        try {
            size = size + new String(Arrays.copyOfRange(header, 19, 27), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return -1;
        }
        try {
            return Integer.parseInt(size, 16) + 37;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int calcAllSize(InputStream rcxFileStream, List<Pair<Integer, UpdateRequiredType>> updateAreas) {
        ArrayList<Pair<Integer, UpdateRequiredType>> areas = new ArrayList<Pair<Integer, UpdateRequiredType>>();
        for (Pair<Integer, UpdateRequiredType> area : updateAreas) {
            if (area.second != UpdateRequiredType.AREA_NOT_MATCHED) {
                areas.add((Pair<Integer, UpdateRequiredType>)new Pair(area.first, (Object)UpdateRequiredType.UPDATE_REQUIRED));
                continue;
            }
            areas.add((Pair<Integer, UpdateRequiredType>)new Pair(area.first, (Object)UpdateRequiredType.AREA_NOT_MATCHED));
        }
        return FirmwareUpdater.calcSendSize(rcxFileStream, areas);
    }

    public static int calcSendSize(InputStream rcxFileStream, List<Pair<Integer, UpdateRequiredType>> updateAreas) {
        int totalSize = 0;
        RccStream rccStream = null;
        try {
            rccStream = new RccStream(rcxFileStream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return -1;
        }
        for (Pair<Integer, UpdateRequiredType> area : updateAreas) {
            if (area.second != UpdateRequiredType.UPDATE_REQUIRED) {
                if (rccStream.next()) continue;
                break;
            }
            try {
                byte[] buffer = new byte[37];
                int readSize = 0;
                while ((readSize += rccStream.read(buffer, readSize, buffer.length - readSize)) < 37) {
                }
                int size = FirmwareUpdater.calcRccSize(buffer);
                if (size == -1) {
                    return -1;
                }
                totalSize += size;
                if (rccStream.next()) continue;
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        return totalSize;
    }

    public void stopUpdate() {
        this.m_stopUpdate = true;
    }

    public static ByteArrayOutputStream createWriteImage(byte[] fwImage, RcxHeaderAnalyzer fwData, ArrayList<Map> printerUnits, int[] maxWaitTime, int[] result) {
        if (fwImage == null || fwData == null || printerUnits == null || maxWaitTime == null || result == null) {
            return null;
        }
        int[] areaKeys = fwData.getChildrenKeys("E", "6");
        ArrayList<Pair> updateAreas = new ArrayList<Pair>();
        try {
            block6: for (int i = 0; i < areaKeys.length; ++i) {
                String unitKindFirm = fwData.get("E", new int[]{6, areaKeys[i]});
                String unitIdFirm = fwData.get("E", new int[]{6, areaKeys[i], 1});
                for (int j = 0; j < printerUnits.size(); ++j) {
                    String unitIdUnit;
                    Map printerUnit = printerUnits.get(j);
                    String unitKindUnit = (String)printerUnit.get("UnitKind");
                    if (!unitKindUnit.equals(unitKindFirm) || !(unitIdUnit = (String)printerUnit.get("UnitID")).equals(unitIdFirm)) continue;
                    updateAreas.add(new Pair((Object)areaKeys[i], (Object)UpdateRequiredType.UPDATE_REQUIRED));
                    continue block6;
                }
            }
        }
        catch (Exception e) {
            result[0] = 43;
            return null;
        }
        int tmpMaxWaitTime = 0;
        ByteArrayInputStream rcxInputStream = new ByteArrayInputStream(fwImage);
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        RccStream rccStream = null;
        ByteArrayOutputStream writeImage = new ByteArrayOutputStream();
        try {
            rccStream = new RccStream(rcxInputStream);
        }
        catch (IOException e1) {
            result[0] = 37;
            return null;
        }
        while (!rccStream.isEofStream()) {
            String rccUnitId = rccStream.getRccUnitId();
            if (rccUnitId != null) {
                for (Pair area : updateAreas) {
                    if (area.second == UpdateRequiredType.AREA_NOT_MATCHED) continue;
                    try {
                        String targetUnitId = fwData.get("E", new int[]{6, (Integer)area.first, 1});
                        if (!targetUnitId.equals(rccUnitId)) continue;
                        String timeString = fwData.get("E", new int[]{6, (Integer)area.first, 3});
                        tmpMaxWaitTime += Integer.parseInt(timeString);
                        int readSize = 0;
                        while ((readSize = rccStream.read(buffer, 0, buffer.length)) != -1) {
                            writeImage.write(buffer, 0, readSize);
                        }
                        break;
                    }
                    catch (IOException e) {
                        result[0] = 37;
                        return null;
                    }
                }
            }
            rccStream.next();
        }
        maxWaitTime[0] = tmpMaxWaitTime;
        result[0] = 0;
        return writeImage;
    }

    public static ByteArrayOutputStream createWriteImage_MOT(byte[] fwImage, int[] maxWaitTime, int[] result) {
        int tmpMaxWaitTime;
        if (fwImage == null || maxWaitTime == null || result == null) {
            return null;
        }
        RcxHeaderAnalyzer fwData = FirmwareUpdate.getRcxHeaderAnalyzer(fwImage);
        if (fwData == null) {
            result[0] = 43;
            return null;
        }
        ByteArrayInputStream rcxInputStream = new ByteArrayInputStream(fwImage);
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        RccStream rccStream = null;
        ByteArrayOutputStream writeImage = new ByteArrayOutputStream();
        try {
            rccStream = new RccStream(rcxInputStream);
        }
        catch (IOException e1) {
            result[0] = 37;
            return null;
        }
        while (!rccStream.isEofStream()) {
            try {
                int readSize = 0;
                while ((readSize = rccStream.read(buffer, 0, buffer.length)) != -1) {
                    writeImage.write(buffer, 0, readSize);
                }
            }
            catch (IOException e) {
                result[0] = 37;
                return null;
            }
            rccStream.next();
        }
        String rcxTimeout = fwData.get("B", "4");
        maxWaitTime[0] = tmpMaxWaitTime = Integer.valueOf(rcxTimeout).intValue();
        result[0] = 0;
        return writeImage;
    }

    public static enum UpdateRequiredType {
        UPDATE_REQUIRED,
        UPDATE_NOT_REQUIRED,
        AREA_NOT_MATCHED,
        UPDATE_REQUIRED_WITH_REPEAT;

    }

    public static interface OnProgressListener {
        public void onProgress(int var1);
    }
}

