/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.content.Context;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.printer.CommonPrinter;
import com.epson.epos2.printer.HybdReceiveListener;
import com.epson.epos2.printer.HybdStatusChangeListener;
import com.epson.epos2.printer.HybridPrinterStatusInfo;
import com.epson.epos2.storage.ConnectionInfo;
import java.lang.reflect.Method;

public class HybridPrinter
extends CommonPrinter {
    private HybdStatusChangeListener mStatusChangeListener;
    private HybdReceiveListener mReceiveListener;
    private ConnectionListener mConnectionListener;
    public static final int PAPER_TYPE_RECEIPT = 0;
    public static final int PAPER_TYPE_SLIP = 1;
    public static final int PAPER_TYPE_ENDORSE = 2;
    public static final int PAPER_TYPE_VALIDATION = 3;
    public static final int METHOD_WAITINSERTION = 0;
    public static final int METHOD_SENDDATA = 1;
    public static final int METHOD_CANCELINSERTION = 2;
    public static final int METHOD_EJECTPAPER = 3;
    public static final int METHOD_READMICRDATA = 4;
    public static final int METHOD_CLEANMICRREADER = 5;
    public static final int MICR_FONT_E13B = 0;
    public static final int MICR_FONT_CMC7 = 1;
    public static final int INSERTION_WAIT_SLIP = 0;
    public static final int INSERTION_WAIT_VALIDATION = 1;
    public static final int INSERTION_WAIT_MICR = 2;
    public static final int INSERTION_WAIT_NONE = 3;
    public static final int SLIP_PAPER_OK = 0;
    public static final int SLIP_PAPER_EMPTY = 1;
    public static final int EVENT_INSERTION_WAIT_SLIP = 12;
    public static final int EVENT_INSERTION_WAIT_VALIDATION = 13;
    public static final int EVENT_INSERTION_WAIT_MICR = 14;
    public static final int EVENT_INSERTION_WAIT_NONE = 15;
    public static final int EVENT_REMOVAL_WAIT_PAPER = 16;
    public static final int EVENT_REMOVAL_WAIT_NONE = 17;
    public static final int EVENT_SLIP_PAPER_OK = 18;
    public static final int EVENT_SLIP_PAPER_EMPTY = 19;
    private int mWaitTime = 500;
    private int mMode40Cpl = 1;
    private int mPaperType = 0;
    private static final int WAITTIME_DEFAULT = 500;
    private static final int MODE40CPL_DEFAULT = 1;
    private static final int PAPER_TYPE_DEFAULT = 0;

    protected native int nativeEpos2CreateHandle(int var1, long[] var2);

    protected native int nativeEpos2DestroyHandle(long var1);

    protected native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    protected native int nativeEpos2Disconnect(long var1);

    protected native HybridPrinterStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2SendData(long var1, int var3, long var4, int var6);

    protected native int nativeEpos2SelectPaperType(long var1, int var3);

    protected native int nativeEpos2WaitInsertion(long var1, long var3, long var5);

    protected native int nativeEpos2CancelInsertion(long var1);

    protected native int nativeEpos2EjectPaper(long var1);

    protected native int nativeEpos2ReadMicrData(long var1, int var3, long var4, long var6);

    protected native int nativeEpos2CleanMicrReader(long var1, long var3, long var5);

    protected native int nativeEpos2ForceCommand(long var1, byte[] var3, int var4, int var5);

    protected native int nativeEpos2SetWaitTime(long var1, long var3);

    protected native int nativeEpos2SetMode40Cpl(long var1, int var3);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public HybridPrinter(int lang, Context context) throws Epos2Exception {
        this();
        this.initializeOuputLogFunctions(context);
        this.outputLogCallFunction("HybridPrinter", lang, context);
        ConnectionInfo.setStoragePath(context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("HybridPrinter", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializePrinterInstance(lang);
        this.outputLogReturnFunction("HybridPrinter", 0, lang, context);
    }

    private HybridPrinter() {
    }

    private void initializePrinterInstance(int lang) throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(lang, bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mPrinterHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mStatusChangeListener = null;
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        try {
            if (this.mPrinterHandle != 0L) {
                this.nativeEpos2Disconnect(this.mPrinterHandle);
                this.nativeEpos2ClearCommandBuffer(this.mPrinterHandle);
                this.nativeEpos2DestroyHandle(this.mPrinterHandle);
                this.mPrinterHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mPrinterHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            errStatus = this.nativeEpos2SetInterval(this.mPrinterHandle, this.mInterval);
            if (0 == errStatus) {
                // empty if block
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public HybridPrinterStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        HybridPrinterStatusInfo statusInfo = this.nativeEpos2GetStatus(this.mPrinterHandle);
        if (statusInfo != null) {
            int connection = statusInfo.getConnection();
            int online = statusInfo.getOnline();
            int coverOpen = statusInfo.getCoverOpen();
            int paper = statusInfo.getPaper();
            int paperFeed = statusInfo.getPaperFeed();
            int panelSwitch = statusInfo.getPanelSwitch();
            int waitOnline = statusInfo.getOnline();
            int drawer = statusInfo.getDrawer();
            int errorStatus = statusInfo.getErrorStatus();
            int autoRecoverError = statusInfo.getAutoRecoverError();
            int insertionWaiting = statusInfo.getInsertionWaiting();
            int removalWaiting = statusInfo.getRemovalWaiting();
            int slipPaper = statusInfo.getSlipPaper();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection, "online->" + online, "coverOpen->" + coverOpen, "paper->" + paper, "paperFeed->" + paperFeed, "panelSwitch->" + panelSwitch, "waitOnline->" + waitOnline, "drawer->" + drawer, "errorStatus->" + errorStatus, "autoRecoverError->" + autoRecoverError, "insertionWaiting->" + insertionWaiting, "removalWaiting->" + removalWaiting, "slipPaper->" + slipPaper);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return statusInfo;
    }

    public void sendData(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("sendData", this.mMode40Cpl, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendData(this.mPrinterHandle, this.mMode40Cpl, timeout, 0);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendData", ex);
            this.outputLogReturnFunction("sendData", ex.getErrorStatus(), this.mMode40Cpl, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", 0, this.mMode40Cpl, timeout);
    }

    public void selectPaperType(int paperType) throws Epos2Exception {
        this.outputLogCallFunction("selectPaperType", paperType);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SelectPaperType(this.mPrinterHandle, paperType);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mPaperType = paperType;
        }
        catch (Epos2Exception ex) {
            this.outputException("selectPaperType", ex);
            this.outputLogReturnFunction("selectPaperType", ex.getErrorStatus(), paperType);
            throw ex;
        }
        this.outputLogReturnFunction("selectPaperType", 0, paperType);
    }

    public void waitInsertion(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("waitInsertion", this.mWaitTime, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2WaitInsertion(this.mPrinterHandle, this.mWaitTime, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("waitInsertion", ex);
            this.outputLogReturnFunction("waitInsertion", ex.getErrorStatus(), this.mWaitTime, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("waitInsertion", 0, this.mWaitTime, timeout);
    }

    public void cancelInsertion() throws Epos2Exception {
        this.outputLogCallFunction("cancelInsertion", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2CancelInsertion(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("cancelInsertion", ex);
            this.outputLogReturnFunction("cancelInsertion", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("cancelInsertion", 0, new Object[0]);
    }

    public void ejectPaper() throws Epos2Exception {
        this.outputLogCallFunction("ejectPaper", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2EjectPaper(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("ejectPaper", ex);
            this.outputLogReturnFunction("ejectPaper", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("ejectPaper", 0, new Object[0]);
    }

    public void readMicrData(int micrFont, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("readMicrData", micrFont, this.mWaitTime, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ReadMicrData(this.mPrinterHandle, micrFont, this.mWaitTime, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("readMicrData", ex);
            this.outputLogReturnFunction("readMicrData", ex.getErrorStatus(), micrFont, this.mWaitTime, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("readMicrData", 0, micrFont, this.mWaitTime, timeout);
    }

    public void cleanMicrReader(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("cleanMicrReader", this.mWaitTime, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2CleanMicrReader(this.mPrinterHandle, this.mWaitTime, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("cleanMicrReader", ex);
            this.outputLogReturnFunction("cleanMicrReader", ex.getErrorStatus(), this.mWaitTime, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("cleanMicrReader", 0, this.mWaitTime, timeout);
    }

    public void forceCommand(byte[] data, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forceCommand", data, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForceCommand(this.mPrinterHandle, data, this.mMode40Cpl, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forceCommand", ex);
            this.outputLogReturnFunction("forceCommand", ex.getErrorStatus(), data, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forceCommand", 0, data, timeout);
    }

    public void setStatusChangeEventListener(HybdStatusChangeListener hybdStatusChangeListener) {
        this.outputLogCallFunction("setStatusChangeEventListener", hybdStatusChangeListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mStatusChangeListener = hybdStatusChangeListener != null ? hybdStatusChangeListener : null;
    }

    public void setReceiveEventListener(HybdReceiveListener hybdReceiveListener) {
        this.outputLogCallFunction("setReceiveEventListener", hybdReceiveListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mReceiveListener = hybdReceiveListener != null ? hybdReceiveListener : null;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    public void setWaitTime(int time) throws Epos2Exception {
        this.outputLogCallFunction("setWaitTime", time);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SetWaitTime(this.mPrinterHandle, time);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mWaitTime = time;
        }
        catch (Epos2Exception ex) {
            this.outputException("setWaitTime", ex);
            this.outputLogReturnFunction("setWaitTime", ex.getErrorStatus(), time);
            throw ex;
        }
        this.outputLogReturnFunction("setWaitTime", 0, time);
    }

    public int getWaitTime() {
        return this.mWaitTime;
    }

    public void setMode40Cpl(int mode) throws Epos2Exception {
        this.outputLogCallFunction("setMode40Cpl", mode);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SetMode40Cpl(this.mPrinterHandle, mode);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mMode40Cpl = mode;
        }
        catch (Epos2Exception ex) {
            this.outputException("setMode40Cpl", ex);
            this.outputLogReturnFunction("setMode40Cpl", ex.getErrorStatus(), mode);
            throw ex;
        }
        this.outputLogReturnFunction("setMode40Cpl", 0, mode);
    }

    public int getMode40Cpl() {
        return this.mMode40Cpl;
    }

    public int getPaperType() {
        return this.mPaperType;
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mPrinterHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mPrinterHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mPrinterHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mPrinterHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    private void onHybdStatusChange(int eventType) {
        this.outputLogCallFunction("onHybdStatusChange", eventType, this);
        if (null != this.mStatusChangeListener) {
            this.mStatusChangeListener.onHybdStatusChange(this, eventType);
            this.outputLogEvent("onHybdStatusChange", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onHybdStatusChange", 0, eventType, this);
    }

    private void onHybdReceive(int method, int code, String micrData, HybridPrinterStatusInfo status) {
        int connection = status.getConnection();
        int online = status.getOnline();
        int coverOpen = status.getCoverOpen();
        int paper = status.getPaper();
        int paperFeed = status.getPaperFeed();
        int panelSwitch = status.getPanelSwitch();
        int waitOnline = status.getOnline();
        int drawer = status.getDrawer();
        int errorStatus = status.getErrorStatus();
        int autoRecoverError = status.getAutoRecoverError();
        int insertionWaiting = status.getInsertionWaiting();
        int removalWaiting = status.getRemovalWaiting();
        int slipPaper = status.getSlipPaper();
        this.outputLogCallFunction("onHybdReceive", method, code, status, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onHybdReceive(this, method, code, micrData, status);
            this.outputLogEvent("onHybdReceive", "method->", method, "code->", code, "connection->", connection, "online->", online, "coverOpen->", coverOpen, "paper->", paper, "paperFeed->", paperFeed, "panelSwitch->", panelSwitch, "waitOnline->", waitOnline, "drawer->", drawer, "errorStatus->", errorStatus, "autoRecoverError->", autoRecoverError, "insertionWaiting->", insertionWaiting, "removalWaiting->", removalWaiting, "slipPaper->", slipPaper);
        }
        this.outputLogReturnFunction("onHybdReceive", 0, method, code, status, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }
}

