/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.content.Context;
import android.graphics.Bitmap;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.printer.CommonPrinter;
import com.epson.epos2.printer.LFCPrintCompleteListener;
import com.epson.epos2.printer.LFCPrinterStatusInfo;
import com.epson.epos2.printer.LFCSendCompleteListener;
import com.epson.epos2.printer.LFCStatusChangeListener;
import com.epson.epos2.printer.LogoKeyCode;
import com.epson.epos2.storage.ConnectionInfo;
import java.lang.reflect.Method;

public class LFCPrinter
extends CommonPrinter {
    private LFCStatusChangeListener mStatusChangeListener;
    private LFCSendCompleteListener mSendCompleteListener;
    private LFCPrintCompleteListener mPrintCompleteListener;
    public static final int TM_L90LFC = 26;
    public static final int TM_L100 = 28;
    public static final int BATTERY_LEVEL_6 = 6;
    public static final int BATTERY_LEVEL_5 = 5;
    public static final int BATTERY_LEVEL_4 = 4;
    public static final int BATTERY_LEVEL_3 = 3;
    public static final int BATTERY_LEVEL_2 = 2;
    public static final int BATTERY_LEVEL_1 = 1;
    public static final int BATTERY_LEVEL_0 = 0;
    public static final int EVENT_BATTERY_ENOUGH = 10;
    public static final int EVENT_BATTERY_EMPTY = 11;
    public static final int EVENT_REMOVAL_WAIT_PAPER = 16;
    public static final int EVENT_REMOVAL_WAIT_NONE = 17;

    protected native int nativeEpos2CreateHandle(int var1, int var2, long[] var3);

    protected native int nativeEpos2DestroyHandle(long var1);

    protected native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    protected native int nativeEpos2Disconnect(long var1);

    protected native int nativeEpos2SendLFCData(long var1, long var3, long var5);

    protected native LFCPrinterStatusInfo nativeEpos2GetStatus(long var1);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    public LFCPrinter(int printerSeries, int lang, Context context) throws Epos2Exception {
        this();
        this.initializeOuputLogFunctions(context);
        ConnectionInfo.setStoragePath(context);
        this.outputLogCallFunction("LFCPrinter", printerSeries, lang, context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("LFCPrinter", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializeLFCPrinterInstance(printerSeries, lang);
        this.outputLogReturnFunction("LFCPrinter", 0, printerSeries, lang, context);
    }

    private LFCPrinter() {
    }

    private void initializeLFCPrinterInstance(int printerSeries, int lang) throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(printerSeries, lang, bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mPrinterHandle = bufHandle[0];
        bufHandle[0] = 0L;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mStatusChangeListener = null;
        this.mSendCompleteListener = null;
        this.mPrintCompleteListener = null;
        try {
            if (this.mPrinterHandle != 0L) {
                this.nativeEpos2Disconnect(this.mPrinterHandle);
                this.nativeEpos2ClearCommandBuffer(this.mPrinterHandle);
                this.nativeEpos2DestroyHandle(this.mPrinterHandle);
                this.mPrinterHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mPrinterHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            errStatus = this.nativeEpos2SetInterval(this.mPrinterHandle, this.mInterval);
            if (0 == errStatus) {
                // empty if block
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public LFCPrinterStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        LFCPrinterStatusInfo statusInfo = this.nativeEpos2GetStatus(this.mPrinterHandle);
        if (statusInfo != null) {
            int connection = statusInfo.getConnection();
            int online = statusInfo.getOnline();
            int coverOpen = statusInfo.getCoverOpen();
            int paper = statusInfo.getPaper();
            int paperFeed = statusInfo.getPaperFeed();
            int panelSwitch = statusInfo.getPanelSwitch();
            int waitOnline = statusInfo.getOnline();
            int drawer = statusInfo.getDrawer();
            int errorStatus = statusInfo.getErrorStatus();
            int autoRecoverError = statusInfo.getAutoRecoverError();
            int buzzer = statusInfo.getBuzzer();
            int adapter = statusInfo.getAdapter();
            int batteryLevel = statusInfo.getBatteryLevel();
            int removalWaiting = statusInfo.getRemovalWaiting();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection, "online->" + online, "coverOpen->" + coverOpen, "paper->" + paper, "paperFeed->" + paperFeed, "panelSwitch->" + panelSwitch, "waitOnline->" + waitOnline, "drawer->" + drawer, "errorStatus->" + errorStatus, "autoRecoverError->" + autoRecoverError, "buzzer->" + buzzer, "adapter->" + adapter, "batteryLevel->" + batteryLevel, "removalWaiting->" + removalWaiting);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return statusInfo;
    }

    public void sendLFCData(int timeout, int jobNumber) throws Epos2Exception {
        this.outputLogCallFunction("sendLFCData", timeout, jobNumber);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendLFCData(this.mPrinterHandle, timeout, jobNumber);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendLFCData", ex);
            this.outputLogReturnFunction("sendLFCData", ex.getErrorStatus(), timeout, jobNumber);
            throw ex;
        }
    }

    protected void registerLogo(int key1, int key2, Bitmap data, int x, int y, int width, int height, int color2, int mode, int halftone, double brightness) throws Epos2Exception {
    }

    protected void unregisterLogo(int key1, int key2) throws Epos2Exception {
    }

    protected void unregisterAllLogo() throws Epos2Exception {
    }

    protected LogoKeyCode[] getLogoList() throws Epos2Exception {
        return null;
    }

    public void setStatusChangeEventListener(LFCStatusChangeListener lfcStatusChangeListener) {
        this.outputLogCallFunction("setStatusChangeEventListener", lfcStatusChangeListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mStatusChangeListener = lfcStatusChangeListener != null ? lfcStatusChangeListener : null;
    }

    public void setSendCompleteEventListener(LFCSendCompleteListener sendCompleteListener) {
        this.outputLogCallFunction("setSendCompleteEventListener", sendCompleteListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mSendCompleteListener = sendCompleteListener != null ? sendCompleteListener : null;
    }

    public void setPrintCompleteEventListener(LFCPrintCompleteListener lfcPrintCompleteListener) {
        this.outputLogCallFunction("setPrintCompleteEventListener", lfcPrintCompleteListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mPrintCompleteListener = lfcPrintCompleteListener != null ? lfcPrintCompleteListener : null;
    }

    public String getAdmin() {
        return "";
    }

    public String getLocation() {
        return "";
    }

    private void onLFCStatusChange(int eventType) {
        this.outputLogCallFunction("onLFCStatusChange", eventType, this);
        if (null != this.mStatusChangeListener) {
            this.mStatusChangeListener.onLFCStatusChange(this, eventType);
            this.outputLogEvent("onLFCStatusChange", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onLFCStatusChange", 0, eventType, this);
    }

    private void onSendComplete(int jobNumber, int code, LFCPrinterStatusInfo status) {
        int connection = status.getConnection();
        int online = status.getOnline();
        int coverOpen = status.getCoverOpen();
        int paper = status.getPaper();
        int paperFeed = status.getPaperFeed();
        int panelSwitch = status.getPanelSwitch();
        int waitOnline = status.getOnline();
        int drawer = status.getDrawer();
        int errorStatus = status.getErrorStatus();
        int autoRecoverError = status.getAutoRecoverError();
        int buzzer = status.getBuzzer();
        int adapter = status.getAdapter();
        int batteryLevel = status.getBatteryLevel();
        int removalWaiting = status.getRemovalWaiting();
        this.outputLogCallFunction("onSendComplete", jobNumber, code, status, this);
        if (null != this.mSendCompleteListener) {
            this.mSendCompleteListener.onSendComplete(this, jobNumber, code, status);
            this.outputLogEvent("onSendComplete", "code->", code, "connection->", connection, "online->", online, "coverOpen->", coverOpen, "paper->", paper, "paperFeed->", paperFeed, "panelSwitch->", panelSwitch, "waitOnline->", waitOnline, "drawer->", drawer, "errorStatus->", errorStatus, "autoRecoverError->", autoRecoverError, "buzzer->", buzzer, "adapter->", adapter, "batteryLevel->", batteryLevel, "removalWaiting->", removalWaiting);
        }
        this.outputLogReturnFunction("onSendComplete", 0, jobNumber, code, status, this);
    }

    private void onPrintComplete(int jobNumber) {
        this.outputLogCallFunction("onPrintComplete", jobNumber, this);
        if (null != this.mPrintCompleteListener) {
            this.mPrintCompleteListener.onPrintComplete(this, jobNumber);
            this.outputLogEvent("onPrintComplete", jobNumber);
        }
        this.outputLogReturnFunction("onPrintComplete", 0, jobNumber, this);
    }

    @Override
    public void beginTransaction() throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public void endTransaction() throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public void forceRecover(int timeout) throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public void forcePulse(int drawer, int pulseTime, int timeout) throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public void forceReset(int timeout) throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public void setInterval(int interval) throws Epos2Exception {
        throw new Epos2Exception(15);
    }

    @Override
    public int getInterval() {
        return this.mInterval;
    }
}

