/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Base64;
import android.util.Pair;
import com.epson.epos2.ConnectionListener;
import com.epson.epos2.Epos2Exception;
import com.epson.epos2.printer.CommonPrinter;
import com.epson.epos2.printer.EposSdkJson;
import com.epson.epos2.printer.FirmwareDownloader;
import com.epson.epos2.printer.FirmwareInfo;
import com.epson.epos2.printer.FirmwareUpdate;
import com.epson.epos2.printer.FirmwareUpdateListener;
import com.epson.epos2.printer.FirmwareUpdater;
import com.epson.epos2.printer.GetPrinterSettingExListener;
import com.epson.epos2.printer.LogoKeyCode;
import com.epson.epos2.printer.MaintenanceCounterListener;
import com.epson.epos2.printer.PrinterInformationListener;
import com.epson.epos2.printer.PrinterNetworkStatusInfo;
import com.epson.epos2.printer.PrinterSettingListener;
import com.epson.epos2.printer.PrinterStatusInfo;
import com.epson.epos2.printer.RcxHeaderAnalyzer;
import com.epson.epos2.printer.ReceiveListener;
import com.epson.epos2.printer.SetPrinterSettingExListener;
import com.epson.epos2.printer.StatusChangeListener;
import com.epson.epos2.printer.TMUtilityFirmwareDownloader;
import com.epson.epos2.printer.TMUtilityFirmwareUpdater;
import com.epson.epos2.printer.VerifyPasswordListener;
import com.epson.epos2.printer.firmwareUpdateException;
import com.epson.epos2.printer.tmutility.data.JSONData;
import com.epson.epos2.printer.tmutility.printerSettings.intelligent.TMiUtil;
import com.epson.epos2.storage.ConnectionInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.json.JSONObject;

public class Printer
extends CommonPrinter {
    private StatusChangeListener mStatusChangeListener;
    private ReceiveListener mReceiveListener;
    private ConnectionListener mConnectionListener;
    private PrinterInformationListener mPrinterInformationListener;
    private VerifyPasswordListener mVerifyPasswordListener;
    private GetPrinterSettingExListener mGetPrinterSettingExListener;
    private SetPrinterSettingExListener mSetPrinterSettingExListener;
    private byte[] firmwareImage;
    private FirmwareInfo currentImagesFirmwareInfo;
    private URL currentImagesFirmwareUrl;
    public static final int TM_M10 = 0;
    public static final int TM_M30 = 1;
    public static final int TM_P20 = 2;
    public static final int TM_P60 = 3;
    public static final int TM_P60II = 4;
    public static final int TM_P80 = 5;
    public static final int TM_T20 = 6;
    public static final int TM_T60 = 7;
    public static final int TM_T70 = 8;
    public static final int TM_T81 = 9;
    public static final int TM_T82 = 10;
    public static final int TM_T83 = 11;
    public static final int TM_T88 = 12;
    public static final int TM_T90 = 13;
    public static final int TM_T90KP = 14;
    public static final int TM_U220 = 15;
    public static final int TM_U330 = 16;
    public static final int TM_L90 = 17;
    public static final int TM_H6000 = 18;
    public static final int TM_T83III = 19;
    public static final int TM_T100 = 20;
    public static final int TM_M30II = 22;
    public static final int TS_100 = 23;
    public static final int TM_M50 = 24;
    public static final int TM_T88VII = 25;
    public static final int TM_L90LFC = 26;
    public static final int EU_M30 = 27;
    public static final int TM_L100 = 28;
    public static final int TM_P20II = 30;
    public static final int TM_P80II = 31;
    public static final int TM_M30III = 32;
    public static final int TM_M50II = 33;
    public static final int TM_M55 = 34;
    public static final int LAYOUT_RECEIPT = 0;
    public static final int LAYOUT_LABEL = 1;
    public static final int LAYOUT_LABEL_BM = 2;
    public static final int LAYOUT_RECEIPT_BM = 3;
    public static final int BATTERY_LEVEL_6 = 6;
    public static final int BATTERY_LEVEL_5 = 5;
    public static final int BATTERY_LEVEL_4 = 4;
    public static final int BATTERY_LEVEL_3 = 3;
    public static final int BATTERY_LEVEL_2 = 2;
    public static final int BATTERY_LEVEL_1 = 1;
    public static final int BATTERY_LEVEL_0 = 0;
    public static final int HIGH_VOLTAGE_ERR = 0;
    public static final int LOW_VOLTAGE_ERR = 1;
    public static final int REMOVAL_DETECT_PAPER = 0;
    public static final int REMOVAL_DETECT_PAPER_NONE = 1;
    public static final int REMOVAL_DETECT_UNKNOWN = 2;
    public static final int EVENT_BATTERY_ENOUGH = 10;
    public static final int EVENT_BATTERY_EMPTY = 11;
    public static final int EVENT_REMOVAL_WAIT_PAPER = 16;
    public static final int EVENT_REMOVAL_WAIT_NONE = 17;
    public static final int EVENT_AUTO_RECOVER_ERROR = 20;
    public static final int EVENT_AUTO_RECOVER_OK = 21;
    public static final int EVENT_UNRECOVERABLE_ERROR = 22;
    public static final int EVENT_REMOVAL_DETECT_PAPER = 23;
    public static final int EVENT_REMOVAL_DETECT_PAPER_NONE = 24;
    public static final int EVENT_REMOVAL_DETECT_UNKNOWN = 25;
    private static final int MIN_PRINTJOBID_LENGTH = 1;
    private static final int MAX_PRINTJOBID_LENGTH = 30;
    public static final int MAINTENANCE_COUNTER_PAPERFEED = 0;
    public static final int MAINTENANCE_COUNTER_AUTOCUTTER = 1;
    public static final int MAINTENANCE_COUNTER_OTHER = 2;
    public static final int SETTING_PAPERWIDTH = 0;
    public static final int SETTING_PRINTDENSITY = 1;
    public static final int SETTING_PRINTSPEED = 2;
    public static final int SETTING_OTHER = 3;
    public static final int SETTING_PAPERWIDTH_NOT_SETTING_TARGET = 100000;
    public static final int SETTING_PAPERWIDTH_58_0 = 2;
    public static final int SETTING_PAPERWIDTH_60_0 = 3;
    public static final int SETTING_PAPERWIDTH_70_0 = 4;
    public static final int SETTING_PAPERWIDTH_76_0 = 5;
    public static final int SETTING_PAPERWIDTH_80_0 = 6;
    public static final int SETTING_PRINTDENSITY_NOT_SETTING_TARGET = 100000;
    public static final int SETTING_PRINTDENSITY_DIP = 100;
    public static final int SETTING_PRINTDENSITY_70 = 65530;
    public static final int SETTING_PRINTDENSITY_75 = 65531;
    public static final int SETTING_PRINTDENSITY_80 = 65532;
    public static final int SETTING_PRINTDENSITY_85 = 65533;
    public static final int SETTING_PRINTDENSITY_90 = 65534;
    public static final int SETTING_PRINTDENSITY_95 = 65535;
    public static final int SETTING_PRINTDENSITY_100 = 0;
    public static final int SETTING_PRINTDENSITY_105 = 1;
    public static final int SETTING_PRINTDENSITY_110 = 2;
    public static final int SETTING_PRINTDENSITY_115 = 3;
    public static final int SETTING_PRINTDENSITY_120 = 4;
    public static final int SETTING_PRINTDENSITY_125 = 5;
    public static final int SETTING_PRINTDENSITY_130 = 6;
    public static final int SETTING_PRINTSPEED_NOT_SETTING_TARGET = 100000;
    public static final int SETTING_PRINTSPEED_1 = 1;
    public static final int SETTING_PRINTSPEED_2 = 2;
    public static final int SETTING_PRINTSPEED_3 = 3;
    public static final int SETTING_PRINTSPEED_4 = 4;
    public static final int SETTING_PRINTSPEED_5 = 5;
    public static final int SETTING_PRINTSPEED_6 = 6;
    public static final int SETTING_PRINTSPEED_7 = 7;
    public static final int SETTING_PRINTSPEED_8 = 8;
    public static final int SETTING_PRINTSPEED_9 = 9;
    public static final int SETTING_PRINTSPEED_10 = 10;
    public static final int SETTING_PRINTSPEED_11 = 11;
    public static final int SETTING_PRINTSPEED_12 = 12;
    public static final int SETTING_PRINTSPEED_13 = 13;
    public static final int SETTING_PRINTSPEED_14 = 14;
    public static final int SETTING_PRINTSPEED_15 = 15;
    public static final int SETTING_PRINTSPEED_16 = 16;
    public static final int SETTING_PRINTSPEED_17 = 17;
    public static final int WIFI_SIGNAL_NO = 0;
    public static final int WIFI_SIGNAL_FAIL = 1;
    public static final int WIFI_SIGNAL_GOOD = 2;
    public static final int WIFI_SIGNAL_EXCELLENT = 3;
    public static final String JSON_KEY_PRINTERSPEC_NAME = "PrinterSpec";
    public static final String JSON_KEY_PRODUCT_NAME = "Product";
    public static final String JSON_KEY_SERIALNO_NAME = "SerialNo";
    public static final String JSON_KEY_MAINTENANCE_NAME = "Maintenance";
    public static final String JSON_KEY_THERMALHEAD_NAME = "ThermalHead";
    public static final String JSON_KEY_N_WARNINGDOT_NAME = "NumberOfWarningDot";
    public static final String JSON_KEY_P_WARNINGDOT_NAME = "PositionOfWarningDot";
    public static final String JSON_KEY_N_BROKENDOT_NAME = "NumberOfBrokenDot";
    public static final String JSON_KEY_P_BROKENDOT_NAME = "PositionOfBrokenDot";
    public static final String JSON_KEY_SETTING_NWDEVINFO_PASSWORDAUTH_KEY = "Setting/NwDevInfo/PasswordAuth";
    public static final String JSON_KEY_SETTING_NWDEVINFO_ADMINID_KEY = "Setting/NwDevInfo/AdminId";
    public static final String JSON_KEY_SETTING_NWCSAUTH_PASSWORD_KEY = "Setting/NwCSAuth/Password";
    public static final String JSON_KEY_SETTING_WIFICFG_WPAPSK_KEY = "Setting/WifiCfg/WpaPsk/Key";
    public static final String PREFIX_ENCRYPT = "U2FsdGVkX1";
    public static final int FIRMWARE_MODE_NORMAL = 1;
    public static final int FIRMWARE_MODE_MEMORY_REWRITE = 2;
    private static final int FIRMWARE_FILE_EFX = 1;
    private static final int FIRMWARE_FILE_MOT = 2;
    int firmwareFileType = -3;

    protected native int nativeEpos2CreateHandle(int var1, int var2, long[] var3);

    protected native int nativeEpos2DestroyHandle(long var1);

    protected native int nativeEpos2Connect(long var1, String var3, long var4, Object var6);

    protected native int nativeEpos2Disconnect(long var1);

    protected native PrinterStatusInfo nativeEpos2GetStatus(long var1);

    protected native int nativeEpos2SendData(long var1, long var3, String var5, int var6);

    protected native int nativeEpos2RequestPrintJobStatus(long var1, String var3);

    protected native int nativeEpos2AddHLine(long var1, long var3, long var5, int var7);

    protected native int nativeEpos2AddVLineBegin(long var1, long var3, int var5, int[] var6);

    protected native int nativeEpos2AddVLineEnd(long var1, int var3);

    protected native int nativeEpos2AddLayout(long var1, int var3, long var4, long var6, long var8, long var10, long var12, long var14);

    protected native int nativeEpos2RegisterLogo(long var1, long var3, long var5, byte[] var7, long var8, long var10, long var12, long var14, long var16, long var18, int var20, int var21, int var22, double var23);

    protected native int nativeEpos2UnregisterLogo(long var1, long var3, long var5);

    protected native int nativeEpos2UnregisterAllLogo(long var1);

    protected native int nativeEpos2GetLogoList(long var1, Vector<LogoKeyCode> var3);

    protected native int nativeEpos2ForceStopSound(long var1, int var3);

    protected native int nativeEpos2ForceCommand(long var1, byte[] var3, int var4);

    protected native String nativeEpos2GetAdmin(long var1);

    protected native String nativeEpos2GetLocation(long var1);

    protected native int nativeEpos2GetMaintenanceCounter(long var1, int var3, int var4, int[] var5);

    protected native int nativeEpos2ResetMaintenanceCounter(long var1, int var3, int var4);

    protected native int nativeEpos2GetPrinterSetting(long var1, int var3, int var4, int[] var5);

    protected native int nativeEpos2SetPrinterSetting(long var1, int var3, int[] var4, int[] var5);

    protected native int nativeEpos2GetFirmwareInformation(long var1, int var3, String[] var4);

    protected native int nativeEpos2WriteFirmwareImage(long var1, byte[] var3, boolean var4);

    protected native int nativeEpos2GetPrinterInformation(long var1, int var3);

    protected native int nativeEpos2VerifyPassword(long var1, int var3, String var4);

    protected native int nativeEpos2GetPrinterSettingEx(long var1, int var3);

    protected native int nativeEpos2SetPrinterSettingEx(long var1, int var3, String var4);

    protected native PrinterNetworkStatusInfo nativeEpos2GetNetworkStatus(long var1, int var3);

    protected native int nativeEpos2GetPrinterMode(long var1);

    protected native String nativeEpos2GetPrinterBootId(long var1);

    protected native int nativeEpos2WriteFirmwareImageMOT(long var1, byte[] var3, boolean var4);

    private void checkPrintJobIdFormat(String printJobId) throws Epos2Exception {
        if (printJobId == null) {
            throw new Epos2Exception(1);
        }
        if (printJobId.length() < 1 || 30 < printJobId.length()) {
            throw new Epos2Exception(1);
        }
        if (printJobId.matches(".*[^-._0-9A-Za-z].*")) {
            throw new Epos2Exception(1);
        }
    }

    public Printer(int printerSeries, int lang, Context context) throws Epos2Exception {
        this();
        this.initializeOuputLogFunctions(context);
        ConnectionInfo.setStoragePath(context);
        this.outputLogCallFunction("Printer", printerSeries, lang, context);
        try {
            Class<?> classInitializer = Class.forName("com.epson.epos2.NativeInitializer");
            Method initializeMethod = classInitializer.getDeclaredMethod("initializeNativeEnv", Context.class);
            initializeMethod.setAccessible(true);
            initializeMethod.invoke(classInitializer, context);
        }
        catch (Exception e) {
            this.outputException("Printer", e);
            e.printStackTrace();
        }
        this.mContext = context;
        this.initializePrinterInstance(printerSeries, lang);
        this.outputLogReturnFunction("Printer", 0, printerSeries, lang, context);
    }

    private Printer() {
    }

    private void initializePrinterInstance(int printerSeries, int lang) throws Epos2Exception {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeEpos2CreateHandle(printerSeries, lang, bufHandle);
        if (0 != errStatus) {
            throw new Epos2Exception(errStatus);
        }
        this.mPrinterHandle = bufHandle[0];
        bufHandle[0] = 0L;
        this.mConnectedTarget = null;
    }

    protected void finalize() throws Throwable {
        this.outputLogCallFunction("finalize", new Object[0]);
        this.mStatusChangeListener = null;
        this.mReceiveListener = null;
        this.mConnectionListener = null;
        this.mPrinterInformationListener = null;
        this.mConnectedTarget = null;
        try {
            if (this.mPrinterHandle != 0L) {
                this.nativeEpos2Disconnect(this.mPrinterHandle);
                this.nativeEpos2ClearCommandBuffer(this.mPrinterHandle);
                this.nativeEpos2DestroyHandle(this.mPrinterHandle);
                this.mPrinterHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
        this.outputLogReturnFunction("finalize", 0, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String target, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("connect", target, timeout);
        try {
            if (null == target) {
                throw new Epos2Exception(1);
            }
            this.checkHandle();
            int errStatus = this.nativeEpos2Connect(this.mPrinterHandle, target, timeout, this.mContext);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mConnectedTarget = target;
            errStatus = this.nativeEpos2SetInterval(this.mPrinterHandle, this.mInterval);
            if (0 == errStatus) {
                // empty if block
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("connect", ex);
            this.outputLogReturnFunction("connect", ex.getErrorStatus(), target, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("connect", 0, target, timeout);
    }

    public void disconnect() throws Epos2Exception {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2Disconnect(this.mPrinterHandle);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            this.mConnectedTarget = null;
        }
        catch (Epos2Exception ex) {
            this.outputException("disconnect", ex);
            this.outputLogReturnFunction("disconnect", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", 0, new Object[0]);
    }

    public PrinterStatusInfo getStatus() {
        this.outputLogCallFunction("getStatus", new Object[0]);
        PrinterStatusInfo statusInfo = this.nativeEpos2GetStatus(this.mPrinterHandle);
        if (statusInfo != null) {
            int connection = statusInfo.getConnection();
            int online = statusInfo.getOnline();
            int coverOpen = statusInfo.getCoverOpen();
            int paper = statusInfo.getPaper();
            int paperFeed = statusInfo.getPaperFeed();
            int panelSwitch = statusInfo.getPanelSwitch();
            int waitOnline = statusInfo.getOnline();
            int drawer = statusInfo.getDrawer();
            int errorStatus = statusInfo.getErrorStatus();
            int autoRecoverError = statusInfo.getAutoRecoverError();
            int buzzer = statusInfo.getBuzzer();
            int adapter = statusInfo.getAdapter();
            int batteryLevel = statusInfo.getBatteryLevel();
            int removalWaiting = statusInfo.getRemovalWaiting();
            int paperTakenSensor = statusInfo.getPaperTakenSensor();
            int unrecoverError = statusInfo.getUnrecoverError();
            this.outputLogReturnFunction("getStatus", 0, "connection->" + connection, "online->" + online, "coverOpen->" + coverOpen, "paper->" + paper, "paperFeed->" + paperFeed, "panelSwitch->" + panelSwitch, "waitOnline->" + waitOnline, "drawer->" + drawer, "errorStatus->" + errorStatus, "autoRecoverError->" + autoRecoverError, "buzzer->" + buzzer, "adapter->" + adapter, "batteryLevel->" + batteryLevel, "removalWaiting->" + removalWaiting, "paperTakenSensor->" + paperTakenSensor, "unrecoverError->" + unrecoverError);
        } else {
            this.outputLogReturnFunction("getStatus", 257, new Object[0]);
        }
        return statusInfo;
    }

    public void sendData(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("sendData", timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2SendData(this.mPrinterHandle, timeout, "", 0);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("sendData", ex);
            this.outputLogReturnFunction("sendData", ex.getErrorStatus(), timeout);
            throw ex;
        }
        this.outputLogReturnFunction("sendData", 0, timeout);
    }

    public void requestPrintJobStatus(String printJobId) throws Epos2Exception {
        this.outputLogCallFunction("getPrintJobStatus", printJobId);
        try {
            this.checkHandle();
            this.checkPrintJobIdFormat(printJobId);
            int errStatus = 0;
            errStatus = this.nativeEpos2RequestPrintJobStatus(this.mPrinterHandle, printJobId);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getPrintJobStatus", ex);
            this.outputLogReturnFunction("getPrintJobStatus", ex.getErrorStatus(), printJobId);
            throw ex;
        }
        this.outputLogReturnFunction("getPrintJobStatus", 0, printJobId);
    }

    public void addHLine(int x1, int x2, int style) throws Epos2Exception {
        this.outputLogCallFunction("addHLine", x1, x2, style);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddHLine(this.mPrinterHandle, x1, x2, style);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addHLine", ex);
            this.outputLogReturnFunction("addHLine", ex.getErrorStatus(), x1, x2, style);
            throw ex;
        }
        this.outputLogReturnFunction("addHLine", 0, x1, x2, style);
    }

    public void addVLineBegin(int x, int style, int[] lineId) throws Epos2Exception {
        this.outputLogCallFunction("addVLineBegin", x, style, lineId);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddVLineBegin(this.mPrinterHandle, x, style, lineId);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addVLineBegin", ex);
            this.outputLogReturnFunction("addVLineBegin", ex.getErrorStatus(), x, style, lineId);
            throw ex;
        }
        this.outputLogReturnFunction("addVLineBegin", 0, x, style, lineId);
    }

    public void addVLineEnd(int lineId) throws Epos2Exception {
        this.outputLogCallFunction("addVLineEnd", lineId);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddVLineEnd(this.mPrinterHandle, lineId);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addVLineEnd", ex);
            this.outputLogReturnFunction("addVLineEnd", ex.getErrorStatus(), lineId);
            throw ex;
        }
        this.outputLogReturnFunction("addVLineEnd", 0, lineId);
    }

    public void addLayout(int type, int width, int height, int marginTop, int marginBottom, int offsetCut, int offsetLabel) throws Epos2Exception {
        this.outputLogCallFunction("addLayout", type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2AddLayout(this.mPrinterHandle, type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("addLayout", ex);
            this.outputLogReturnFunction("addLayout", ex.getErrorStatus(), type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
            throw ex;
        }
        this.outputLogReturnFunction("addLayout", 0, type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
    }

    protected void registerLogo(int key1, int key2, Bitmap data, int x, int y, int width, int height, int color2, int mode, int halftone, double brightness) throws Epos2Exception {
    }

    protected void unregisterLogo(int key1, int key2) throws Epos2Exception {
    }

    protected void unregisterAllLogo() throws Epos2Exception {
    }

    protected LogoKeyCode[] getLogoList() throws Epos2Exception {
        return null;
    }

    public void forceStopSound(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forceStopSound", timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForceStopSound(this.mPrinterHandle, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forceStopSound", ex);
            this.outputLogReturnFunction("forceStopSound", ex.getErrorStatus(), timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forceStopSound", 0, timeout);
    }

    public void forceCommand(byte[] data, int timeout) throws Epos2Exception {
        this.outputLogCallFunction("forceCommand", data, timeout);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2ForceCommand(this.mPrinterHandle, data, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("forceCommand", ex);
            this.outputLogReturnFunction("forceCommand", ex.getErrorStatus(), data, timeout);
            throw ex;
        }
        this.outputLogReturnFunction("forceCommand", 0, data, timeout);
    }

    public void setStatusChangeEventListener(StatusChangeListener statusChangeListener) {
        this.outputLogCallFunction("setStatusChangeEventListener", statusChangeListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mStatusChangeListener = statusChangeListener != null ? statusChangeListener : null;
    }

    public void setReceiveEventListener(ReceiveListener receiveListener) {
        this.outputLogCallFunction("setReceiveEventListener", receiveListener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mReceiveListener = receiveListener != null ? receiveListener : null;
    }

    public void setConnectionEventListener(ConnectionListener listener) {
        this.outputLogCallFunction("setConnectionEventListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mConnectionListener = listener != null ? listener : null;
    }

    private void setPrinterInformationListener(PrinterInformationListener listener) {
        this.outputLogCallFunction("setPrinterInformationListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mPrinterInformationListener = listener != null ? listener : null;
    }

    public void setVerifyPasswordListener(VerifyPasswordListener listener) {
        this.outputLogCallFunction("setVerifyPasswordListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mVerifyPasswordListener = listener != null ? listener : null;
    }

    public void setGetPrinterSettingExListener(GetPrinterSettingExListener listener) {
        this.outputLogCallFunction("setGetPrinterSettingExListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mGetPrinterSettingExListener = listener != null ? listener : null;
    }

    public void setSetPrinterSettingExListener(SetPrinterSettingExListener listener) {
        this.outputLogCallFunction("setSetPrinterSettingExListener", listener);
        if (this.mPrinterHandle == 0L) {
            return;
        }
        this.mSetPrinterSettingExListener = listener != null ? listener : null;
    }

    public String getAdmin() {
        String admin = null;
        this.outputLogCallFunction("getAdmin", new Object[0]);
        if (this.mPrinterHandle == 0L) {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
            return "";
        }
        admin = this.nativeEpos2GetAdmin(this.mPrinterHandle);
        if (admin != null) {
            this.outputLogReturnFunction("getAdmin", 0, admin);
        } else {
            this.outputLogReturnFunction("getAdmin", 256, new Object[0]);
        }
        return admin;
    }

    public String getLocation() {
        String location = null;
        this.outputLogCallFunction("getLocation", new Object[0]);
        if (this.mPrinterHandle == 0L) {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
            return "";
        }
        location = this.nativeEpos2GetLocation(this.mPrinterHandle);
        if (location != null) {
            this.outputLogReturnFunction("getLocation", 0, location);
        } else {
            this.outputLogReturnFunction("getLocation", 256, new Object[0]);
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMaintenanceCounter(int timeout, int type, MaintenanceCounterListener listener) throws Epos2Exception {
        this.outputLogCallFunction("getMaintenanceCounter", timeout, type);
        try {
            this.checkHandle();
            int edcType = 2;
            if (timeout == -2) {
                timeout = 10000;
            }
            if (timeout < 5000 || 60000 < timeout) {
                throw new Epos2Exception(1);
            }
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            if (type != 0 && type != 1) {
                throw new Epos2Exception(1);
            }
            Printer printer = this;
            synchronized (printer) {
                InnerThread th = new InnerThread(this, listener, this.mPrinterHandle, timeout, type, null, null){

                    @Override
                    public void run() {
                        if (this.mPrn == null || this.mListener == null) {
                            return;
                        }
                        int[] value = new int[]{0};
                        int errStatus = this.mPrn.nativeEpos2GetMaintenanceCounter(this.mHandle, this.mTimeout, this.mType, value);
                        Printer.this.outputLogEvent("onGetMaintenanceCounter", "code->", errStatus, "type->", this.mType, "value->", value[0]);
                        ((MaintenanceCounterListener)this.mListener).onGetMaintenanceCounter(errStatus, this.mType, value[0]);
                    }
                };
                th.start();
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getMaintenanceCounter", ex);
            this.outputLogReturnFunction("getMaintenanceCounter", ex.getErrorStatus(), timeout, type);
            throw ex;
        }
        this.outputLogReturnFunction("getMaintenanceCounter", 0, timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMaintenanceCounter(int timeout, int type, MaintenanceCounterListener listener) throws Epos2Exception {
        this.outputLogCallFunction("resetMaintenanceCounter", timeout, type);
        try {
            this.checkHandle();
            int edcType = 2;
            if (timeout == -2) {
                timeout = 10000;
            }
            if (timeout < 5000 || 60000 < timeout) {
                throw new Epos2Exception(1);
            }
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            if (type != 0 && type != 1) {
                throw new Epos2Exception(1);
            }
            Printer printer = this;
            synchronized (printer) {
                InnerThread th = new InnerThread(this, listener, this.mPrinterHandle, timeout, type, null, null){

                    @Override
                    public void run() {
                        if (this.mPrn == null || this.mListener == null) {
                            return;
                        }
                        int errStatus = this.mPrn.nativeEpos2ResetMaintenanceCounter(this.mHandle, this.mTimeout, this.mType);
                        Printer.this.outputLogEvent("onResetMaintenanceCounter", "code->", errStatus, "type->", this.mType);
                        ((MaintenanceCounterListener)this.mListener).onResetMaintenanceCounter(errStatus, this.mType);
                    }
                };
                th.start();
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("resetMaintenanceCounter", ex);
            this.outputLogReturnFunction("resetMaintenanceCounter", ex.getErrorStatus(), timeout, type);
            throw ex;
        }
        this.outputLogReturnFunction("resetMaintenanceCounter", 0, timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPrinterSetting(int timeout, int type, PrinterSettingListener listener) throws Epos2Exception {
        this.outputLogCallFunction("getPrinterSetting", timeout, type);
        try {
            this.checkHandle();
            boolean edcType = false;
            if (timeout == -2) {
                timeout = 10000;
            }
            if (timeout < 5000 || 60000 < timeout) {
                throw new Epos2Exception(1);
            }
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            if (type != 0 && type != 1 && type != 2) {
                throw new Epos2Exception(1);
            }
            Printer printer = this;
            synchronized (printer) {
                InnerThread th = new InnerThread(this, listener, this.mPrinterHandle, timeout, type, null, null){

                    @Override
                    public void run() {
                        if (this.mPrn == null || this.mListener == null) {
                            return;
                        }
                        int[] value = new int[]{0};
                        int errStatus = this.mPrn.nativeEpos2GetPrinterSetting(this.mHandle, this.mTimeout, this.mType, value);
                        Printer.this.outputLogEvent("onGetPrinterSetting", "code->", errStatus, "type->", this.mType, "value->", value[0]);
                        ((PrinterSettingListener)this.mListener).onGetPrinterSetting(errStatus, this.mType, value[0]);
                    }
                };
                th.start();
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getPrinterSetting", ex);
            this.outputLogReturnFunction("getPrinterSetting", ex.getErrorStatus(), timeout, type);
            throw ex;
        }
        this.outputLogReturnFunction("getPrinterSetting", 0, timeout, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrinterSetting(int timeout, Map<Integer, Integer> list, PrinterSettingListener listener) throws Epos2Exception {
        this.outputLogCallFunction("setPrinterSetting", timeout, list);
        try {
            this.checkHandle();
            boolean edcType = false;
            if (list == null) {
                throw new Epos2Exception(1);
            }
            int size = list.size();
            if (size <= 0) {
                throw new Epos2Exception(1);
            }
            if (size > 3) {
                throw new Epos2Exception(1);
            }
            int[] types = new int[size];
            int[] values = new int[size];
            int counter = 0;
            for (Map.Entry<Integer, Integer> entry : list.entrySet()) {
                types[counter] = entry.getKey();
                values[counter] = entry.getValue();
                ++counter;
            }
            if (timeout == -2) {
                timeout = 10000;
            }
            if (timeout < 5000 || 60000 < timeout) {
                throw new Epos2Exception(1);
            }
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            Printer printer = this;
            synchronized (printer) {
                InnerThread th = new InnerThread(this, listener, this.mPrinterHandle, timeout, 0, types, values){

                    @Override
                    public void run() {
                        if (this.mPrn == null || this.mListener == null || this.mTypes == null || this.mValues == null) {
                            return;
                        }
                        int errStatus = this.mPrn.nativeEpos2SetPrinterSetting(this.mHandle, this.mTimeout, this.mTypes, this.mValues);
                        Printer.this.outputLogEvent("onSetPrinterSetting", "code->", errStatus);
                        ((PrinterSettingListener)this.mListener).onSetPrinterSetting(errStatus);
                    }
                };
                th.start();
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getPrinterSetting", ex);
            this.outputLogReturnFunction("setPrinterSetting", ex.getErrorStatus(), timeout, list);
            throw ex;
        }
        this.outputLogReturnFunction("setPrinterSetting", 0, timeout, list);
    }

    public void getPrinterInformation(int timeout, PrinterInformationListener listener) throws Epos2Exception {
        this.outputLogCallFunction("getPrinterInformation", timeout, listener);
        try {
            this.checkHandle();
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            this.setPrinterInformationListener(listener);
            int errStatus = this.nativeEpos2GetPrinterInformation(this.mPrinterHandle, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("getPrinterInformation", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("getPrinterInformation", 0, new Object[0]);
    }

    private void onPtrGetPrinterInformation(int code, String jsonString) {
        this.outputLogCallFunction("onGetPrinterInformation", code, this);
        if (null != this.mPrinterInformationListener) {
            String positionOfBrokenDot;
            String numberOfBrokenDot;
            String positionOfWarningDot;
            String numberOfWarningDot;
            String serialNo;
            JSONObject printerInformationJson;
            try {
                printerInformationJson = new JSONObject(jsonString);
            }
            catch (Exception e) {
                printerInformationJson = new JSONObject();
                this.outputLogReturnFunction("onGetPrinterInformation", code, e.getMessage());
            }
            try {
                serialNo = printerInformationJson.getJSONObject(JSON_KEY_PRINTERSPEC_NAME).getJSONObject(JSON_KEY_PRODUCT_NAME).getString(JSON_KEY_SERIALNO_NAME);
            }
            catch (Exception ex) {
                serialNo = "";
            }
            try {
                numberOfWarningDot = printerInformationJson.getJSONObject(JSON_KEY_MAINTENANCE_NAME).getJSONObject(JSON_KEY_THERMALHEAD_NAME).getString(JSON_KEY_N_WARNINGDOT_NAME);
            }
            catch (Exception ex) {
                numberOfWarningDot = "";
            }
            try {
                positionOfWarningDot = printerInformationJson.getJSONObject(JSON_KEY_MAINTENANCE_NAME).getJSONObject(JSON_KEY_THERMALHEAD_NAME).getString(JSON_KEY_P_WARNINGDOT_NAME);
            }
            catch (Exception ex) {
                positionOfWarningDot = "";
            }
            try {
                numberOfBrokenDot = printerInformationJson.getJSONObject(JSON_KEY_MAINTENANCE_NAME).getJSONObject(JSON_KEY_THERMALHEAD_NAME).getString(JSON_KEY_N_BROKENDOT_NAME);
            }
            catch (Exception ex) {
                numberOfBrokenDot = "";
            }
            try {
                positionOfBrokenDot = printerInformationJson.getJSONObject(JSON_KEY_MAINTENANCE_NAME).getJSONObject(JSON_KEY_THERMALHEAD_NAME).getString(JSON_KEY_P_BROKENDOT_NAME);
            }
            catch (Exception ex) {
                positionOfBrokenDot = "";
            }
            JSONObject jsonProduct = new JSONObject();
            try {
                JSONObject jsonSerial = new JSONObject();
                jsonSerial.put(JSON_KEY_SERIALNO_NAME, (Object)serialNo);
                jsonProduct.put(JSON_KEY_PRODUCT_NAME, (Object)jsonSerial);
            }
            catch (Exception e) {
                this.outputLogReturnFunction("onGetPrinterInformation", code, e.getMessage());
                return;
            }
            JSONObject jsonThermalHead = new JSONObject();
            try {
                JSONObject jsonDot = new JSONObject();
                jsonDot.put(JSON_KEY_N_WARNINGDOT_NAME, (Object)numberOfWarningDot).put(JSON_KEY_P_WARNINGDOT_NAME, (Object)positionOfWarningDot).put(JSON_KEY_N_BROKENDOT_NAME, (Object)numberOfBrokenDot).put(JSON_KEY_P_BROKENDOT_NAME, (Object)positionOfBrokenDot);
                jsonThermalHead.put(JSON_KEY_THERMALHEAD_NAME, (Object)jsonDot);
            }
            catch (Exception e) {
                this.outputLogReturnFunction("onGetPrinterInformation", code, e.getMessage());
                return;
            }
            JSONObject jsonObj = new JSONObject();
            try {
                jsonObj.put(JSON_KEY_PRINTERSPEC_NAME, (Object)jsonProduct).put(JSON_KEY_MAINTENANCE_NAME, (Object)jsonThermalHead);
            }
            catch (Exception e) {
                this.outputLogReturnFunction("onGetPrinterInformation", code, e.getMessage());
                return;
            }
            this.mPrinterInformationListener.onGetPrinterInformation(code, jsonObj.toString());
            this.outputLogEvent("onGetPrinterInformation", "code->", code, "jsonString->", jsonObj.toString());
        }
        this.outputLogReturnFunction("onGetPrinterInformation", 0, code, this);
    }

    public void verifyPassword(int timeout, String administratorPassword) throws Epos2Exception {
        this.outputLogCallFunction("verifyPassword", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2VerifyPassword(this.mPrinterHandle, timeout, administratorPassword);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("verifyPassword", ex);
            this.outputLogReturnFunction("verifyPassword", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("verifyPassword", 0, new Object[0]);
    }

    private void onVerifyPassword(int code, String jsonString, String administratorPassword) {
        this.outputLogCallFunction("onVerifyPassword", code, this);
        if (jsonString == null) {
            jsonString = "";
        }
        if (administratorPassword == null) {
            return;
        }
        if (null != this.mVerifyPasswordListener) {
            if (code == 0) {
                JSONObject jsonObject;
                try {
                    jsonObject = new JSONObject(jsonString);
                }
                catch (Exception e) {
                    this.outputLogReturnFunction("onVerifyPassword", code, e.getMessage());
                    return;
                }
                JSONData jsonData = new JSONData();
                jsonData.setJSONObj(jsonObject);
                String passwordAuth = jsonData.getJSONValue2(JSON_KEY_SETTING_NWDEVINFO_PASSWORDAUTH_KEY);
                if (passwordAuth == null) {
                    passwordAuth = "";
                }
                if (passwordAuth.equals("") || passwordAuth.equals("Disable")) {
                    code = 48;
                }
                if (passwordAuth.equals("Enable")) {
                    String adminId = jsonData.getJSONValue2(JSON_KEY_SETTING_NWDEVINFO_ADMINID_KEY);
                    if (adminId == null) {
                        this.outputLogInfo(new Object[0]);
                        code = 255;
                    } else {
                        String shaPassword = TMiUtil.convertEncryptedHashValue(administratorPassword);
                        if (shaPassword == null) {
                            this.outputLogInfo(new Object[0]);
                            code = 255;
                        }
                        if (!shaPassword.equals(adminId)) {
                            code = 49;
                        }
                    }
                }
            }
            this.mVerifyPasswordListener.onVerifyPassword(this, code);
        }
        this.outputLogReturnFunction("onVerifyPassword", 0, code, this);
    }

    public void getPrinterSettingEx(int timeout) throws Epos2Exception {
        this.outputLogCallFunction("getPrinterSettingEx", new Object[0]);
        try {
            this.checkHandle();
            int errStatus = this.nativeEpos2GetPrinterSettingEx(this.mPrinterHandle, timeout);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputException("getPrinterSettingEx", ex);
            this.outputLogReturnFunction("getPrinterSettingEx", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("getPrinterSettingEx", 0, new Object[0]);
    }

    private void onGetPrinterSettingEx(int code, String jsonString) {
        this.outputLogCallFunction("onGetPrinterSettingEx", code, this);
        if (jsonString == null) {
            jsonString = "";
        }
        if (null != this.mGetPrinterSettingExListener) {
            String sdkJsonString = EposSdkJson.jsonToSdkJson(jsonString);
            this.outputLogInfo("JSON(Convert) : " + sdkJsonString);
            this.mGetPrinterSettingExListener.onGetPrinterSettingEx(this, code, sdkJsonString);
        }
        this.outputLogReturnFunction("onGetPrinterSettingEx", 0, code, this);
    }

    public void setPrinterSettingEx(int timeout, String jsonString) throws Epos2Exception {
        this.outputLogCallFunction("setPrinterSettingEx", timeout, jsonString);
        try {
            int errStatus;
            this.checkHandle();
            if (jsonString == null) {
                throw new Epos2Exception(1);
            }
            String sdkJsonString = EposSdkJson.jsonToSdkJsonDeprecated(jsonString);
            if (sdkJsonString.equals("")) {
                sdkJsonString = jsonString;
            }
            if (0 != (errStatus = this.nativeEpos2SetPrinterSettingEx(this.mPrinterHandle, timeout, sdkJsonString))) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("setPrinterSettingEx", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("setPrinterSettingEx", 0, new Object[0]);
    }

    public void setPrinterSettingEx(int timeout, String jsonString, String administratorPassword) throws Epos2Exception {
        this.outputLogCallFunction("setPrinterSettingEx", timeout);
        try {
            this.checkHandle();
            if (jsonString == null) {
                throw new Epos2Exception(1);
            }
            String editedJsonString = jsonString;
            String encryptedString = this.replaceToEncryptedValue(jsonString, JSON_KEY_SETTING_WIFICFG_WPAPSK_KEY);
            if (encryptedString == null) {
                this.outputLogInfo(new Object[0]);
            } else {
                editedJsonString = encryptedString;
            }
            if (administratorPassword != null) {
                String passwordedString;
                String encryptedPassword = TMiUtil.encodeData(administratorPassword);
                if (encryptedPassword == null) {
                    encryptedPassword = "";
                }
                if ((passwordedString = this.appendPasswordToJson(editedJsonString, encryptedPassword)) == null) {
                    this.outputLogInfo(new Object[0]);
                } else {
                    editedJsonString = passwordedString;
                }
            }
            this.outputLogInfo(editedJsonString);
            int errStatus = this.nativeEpos2SetPrinterSettingEx(this.mPrinterHandle, timeout, editedJsonString);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("setPrinterSettingEx", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("setPrinterSettingEx", 0, new Object[0]);
    }

    public PrinterNetworkStatusInfo getNetworkStatus(int timeout) {
        this.outputLogCallFunction("getNetworkStatus", new Object[0]);
        PrinterNetworkStatusInfo networkStatusInfo = this.nativeEpos2GetNetworkStatus(this.mPrinterHandle, timeout);
        if (networkStatusInfo != null) {
            int connection = networkStatusInfo.getConnection();
            int wifiSignalStatus = networkStatusInfo.getWifiSignalStatus();
            String connectApMacAddress = networkStatusInfo.getConnectApMacAddress();
            String ssid = networkStatusInfo.getSsid();
            this.outputLogReturnFunction("getNetworkStatus", 0, "connection->" + connection, "wifiSignalStatus->" + wifiSignalStatus, "connectApMacAddress->" + connectApMacAddress, "ssid->" + ssid);
        } else {
            this.outputLogReturnFunction("getNetworkStatus", 257, new Object[0]);
        }
        return networkStatusInfo;
    }

    private String replaceToEncryptedValue(String jsonString, String targetKeys) {
        JSONObject jsonObject;
        if (jsonString == null || targetKeys == null) {
            this.outputLogInfo(new Object[0]);
            return null;
        }
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (Exception e) {
            this.outputLogInfo(e);
            return null;
        }
        String tmpString = jsonString;
        JSONData jsonData = new JSONData();
        jsonData.setJSONObj(jsonObject);
        String targetValue = jsonData.getJSONValue2(targetKeys);
        if (targetValue != null && !targetValue.startsWith(PREFIX_ENCRYPT)) {
            String encryptedValue = TMiUtil.encodeData(targetValue);
            if (encryptedValue == null) {
                this.outputLogInfo(new Object[0]);
                encryptedValue = "";
            }
            if (!jsonData.setJSONValue(targetKeys, encryptedValue)) {
                this.outputLogInfo(new Object[0]);
                return null;
            }
            JSONObject tmpJsonObject = jsonData.getJSONObj();
            if (tmpJsonObject == null) {
                this.outputLogInfo(new Object[0]);
                return null;
            }
            tmpString = tmpJsonObject.toString();
            if (tmpString == null) {
                this.outputLogInfo(new Object[0]);
            }
        }
        return tmpString;
    }

    private String appendPasswordToJson(String jsonString, String encryptedPassword) {
        JSONObject jsonObject;
        if (jsonString == null || encryptedPassword == null) {
            this.outputLogInfo(new Object[0]);
            return null;
        }
        try {
            jsonObject = new JSONObject(jsonString);
        }
        catch (Exception e) {
            this.outputLogInfo(e);
            return null;
        }
        JSONData jsonData = new JSONData();
        jsonData.setJSONObj(jsonObject);
        if (!jsonData.setJSONValue(JSON_KEY_SETTING_NWCSAUTH_PASSWORD_KEY, encryptedPassword)) {
            this.outputLogInfo(new Object[0]);
            return null;
        }
        JSONObject tmpJsonObject = jsonData.getJSONObj();
        if (tmpJsonObject == null) {
            this.outputLogInfo(new Object[0]);
            return null;
        }
        String tmpString = tmpJsonObject.toString();
        if (tmpString == null) {
            this.outputLogInfo(new Object[0]);
        }
        return tmpString;
    }

    private void onSetPrinterSettingEx(int code) {
        this.mSetPrinterSettingExListener.onSetPrinterSettingEx(this, code);
    }

    private void onPtrStatusChange(int eventType) {
        this.outputLogCallFunction("onPtrStatusChange", eventType, this);
        if (null != this.mStatusChangeListener) {
            this.mStatusChangeListener.onPtrStatusChange(this, eventType);
            this.outputLogEvent("onPtrStatusChange", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onPtrStatusChange", 0, eventType, this);
    }

    private void onPtrReceive(int code, PrinterStatusInfo status, String printJobId) {
        int connection = status.getConnection();
        int online = status.getOnline();
        int coverOpen = status.getCoverOpen();
        int paper = status.getPaper();
        int paperFeed = status.getPaperFeed();
        int panelSwitch = status.getPanelSwitch();
        int waitOnline = status.getOnline();
        int drawer = status.getDrawer();
        int errorStatus = status.getErrorStatus();
        int autoRecoverError = status.getAutoRecoverError();
        int buzzer = status.getBuzzer();
        int adapter = status.getAdapter();
        int batteryLevel = status.getBatteryLevel();
        int removalWaiting = status.getRemovalWaiting();
        int paperTakenSensor = status.getPaperTakenSensor();
        int unrecoverError = status.getUnrecoverError();
        this.outputLogCallFunction("onPtrReceive", code, status, printJobId, this);
        if (null != this.mReceiveListener) {
            this.mReceiveListener.onPtrReceive(this, code, status, printJobId);
            this.outputLogEvent("onPtrReceive", "code->", code, "connection->", connection, "online->", online, "coverOpen->", coverOpen, "paper->", paper, "paperFeed->", paperFeed, "panelSwitch->", panelSwitch, "waitOnline->", waitOnline, "drawer->", drawer, "errorStatus->", errorStatus, "autoRecoverError->", autoRecoverError, "buzzer->", buzzer, "adapter->", adapter, "batteryLevel->", batteryLevel, "removalWaiting->", removalWaiting, "paperTakenSensor->", paperTakenSensor, "unrecoverError->", unrecoverError, "printJobId->", printJobId);
        }
        this.outputLogReturnFunction("onPtrReceive", 0, code, status, printJobId, this);
    }

    private void onConnection(int eventType) {
        this.outputLogCallFunction("onConnection", eventType, this);
        if (null != this.mConnectionListener) {
            this.mConnectionListener.onConnection(this, eventType);
            this.outputLogEvent("onConnection", "eventType->", eventType);
        }
        this.outputLogReturnFunction("onConnection", 0, eventType, this);
    }

    public void downloadFirmwareList(String printerModel, FirmwareUpdateListener listener) throws Epos2Exception {
        this.downloadFirmwareList(printerModel, "", listener);
    }

    public void downloadFirmwareList(String printerModel, String option, FirmwareUpdateListener listener) throws Epos2Exception {
        this.outputLogCallFunction("downloadFirmwareList", printerModel, option);
        try {
            this.checkHandle();
            if (listener == null || printerModel == null || printerModel.equals("") || option == null) {
                throw new Epos2Exception(1);
            }
            String requestPrinterModel = printerModel + option;
            DownloadFirmwareListMain downloder = new DownloadFirmwareListMain(printerModel, requestPrinterModel, listener);
            downloder.start();
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("downloadFirmwareList", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("downloadFirmwareList", 0, printerModel, option);
    }

    public void getPrinterFirmwareInfo(int timeout, FirmwareUpdateListener listener) throws Epos2Exception {
        this.outputLogCallFunction("getPrinterFirmwareInfo", timeout);
        try {
            this.checkHandle();
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            if (timeout == -2) {
                timeout = 30000;
            }
            if (timeout < 15000 || 60000 < timeout) {
                throw new Epos2Exception(1);
            }
            String[] infoStr = new String[]{"temp"};
            int errStatus = this.nativeEpos2GetFirmwareInformation(this.mPrinterHandle, timeout, infoStr);
            if (0 != errStatus) {
                throw new Epos2Exception(errStatus);
            }
            String firmwareInfoJson = infoStr[0];
            FirmwareInfo frimInfo = new FirmwareInfo(firmwareInfoJson);
            listener.onReceiveFirmwareInformation(frimInfo);
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("getPrinterFirmwareInfo", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("getPrinterFirmwareInfo", 0, new Object[0]);
    }

    public void updateFirmware(FirmwareInfo targetFirmwareInfo, FirmwareUpdateListener listener, Context context) throws Epos2Exception {
        this.outputLogCallFunction("updateFirmware", new Object[0]);
        try {
            this.checkHandle();
            if (listener == null || targetFirmwareInfo == null || context == null) {
                throw new Epos2Exception(1);
            }
            UpdateFirmwareMain updater = new UpdateFirmwareMain(targetFirmwareInfo, listener, context);
            updater.start();
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("updateFirmware", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("updateFirmware", 0, new Object[0]);
    }

    public void verifyUpdate(FirmwareInfo targetFirmwareInfo, FirmwareUpdateListener listener) throws Epos2Exception {
        this.outputLogCallFunction("verifyUpdate", targetFirmwareInfo);
        try {
            this.checkHandle();
            if (listener == null || targetFirmwareInfo == null) {
                throw new Epos2Exception(1);
            }
            if (this.currentImagesFirmwareInfo == null || this.firmwareImage == null) {
                throw new Epos2Exception(1);
            }
            VerifyUpdateMain verifier = new VerifyUpdateMain(targetFirmwareInfo, listener);
            verifier.start();
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("verifyUpdate", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("verifyUpdate", 0, new Object[0]);
    }

    public void updateFirmware(URL url, String user, String password, FirmwareUpdateListener listener, Context context) throws Epos2Exception {
        this.outputLogCallFunction("updateFirmware", new Object[0]);
        try {
            this.checkHandle();
            if (listener == null || url == null || user == null || password == null || context == null) {
                throw new Epos2Exception(1);
            }
            UpdateFirmwareWithUrlMain updater = new UpdateFirmwareWithUrlMain(url, user, password, listener, context);
            updater.start();
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("updateFirmware", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("updateFirmware", 0, new Object[0]);
    }

    public void verifyUpdate(URL url, String user, String password, FirmwareUpdateListener listener) throws Epos2Exception {
        this.outputLogCallFunction("verifyUpdate", url);
        try {
            this.checkHandle();
            if (listener == null || url == null || user == null || password == null) {
                throw new Epos2Exception(1);
            }
            if (this.currentImagesFirmwareUrl == null || this.firmwareImage == null) {
                throw new Epos2Exception(1);
            }
            VerifyUpdateWithUrlMain verifier = new VerifyUpdateWithUrlMain(url, user, password, listener);
            verifier.start();
        }
        catch (Epos2Exception ex) {
            this.outputLogReturnFunction("verifyUpdate", ex.getErrorStatus(), new Object[0]);
            throw ex;
        }
        this.outputLogReturnFunction("verifyUpdate", 0, new Object[0]);
    }

    static /* synthetic */ byte[] access$302(Printer x0, byte[] x1) {
        x0.firmwareImage = x1;
        return x1;
    }

    class VerifyUpdateWithUrlMain
    extends Thread {
        FirmwareUpdateListener listener = null;
        FirmwareInfo currentFirmwareInfo;
        URL firmImageUrl;

        VerifyUpdateWithUrlMain(URL url, String user, String password, FirmwareUpdateListener listener) throws Epos2Exception {
            if (listener == null || url == null || user == null || password == null) {
                throw new Epos2Exception(1);
            }
            this.listener = listener;
            this.firmImageUrl = url;
        }

        @Override
        public void run() {
            Printer.this.outputLogCallFunction("verifyUpdate_main", new Object[0]);
            if (Printer.this.currentImagesFirmwareUrl == null || Printer.this.firmwareImage == null) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(39);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 39, new Object[0]);
                return;
            }
            if (!this.firmImageUrl.equals(Printer.this.currentImagesFirmwareUrl)) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(42);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                return;
            }
            String[] infoStr = new String[]{"temp"};
            int errStatus = Printer.this.nativeEpos2GetFirmwareInformation(Printer.this.mPrinterHandle, 60000, infoStr);
            if (0 != errStatus && this.listener != null) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(errStatus);
                if (this.listener != null) {
                    this.listener.onUpdateVerify(code);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", code, new Object[0]);
                return;
            }
            String firmwareInfoJson = infoStr[0];
            try {
                this.currentFirmwareInfo = new FirmwareInfo(firmwareInfoJson);
            }
            catch (Epos2Exception ex) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(37);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 37, new Object[0]);
                return;
            }
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(Printer.this.firmwareImage);
            if (rcxHeaderAnalyzer == null) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(43);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 43, new Object[0]);
                return;
            }
            boolean[] forceUpdateFlag = new boolean[]{true};
            String targetVersion = "";
            int validateRsult = TMUtilityFirmwareUpdater.checkFirmwareInfo(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson(), targetVersion, forceUpdateFlag);
            if (validateRsult != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(validateRsult);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", validateRsult, new Object[0]);
                return;
            }
            List<Pair<Integer, FirmwareUpdater.UpdateRequiredType>> enumlatedAreas = TMUtilityFirmwareUpdater.enumUpdateAreas(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson());
            if (enumlatedAreas.isEmpty()) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(43, 0);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 43, new Object[0]);
                return;
            }
            boolean isDifferentVersion = false;
            boolean isRetry = false;
            for (Pair<Integer, FirmwareUpdater.UpdateRequiredType> area : enumlatedAreas) {
                if (area.second == FirmwareUpdater.UpdateRequiredType.UPDATE_REQUIRED_WITH_REPEAT) {
                    isRetry = true;
                    continue;
                }
                if (area.second != FirmwareUpdater.UpdateRequiredType.UPDATE_REQUIRED) continue;
                isDifferentVersion = true;
            }
            if (isRetry) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(45, 0);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 45, new Object[0]);
                return;
            }
            if (isDifferentVersion) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(42, 0);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onUpdateVerify(0);
            }
            Printer.this.outputLogReturnFunction("verifyUpdate_main", 0, new Object[0]);
        }
    }

    class UpdateFirmwareWithUrlMain
    extends Thread {
        FirmwareUpdateListener listener = null;
        URL firmImageUrl;
        String user;
        String password;
        FirmwareInfo currentFirmwareInfo;
        String downloadDir;
        String efxFWImageFile;

        UpdateFirmwareWithUrlMain(URL url, String user, String password, FirmwareUpdateListener listener, Context context) throws Epos2Exception {
            if (listener == null || url == null || user == null || password == null || context == null) {
                throw new Epos2Exception(1);
            }
            this.listener = listener;
            this.firmImageUrl = url;
            this.user = user;
            this.password = password;
            this.downloadDir = context.getFilesDir().toString() + "/";
            this.efxFWImageFile = "encueh4ugi4ejhcvowkdx";
        }

        @Override
        public void run() {
            this.getCurrent();
        }

        private void getCurrent() {
            Printer.this.outputLogCallFunction("updateFirmware_getCurrent", new Object[0]);
            try {
                int errStatus;
                String[] infoStr = new String[]{"temp"};
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 0.1f);
                }
                if (0 != (errStatus = Printer.this.nativeEpos2GetFirmwareInformation(Printer.this.mPrinterHandle, 60000, infoStr))) {
                    throw new Epos2Exception(errStatus);
                }
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 0.8f);
                }
                String firmwareInfoJson = infoStr[0];
                this.currentFirmwareInfo = new FirmwareInfo(firmwareInfoJson);
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 1.0f);
                }
                this.download();
            }
            catch (Epos2Exception ex) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(ex.getErrorStatus());
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(code, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_getCurrent", code, new Object[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_getCurrent", 0, new Object[0]);
        }

        private void download() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    UpdateFirmwareWithUrlMain.this.downloadMain();
                }
            }).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void downloadMain() {
            Printer.this.outputLogCallFunction("updateFirmware_download", new Object[0]);
            if (Printer.this.currentImagesFirmwareUrl != null && Printer.this.firmwareImage != null && this.firmImageUrl.equals(Printer.this.currentImagesFirmwareUrl)) {
                this.update();
                return;
            }
            try {
                HttpURLConnection con = (HttpURLConnection)this.firmImageUrl.openConnection();
                con.setRequestMethod("GET");
                String userPassword = this.user + ":" + this.password;
                String encodeAuthorization = Base64.encodeToString((byte[])userPassword.getBytes(), (int)2);
                con.setRequestProperty("Authorization", "Basic " + encodeAuthorization);
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Download firmware.", 0.0f);
                }
                con.connect();
                int status = con.getResponseCode();
                if (status != 200) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(35, 0);
                    }
                    Printer.this.outputLogReturnFunction("updateFirmware_download", 35, new Object[0]);
                    return;
                }
                File dir = new File(this.downloadDir);
                dir.mkdirs();
                File file = new File(this.downloadDir + this.efxFWImageFile);
                file.createNewFile();
                FileOutputStream firmwareImageOutputStream = new FileOutputStream(this.downloadDir + this.efxFWImageFile);
                boolean isContentLenghtAvailable = false;
                int contentLength = con.getContentLength();
                if (contentLength > 0) {
                    isContentLenghtAvailable = true;
                }
                InputStream downloadFirmwareIS = con.getInputStream();
                int read = 0;
                int totalRead = 0;
                int lastProgressedRead = 0;
                byte[] bytes = new byte[1024];
                while ((read = downloadFirmwareIS.read(bytes)) != -1) {
                    firmwareImageOutputStream.write(bytes, 0, read);
                    if (!isContentLenghtAvailable || lastProgressedRead + 0x100000 > (totalRead += read)) continue;
                    float progress = (float)totalRead / (float)contentLength;
                    if (this.listener != null) {
                        this.listener.onFirmwareUpdateProgress("Download firmware.", progress);
                    }
                    lastProgressedRead = totalRead;
                }
                downloadFirmwareIS.close();
                firmwareImageOutputStream.close();
                byte[] fwImage = null;
                try {
                    fwImage = FirmwareUpdate.extract(this.downloadDir, this.efxFWImageFile);
                }
                catch (firmwareUpdateException ex) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(ex.getErrorStatus(), 0);
                    }
                    Printer.this.outputLogReturnFunction("updateFirmware_update", ex.getErrorStatus(), new Object[0]);
                    return;
                }
                finally {
                    file = new File(this.downloadDir + this.efxFWImageFile);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                Printer.this.currentImagesFirmwareUrl = this.firmImageUrl;
                Printer.access$302(Printer.this, fwImage);
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Download firmware.", 1.0f);
                }
                this.update();
            }
            catch (IOException ex) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(35, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_download", 35, new Object[0]);
            }
        }

        private void update() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    UpdateFirmwareWithUrlMain.this.updateMain();
                }
            }).start();
        }

        private void updateMain() {
            ArrayList<Map> printerUnits;
            Printer.this.outputLogCallFunction("updateFirmware_update", new Object[0]);
            byte[] fwImage = Printer.this.firmwareImage;
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(fwImage);
            if (rcxHeaderAnalyzer == null) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(43, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", 43, new Object[0]);
                return;
            }
            boolean[] forceUpdateFlag = new boolean[]{true};
            String targetVersion = "";
            int validateRsult = TMUtilityFirmwareUpdater.checkFirmwareInfo(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson(), targetVersion, forceUpdateFlag);
            if (validateRsult != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(validateRsult, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", validateRsult, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 0.0f);
            }
            if ((printerUnits = FirmwareInfo.makePrinterUnits(this.currentFirmwareInfo.getJson())) == null) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(43, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", 43, new Object[0]);
                return;
            }
            int[] maxWaitTime = new int[1];
            int[] result = new int[]{255};
            ByteArrayOutputStream writeImage = FirmwareUpdater.createWriteImage(fwImage, rcxHeaderAnalyzer, printerUnits, maxWaitTime, result);
            if (result[0] != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(result[0], 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", result[0], new Object[0]);
                return;
            }
            ProgressMonitor progressMonitor = new ProgressMonitor();
            progressMonitor.start();
            int errStatus = Printer.this.nativeEpos2WriteFirmwareImage(Printer.this.mPrinterHandle, writeImage.toByteArray(), false);
            progressMonitor.stopMonitor();
            if (0 != errStatus) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(errStatus);
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(code, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", code, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 1.0f);
            }
            if (this.listener != null) {
                this.listener.onUpdateFirmware(0, maxWaitTime[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_update", 0, new Object[0]);
        }

        class ProgressMonitor
        extends Thread {
            boolean isMonitor = false;
            long dummyPrintHnadler = 1L;

            ProgressMonitor() {
            }

            @Override
            public void run() {
                try {
                    ProgressMonitor.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.startMonitor();
            }

            public void startMonitor() {
                this.isMonitor = true;
                try {
                    while (this.isMonitor) {
                        int p = Printer.this.nativeEpos2WriteFirmwareImage(this.dummyPrintHnadler, null, true);
                        float floatProgress = (float)p / 1000.0f / 1000.0f;
                        if (UpdateFirmwareWithUrlMain.this.listener != null) {
                            UpdateFirmwareWithUrlMain.this.listener.onFirmwareUpdateProgress("Sending firmware image.", floatProgress);
                        }
                        ProgressMonitor.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    this.stopMonitor();
                }
                finally {
                    this.stopMonitor();
                }
            }

            public void stopMonitor() {
                this.isMonitor = false;
            }
        }
    }

    class VerifyUpdateMain
    extends Thread {
        FirmwareUpdateListener listener = null;
        FirmwareInfo currentFirmwareInfo;
        FirmwareInfo targetFirmwareInfo;
        private static final int UPDATESTATUS_SUCCESS = 0;
        private static final int UPDATESTATUS_DIFFERNET_VERSION = 1;

        VerifyUpdateMain(FirmwareInfo targetFirmwareInfo, FirmwareUpdateListener listener) throws Epos2Exception {
            if (listener == null || targetFirmwareInfo == null) {
                throw new Epos2Exception(1);
            }
            this.listener = listener;
            this.targetFirmwareInfo = targetFirmwareInfo;
        }

        private int getFirmwareFileType(byte[] fwData) {
            if (fwData == null) {
                Printer.this.outputLogReturnFunction("verifyUpdate_getFirmwareFileType", 255, new Object[0]);
                return -3;
            }
            byte[] fwImage = fwData;
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(fwImage);
            if (rcxHeaderAnalyzer == null) {
                Printer.this.outputLogReturnFunction("verifyUpdate_getFirmwareFileType", 255, new Object[0]);
                return -3;
            }
            int firmwareFileType = -3;
            firmwareFileType = rcxHeaderAnalyzer.get("E", "2").equals("1000") || rcxHeaderAnalyzer.get("E", "2").equals("1010") ? 1 : (rcxHeaderAnalyzer.get("E", "2").equals("1100") ? 2 : -3);
            return firmwareFileType;
        }

        private int getUpdateStatusMot(byte[] fwData, String printerFirmVersion) {
            String fwDataVersion;
            if (fwData == null || printerFirmVersion == null) {
                return 1;
            }
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(fwData);
            if (rcxHeaderAnalyzer == null) {
                return 1;
            }
            String rcxVersion = rcxHeaderAnalyzer.get("E", "6.240.2");
            String rcxESCPOS = rcxHeaderAnalyzer.get("E", "6.240.4");
            int result = 1;
            if (rcxVersion != null && rcxESCPOS != null && (fwDataVersion = rcxVersion + " " + rcxESCPOS) != null && fwDataVersion.equals(printerFirmVersion)) {
                result = 0;
            }
            return result;
        }

        @Override
        public void run() {
            String currentVersion;
            Printer.this.outputLogCallFunction("verifyUpdate_main", new Object[0]);
            if (Printer.this.currentImagesFirmwareInfo == null || Printer.this.firmwareImage == null) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(39);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 39, new Object[0]);
                return;
            }
            String targetVersion = this.targetFirmwareInfo.getVersion();
            if (!targetVersion.equals(currentVersion = Printer.this.currentImagesFirmwareInfo.getVersion())) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(42);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                return;
            }
            String[] infoStr = new String[]{"temp"};
            int errStatus = Printer.this.nativeEpos2GetFirmwareInformation(Printer.this.mPrinterHandle, 60000, infoStr);
            if (0 != errStatus && this.listener != null) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(errStatus);
                if (this.listener != null) {
                    this.listener.onUpdateVerify(code);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", code, new Object[0]);
                return;
            }
            String firmwareInfoJson = infoStr[0];
            try {
                this.currentFirmwareInfo = new FirmwareInfo(firmwareInfoJson);
            }
            catch (Epos2Exception ex) {
                if (this.listener != null) {
                    this.listener.onUpdateVerify(37);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 37, new Object[0]);
                return;
            }
            int firmwareFileType = this.getFirmwareFileType(Printer.this.firmwareImage);
            if (firmwareFileType == 1) {
                RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(Printer.this.firmwareImage);
                if (rcxHeaderAnalyzer == null) {
                    if (this.listener != null) {
                        this.listener.onUpdateVerify(43);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", 43, new Object[0]);
                    return;
                }
                boolean[] forceUpdateFlag = new boolean[]{true};
                int validateRsult = TMUtilityFirmwareUpdater.checkFirmwareInfo(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson(), this.targetFirmwareInfo.getVersion(), forceUpdateFlag);
                if (validateRsult != 0) {
                    if (this.listener != null) {
                        this.listener.onUpdateVerify(validateRsult);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", validateRsult, new Object[0]);
                    return;
                }
                List<Pair<Integer, FirmwareUpdater.UpdateRequiredType>> enumlatedAreas = TMUtilityFirmwareUpdater.enumUpdateAreas(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson());
                if (enumlatedAreas.isEmpty()) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(43, 0);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", 43, new Object[0]);
                    return;
                }
                boolean isDifferentVersion = false;
                boolean isRetry = false;
                for (Pair<Integer, FirmwareUpdater.UpdateRequiredType> area : enumlatedAreas) {
                    if (area.second == FirmwareUpdater.UpdateRequiredType.UPDATE_REQUIRED_WITH_REPEAT) {
                        isRetry = true;
                        continue;
                    }
                    if (area.second != FirmwareUpdater.UpdateRequiredType.UPDATE_REQUIRED) continue;
                    isDifferentVersion = true;
                }
                if (isRetry) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(45, 0);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", 45, new Object[0]);
                    return;
                }
                if (isDifferentVersion) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(42, 0);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                    return;
                }
            } else if (firmwareFileType == 2) {
                int errStatusCallback = FirmwareUpdate.validateFirmware(Printer.this.firmwareImage, this.currentFirmwareInfo, null);
                if (errStatusCallback != 0) {
                    if (this.listener != null) {
                        this.listener.onUpdateVerify(errStatusCallback);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", errStatusCallback, new Object[0]);
                    return;
                }
                int updateStatus = this.getUpdateStatusMot(Printer.this.firmwareImage, this.currentFirmwareInfo.getVersion());
                if (updateStatus != 0) {
                    if (this.listener != null) {
                        this.listener.onUpdateFirmware(42, 0);
                    }
                    Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                    return;
                }
            } else {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(42, 0);
                }
                Printer.this.outputLogReturnFunction("verifyUpdate_main", 42, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onUpdateVerify(0);
            }
            Printer.this.outputLogReturnFunction("verifyUpdate_main", 0, new Object[0]);
        }
    }

    class UpdateFirmwareMain
    extends Thread
    implements FirmwareDownloader.OnResultListener,
    FirmwareDownloader.OnProgressListener {
        FirmwareUpdateListener listener = null;
        FirmwareInfo currentFirmwareInfo = null;
        FirmwareInfo targetFirmwareInfo = null;
        String bootId = null;
        String downloadDir;
        String efxFWImageFile;
        float currentDownloadProgress = 0.0f;

        UpdateFirmwareMain(FirmwareInfo targetFirmwareInfo, FirmwareUpdateListener listener, Context context) throws Epos2Exception {
            if (listener == null || targetFirmwareInfo == null || context == null) {
                throw new Epos2Exception(1);
            }
            this.listener = listener;
            this.targetFirmwareInfo = targetFirmwareInfo;
            this.downloadDir = context.getFilesDir().toString() + "/";
            this.efxFWImageFile = "encueh4ugi4ejhcvowkdx";
        }

        private int getPrinterMode() {
            int printerMode = -3;
            try {
                Printer.this.checkHandle();
                printerMode = Printer.this.nativeEpos2GetPrinterMode(Printer.this.mPrinterHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return printerMode;
        }

        @Override
        public void run() {
            int printerMode = this.getPrinterMode();
            String printerBootId = null;
            if (printerMode == 1) {
                this.getCurrent();
            } else if (printerMode == 2) {
                printerBootId = this.getPrinterBootId();
                if (printerBootId == null) {
                    this.listener.onUpdateFirmware(35, 0);
                    Printer.this.outputLogReturnFunction("printerBootId is null", 35, new Object[0]);
                }
                this.bootId = printerBootId;
                this.download();
            } else {
                this.listener.onUpdateFirmware(255, 0);
                Printer.this.outputLogReturnFunction("printerMode is unknown", 255, new Object[0]);
            }
        }

        private void getCurrent() {
            Printer.this.outputLogCallFunction("updateFirmware_getCurrent", new Object[0]);
            try {
                int errStatus;
                String[] infoStr = new String[]{"temp"};
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 0.1f);
                }
                if (0 != (errStatus = Printer.this.nativeEpos2GetFirmwareInformation(Printer.this.mPrinterHandle, 60000, infoStr))) {
                    throw new Epos2Exception(errStatus);
                }
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 0.8f);
                }
                String firmwareInfoJson = infoStr[0];
                this.currentFirmwareInfo = new FirmwareInfo(firmwareInfoJson);
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Preparation.", 1.0f);
                }
                this.download();
            }
            catch (Epos2Exception ex) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(ex.getErrorStatus());
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(code, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_getCurrent", code, new Object[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_getCurrent", 0, new Object[0]);
        }

        private String getPrinterBootId() {
            String printerBootId = null;
            try {
                Printer.this.checkHandle();
                printerBootId = Printer.this.nativeEpos2GetPrinterBootId(Printer.this.mPrinterHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return printerBootId;
        }

        private void download() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (UpdateFirmwareMain.this.currentFirmwareInfo != null) {
                        UpdateFirmwareMain.this.downloadMain();
                    } else {
                        UpdateFirmwareMain.this.downloadMain_Mot();
                    }
                }
            }).start();
        }

        private void downloadMain() {
            Printer.this.outputLogCallFunction("updateFirmware_download", new Object[0]);
            if (Printer.this.currentImagesFirmwareInfo != null && Printer.this.firmwareImage != null) {
                String targetModel = this.targetFirmwareInfo.getModel();
                String currentModel = Printer.this.currentImagesFirmwareInfo.getModel();
                String targetVersion = this.targetFirmwareInfo.getVersion();
                String currentVersion = Printer.this.currentImagesFirmwareInfo.getVersion();
                if (targetModel.equals(currentModel) && targetVersion.equals(currentVersion)) {
                    if (this.listener != null) {
                        this.listener.onFirmwareUpdateProgress("Download firmware.", 1.0f);
                    }
                    this.update();
                    return;
                }
            }
            try {
                TMUtilityFirmwareDownloader downloader = new TMUtilityFirmwareDownloader(this.targetFirmwareInfo.getModel(), this.targetFirmwareInfo.getRequestModel(), this.targetFirmwareInfo.getVersion());
                downloader.setOnResultListener(this);
                downloader.setOnProgressListener(this);
                File dir = new File(this.downloadDir);
                dir.mkdirs();
                File file = new File(this.downloadDir + this.efxFWImageFile);
                file.createNewFile();
                FileOutputStream firmwareImageOutputStream = new FileOutputStream(this.downloadDir + this.efxFWImageFile);
                this.currentDownloadProgress = 0.0f;
                downloader.getFile(this.targetFirmwareInfo.getVersion(), firmwareImageOutputStream);
            }
            catch (IOException e) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(44, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_download", 44, new Object[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_download", 0, new Object[0]);
        }

        private void downloadMain_Mot() {
            Printer.this.outputLogCallFunction("updateFirmware_downloadFirmware", new Object[0]);
            try {
                TMUtilityFirmwareDownloader downloader = new TMUtilityFirmwareDownloader(this.targetFirmwareInfo.getModel(), this.targetFirmwareInfo.getRequestModel(), this.targetFirmwareInfo.getVersion());
                downloader.setOnResultListener(this);
                downloader.setOnProgressListener(this);
                File dir = new File(this.downloadDir);
                dir.mkdirs();
                File file = new File(this.downloadDir + this.efxFWImageFile);
                file.createNewFile();
                FileOutputStream firmwareImageOutputStream = new FileOutputStream(this.downloadDir + this.efxFWImageFile);
                this.currentDownloadProgress = 0.0f;
                downloader.getFile(this.targetFirmwareInfo.getVersion(), firmwareImageOutputStream);
            }
            catch (IOException e) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(44, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_downloadFirmware", 44, new Object[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_downloadFirmware", 0, new Object[0]);
        }

        @Override
        public void OnDownloadFirmwareProgress(int receivedByte, int totalByte) {
            float progress = (float)receivedByte / (float)totalByte;
            if ((double)progress > (double)this.currentDownloadProgress + 0.01) {
                if (this.listener != null) {
                    this.listener.onFirmwareUpdateProgress("Download firmware.", progress);
                }
                this.currentDownloadProgress = progress;
            }
        }

        @Override
        public void OnSuccess() {
            Printer.this.outputLogCallFunction("updateFirmware_download_OnSuccess", new Object[0]);
            System.gc();
            byte[] fwImage = null;
            try {
                fwImage = FirmwareUpdate.extract(this.downloadDir, this.efxFWImageFile);
            }
            catch (firmwareUpdateException ex) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(ex.getErrorStatus(), 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_update", ex.getErrorStatus(), new Object[0]);
            }
            finally {
                File file = new File(this.downloadDir + this.efxFWImageFile);
                if (file.exists()) {
                    file.delete();
                }
            }
            if (fwImage == null) {
                return;
            }
            Printer.this.currentImagesFirmwareInfo = this.targetFirmwareInfo;
            Printer.access$302(Printer.this, fwImage);
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Download firmware.", 1.0f);
            }
            this.update();
            Printer.this.outputLogReturnFunction("updateFirmware_download_OnSuccess", 0, new Object[0]);
        }

        @Override
        public void OnError(FirmwareDownloader.Error error) {
            Printer.this.outputLogCallFunction("updateFirmware_download_OnError", new Object[0]);
            File file = new File(this.efxFWImageFile);
            if (file.exists()) {
                file.delete();
            }
            if (this.listener != null) {
                this.listener.onUpdateFirmware(35, 0);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_download_OnError", 0, new Object[0]);
        }

        @Override
        public void OnHistoryGet(String url) {
        }

        @Override
        public void OnFileListGet(String model, String requestModel, String[] fileList) {
        }

        private int getFirmwareFileType() {
            byte[] fwImage = Printer.this.firmwareImage;
            if (fwImage == null) {
                return -3;
            }
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(fwImage);
            if (rcxHeaderAnalyzer == null) {
                Printer.this.outputLogReturnFunction("updateFirmware_getFirmwareFileType", 255, new Object[0]);
                return -3;
            }
            int firmwareFileType = -3;
            firmwareFileType = rcxHeaderAnalyzer.get("E", "2").equals("1000") || rcxHeaderAnalyzer.get("E", "2").equals("1010") ? 1 : (rcxHeaderAnalyzer.get("E", "2").equals("1100") ? 2 : -3);
            return firmwareFileType;
        }

        private void update() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int firmwareFileType = UpdateFirmwareMain.this.getFirmwareFileType();
                    if (UpdateFirmwareMain.this.currentFirmwareInfo == null && firmwareFileType != 2) {
                        if (UpdateFirmwareMain.this.listener != null) {
                            UpdateFirmwareMain.this.listener.onUpdateFirmware(41, 0);
                        }
                        return;
                    }
                    if (firmwareFileType == 1) {
                        UpdateFirmwareMain.this.writeFirmware();
                    } else if (firmwareFileType == 2) {
                        UpdateFirmwareMain.this.writeFirmware_MOT();
                    } else {
                        if (UpdateFirmwareMain.this.listener != null) {
                            UpdateFirmwareMain.this.listener.onUpdateFirmware(255, 0);
                        }
                        Printer.this.outputLogReturnFunction("updateFirmware_update", 255, new Object[0]);
                    }
                }
            }).start();
        }

        private void writeFirmware() {
            ArrayList<Map> printerUnits;
            Printer.this.outputLogCallFunction("updateFirmware_writeFirmware", new Object[0]);
            byte[] fwImage = Printer.this.firmwareImage;
            RcxHeaderAnalyzer rcxHeaderAnalyzer = FirmwareUpdate.getRcxHeaderAnalyzer(fwImage);
            if (rcxHeaderAnalyzer == null) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(43, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", 43, new Object[0]);
                return;
            }
            boolean[] forceUpdateFlag = new boolean[]{true};
            int validateRsult = TMUtilityFirmwareUpdater.checkFirmwareInfo(rcxHeaderAnalyzer, this.currentFirmwareInfo.getJson(), this.targetFirmwareInfo.getVersion(), forceUpdateFlag);
            if (validateRsult != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(validateRsult, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", validateRsult, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 0.0f);
            }
            if ((printerUnits = FirmwareInfo.makePrinterUnits(this.currentFirmwareInfo.getJson())) == null) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(43, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", 43, new Object[0]);
                return;
            }
            int[] maxWaitTime = new int[1];
            int[] result = new int[]{255};
            ByteArrayOutputStream writeImage = FirmwareUpdater.createWriteImage(fwImage, rcxHeaderAnalyzer, printerUnits, maxWaitTime, result);
            if (result[0] != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(result[0], 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", result[0], new Object[0]);
                return;
            }
            ProgressMonitor progressMonitor = new ProgressMonitor();
            progressMonitor.start();
            int errStatus = Printer.this.nativeEpos2WriteFirmwareImage(Printer.this.mPrinterHandle, writeImage.toByteArray(), false);
            progressMonitor.stopMonitor();
            if (0 != errStatus) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(errStatus);
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(code, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", code, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 1.0f);
            }
            if (this.listener != null) {
                this.listener.onUpdateFirmware(0, maxWaitTime[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware", 0, new Object[0]);
        }

        private void writeFirmware_MOT() {
            Printer.this.outputLogCallFunction("updateFirmware_writeFirmware_MOT", new Object[0]);
            byte[] fwImage = Printer.this.firmwareImage;
            int errStatusCallback = FirmwareUpdate.validateFirmware(fwImage, this.currentFirmwareInfo, this.bootId);
            if (errStatusCallback != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(errStatusCallback, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware_MOT", errStatusCallback, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 0.0f);
            }
            int[] maxWaitTime = new int[1];
            int[] result = new int[]{255};
            ByteArrayOutputStream writeImage = FirmwareUpdater.createWriteImage_MOT(fwImage, maxWaitTime, result);
            if (result[0] != 0) {
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(result[0], 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware_MOT", result[0], new Object[0]);
                return;
            }
            ProgressMonitor progressMonitor = new ProgressMonitor(2);
            progressMonitor.start();
            int errStatus = Printer.this.nativeEpos2WriteFirmwareImageMOT(Printer.this.mPrinterHandle, writeImage.toByteArray(), false);
            progressMonitor.stopMonitor();
            if (0 != errStatus) {
                int code = FirmwareUpdate.convertEpos2exToEpos2CallbackCode(errStatus);
                if (this.listener != null) {
                    this.listener.onUpdateFirmware(code, 0);
                }
                Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware_MOT", code, new Object[0]);
                return;
            }
            if (this.listener != null) {
                this.listener.onFirmwareUpdateProgress("Sending firmware image.", 1.0f);
            }
            if (this.listener != null) {
                this.listener.onUpdateFirmware(0, maxWaitTime[0]);
            }
            Printer.this.outputLogReturnFunction("updateFirmware_writeFirmware_MOT", 0, new Object[0]);
        }

        class ProgressMonitor
        extends Thread {
            boolean isMonitor = false;
            long dummyPrintHandle = 1L;
            int firmwareType = 1;

            ProgressMonitor() {
            }

            ProgressMonitor(int type) {
                this.firmwareType = type;
            }

            @Override
            public void run() {
                try {
                    ProgressMonitor.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.startMonitor();
            }

            public void startMonitor() {
                this.isMonitor = true;
                try {
                    while (this.isMonitor) {
                        int p = 0;
                        if (this.firmwareType == 1) {
                            p = Printer.this.nativeEpos2WriteFirmwareImage(this.dummyPrintHandle, null, true);
                        } else if (this.firmwareType == 2) {
                            p = Printer.this.nativeEpos2WriteFirmwareImageMOT(this.dummyPrintHandle, null, true);
                        }
                        float floatProgress = (float)p / 1000.0f / 1000.0f;
                        if (UpdateFirmwareMain.this.listener != null) {
                            UpdateFirmwareMain.this.listener.onFirmwareUpdateProgress("Sending firmware image.", floatProgress);
                        }
                        ProgressMonitor.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    this.stopMonitor();
                }
                finally {
                    this.stopMonitor();
                }
            }

            public void stopMonitor() {
                this.isMonitor = false;
            }
        }
    }

    class DownloadFirmwareListMain
    implements FirmwareDownloader.OnResultListener {
        FirmwareUpdateListener listener = null;
        String model;
        String requestModel;

        public void start() {
            Printer.this.outputLogCallFunction("downloadFirmwareList_main", new Object[0]);
            TMUtilityFirmwareDownloader downloader = new TMUtilityFirmwareDownloader(this.model, this.requestModel, "1.0.0 ESC/POS");
            downloader.setOnResultListener(this);
            downloader.getFileList(Printer.this.mConnectedTarget);
            Printer.this.outputLogReturnFunction("downloadFirmwareList_main", 0, new Object[0]);
        }

        public DownloadFirmwareListMain(String model, String requestModel, FirmwareUpdateListener listener) throws Epos2Exception {
            if (listener == null) {
                throw new Epos2Exception(1);
            }
            this.listener = listener;
            this.model = model;
            this.requestModel = requestModel;
        }

        @Override
        public void OnFileListGet(String model, String requestModel, String[] fileList) {
            Printer.this.outputLogCallFunction("downloadFirmwareList_OnSuccess", new Object[0]);
            FirmwareInfo[] firmInfoList = new FirmwareInfo[fileList.length];
            for (int i = 0; i < fileList.length; ++i) {
                firmInfoList[i] = new FirmwareInfo(model, fileList[i], requestModel);
            }
            if (this.listener != null) {
                this.listener.onDownloadFirmwareList(0, firmInfoList);
            }
            Printer.this.outputLogReturnFunction("downloadFirmwareList_OnSuccess", 0, new Object[0]);
        }

        @Override
        public void OnError(FirmwareDownloader.Error error) {
            Printer.this.outputLogCallFunction("downloadFirmwareList_OnError", new Object[0]);
            if (this.listener != null) {
                this.listener.onDownloadFirmwareList(35, null);
            }
            Printer.this.outputLogReturnFunction("downloadFirmwareList_OnError", error.ordinal(), new Object[0]);
        }

        @Override
        public void OnSuccess() {
        }

        @Override
        public void OnHistoryGet(String url) {
        }
    }

    class InnerThread
    extends Thread {
        Printer mPrn = null;
        Object mListener = null;
        long mHandle = 0L;
        int mTimeout = 0;
        int mType = 0;
        int[] mTypes = null;
        int[] mValues = null;

        public InnerThread(Printer prn, Object listener, long handle, int timeout, int type, int[] types, int[] values) {
            this.mPrn = prn;
            this.mListener = listener;
            this.mHandle = handle;
            this.mTimeout = timeout;
            this.mType = type;
            if (types != null) {
                this.mTypes = new int[types.length];
                try {
                    System.arraycopy(types, 0, this.mTypes, 0, types.length);
                }
                catch (Exception e) {
                    this.mTypes = null;
                }
            }
            if (values != null) {
                this.mValues = new int[values.length];
                try {
                    System.arraycopy(values, 0, this.mValues, 0, values.length);
                }
                catch (Exception e) {
                    this.mValues = null;
                }
            }
        }
    }
}

