/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class RccStream {
    public static final int HEADER_LENGTH = 37;
    public static final int ID_ADDRESS = 2;
    public static final int ID_LENGTH = 5;
    public static final int ADDRESS_ADDRESS = 10;
    public static final int ADDRESS_LENGTH = 8;
    public static final int LENGTH_ADDRESS = 19;
    public static final int LENGTH_LENGTH = 8;
    public static final int CRC32_ADDRESS = 28;
    public static final int CRC32_LENGTH = 8;
    public static final int END_OF_RCC = -1;
    private static byte[] COMMAND_ENTER_LANGUAGE_RCC = new byte[]{27, 1, 64, 69, 74, 76, 32, 69, 78, 84, 69, 82, 32, 76, 65, 78, 71, 85, 65, 71, 69, 32, 61, 32, 82, 67, 67, 13, 10};
    private InputStream m_inputStream = null;
    private int m_binaryRemain = 0;
    private byte[] m_rccHeader = new byte[37];
    private int m_headerOutputRemain = 0;

    public RccStream(InputStream rcxInputStream) throws IOException {
        this.m_inputStream = new BufferedInputStream(rcxInputStream);
        if (!this.findFirstRccHeader()) {
            throw new IOException();
        }
        if (!this.readHeader()) {
            throw new IOException();
        }
    }

    private boolean findFirstRccHeader() {
        int index = 0;
        while (index < COMMAND_ENTER_LANGUAGE_RCC.length) {
            try {
                int readInt = this.m_inputStream.read();
                if (readInt == -1) {
                    return false;
                }
                if ((byte)(readInt & 0xFF) == COMMAND_ENTER_LANGUAGE_RCC[index]) {
                    ++index;
                    continue;
                }
                index = 0;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean readHeader() {
        int index = 0;
        try {
            int readSize;
            do {
                if ((readSize = this.m_inputStream.read(this.m_rccHeader, index, 37 - index)) != -1) continue;
                return false;
            } while ((index += readSize) < 37);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.m_rccHeader[0] != 27) {
            return false;
        }
        if (this.m_rccHeader[1] != 29) {
            return false;
        }
        if (this.m_rccHeader[7] != 59) {
            return false;
        }
        if (this.m_rccHeader[18] != 59) {
            return false;
        }
        if (this.m_rccHeader[27] != 59) {
            return false;
        }
        if (this.m_rccHeader[36] != 125) {
            return false;
        }
        this.m_headerOutputRemain = 37;
        try {
            this.m_binaryRemain = Integer.parseInt(new String(Arrays.copyOfRange(this.m_rccHeader, 19, 27)), 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean next() {
        if (this.m_binaryRemain > 0) {
            try {
                while (this.m_binaryRemain > 0) {
                    this.m_binaryRemain = (int)((long)this.m_binaryRemain - this.m_inputStream.skip(this.m_binaryRemain));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.readHeader();
    }

    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        if (this.m_headerOutputRemain > 0) {
            int copySize = byteCount < this.m_headerOutputRemain ? byteCount : this.m_headerOutputRemain;
            System.arraycopy(this.m_rccHeader, 0, buffer, byteOffset, copySize);
            this.m_headerOutputRemain -= copySize;
            return copySize;
        }
        if (this.m_binaryRemain <= 0) {
            return -1;
        }
        int readSize = this.m_inputStream.read(buffer, byteOffset, this.m_binaryRemain < byteCount ? this.m_binaryRemain : byteCount);
        if (readSize == -1) {
            return -1;
        }
        this.m_binaryRemain -= readSize;
        return readSize;
    }

    public String getRccUnitId() {
        String rccHeaderUnitId = null;
        try {
            rccHeaderUnitId = new String(Arrays.copyOfRange(this.m_rccHeader, 2, 7));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rccHeaderUnitId;
    }

    public boolean isEofStream() {
        return this.m_binaryRemain <= 0;
    }
}

