/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer.tmutility.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONData
implements Serializable {
    private JSONObject mJsonObj = null;

    public static JSONData getJsonData(String jsonText) {
        if (jsonText == null) {
            return null;
        }
        if (jsonText.isEmpty()) {
            return null;
        }
        JSONData jsonData = new JSONData();
        try {
            JSONObject obj = new JSONObject(jsonText);
            jsonData.setJSONObj(obj);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonData;
    }

    public JSONObject getJSONObj() {
        return this.mJsonObj;
    }

    public void setJSONObj(JSONObject jsonObj) {
        this.mJsonObj = jsonObj;
    }

    public JSONObject getJSONObj(String key) {
        if (key == null) {
            return null;
        }
        String[] keyList = key.split("/", 0);
        ArrayList<String> keyArray = new ArrayList<String>();
        Collections.addAll(keyArray, keyList);
        return this.getJSONObj(keyArray);
    }

    public JSONObject getJSONObj(ArrayList<String> keyArray) {
        if (keyArray == null) {
            return null;
        }
        if (null == this.mJsonObj) {
            return null;
        }
        JSONObject extractJson = this.mJsonObj;
        for (int i = 0; i < keyArray.size(); ++i) {
            try {
                extractJson = extractJson.getJSONObject(keyArray.get(i));
                continue;
            }
            catch (JSONException e) {
                return null;
            }
            catch (NullPointerException ne) {
                return null;
            }
        }
        return extractJson;
    }

    public String getJSONValue(String key) {
        if (key == null) {
            return null;
        }
        String value = "";
        if (null == this.mJsonObj) {
            return null;
        }
        int offset = key.lastIndexOf("/");
        String findValueKey = key;
        JSONObject obj = this.mJsonObj;
        if (-1 != offset) {
            String findKey = key.substring(0, offset);
            findValueKey = key.substring(offset + 1);
            obj = this.getJSONObj(findKey);
        }
        if (null != obj) {
            try {
                if (obj.has(findValueKey)) {
                    value = obj.getString(findValueKey);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return value;
    }

    public String getJSONValue2(String key) {
        if (key == null) {
            return null;
        }
        String value = null;
        if (null == this.mJsonObj) {
            return null;
        }
        int offset = key.lastIndexOf("/");
        if (-1 == offset) {
            try {
                if (this.mJsonObj.has(key)) {
                    value = this.mJsonObj.getString(key);
                    return value;
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return null;
        }
        String findKey = key.substring(0, offset);
        String findValueKey = key.substring(offset + 1);
        JSONObject obj = this.getJSONObj(findKey);
        if (null != obj) {
            try {
                if (obj.has(findValueKey)) {
                    value = obj.getString(findValueKey);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean setJSONValue(String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        if (null == this.mJsonObj) {
            return false;
        }
        String[] keyList = key.split("/", 0);
        JSONObject obj = this.mJsonObj;
        try {
            if (1 != keyList.length) {
                for (int i = 0; i < keyList.length - 1; ++i) {
                    if (!obj.has(keyList[i])) {
                        JSONObject objNode = new JSONObject();
                        obj.put(keyList[i], (Object)objNode);
                    }
                    obj = obj.getJSONObject(keyList[i]);
                }
            }
            obj.put(keyList[keyList.length - 1], (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return true;
    }

    public boolean isEnableKey(String key) {
        if (key == null) {
            return false;
        }
        boolean isEnable = false;
        if (null == this.mJsonObj) {
            return false;
        }
        int offset = key.lastIndexOf("/");
        String findValueKey = key;
        JSONObject obj = this.mJsonObj;
        if (-1 != offset) {
            String findKey = key.substring(0, offset);
            findValueKey = key.substring(offset + 1);
            obj = this.getJSONObj(findKey);
        }
        if (null != obj) {
            isEnable = obj.has(findValueKey);
        }
        return isEnable;
    }

    public void deleteKey(String jsonPath) {
        if (jsonPath == null) {
            return;
        }
        if (null == this.mJsonObj) {
            return;
        }
        String[] keyList = jsonPath.split("/", 0);
        JSONObject obj = this.mJsonObj;
        try {
            if (1 != keyList.length) {
                for (int i = 0; i < keyList.length - 1; ++i) {
                    if (!obj.has(keyList[i])) {
                        return;
                    }
                    obj = obj.getJSONObject(keyList[i]);
                }
            }
            obj.remove(keyList[keyList.length - 1]);
        }
        catch (JSONException ignored) {
            ignored.printStackTrace();
        }
    }

    public String getParentKeyPath(String keys) {
        if (keys == null) {
            return null;
        }
        int offset = keys.lastIndexOf("/");
        if (offset == -1) {
            return keys;
        }
        return keys.substring(0, offset);
    }
}

