/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.printer.tmutility.printerSettings.intelligent;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TMiUtil {
    private static final String PASSWORD = "U2FsdGVkX18DE+jLq2VYi1GQYyhjKiCwLWRTfOJoWYk=";
    private static final int SALT_SIZE = 8;
    private static final String SALT_HEADER = "Salted__";
    private static final String CIPHER_KEY = "key";
    private static final String CIPHER_IV = "iv";
    private static final String DIGEST_METHOD_MD5 = "MD5";
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String CIPHER_METHOD = "AES/CBC/PKCS5Padding";
    private static final String MESSAGE_DIGEST_SHA256 = "SHA-256";

    public static String encodeData(String strData) {
        if (strData == null) {
            return null;
        }
        String password = PASSWORD;
        byte[] salt = TMiUtil.getRandomSalt();
        HashMap<String, byte[]> keyMap = TMiUtil.generateCipherKeys(password, salt);
        if (null == keyMap) {
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(keyMap.get(CIPHER_KEY), CIPHER_ALGORITHM);
        Cipher cipher = null;
        String strResult = null;
        try {
            cipher = Cipher.getInstance(CIPHER_METHOD);
            cipher.init(1, (Key)secretKey, new IvParameterSpec(keyMap.get(CIPHER_IV)));
            byte[] encryptedData = cipher.doFinal(strData.getBytes());
            ByteBuffer saltedEncryptedDataBuf = ByteBuffer.allocate(SALT_HEADER.length() + salt.length + encryptedData.length);
            saltedEncryptedDataBuf.put(SALT_HEADER.getBytes());
            saltedEncryptedDataBuf.put(salt);
            saltedEncryptedDataBuf.put(encryptedData);
            byte[] saltedEncryptedData = saltedEncryptedDataBuf.array();
            byte[] encodedData = Base64.encode((byte[])saltedEncryptedData, (int)0);
            strResult = new String(encodedData, "UTF-8");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
        }
        catch (BadPaddingException badPaddingException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return strResult;
    }

    private static byte[] getRandomSalt() {
        byte[] salt = new byte[8];
        long seed = System.currentTimeMillis();
        Random r = new Random(seed);
        r.nextBytes(salt);
        return salt;
    }

    private static HashMap<String, byte[]> generateCipherKeys(String password, byte[] salt) {
        if (password == null || salt == null) {
            return null;
        }
        HashMap<String, byte[]> keyMap = new HashMap<String, byte[]>();
        if ("".equals(password)) {
            return null;
        }
        byte[] bPassword = password.getBytes();
        ByteBuffer byteBufHash1 = ByteBuffer.allocate(bPassword.length + salt.length);
        byteBufHash1.put(bPassword);
        byteBufHash1.put(salt);
        byte[] hash1 = TMiUtil.convertToMD5(byteBufHash1.array());
        if (hash1 == null) {
            return null;
        }
        ByteBuffer byteBufHash2 = ByteBuffer.allocate(hash1.length + bPassword.length + salt.length);
        byteBufHash2.put(hash1);
        byteBufHash2.put(bPassword);
        byteBufHash2.put(salt);
        byte[] hash2 = TMiUtil.convertToMD5(byteBufHash2.array());
        if (hash2 == null) {
            return null;
        }
        ByteBuffer byteBufKey = ByteBuffer.allocate(hash1.length + hash2.length);
        byteBufKey.put(hash1);
        byteBufKey.put(hash2);
        keyMap.put(CIPHER_KEY, byteBufKey.array());
        ByteBuffer byteBufIv = ByteBuffer.allocate(hash2.length + bPassword.length + salt.length);
        byteBufIv.put(hash2);
        byteBufIv.put(bPassword);
        byteBufIv.put(salt);
        byte[] iv = TMiUtil.convertToMD5(byteBufIv.array());
        if (iv == null) {
            return null;
        }
        keyMap.put(CIPHER_IV, iv);
        return keyMap;
    }

    private static byte[] convertToMD5(byte[] source) {
        if (source == null) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(DIGEST_METHOD_MD5);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(source);
        byte[] hash = md.digest();
        return hash;
    }

    public static String convertEncryptedHashValue(String value) {
        if (value == null) {
            return null;
        }
        MessageDigest md = null;
        String hashedValue = null;
        StringBuilder sb = null;
        try {
            md = MessageDigest.getInstance(MESSAGE_DIGEST_SHA256);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (md != null) {
            md.update(value.getBytes());
            sb = new StringBuilder();
            for (byte b : md.digest()) {
                String hex = String.format("%02x", b);
                sb.append(hex);
            }
            hashedValue = sb.toString();
        }
        return hashedValue;
    }
}

