/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epos2.storage;

import android.content.Context;
import java.io.File;
import java.lang.reflect.Method;

public class ConnectionInfo {
    private static final String dirName = "Epos2ConnectionInfo";
    private static Class<?> mClassOutputLog;
    private static Method mOutputLogInfoMethod;

    private static native int nativeEpos2SetStoragePath(String var0);

    public static void setStoragePath(Context context) {
        int errStatus;
        String path = "";
        String dirPath = "";
        try {
            path = context.getExternalFilesDir(null).toString();
            dirPath = path + "/" + dirName;
        }
        catch (Exception e) {
            path = "";
            ConnectionInfo.outputLogInfo(new Object[0]);
        }
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            ConnectionInfo.outputLogInfo(new Object[0]);
        }
        if ((errStatus = ConnectionInfo.nativeEpos2SetStoragePath(path)) != 0) {
            ConnectionInfo.outputLogInfo(new Object[0]);
        }
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        mClassOutputLog = null;
        mOutputLogInfoMethod = null;
        try {
            ConnectionInfo.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

