/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.epson.eposdevice.ConnectListener;
import com.epson.eposdevice.CreateDeviceListener;
import com.epson.eposdevice.DeleteDeviceListener;
import com.epson.eposdevice.DeviceInnerImplement;
import com.epson.eposdevice.DisconnectListener;
import com.epson.eposdevice.EposException;
import com.epson.eposdevice.NativeDevice;
import com.epson.eposdevice.ReconnectListener;
import com.epson.eposdevice.ReconnectingListener;
import com.epson.eposdevice.commbox.CommBoxManager;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class Device
extends DeviceInnerImplement {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_UNSPECIFIED = -1;
    public static final int PARAM_DEFAULT = -2;
    public static final int DEV_TYPE_PRINTER = 0;
    public static final int DEV_TYPE_DISPLAY = 1;
    public static final int DEV_TYPE_KEYBOARD = 2;
    public static final int DEV_TYPE_SCANNER = 3;
    public static final int DEV_TYPE_SIMPLE_SERIAL = 4;
    private ReconnectingListener mReconnectingListener;
    private ReconnectListener mReconnectListener;
    private DisconnectListener mDisconnectListener;
    private Vector<DeviceInnerImplement.IDeviceObject> mCreatedDeviceList = new Vector();
    private static final String SDK_NAME = "ePOS-Device SDK for Android";
    private static final String SDK_VERSION = "1.2.0";
    private long mDeviceHandle = 0L;
    private DeviceInnerImplement.CommBoxManagerInner mCommBoxManager = null;

    public Device() throws EposException {
        this.initializeDeviceInstance();
    }

    public Device(Context context) throws EposException {
        String path = "";
        if (null != context) {
            try {
                path = context.getExternalFilesDir(null).toString();
            }
            catch (Exception e) {
                path = "";
            }
        }
        String deviceOs = "Android";
        String deviceOsVer = Build.VERSION.RELEASE;
        String deviceName = Build.MODEL;
        long totalRamSize = Device.getTotalMemorySize(Environment.getDataDirectory());
        long freeRamSize = Device.getFreeMemorySize(Environment.getDataDirectory());
        long freeStorageSize = 0L;
        if (null != context) {
            try {
                freeStorageSize = Device.getFreeMemorySize(context.getExternalFilesDir(null));
            }
            catch (Exception e) {
                freeStorageSize = 0L;
            }
        }
        String ramSize = String.format(Locale.US, "%d/%d", freeRamSize, totalRamSize);
        String storageSize = String.format(Locale.US, "%d", freeStorageSize);
        try {
            this.nativeReadLogSettings(path, SDK_NAME, SDK_VERSION, deviceOs, deviceOsVer, deviceName, ramSize, storageSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeDeviceInstance();
    }

    private static long getTotalMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getTotalSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    private static long getFreeMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getFreeSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    protected void initializeDeviceInstance() throws EposException {
        long[] bufHandle = new long[1];
        int errStatus = this.nativeCreateHandle(bufHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
        this.mDeviceHandle = bufHandle[0];
        bufHandle[0] = 0L;
        errStatus = this.nativeGetCommBoxManager(this.mDeviceHandle, bufHandle);
        if (0 != errStatus) {
            this.nativeDeleteHandle(this.mDeviceHandle);
            throw new EposException(errStatus);
        }
        this.mCommBoxManager = new DeviceInnerImplement.CommBoxManagerInner(this, bufHandle[0]);
    }

    protected void finalize() throws Throwable {
        try {
            this.deleteAllDeviceObject();
            if (this.mCommBoxManager != null) {
                this.mCommBoxManager.deleteInstance();
                this.mCommBoxManager = null;
            }
            if (this.mDeviceHandle != 0L) {
                this.nativeSetDeviceCallback(this.mDeviceHandle, null);
                this.nativeDeleteHandle(this.mDeviceHandle);
            }
        }
        finally {
            super.finalize();
        }
    }

    public void connect(String ipAddress, ConnectListener target) throws EposException {
        this.outputLogCallFunction("connect", ipAddress, target);
        try {
            if (null == ipAddress || null == target) {
                throw new EposException(1);
            }
            if (0L == this.mDeviceHandle) {
                throw new EposException(5);
            }
            int errStatus = this.nativeConnect(this.mDeviceHandle, ipAddress, new ConnectCallbackAdapter(target));
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("connect", ex);
            throw ex;
        }
        this.outputLogReturnFunction("connect", ipAddress, target);
    }

    public void disconnect() throws EposException {
        this.outputLogCallFunction("disconnect", new Object[0]);
        try {
            if (0L == this.mDeviceHandle) {
                throw new EposException(5);
            }
            int errStatus = this.nativeDisconnect(this.mDeviceHandle);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("disconnect", ex);
            throw ex;
        }
        this.outputLogReturnFunction("disconnect", new Object[0]);
    }

    public boolean isConnected() {
        if (0L == this.mDeviceHandle) {
            return false;
        }
        boolean status = this.nativeIsConnect(this.mDeviceHandle);
        return status;
    }

    public void createDevice(String deviceId, int deviceType, int crypto, int buffer, CreateDeviceListener target) throws EposException {
        this.outputLogCallFunction("createDevice", deviceId, deviceType, crypto, buffer, target);
        try {
            if (null == deviceId || null == target) {
                throw new EposException(1);
            }
            if (0L == this.mDeviceHandle) {
                throw new EposException(5);
            }
            int errStatus = this.nativeCreateDevice(this.mDeviceHandle, deviceId, deviceType, crypto, buffer, new CreateDeviceCallbackAdapter(target));
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("createDevice", ex);
            throw ex;
        }
        this.outputLogReturnFunction("createDevice", deviceId, deviceType, crypto, buffer, target);
    }

    public void deleteDevice(Object deviceObject, DeleteDeviceListener target) throws EposException {
        this.outputLogCallFunction("deleteDevice", deviceObject, target);
        try {
            if (null == deviceObject || null == target) {
                throw new EposException(1);
            }
            if (!(deviceObject instanceof DeviceInnerImplement.IDeviceObject)) {
                throw new EposException(1);
            }
            if (0L == this.mDeviceHandle) {
                throw new EposException(5);
            }
            long deviceHandle = ((DeviceInnerImplement.IDeviceObject)deviceObject).getDeviceHandle();
            int errStatus = this.nativeDeleteDevice(this.mDeviceHandle, deviceHandle, new DeleteDeviceCallbackAdapter(target, (DeviceInnerImplement.IDeviceObject)deviceObject));
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (EposException ex) {
            this.outputException("deleteDevice", ex);
            throw ex;
        }
        this.outputLogReturnFunction("deleteDevice", deviceObject, target);
    }

    public String getAdmin() {
        if (0L == this.mDeviceHandle) {
            return null;
        }
        String adminInfo = this.nativeGetAdmin(this.mDeviceHandle);
        if (adminInfo == null) {
            adminInfo = "";
        }
        return adminInfo;
    }

    public String getLocation() {
        if (0L == this.mDeviceHandle) {
            return null;
        }
        String localInfo = this.nativeGetLocal(this.mDeviceHandle);
        if (localInfo == null) {
            localInfo = "";
        }
        return localInfo;
    }

    public CommBoxManager getCommBoxManager() {
        return this.mCommBoxManager;
    }

    public void setReconnectingEventCallback(ReconnectingListener reconnectingListener) {
        if (this.isEmptyCallbacks() && reconnectingListener != null) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, this);
        }
        this.mReconnectingListener = reconnectingListener;
        if (this.isEmptyCallbacks()) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, null);
        }
    }

    public void setReconnectEventCallback(ReconnectListener reconnectListener) {
        if (this.isEmptyCallbacks() && reconnectListener != null) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, this);
        }
        this.mReconnectListener = reconnectListener;
        if (this.isEmptyCallbacks()) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, null);
        }
    }

    public void setDisconnectEventCallback(DisconnectListener disconnectListener) {
        if (this.isEmptyCallbacks() && disconnectListener != null) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, this);
        }
        this.mDisconnectListener = disconnectListener;
        if (this.isEmptyCallbacks()) {
            this.nativeSetDeviceCallback(this.mDeviceHandle, null);
        }
    }

    protected boolean isEmptyCallbacks() {
        boolean bEmpty = false;
        if (this.mReconnectingListener == null && this.mReconnectListener == null && this.mDisconnectListener == null) {
            bEmpty = true;
        }
        return bEmpty;
    }

    private void onReconnecting(String ipAddress) {
        if (null != this.mReconnectingListener) {
            this.outputLogEvent("onReconnecting", ipAddress);
            this.mReconnectingListener.onReconnecting(ipAddress);
        }
    }

    private void onReconnect(String ipAddress) {
        if (null != this.mReconnectListener) {
            this.outputLogEvent("onReconnect", ipAddress);
            this.mReconnectListener.onReconnect(ipAddress);
        }
    }

    private void onDisconnect(String ipAddress) {
        if (null != this.mDisconnectListener) {
            this.outputLogEvent("onDisconnect", ipAddress);
            this.mDisconnectListener.onDisconnect(ipAddress);
        }
        this.deleteAllDeviceObject();
    }

    @Override
    protected void nativeOnDisconnect(String ipAddress) {
        this.onDisconnect(ipAddress);
    }

    @Override
    protected void nativeOnReconnecting(String ipAddress) {
        this.onReconnecting(ipAddress);
    }

    @Override
    protected void nativeOnReconnect(String ipAddress) {
        this.onReconnect(ipAddress);
    }

    protected void deleteAllDeviceObject() {
        Iterator<DeviceInnerImplement.IDeviceObject> iterator = this.mCreatedDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().deleteInstance();
        }
        this.mCreatedDeviceList.removeAllElements();
    }

    protected void outputLogCallFunction(String methodName, Object ... param) {
        this.processOutputLogData(this.LOGIF_FUNC_IN, this.mDeviceHandle, methodName, param);
    }

    protected void outputLogReturnFunction(String methodName, Object ... param) {
        this.processOutputLogData(this.LOGIF_FUNC_OUT_WITH_RET, this.mDeviceHandle, methodName, param);
    }

    protected void outputException(String methodName, Exception ex) {
        this.processOutputExceptionLog(this.LOGIF_FUNC_OUT_WITHOUT_RET, this.mDeviceHandle, methodName, ex);
    }

    protected void outputLogEvent(String methodName, Object ... param) {
        this.processOutputLogData(this.LOGIF_FUNC_CB_EVENT, this.mDeviceHandle, methodName, param);
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private class DeleteDeviceCallbackAdapter
    implements NativeDevice.NativeDeleteDeviceCallbackAdapter {
        private DeleteDeviceListener mListener = null;
        private DeviceInnerImplement.IDeviceObject mDeleteObj = null;

        public DeleteDeviceCallbackAdapter(DeleteDeviceListener listener, DeviceInnerImplement.IDeviceObject objDelete) {
            this.mListener = listener;
            this.mDeleteObj = objDelete;
        }

        @Override
        public void nativeOnDeleteDevice(String ipAddress, String deviceId, int code) {
            if (this.mListener != null) {
                Device.this.outputLogEvent("OnDeleteDevice", ipAddress, deviceId, code);
                this.mListener.onDeleteDevice(ipAddress, deviceId, code);
            }
            if (code == 0) {
                Device.this.mCreatedDeviceList.remove(this.mDeleteObj);
                this.mDeleteObj.deleteInstance();
            }
        }
    }

    private class CreateDeviceCallbackAdapter
    implements NativeDevice.NativeCreateDeviceCallbackAdapter {
        private CreateDeviceListener mListener = null;

        public CreateDeviceCallbackAdapter(CreateDeviceListener listener) {
            this.mListener = listener;
        }

        @Override
        public void nativeOnCreateDevice(String ipAddress, String deviceId, int deviceType, long deviceObjectHandle, int code) {
            DeviceInnerImplement.IDeviceObject deviceObj = null;
            if (code == 0) {
                switch (deviceType) {
                    case 0: {
                        deviceObj = new DeviceInnerImplement.PrinterInner(Device.this, deviceObjectHandle);
                        break;
                    }
                    case 1: {
                        deviceObj = new DeviceInnerImplement.DisplayInner(Device.this, deviceObjectHandle);
                        break;
                    }
                    case 2: {
                        deviceObj = new DeviceInnerImplement.KeyboardInner(Device.this, deviceObjectHandle);
                        break;
                    }
                    case 3: {
                        deviceObj = new DeviceInnerImplement.ScannerInner(Device.this, deviceObjectHandle);
                        break;
                    }
                    case 4: {
                        deviceObj = new DeviceInnerImplement.SimpleSerialInner(Device.this, deviceObjectHandle);
                    }
                }
                Device.this.mCreatedDeviceList.add(deviceObj);
            }
            if (this.mListener != null) {
                Device.this.outputLogEvent("OnCreateDevice", ipAddress, deviceId, deviceType, deviceObj, code);
                this.mListener.onCreateDevice(ipAddress, deviceId, deviceType, deviceObj, code);
            }
        }
    }

    private class ConnectCallbackAdapter
    implements NativeDevice.NativeConnectCallbackAdapter {
        private ConnectListener mListener = null;

        public ConnectCallbackAdapter(ConnectListener listener) {
            this.mListener = listener;
        }

        @Override
        public void nativeOnConnect(String ipAddress, int code) {
            if (this.mListener != null) {
                Device.this.outputLogEvent("onConnect", ipAddress, code);
                this.mListener.onConnect(ipAddress, code);
            }
        }
    }
}

