/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.commbox;

import com.epson.eposdevice.EposException;
import com.epson.eposdevice.commbox.CloseCommBoxListener;
import com.epson.eposdevice.commbox.CommBox;
import com.epson.eposdevice.commbox.NativeCommBoxManager;
import com.epson.eposdevice.commbox.OpenCommBoxListener;
import java.util.Iterator;
import java.util.Vector;

public abstract class CommBoxManager
extends NativeCommBoxManager {
    private long mCommBoxManagerHandle = 0L;
    private Vector<CommBoxAccessor> mCommBoxList = new Vector();

    protected CommBoxManager(long handle) {
        this.mCommBoxManagerHandle = handle;
    }

    protected long getInnerHandle() {
        return this.mCommBoxManagerHandle;
    }

    protected void innerDeleteInstance() {
        this.mCommBoxManagerHandle = 0L;
        Iterator<CommBoxAccessor> iterator = this.mCommBoxList.iterator();
        while (iterator.hasNext()) {
            iterator.next().deleteInstance();
        }
        this.mCommBoxList.clear();
    }

    public void openCommBox(String boxId, String memberId, int[] sequence, OpenCommBoxListener target) throws EposException {
        this.outputLogCallFunction("openCommBox", boxId, memberId, sequence, target);
        try {
            if (this.mCommBoxManagerHandle == 0L) {
                throw new EposException(5);
            }
            if (sequence == null) {
                throw new EposException(1);
            }
            if (sequence.length == 0) {
                throw new EposException(1);
            }
            long[] sequenceNumber = new long[1];
            int errState = this.nativeOpenCommBox(this.mCommBoxManagerHandle, boxId, memberId, sequenceNumber, new OpenCommBoxCallbackAdapter(target));
            if (errState != 0) {
                throw new EposException(errState);
            }
            sequence[0] = (int)sequenceNumber[0];
        }
        catch (EposException ex) {
            this.outputException("openCommBox", ex);
            throw ex;
        }
        this.outputLogReturnFunction("openCommBox", boxId, memberId, sequence, target);
    }

    public void closeCommBox(CommBox commBoxObject, int[] sequence, CloseCommBoxListener target) throws EposException {
        this.outputLogCallFunction("closeCommBox", commBoxObject, sequence, target);
        try {
            if (this.mCommBoxManagerHandle == 0L) {
                throw new EposException(5);
            }
            if (sequence == null) {
                throw new EposException(1);
            }
            if (sequence.length == 0) {
                throw new EposException(1);
            }
            if (!(commBoxObject instanceof CommBoxAccessor)) {
                throw new EposException(1);
            }
            CommBoxAccessor boxInstance = (CommBoxAccessor)commBoxObject;
            long[] sequenceNumber = new long[1];
            int errState = this.nativeCloseCommBox(this.mCommBoxManagerHandle, boxInstance.getHandle(), sequenceNumber, new CloseCommBoxCallbackAdapter(target, boxInstance));
            if (errState != 0) {
                throw new EposException(errState);
            }
            sequence[0] = (int)sequenceNumber[0];
        }
        catch (EposException ex) {
            this.outputException("closeCommBox", ex);
            throw ex;
        }
        this.outputLogReturnFunction("closeCommBox", commBoxObject, sequence, target);
    }

    protected abstract CommBoxAccessor createCommBoxInstance(long var1);

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);

    protected abstract class CommBoxAccessor
    extends CommBox {
        protected CommBoxAccessor(long handle) {
            super(handle);
        }

        protected long getHandle() {
            return super.getInnerHandle();
        }

        protected void deleteInstance() {
            super.innerDeleteInstance();
        }
    }

    protected class CloseCommBoxCallbackAdapter
    implements NativeCommBoxManager.NativeCloseCommBoxCallbackAdapter {
        private CloseCommBoxListener mListener = null;
        private CommBoxAccessor mDeleteBox = null;

        public CloseCommBoxCallbackAdapter(CloseCommBoxListener target, CommBoxAccessor deleteBox) {
            this.mListener = target;
            this.mDeleteBox = deleteBox;
        }

        @Override
        public void nativeOnCloseCommBox(long commBoxMgrHandle, long commBoxHandle, String ipAddress, int code, long sequence) {
            if (this.mListener != null) {
                CommBoxManager.this.outputLogEvent("onCloseCommBox", ipAddress, code, sequence);
                this.mListener.onCloseCommBox(ipAddress, code, (int)sequence);
            }
            if (this.mDeleteBox != null) {
                CommBoxManager.this.mCommBoxList.remove(this.mDeleteBox);
                this.mDeleteBox.deleteInstance();
            }
        }
    }

    protected class OpenCommBoxCallbackAdapter
    implements NativeCommBoxManager.NativeOpenCommBoxCallbackAdapter {
        private OpenCommBoxListener mListener = null;

        public OpenCommBoxCallbackAdapter(OpenCommBoxListener target) {
            this.mListener = target;
        }

        @Override
        public void nativeOnOpenCommBox(long commBoxMgrHandle, long commBoxHandle, String ipAddress, int code, long sequence) {
            if (this.mListener != null) {
                CommBoxAccessor commBoxInstance = null;
                if (code == 0) {
                    commBoxInstance = CommBoxManager.this.createCommBoxInstance(commBoxHandle);
                    CommBoxManager.this.mCommBoxList.add(commBoxInstance);
                }
                CommBoxManager.this.outputLogEvent("onOpenCommBox", ipAddress, commBoxInstance, code, sequence);
                this.mListener.onOpenCommBox(ipAddress, commBoxInstance, code, (int)sequence);
            }
        }
    }
}

