/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposprint;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import com.epson.eposprint.EposException;
import java.io.File;
import java.util.Locale;

public class Builder {
    private long mCommandHandle = 0L;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int PARAM_UNSPECIFIED = -1;
    public static final int PARAM_DEFAULT = -2;
    public static final int MODEL_ANK = 0;
    public static final int MODEL_JAPANESE = 1;
    public static final int MODEL_CHINESE = 2;
    public static final int MODEL_TAIWAN = 3;
    public static final int MODEL_KOREAN = 4;
    public static final int MODEL_THAI = 5;
    public static final int MODEL_SOUTHASIA = 6;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int LANG_EN = 0;
    public static final int LANG_JA = 1;
    public static final int LANG_ZH_CN = 2;
    public static final int LANG_ZH_TW = 3;
    public static final int LANG_KO = 4;
    public static final int LANG_TH = 5;
    public static final int LANG_VI = 6;
    public static final int FONT_A = 0;
    public static final int FONT_B = 1;
    public static final int FONT_C = 2;
    public static final int FONT_D = 3;
    public static final int FONT_E = 4;
    public static final int COLOR_NONE = 0;
    public static final int COLOR_1 = 1;
    public static final int COLOR_2 = 2;
    public static final int COLOR_3 = 3;
    public static final int COLOR_4 = 4;
    public static final int MODE_MONO = 0;
    public static final int MODE_GRAY16 = 1;
    public static final int HALFTONE_DITHER = 0;
    public static final int HALFTONE_ERROR_DIFFUSION = 1;
    public static final int HALFTONE_THRESHOLD = 2;
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_DEFLATE = 1;
    public static final int BARCODE_UPC_A = 0;
    public static final int BARCODE_UPC_E = 1;
    public static final int BARCODE_EAN13 = 2;
    public static final int BARCODE_JAN13 = 3;
    public static final int BARCODE_EAN8 = 4;
    public static final int BARCODE_JAN8 = 5;
    public static final int BARCODE_CODE39 = 6;
    public static final int BARCODE_ITF = 7;
    public static final int BARCODE_CODABAR = 8;
    public static final int BARCODE_CODE93 = 9;
    public static final int BARCODE_CODE128 = 10;
    public static final int BARCODE_GS1_128 = 11;
    public static final int BARCODE_GS1_DATABAR_OMNIDIRECTIONAL = 12;
    public static final int BARCODE_GS1_DATABAR_TRUNCATED = 13;
    public static final int BARCODE_GS1_DATABAR_LIMITED = 14;
    public static final int BARCODE_GS1_DATABAR_EXPANDED = 15;
    public static final int HRI_NONE = 0;
    public static final int HRI_ABOVE = 1;
    public static final int HRI_BELOW = 2;
    public static final int HRI_BOTH = 3;
    public static final int SYMBOL_PDF417_STANDARD = 0;
    public static final int SYMBOL_PDF417_TRUNCATED = 1;
    public static final int SYMBOL_QRCODE_MODEL_1 = 2;
    public static final int SYMBOL_QRCODE_MODEL_2 = 3;
    public static final int SYMBOL_MAXICODE_MODE_2 = 4;
    public static final int SYMBOL_MAXICODE_MODE_3 = 5;
    public static final int SYMBOL_MAXICODE_MODE_4 = 6;
    public static final int SYMBOL_MAXICODE_MODE_5 = 7;
    public static final int SYMBOL_MAXICODE_MODE_6 = 8;
    public static final int SYMBOL_GS1_DATABAR_STACKED = 9;
    public static final int SYMBOL_GS1_DATABAR_STACKED_OMNIDIRECTIONAL = 10;
    public static final int SYMBOL_GS1_DATABAR_EXPANDED_STACKED = 11;
    public static final int SYMBOL_AZTECCODE_FULLRANGE = 12;
    public static final int SYMBOL_AZTECCODE_COMPACT = 13;
    public static final int SYMBOL_DATAMATRIX_SQUARE = 14;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_8 = 15;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_12 = 16;
    public static final int SYMBOL_DATAMATRIX_RECTANGLE_16 = 17;
    public static final int LEVEL_0 = 0;
    public static final int LEVEL_1 = 1;
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    public static final int LEVEL_4 = 4;
    public static final int LEVEL_5 = 5;
    public static final int LEVEL_6 = 6;
    public static final int LEVEL_7 = 7;
    public static final int LEVEL_8 = 8;
    public static final int LEVEL_L = 9;
    public static final int LEVEL_M = 10;
    public static final int LEVEL_Q = 11;
    public static final int LEVEL_H = 12;
    public static final int LEVEL_DEFAULT = 13;
    public static final int LINE_THIN = 0;
    public static final int LINE_MEDIUM = 1;
    public static final int LINE_THICK = 2;
    public static final int LINE_THIN_DOUBLE = 3;
    public static final int LINE_MEDIUM_DOUBLE = 4;
    public static final int LINE_THICK_DOUBLE = 5;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_BOTTOM_TO_TOP = 1;
    public static final int DIRECTION_RIGHT_TO_LEFT = 2;
    public static final int DIRECTION_TOP_TO_BOTTOM = 3;
    public static final int CUT_NO_FEED = 0;
    public static final int CUT_FEED = 1;
    public static final int CUT_RESERVE = 2;
    public static final int DRAWER_1 = 0;
    public static final int DRAWER_2 = 1;
    public static final int PULSE_100 = 0;
    public static final int PULSE_200 = 1;
    public static final int PULSE_300 = 2;
    public static final int PULSE_400 = 3;
    public static final int PULSE_500 = 4;
    public static final int PATTERN_A = 1;
    public static final int PATTERN_B = 2;
    public static final int PATTERN_C = 3;
    public static final int PATTERN_D = 4;
    public static final int PATTERN_E = 5;
    public static final int PATTERN_ERROR = 6;
    public static final int PATTERN_PAPER_END = 7;
    public static final int PATTERN_1 = 8;
    public static final int PATTERN_2 = 9;
    public static final int PATTERN_3 = 10;
    public static final int PATTERN_4 = 11;
    public static final int PATTERN_5 = 12;
    public static final int PATTERN_6 = 13;
    public static final int PATTERN_7 = 14;
    public static final int PATTERN_8 = 15;
    public static final int PATTERN_9 = 16;
    public static final int PATTERN_10 = 17;
    public static final int FEED_PEELING = 0;
    public static final int FEED_CUTTING = 1;
    public static final int FEED_CURRENT_TOF = 2;
    public static final int FEED_NEXT_TOF = 3;
    public static final int LAYOUT_RECEIPT = 0;
    public static final int LAYOUT_LABEL = 1;
    public static final int LAYOUT_LABEL_BM = 2;
    public static final int LAYOUT_RECEIPT_BM = 3;
    private static final int MIN_IMAGE_WIDTH = 1;
    private static final int MIN_IMAGE_HEIGHT = 1;

    protected long getHandle() {
        return this.mCommandHandle;
    }

    private native int eposCreateCommandBuffer(long[] var1, String var2, int var3);

    private native int eposDeleteCommandBuffer(long var1);

    private native int eposClearCommandBuffer(long var1);

    private native int eposAddTextAlign(long var1, int var3);

    private native int eposAddTextLineSpace(long var1, int var3);

    private native int eposAddTextRotate(long var1, int var3);

    private native int eposAddText(long var1, String var3);

    private native int eposAddTextLang(long var1, int var3);

    private native int eposAddTextFont(long var1, int var3);

    private native int eposAddTextSmooth(long var1, int var3);

    private native int eposAddTextDouble(long var1, int var3, int var4);

    private native int eposAddTextSize(long var1, int var3, int var4);

    private native int eposAddTextStyle(long var1, int var3, int var4, int var5, int var6);

    private native int eposAddTextPosition(long var1, int var3);

    private native int eposAddFeedUnit(long var1, int var3);

    private native int eposAddFeedLine(long var1, int var3);

    private native int eposAddImage(long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, double var13, int var15);

    private native int eposAddLogo(long var1, int var3, int var4);

    private native int eposAddBarcode(long var1, String var3, int var4, int var5, int var6, int var7, int var8);

    private native int eposAddSymbol(long var1, String var3, int var4, int var5, int var6, int var7, int var8);

    private native int eposAddHLine(long var1, int var3, int var4, int var5);

    private native int eposAddVLineBegin(long var1, int var3, int var4);

    private native int eposAddVLineEnd(long var1, int var3, int var4);

    private native int eposAddPageBegin(long var1);

    private native int eposAddPageEnd(long var1);

    private native int eposAddPageArea(long var1, int var3, int var4, int var5, int var6);

    private native int eposAddPageDirection(long var1, int var3);

    private native int eposAddPagePosition(long var1, int var3, int var4);

    private native int eposAddPageLine(long var1, int var3, int var4, int var5, int var6, int var7);

    private native int eposAddPageRectangle(long var1, int var3, int var4, int var5, int var6, int var7);

    private native int eposAddCut(long var1, int var3);

    private native int eposAddPulse(long var1, int var3, int var4);

    private native int eposAddSound(long var1, int var3, int var4, int var5);

    private native int eposAddCommand(long var1, byte[] var3, int var4);

    private native int eposAddFeedPosition(long var1, int var3);

    private native int eposAddLayout(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native int eposReadLogSettings(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    public Builder(String printerModel, int lang) throws EposException {
        if (null == printerModel) {
            throw new EposException(1);
        }
        long[] pCommandHandle = new long[]{0L};
        int errStatus = this.eposCreateCommandBuffer(pCommandHandle, printerModel, lang);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
        this.mCommandHandle = pCommandHandle[0];
    }

    public Builder(String printerModel, int lang, Context context) throws EposException {
        if (null == printerModel) {
            throw new EposException(1);
        }
        String path = "";
        if (null != context) {
            try {
                path = context.getExternalFilesDir(null).toString();
            }
            catch (Exception e) {
                path = "";
            }
        }
        String sdkName = "ePOS-Print SDK for Android";
        String sdkVer = "1.9.0";
        String deviceOs = "Android";
        String deviceOsVer = Build.VERSION.RELEASE;
        String deviceName = Build.MODEL;
        long totalRamSize = Builder.getTotalMemorySize(Environment.getDataDirectory());
        long freeRamSize = Builder.getFreeMemorySize(Environment.getDataDirectory());
        long freeStorageSize = 0L;
        if (null != context) {
            try {
                freeStorageSize = Builder.getFreeMemorySize(context.getExternalFilesDir(null));
            }
            catch (Exception e) {
                freeStorageSize = 0L;
            }
        }
        String ramSize = String.format(Locale.US, "%d/%d", freeRamSize, totalRamSize);
        String storageSize = String.format(Locale.US, "%d\n", freeStorageSize);
        try {
            this.eposReadLogSettings(path, sdkName, sdkVer, deviceOs, deviceOsVer, deviceName, ramSize, storageSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long[] pCommandHandle = new long[]{0L};
        int errStatus = this.eposCreateCommandBuffer(pCommandHandle, printerModel, lang);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
        this.mCommandHandle = pCommandHandle[0];
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.eposDeleteCommandBuffer(this.mCommandHandle);
            this.mCommandHandle = 0L;
        }
    }

    public void clearCommandBuffer() {
        this.eposClearCommandBuffer(this.mCommandHandle);
    }

    public void addTextAlign(int align) throws EposException {
        int errStatus = this.eposAddTextAlign(this.mCommandHandle, align);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextLineSpace(int linespc) throws EposException {
        int errStatus = this.eposAddTextLineSpace(this.mCommandHandle, linespc);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextRotate(int rotate) throws EposException {
        int errStatus = this.eposAddTextRotate(this.mCommandHandle, rotate);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addText(String data) throws EposException {
        if (null == data) {
            throw new EposException(1);
        }
        int errStatus = this.eposAddText(this.mCommandHandle, data);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextLang(int lang) throws EposException {
        int errStatus = this.eposAddTextLang(this.mCommandHandle, lang);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextFont(int font) throws EposException {
        int errStatus = this.eposAddTextFont(this.mCommandHandle, font);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextSmooth(int smooth) throws EposException {
        int errStatus = this.eposAddTextSmooth(this.mCommandHandle, smooth);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextDouble(int dw, int dh) throws EposException {
        int errStatus = this.eposAddTextDouble(this.mCommandHandle, dw, dh);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextSize(int width, int height) throws EposException {
        int errStatus = this.eposAddTextSize(this.mCommandHandle, width, height);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextStyle(int reverse, int ul, int em, int color2) throws EposException {
        int errStatus = this.eposAddTextStyle(this.mCommandHandle, reverse, ul, em, color2);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addTextPosition(int x) throws EposException {
        int errStatus = this.eposAddTextPosition(this.mCommandHandle, x);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addFeedUnit(int unit) throws EposException {
        int errStatus = this.eposAddFeedUnit(this.mCommandHandle, unit);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addFeedLine(int line) throws EposException {
        int errStatus = this.eposAddFeedLine(this.mCommandHandle, line);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addImage(Bitmap data, int x, int y, int width, int height, int color2) throws EposException {
        this.addImage(data, x, y, width, height, color2, -2, -2, -2.0, -2);
    }

    public void addImage(Bitmap data, int x, int y, int width, int height, int color2, int mode, int halftone, double brightness) throws EposException {
        this.addImage(data, x, y, width, height, color2, mode, halftone, brightness, -2);
    }

    public void addImage(Bitmap data, int x, int y, int width, int height, int color2, int mode, int halftone, double brightness, int compress) throws EposException {
        int bgrBytePerPixel = 3;
        int maxByteValue = 255;
        if (null == data) {
            throw new EposException(1);
        }
        int srcWidth = data.getWidth();
        int srcHeight = data.getHeight();
        if (1 > srcWidth || 1 > srcHeight) {
            throw new EposException(1);
        }
        try {
            Bitmap image = null;
            if (data.getConfig() == Bitmap.Config.ARGB_8888) {
                image = data;
            } else {
                image = data.copy(Bitmap.Config.ARGB_8888, false);
                if (null == image) {
                    throw new EposException(5);
                }
            }
            int byteMask = 255;
            int shiftBitForAlpha = 24;
            int shiftBitForRed = 16;
            int shiftBitForGreen = 8;
            int srcPos = 0;
            int dstPos = 0;
            int alpha = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            int line = 0;
            int row = 0;
            int[] lineBuf = new int[srcWidth];
            int divTableSize = 256;
            double[] divTable = new double[256];
            for (int i = 0; i < 256; ++i) {
                divTable[i] = 1.0 - (double)i / 255.0;
            }
            byte[] imageBGR = new byte[3 * srcWidth * srcHeight];
            for (line = 0; line < srcHeight; ++line) {
                image.getPixels(lineBuf, 0, srcWidth, 0, line, srcWidth, 1);
                srcPos = 0;
                for (row = 0; row < srcWidth; ++row) {
                    alpha = lineBuf[srcPos] >> 24 & 0xFF;
                    r = lineBuf[srcPos] >> 16 & 0xFF;
                    g = lineBuf[srcPos] >> 8 & 0xFF;
                    b = lineBuf[srcPos] & 0xFF;
                    if (255 == alpha) {
                        imageBGR[dstPos] = (byte)b;
                        imageBGR[dstPos + 1] = (byte)g;
                        imageBGR[dstPos + 2] = (byte)r;
                    } else if (0 == alpha) {
                        imageBGR[dstPos] = -1;
                        imageBGR[dstPos + 1] = -1;
                        imageBGR[dstPos + 2] = -1;
                    } else {
                        imageBGR[dstPos] = (byte)(255.0 - (double)alpha * divTable[b]);
                        imageBGR[dstPos + 1] = (byte)(255.0 - (double)alpha * divTable[g]);
                        imageBGR[dstPos + 2] = (byte)(255.0 - (double)alpha * divTable[r]);
                    }
                    dstPos += 3;
                    ++srcPos;
                }
            }
            int errStatus = this.eposAddImage(this.mCommandHandle, imageBGR, srcWidth, srcHeight, x, y, width, height, color2, mode, halftone, brightness, compress);
            if (0 != errStatus) {
                throw new EposException(errStatus);
            }
        }
        catch (OutOfMemoryError ex) {
            throw new EposException(5);
        }
    }

    public void addLogo(int key1, int key2) throws EposException {
        int errStatus = this.eposAddLogo(this.mCommandHandle, key1, key2);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addBarcode(String data, int type, int hri, int font, int width, int height) throws EposException {
        if (null == data) {
            throw new EposException(1);
        }
        int errStatus = this.eposAddBarcode(this.mCommandHandle, data, type, hri, font, width, height);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addSymbol(String data, int type, int level, int width, int height, int size) throws EposException {
        if (null == data) {
            throw new EposException(1);
        }
        int errStatus = this.eposAddSymbol(this.mCommandHandle, data, type, level, width, height, size);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addHLine(int x1, int x2, int style) throws EposException {
        int errStatus = this.eposAddHLine(this.mCommandHandle, x1, x2, style);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addVLineBegin(int x, int style) throws EposException {
        int errStatus = this.eposAddVLineBegin(this.mCommandHandle, x, style);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addVLineEnd(int x, int style) throws EposException {
        int errStatus = this.eposAddVLineEnd(this.mCommandHandle, x, style);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageBegin() throws EposException {
        int errStatus = this.eposAddPageBegin(this.mCommandHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageEnd() throws EposException {
        int errStatus = this.eposAddPageEnd(this.mCommandHandle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageArea(int x, int y, int width, int height) throws EposException {
        int errStatus = this.eposAddPageArea(this.mCommandHandle, x, y, width, height);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageDirection(int dir) throws EposException {
        int errStatus = this.eposAddPageDirection(this.mCommandHandle, dir);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPagePosition(int x, int y) throws EposException {
        int errStatus = this.eposAddPagePosition(this.mCommandHandle, x, y);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageLine(int x1, int y1, int x2, int y2, int style) throws EposException {
        int errStatus = this.eposAddPageLine(this.mCommandHandle, x1, y1, x2, y2, style);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPageRectangle(int x1, int y1, int x2, int y2, int style) throws EposException {
        int errStatus = this.eposAddPageRectangle(this.mCommandHandle, x1, y1, x2, y2, style);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addCut(int type) throws EposException {
        int errStatus = this.eposAddCut(this.mCommandHandle, type);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addPulse(int drawer, int time) throws EposException {
        int errStatus = this.eposAddPulse(this.mCommandHandle, drawer, time);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addSound(int pattern, int repeat) throws EposException {
        this.addSound(pattern, repeat, -2);
    }

    public void addSound(int pattern, int repeat, int cycle) throws EposException {
        int errStatus = this.eposAddSound(this.mCommandHandle, pattern, repeat, cycle);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addCommand(byte[] data) throws EposException {
        if (null == data) {
            throw new EposException(1);
        }
        int errStatus = this.eposAddCommand(this.mCommandHandle, data, data.length);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addFeedPosition(int position) throws EposException {
        int errStatus = this.eposAddFeedPosition(this.mCommandHandle, position);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    public void addLayout(int type, int width, int height, int marginTop, int marginBottom, int offsetCut, int offsetLabel) throws EposException {
        int errStatus = this.eposAddLayout(this.mCommandHandle, type, width, height, marginTop, marginBottom, offsetCut, offsetLabel);
        if (0 != errStatus) {
            throw new EposException(errStatus);
        }
    }

    private static long getTotalMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getTotalSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    private static long getFreeMemorySize(File item) {
        long size = 0L;
        try {
            size = item.getFreeSpace();
        }
        catch (IllegalArgumentException e) {
            size = -1L;
        }
        return size;
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

