/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.epson.epsonio.EpsonIoException;
import com.epson.epsonio.SupportUsb;

public class EpsonIo {
    private static final long M_CLOSE_HANDLE = 0L;
    private long mHandle = 0L;

    private native int openDevice(long[] var1, int var2, String var3, String var4, Context var5, long var6);

    private native int closeDevice(long var1);

    private native int writeData(long var1, byte[] var3, int var4, int var5, int var6, int[] var7);

    private native int readData(long var1, byte[] var3, int var4, int var5, int var6, int[] var7);

    private native void eposSetAVDInfo();

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (0L != this.mHandle) {
                this.closeDevice(this.mHandle);
                this.mHandle = 0L;
            }
        }
    }

    public void open(int deviceType, String deviceName, String deviceSettings) throws EpsonIoException {
        this.open(deviceType, deviceName, deviceSettings, null);
    }

    public void open(int deviceType, String deviceName, String deviceSettings, Context context) throws EpsonIoException {
        boolean isAVD;
        long[] handle = new long[1];
        int errStatus = 255;
        if (0L != this.mHandle) {
            throw new EpsonIoException(6);
        }
        if (deviceType == 259 && !SupportUsb.isSupport().booleanValue()) {
            throw new EpsonIoException(6);
        }
        boolean bl = isAVD = TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"google_sdk") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_phone_armv7") || TextUtils.equals((CharSequence)Build.PRODUCT, (CharSequence)"sdk_google_phone_armv7");
        if (isAVD) {
            this.eposSetAVDInfo();
        }
        try {
            errStatus = this.openDevice(handle, deviceType, deviceName, deviceSettings, context, 15000L);
        }
        catch (Exception e) {
            EpsonIoException ie = new EpsonIoException(null, e);
            ie.setStatus(255);
            throw ie;
        }
        if (errStatus != 0) {
            throw new EpsonIoException(errStatus);
        }
        this.mHandle = handle[0];
    }

    public void close() throws EpsonIoException {
        int errStatus = 255;
        if (0L == this.mHandle) {
            throw new EpsonIoException(6);
        }
        try {
            errStatus = this.closeDevice(this.mHandle);
        }
        catch (Exception e) {
            EpsonIoException ie = new EpsonIoException(null, e);
            ie.setStatus(255);
            throw ie;
        }
        if (errStatus != 0) {
            throw new EpsonIoException(errStatus);
        }
        this.mHandle = 0L;
    }

    public int write(byte[] data, int offset, int size, int timeout) throws EpsonIoException {
        int[] sizeWritten = new int[]{0};
        if (0L == this.mHandle) {
            throw new EpsonIoException(6);
        }
        if (null == data) {
            throw new EpsonIoException(1);
        }
        if (0 > offset) {
            throw new EpsonIoException(1);
        }
        if (0 > size) {
            throw new EpsonIoException(1);
        }
        if (data.length < offset + size) {
            throw new EpsonIoException(1);
        }
        int errStatus = 255;
        try {
            errStatus = this.writeData(this.mHandle, data, offset, size, timeout, sizeWritten);
        }
        catch (Exception e) {
            EpsonIoException ie = new EpsonIoException(null, e);
            ie.setStatus(255);
            throw ie;
        }
        if (errStatus != 0) {
            if (4 == errStatus) {
                errStatus = 0;
            } else {
                throw new EpsonIoException(errStatus);
            }
        }
        return sizeWritten[0];
    }

    public int read(byte[] data, int offset, int size, int timeout) throws EpsonIoException {
        int[] sizeRead = new int[]{0};
        if (0L == this.mHandle) {
            throw new EpsonIoException(6);
        }
        if (null == data) {
            throw new EpsonIoException(1);
        }
        if (0 > offset) {
            throw new EpsonIoException(1);
        }
        if (0 > size) {
            throw new EpsonIoException(1);
        }
        if (data.length < offset + size) {
            throw new EpsonIoException(1);
        }
        int errStatus = 255;
        try {
            errStatus = this.readData(this.mHandle, data, offset, size, timeout, sizeRead);
        }
        catch (Exception e) {
            EpsonIoException ie = new EpsonIoException(null, e);
            ie.setStatus(255);
            throw ie;
        }
        if (errStatus != 0) {
            if (4 == errStatus) {
                errStatus = 0;
            } else {
                throw new EpsonIoException(errStatus);
            }
        }
        return sizeRead[0];
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (UnsatisfiedLinkError e) {
            try {
                System.loadLibrary("epsonio");
            }
            catch (UnsatisfiedLinkError e2) {
                throw e;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

