/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio;

import android.content.Context;
import com.epson.epsonio.DeviceInfo;
import com.epson.epsonio.EpsonIoException;
import com.epson.epsonio.SupportUsb;
import com.epson.epsonio.bluetooth.DevBt;

public class Finder {
    public static final int PARAM_DEFAULT = -2;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_NAME = 1;
    public static final String[] LIST_PREFIX = new String[]{"TM-", "UB-B", "EU-", "TS-"};
    public static final String[] LIST_MATCH = new String[]{"BT304"};
    private static int mDeviceType;

    private static final native int findStart(Context var0, int var1, String var2);

    private static final native DeviceInfo[] getDevList(int[] var0, int var1);

    private static final native int findStop();

    public static synchronized void start(Context context, int deviceType, String findOption) throws EpsonIoException {
        int errStatus = 255;
        if (0 != mDeviceType) {
            throw new EpsonIoException(6);
        }
        switch (deviceType) {
            case 257: {
                try {
                    errStatus = Finder.findStart(context, deviceType, findOption);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 258: {
                try {
                    errStatus = DevBt.start(context, deviceType, findOption, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 259: {
                try {
                    errStatus = SupportUsb.start(context, deviceType, findOption);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            default: {
                throw new EpsonIoException(1);
            }
        }
        if (errStatus != 0) {
            throw new EpsonIoException(errStatus);
        }
        mDeviceType = deviceType;
    }

    public static final synchronized String[] getResult() throws EpsonIoException {
        String[] devList;
        DeviceInfo[] deviceInfoList = null;
        int[] errStatus = new int[1];
        if (0 == mDeviceType) {
            throw new EpsonIoException(6);
        }
        switch (mDeviceType) {
            case 257: {
                try {
                    deviceInfoList = Finder.getDevList(errStatus, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 258: {
                try {
                    deviceInfoList = DevBt.getResult(errStatus, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 259: {
                try {
                    deviceInfoList = SupportUsb.getResult(errStatus, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            default: {
                throw new EpsonIoException(255);
            }
        }
        if (0 != errStatus[0]) {
            throw new EpsonIoException(errStatus[0]);
        }
        try {
            devList = new String[deviceInfoList.length];
        }
        catch (Exception e) {
            EpsonIoException ie = new EpsonIoException(null, e);
            ie.setStatus(255);
            throw ie;
        }
        for (int i = 0; i < deviceInfoList.length; ++i) {
            devList[i] = 257 == mDeviceType ? deviceInfoList[i].getIpAddress() : deviceInfoList[i].getDeviceName();
        }
        return devList;
    }

    public static final synchronized DeviceInfo[] getDeviceInfoList(int filterOption) throws EpsonIoException {
        DeviceInfo[] deviceInfoList = null;
        int[] errStatus = new int[1];
        if (0 == mDeviceType) {
            throw new EpsonIoException(6);
        }
        if (1 != filterOption && 0 != filterOption && -2 != filterOption) {
            throw new EpsonIoException(1);
        }
        switch (mDeviceType) {
            case 257: {
                try {
                    deviceInfoList = Finder.getDevList(errStatus, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 258: {
                try {
                    deviceInfoList = DevBt.getResult(errStatus, filterOption);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 259: {
                try {
                    deviceInfoList = SupportUsb.getResult(errStatus, 0);
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            default: {
                throw new EpsonIoException(255);
            }
        }
        if (0 != errStatus[0]) {
            throw new EpsonIoException(errStatus[0]);
        }
        return deviceInfoList;
    }

    public static synchronized void stop() throws EpsonIoException {
        int errStatus = 255;
        if (0 == mDeviceType) {
            throw new EpsonIoException(6);
        }
        switch (mDeviceType) {
            case 257: {
                try {
                    errStatus = Finder.findStop();
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 258: {
                try {
                    errStatus = DevBt.stop();
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            case 259: {
                try {
                    errStatus = SupportUsb.stop();
                    break;
                }
                catch (Exception e) {
                    EpsonIoException ie = new EpsonIoException(null, e);
                    ie.setStatus(255);
                    throw ie;
                }
            }
            default: {
                throw new EpsonIoException(255);
            }
        }
        if (0 != errStatus) {
            throw new EpsonIoException(errStatus);
        }
        mDeviceType = 0;
    }

    public static boolean isEpson(String name) {
        if (name == null) {
            return false;
        }
        try {
            int i;
            for (i = 0; i < LIST_PREFIX.length; ++i) {
                if (!name.startsWith(LIST_PREFIX[i])) continue;
                return true;
            }
            for (i = 0; i < LIST_MATCH.length; ++i) {
                if (!name.matches(LIST_MATCH[i])) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    static {
        try {
            System.loadLibrary("epos2");
        }
        catch (UnsatisfiedLinkError e) {
            try {
                System.loadLibrary("epsonio");
            }
            catch (UnsatisfiedLinkError e2) {
                throw e;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        mDeviceType = 0;
    }
}

