/*
 * Decompiled with CFR 0.152.
 */
package com.epson.epsonio;

import com.epson.epsonio.NetIfResult;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetIFInfo {
    private static final String NET_IF_NAME_WLAN = "wlan";
    private static final String NET_IF_NAME_ETH = "eth";
    private static final String NET_IF_NAME_MLAN = "mlan";
    private static final String COMMAND_GET_PROP = "/system/bin/getprop";
    private static final String PACKAGE_HOST_ADDRESS = "arc.net.ipv4.host_address";
    private static final int NET_IF_ADDR_TYPE_IP_ADDRESS = 0;
    private static final int NET_IF_ADDR_TYPE_BROADCAST_ADDRESS = 1;
    private static final int NET_IF_ADDR_TYPE_SUBNET_MASK = 2;
    private static Class<?> mClassOutputLog = null;
    private static Method mOutputLogInfoMethod = null;

    public static int getNetInfoNum(int[] netIfNum) {
        int nNetIfNum = 0;
        try {
            Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
            while (netIFs.hasMoreElements()) {
                NetworkInterface netIF = netIFs.nextElement();
                Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    InetAddress ip = ipAddrs.nextElement();
                    if (ip.isLoopbackAddress()) continue;
                    if (ip instanceof Inet4Address) {
                        ++nNetIfNum;
                        continue;
                    }
                    if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                }
            }
        }
        catch (SocketException e) {
            NetIFInfo.outputLogInfo(e);
            return 255;
        }
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            Process result = processBuilder.command(COMMAND_GET_PROP, PACKAGE_HOST_ADDRESS).start();
            InputStream inputStream = result.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = bufferedReader.readLine();
            while (line != null && !line.isEmpty()) {
                try {
                    byte[] ipAddressByteArray;
                    InetAddress ipAddress = InetAddress.getByName(line);
                    NetIFInfo.outputLogInfo("getprop_ipAddress(Num) : " + ipAddress);
                    if (ipAddress != null && (ipAddressByteArray = ipAddress.getAddress()) != null) {
                        ++nNetIfNum;
                        NetIFInfo.outputLogInfo("getprop_ipAddress count up.");
                    }
                }
                catch (Exception e) {
                    NetIFInfo.outputLogInfo(e);
                }
                line = bufferedReader.readLine();
            }
        }
        catch (Exception e) {
            NetIFInfo.outputLogInfo(e);
        }
        netIfNum[0] = nNetIfNum;
        return 0;
    }

    public static NetIfResult[] getNetInfoList(int netIfNum) {
        int index = 0;
        boolean netIfFin = false;
        NetIfResult[] netIfResult = new NetIfResult[netIfNum];
        try {
            Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
            while (netIFs.hasMoreElements() && !netIfFin) {
                NetworkInterface netIF = netIFs.nextElement();
                Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    InetAddress ip = ipAddrs.nextElement();
                    if (ip.isLoopbackAddress()) continue;
                    if (ip instanceof Inet4Address) {
                        netIfResult[index] = new NetIfResult();
                        netIfResult[index].NetIfsetIpAddress(ip.getAddress());
                        if (++index != netIfNum) continue;
                        netIfFin = true;
                        continue;
                    }
                    if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                }
            }
        }
        catch (SocketException e) {
            NetIFInfo.outputLogInfo(e);
            return null;
        }
        if (!netIfFin) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                Process result = processBuilder.command(COMMAND_GET_PROP, PACKAGE_HOST_ADDRESS).start();
                InputStream inputStream = result.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String line = bufferedReader.readLine();
                while (line != null && !line.isEmpty()) {
                    block11: {
                        try {
                            byte[] ipAddressByteArray;
                            InetAddress ipAddress = InetAddress.getByName(line);
                            NetIFInfo.outputLogInfo("getprop_ipAddress : " + ipAddress);
                            if (ipAddress == null || (ipAddressByteArray = ipAddress.getAddress()) == null) break block11;
                            netIfResult[index] = new NetIfResult();
                            netIfResult[index].NetIfsetIpAddress(ipAddressByteArray);
                            NetIFInfo.outputLogInfo("getprop_ipAddress create NetIfResult");
                            if (++index != netIfNum) break block11;
                            break;
                        }
                        catch (Exception e) {
                            NetIFInfo.outputLogInfo(e);
                        }
                    }
                    line = bufferedReader.readLine();
                }
            }
            catch (Exception e) {
                NetIFInfo.outputLogInfo(e);
            }
        }
        return netIfResult;
    }

    public static int getTargetSmartDeviceNetIfNum(int[] targetCount) {
        int tmpTargetCount;
        block6: {
            if (targetCount == null) {
                return 1;
            }
            tmpTargetCount = 0;
            try {
                Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
                if (netIFs == null) break block6;
                while (netIFs.hasMoreElements()) {
                    NetworkInterface netIF = netIFs.nextElement();
                    Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                    while (ipAddrs.hasMoreElements()) {
                        InetAddress ip = ipAddrs.nextElement();
                        if (ip.isLoopbackAddress()) continue;
                        if (ip instanceof Inet4Address) {
                            String ifName = netIF.getDisplayName();
                            if (ifName == null || !ifName.startsWith(NET_IF_NAME_WLAN) && !ifName.startsWith(NET_IF_NAME_ETH) && !ifName.startsWith(NET_IF_NAME_MLAN)) continue;
                            ++tmpTargetCount;
                            continue;
                        }
                        if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                    }
                }
            }
            catch (Exception e) {
                return 255;
            }
        }
        targetCount[0] = tmpTargetCount;
        return 0;
    }

    public static int createNetworkInterfaceArray(NetworkInterface[] networkIf, int networkIfCount) {
        block6: {
            if (networkIf == null || networkIfCount == 0) {
                return 1;
            }
            int index = 0;
            boolean isComplete = false;
            try {
                Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
                if (netIFs == null) break block6;
                while (netIFs.hasMoreElements()) {
                    NetworkInterface netIF = netIFs.nextElement();
                    Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                    while (ipAddrs.hasMoreElements()) {
                        InetAddress ip = ipAddrs.nextElement();
                        if (ip.isLoopbackAddress()) continue;
                        if (ip instanceof Inet4Address) {
                            String ifName = netIF.getDisplayName();
                            if (ifName == null || !ifName.startsWith(NET_IF_NAME_WLAN) && !ifName.startsWith(NET_IF_NAME_ETH) && !ifName.startsWith(NET_IF_NAME_MLAN)) continue;
                            networkIf[index] = netIF;
                            if (++index != networkIfCount) continue;
                            isComplete = true;
                            break;
                        }
                        if (!ip.isLinkLocalAddress() && !(ip instanceof Inet6Address)) continue;
                    }
                    if (!isComplete) continue;
                    break;
                }
            }
            catch (Exception e) {
                return 255;
            }
        }
        return 0;
    }

    public static String getNetworkInterfaceName(NetworkInterface networkIf) {
        String ifName;
        if (networkIf == null) {
            return null;
        }
        try {
            ifName = networkIf.getDisplayName();
        }
        catch (Exception e) {
            return null;
        }
        return ifName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMyAddress(String interfaceName, int infoType) {
        String address = null;
        if (interfaceName == null) {
            return null;
        }
        try {
            Enumeration<NetworkInterface> netIFs = NetworkInterface.getNetworkInterfaces();
            if (netIFs == null) return address;
            boolean isComplete = false;
            block7: do {
                if (!netIFs.hasMoreElements()) return address;
                NetworkInterface netIF = netIFs.nextElement();
                Enumeration<InetAddress> ipAddrs = netIF.getInetAddresses();
                while (ipAddrs.hasMoreElements()) {
                    block13: {
                        InetAddress ip;
                        block14: {
                            String tmpAddrInet;
                            ip = ipAddrs.nextElement();
                            if (ip.isLoopbackAddress()) break block13;
                            if (!(ip instanceof Inet4Address)) break block14;
                            String ifName = netIF.getDisplayName();
                            if (ifName == null || !ifName.equals(interfaceName) || (tmpAddrInet = ip.getHostAddress()) == null) break block13;
                            switch (infoType) {
                                case 0: {
                                    return tmpAddrInet;
                                }
                                case 1: {
                                    String tmpAddrIFAdder;
                                    InetAddress tmpInet;
                                    for (InterfaceAddress interfaceAddress : netIF.getInterfaceAddresses()) {
                                        tmpInet = interfaceAddress.getAddress();
                                        if (tmpInet == null || (tmpAddrIFAdder = tmpInet.toString().substring(1)) == null || !tmpAddrInet.equals(tmpAddrIFAdder) || interfaceAddress.getBroadcast() == null) continue;
                                        return interfaceAddress.getBroadcast().toString().substring(1);
                                    }
                                    break block13;
                                }
                                case 2: {
                                    String tmpAddrIFAdder;
                                    InetAddress tmpInet;
                                    for (InterfaceAddress interfaceAddress : netIF.getInterfaceAddresses()) {
                                        tmpInet = interfaceAddress.getAddress();
                                        if (tmpInet == null || (tmpAddrIFAdder = tmpInet.toString().substring(1)) == null || !tmpAddrInet.equals(tmpAddrIFAdder)) continue;
                                        return String.valueOf(interfaceAddress.getNetworkPrefixLength());
                                    }
                                    break block13;
                                }
                            }
                            break block13;
                        }
                        if (ip.isLinkLocalAddress() || ip instanceof Inet6Address) {
                            // empty if block
                        }
                    }
                    if (!isComplete) continue;
                    continue block7;
                }
            } while (!isComplete);
            return address;
        }
        catch (Exception e) {
            NetIFInfo.outputLogInfo(e);
            return null;
        }
    }

    private static void initializeOuputLogFunctions() {
        try {
            mClassOutputLog = Class.forName("com.epson.epos2.OutputLog");
            mOutputLogInfoMethod = mClassOutputLog.getDeclaredMethod("outputLogInfo", Long.TYPE, Object[].class);
            mOutputLogInfoMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void outputLogInfo(Object ... param) {
        try {
            mOutputLogInfoMethod.invoke(mClassOutputLog, 0, param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            NetIFInfo.initializeOuputLogFunctions();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

